/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gavgav.jakartajavax.jms;

import jakarta.jms.ConnectionConsumer;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.ServerSessionPool;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import javax.jms.Connection;
import net.sf.gavgav.jakartajavax.jms.JakartaJmsConnectionConsumer;
import net.sf.gavgav.jakartajavax.jms.JakartaJmsConnectionMetaData;
import net.sf.gavgav.jakartajavax.jms.JakartaJmsExceptionListener;
import net.sf.gavgav.jakartajavax.jms.JakartaJmsServerSessionPool;
import net.sf.gavgav.jakartajavax.jms.JakartaJmsSession;
import net.sf.gavgav.jakartajavax.jms.JakartaJmsTopic;
import net.sf.gavgav.jakartajavax.jms.JmsDestination;
import net.sf.gavgav.jakartajavax.jms.JmsException;

public class JakartaJmsConnection
implements jakarta.jms.Connection {
    private Connection conn;

    public JakartaJmsConnection(Connection conn) {
        this.conn = conn;
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        try {
            return new JakartaJmsSession(this.conn.createSession(transacted, acknowledgeMode));
        }
        catch (javax.jms.JMSException e) {
            throw JmsException.wrap(e);
        }
    }

    public Session createSession(int sessionMode) throws JMSException {
        try {
            return new JakartaJmsSession(this.conn.createSession(sessionMode));
        }
        catch (javax.jms.JMSException e) {
            throw JmsException.wrap(e);
        }
    }

    public Session createSession() throws JMSException {
        try {
            return new JakartaJmsSession(this.conn.createSession());
        }
        catch (javax.jms.JMSException e) {
            throw JmsException.wrap(e);
        }
    }

    public String getClientID() throws JMSException {
        try {
            return this.conn.getClientID();
        }
        catch (javax.jms.JMSException e) {
            throw JmsException.wrap(e);
        }
    }

    public void setClientID(String clientID) throws JMSException {
        try {
            this.conn.setClientID(clientID);
        }
        catch (javax.jms.JMSException e) {
            throw JmsException.wrap(e);
        }
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        try {
            return new JakartaJmsConnectionMetaData(this.conn.getMetaData());
        }
        catch (javax.jms.JMSException e) {
            throw JmsException.wrap(e);
        }
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        try {
            return new JakartaJmsExceptionListener(this.conn.getExceptionListener());
        }
        catch (javax.jms.JMSException e) {
            throw JmsException.wrap(e);
        }
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        try {
            this.conn.setExceptionListener(JakartaJmsExceptionListener.unwrap(listener));
        }
        catch (javax.jms.JMSException e) {
            throw JmsException.wrap(e);
        }
    }

    public void start() throws JMSException {
        try {
            this.conn.start();
        }
        catch (javax.jms.JMSException e) {
            throw JmsException.wrap(e);
        }
    }

    public void stop() throws JMSException {
        try {
            this.conn.stop();
        }
        catch (javax.jms.JMSException e) {
            throw JmsException.wrap(e);
        }
    }

    public void close() throws JMSException {
        try {
            this.conn.close();
        }
        catch (javax.jms.JMSException e) {
            throw JmsException.wrap(e);
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        try {
            return new JakartaJmsConnectionConsumer(this.conn.createConnectionConsumer(JmsDestination.unwrap(destination), messageSelector, JakartaJmsServerSessionPool.unwrap(sessionPool), maxMessages));
        }
        catch (javax.jms.JMSException e) {
            throw JmsException.wrap(e);
        }
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        try {
            return new JakartaJmsConnectionConsumer(this.conn.createSharedConnectionConsumer(JakartaJmsTopic.unwrap(topic), subscriptionName, messageSelector, JakartaJmsServerSessionPool.unwrap(sessionPool), maxMessages));
        }
        catch (javax.jms.JMSException e) {
            throw JmsException.wrap(e);
        }
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        try {
            return new JakartaJmsConnectionConsumer(this.conn.createDurableConnectionConsumer(JakartaJmsTopic.unwrap(topic), subscriptionName, messageSelector, JakartaJmsServerSessionPool.unwrap(sessionPool), maxMessages));
        }
        catch (javax.jms.JMSException e) {
            throw JmsException.wrap(e);
        }
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        try {
            return new JakartaJmsConnectionConsumer(this.conn.createSharedDurableConnectionConsumer(JakartaJmsTopic.unwrap(topic), subscriptionName, messageSelector, JakartaJmsServerSessionPool.unwrap(sessionPool), maxMessages));
        }
        catch (javax.jms.JMSException e) {
            throw JmsException.wrap(e);
        }
    }
}

