/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gavgav.jakartajavax.jms;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import net.sf.gavgav.jakartajavax.jms.JakartaJmsConnection;
import net.sf.gavgav.jakartajavax.jms.JakartaJmsContext;
import net.sf.gavgav.jakartajavax.jms.JmsException;

public class JakartaJmsConnectionFactory
implements ConnectionFactory {
    private javax.jms.ConnectionFactory cf;

    public JakartaJmsConnectionFactory(javax.jms.ConnectionFactory cf) {
        this.cf = cf;
    }

    public Connection createConnection() throws JMSException {
        try {
            return new JakartaJmsConnection(this.cf.createConnection());
        }
        catch (javax.jms.JMSException e) {
            throw JmsException.wrap(e);
        }
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        try {
            return new JakartaJmsConnection(this.cf.createConnection(userName, password));
        }
        catch (javax.jms.JMSException e) {
            throw JmsException.wrap(e);
        }
    }

    public JMSContext createContext() {
        return new JakartaJmsContext(this.cf.createContext());
    }

    public JMSContext createContext(String userName, String password) {
        return new JakartaJmsContext(this.cf.createContext(userName, password));
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        return new JakartaJmsContext(this.cf.createContext(userName, password, sessionMode));
    }

    public JMSContext createContext(int sessionMode) {
        return new JakartaJmsContext(this.cf.createContext(sessionMode));
    }
}

