/*
 * Decompiled with CFR 0.152.
 */
package net.sf.geographiclib;

import net.sf.geographiclib.Pair;

public class GeoMath {
    public static final int digits = 53;

    public static double sq(double x) {
        return x * x;
    }

    public static double atanh(double x) {
        double y = Math.abs(x);
        y = Math.log1p(2.0 * y / (1.0 - y)) / 2.0;
        return x > 0.0 ? y : (x < 0.0 ? -y : x);
    }

    public static void norm(Pair p, double sinx, double cosx) {
        double r = Math.hypot(sinx, cosx);
        p.first = sinx / r;
        p.second = cosx / r;
    }

    public static void sum(Pair p, double u, double v) {
        double s = u + v;
        double up = s - v;
        double vpp = s - up;
        double t = -((up -= u) + (vpp -= v));
        p.first = s;
        p.second = t;
    }

    public static double polyval(int N, double[] p, int s, double x) {
        double y;
        double d = y = N < 0 ? 0.0 : p[s++];
        while (--N >= 0) {
            y = y * x + p[s++];
        }
        return y;
    }

    public static double AngRound(double x) {
        double z = 0.0625;
        if (x == 0.0) {
            return 0.0;
        }
        double y = Math.abs(x);
        y = y < 0.0625 ? 0.0625 - (0.0625 - y) : y;
        return x < 0.0 ? -y : y;
    }

    public static double remainder(double x, double y) {
        return (x %= y) < -y / 2.0 ? x + y : (x < y / 2.0 ? x : x - y);
    }

    public static double AngNormalize(double x) {
        return (x = GeoMath.remainder(x, 360.0)) == -180.0 ? 180.0 : x;
    }

    public static double LatFix(double x) {
        return Math.abs(x) > 90.0 ? Double.NaN : x;
    }

    public static void AngDiff(Pair p, double x, double y) {
        GeoMath.sum(p, GeoMath.AngNormalize(-x), GeoMath.AngNormalize(y));
        double d = GeoMath.AngNormalize(p.first);
        double t = p.second;
        GeoMath.sum(p, d == 180.0 && t > 0.0 ? -180.0 : d, t);
    }

    public static void sincosd(Pair p, double x) {
        double cosx;
        double sinx;
        double r = x % 360.0;
        int q = (int)Math.round(r / 90.0);
        r -= (double)(90 * q);
        r = Math.toRadians(r);
        double s = Math.sin(r);
        double c = Math.cos(r);
        switch (q & 3) {
            case 0: {
                sinx = s;
                cosx = c;
                break;
            }
            case 1: {
                sinx = c;
                cosx = -s;
                break;
            }
            case 2: {
                sinx = -s;
                cosx = -c;
                break;
            }
            default: {
                sinx = -c;
                cosx = s;
            }
        }
        if (x != 0.0) {
            sinx += 0.0;
            cosx += 0.0;
        }
        p.first = sinx;
        p.second = cosx;
    }

    public static double atan2d(double y, double x) {
        int q = 0;
        if (Math.abs(y) > Math.abs(x)) {
            double t = x;
            x = y;
            y = t;
            q = 2;
        }
        if (x < 0.0) {
            x = -x;
            ++q;
        }
        double ang = Math.toDegrees(Math.atan2(y, x));
        switch (q) {
            case 1: {
                ang = (double)(y >= 0.0 ? 180 : -180) - ang;
                break;
            }
            case 2: {
                ang = 90.0 - ang;
                break;
            }
            case 3: {
                ang = -90.0 + ang;
            }
        }
        return ang;
    }

    public static boolean isfinite(double x) {
        return Math.abs(x) <= Double.MAX_VALUE;
    }

    public static Pair norm(double sinx, double cosx) {
        Pair p = new Pair();
        GeoMath.norm(p, sinx, cosx);
        return p;
    }

    public static Pair sum(double u, double v) {
        Pair p = new Pair();
        GeoMath.sum(p, u, v);
        return p;
    }

    public static Pair AngDiff(double x, double y) {
        Pair p = new Pair();
        GeoMath.AngDiff(p, x, y);
        return p;
    }

    public static Pair sincosd(double x) {
        Pair p = new Pair();
        GeoMath.sincosd(p, x);
        return p;
    }

    private GeoMath() {
    }
}

