/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.plugin.http;

import HTTPClient.CookieModule;
import HTTPClient.HTTPConnection;
import HTTPClient.NVPair;
import java.net.InetAddress;
import java.net.UnknownHostException;
import net.grinder.plugin.http.HTTPPluginConnection;
import net.grinder.plugin.http.HTTPPluginConnectionDefaults;
import net.grinder.plugin.http.SlowClientBandwidthLimiterFactory;
import net.grinder.plugin.http.URLException;
import net.grinder.util.Sleeper;

final class HTTPConnectionWrapper
implements HTTPPluginConnection {
    private static final Class<?> s_authorizationModule;
    private static final Class<?> s_contentEncodingModule;
    private static final Class<?> s_redirectionModule;
    private static final Class<?> s_transferEncodingModule;
    private final HTTPConnection m_httpConnection;
    private final Sleeper m_slowClientSleeper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPConnectionWrapper(HTTPConnection httpConnection, HTTPPluginConnectionDefaults defaults, Sleeper slowClientSleeper) {
        this.m_httpConnection = httpConnection;
        this.m_slowClientSleeper = slowClientSleeper;
        this.m_httpConnection.setAllowUserInteraction(false);
        this.m_httpConnection.setTestConnectionHealthWithBlockingRead(true);
        HTTPPluginConnectionDefaults hTTPPluginConnectionDefaults = defaults;
        synchronized (hTTPPluginConnectionDefaults) {
            this.setFollowRedirects(defaults.getFollowRedirects());
            this.setUseCookies(defaults.getUseCookies());
            this.setUseContentEncoding(defaults.getUseContentEncoding());
            this.setUseTransferEncoding(defaults.getUseTransferEncoding());
            this.setUseAuthorizationModule(defaults.getUseAuthorizationModule());
            this.setDefaultHeaders(defaults.getDefaultHeaders());
            this.setTimeout(defaults.getTimeout());
            this.setVerifyServerDistinguishedName(defaults.getVerifyServerDistinguishedName());
            this.setProxyServer(defaults.getProxyHost(), defaults.getProxyPort());
            this.setLocalAddress(defaults.getLocalAddress());
            this.setBandwidthLimit(defaults.getBandwidthLimit());
        }
    }

    HTTPConnection getConnection() {
        return this.m_httpConnection;
    }

    @Override
    public void setFollowRedirects(boolean followRedirects) {
        if (followRedirects) {
            this.m_httpConnection.addModule(s_redirectionModule, 0);
        } else {
            this.m_httpConnection.removeModule(s_redirectionModule);
        }
    }

    @Override
    public void setUseCookies(boolean useCookies) {
        if (useCookies) {
            this.m_httpConnection.addModule(CookieModule.class, 0);
        } else {
            this.m_httpConnection.removeModule(CookieModule.class);
        }
    }

    @Override
    public void setUseContentEncoding(boolean useContentEncoding) {
        if (useContentEncoding) {
            this.m_httpConnection.addModule(s_contentEncodingModule, 0);
        } else {
            this.m_httpConnection.removeModule(s_contentEncodingModule);
        }
    }

    @Override
    public void setUseTransferEncoding(boolean useTransferEncoding) {
        if (useTransferEncoding) {
            this.m_httpConnection.addModule(s_transferEncodingModule, 0);
        } else {
            this.m_httpConnection.removeModule(s_transferEncodingModule);
        }
    }

    @Override
    public void setUseAuthorizationModule(boolean useAuthorizationModule) {
        if (useAuthorizationModule) {
            this.m_httpConnection.addModule(s_authorizationModule, 0);
        } else {
            this.m_httpConnection.removeModule(s_authorizationModule);
        }
    }

    @Override
    public void setDefaultHeaders(NVPair[] defaultHeaders) {
        this.m_httpConnection.setDefaultHeaders(defaultHeaders);
    }

    @Override
    public void setTimeout(int timeout) {
        this.m_httpConnection.setTimeout(timeout);
    }

    @Override
    public void setVerifyServerDistinguishedName(boolean b) {
        this.m_httpConnection.setCheckCertificates(b);
    }

    @Override
    public void setProxyServer(String host, int port) {
        this.m_httpConnection.setCurrentProxy(host, port);
    }

    @Override
    public void setLocalAddress(String localAddress) throws URLException {
        try {
            this.setLocalAddress(InetAddress.getByName(localAddress));
        }
        catch (UnknownHostException e) {
            throw new URLException(e.getMessage(), e);
        }
    }

    private void setLocalAddress(InetAddress localAddress) {
        this.m_httpConnection.setLocalAddress(localAddress, 0);
    }

    @Override
    public void setBandwidthLimit(int targetBPS) {
        if (targetBPS < 1) {
            this.m_httpConnection.setBufferGrowthStrategyFactory(null);
        } else {
            this.m_httpConnection.setBufferGrowthStrategyFactory((HTTPConnection.BandwidthLimiterFactory)new SlowClientBandwidthLimiterFactory(this.m_slowClientSleeper, targetBPS));
        }
    }

    @Override
    public void close() {
        this.m_httpConnection.stop();
    }

    static {
        try {
            s_authorizationModule = Class.forName("HTTPClient.AuthorizationModule");
            s_contentEncodingModule = Class.forName("HTTPClient.ContentEncodingModule");
            s_redirectionModule = Class.forName("HTTPClient.RedirectionModule");
            s_transferEncodingModule = Class.forName("HTTPClient.TransferEncodingModule");
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

