/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.plugin.http;

import HTTPClient.CookieModule;
import HTTPClient.DefaultAuthHandler;
import HTTPClient.HTTPConnection;
import net.grinder.common.GrinderException;
import net.grinder.common.SSLContextFactory;
import net.grinder.plugin.http.HTTPPluginThreadState;
import net.grinder.plugininterface.GrinderPlugin;
import net.grinder.plugininterface.PluginException;
import net.grinder.plugininterface.PluginProcessContext;
import net.grinder.plugininterface.PluginRegistry;
import net.grinder.plugininterface.PluginThreadContext;
import net.grinder.plugininterface.PluginThreadListener;
import net.grinder.script.Grinder;
import net.grinder.script.Statistics;
import net.grinder.util.Sleeper;
import net.grinder.util.SleeperImplementation;

public class HTTPPlugin
implements GrinderPlugin {
    private static final HTTPPlugin s_singleton = new HTTPPlugin();
    private PluginProcessContext m_pluginProcessContext;
    private SSLContextFactory m_sslContextFactory;
    private Sleeper m_slowClientSleeper;

    static final HTTPPlugin getPlugin() {
        return s_singleton;
    }

    final PluginProcessContext getPluginProcessContext() {
        return this.m_pluginProcessContext;
    }

    public void initialize(PluginProcessContext processContext) throws PluginException {
        this.m_pluginProcessContext = processContext;
        Grinder.ScriptContext scriptContext = processContext.getScriptContext();
        this.m_sslContextFactory = scriptContext.getSSLControl();
        this.m_slowClientSleeper = new SleeperImplementation(this.m_pluginProcessContext.getTimeAuthority(), null, 1.0, 0.0);
        try {
            HTTPConnection.removeDefaultModule(Class.forName("HTTPClient.RetryModule"));
        }
        catch (ClassNotFoundException e) {
            throw new PluginException("Could not load HTTPClient modules", (Throwable)e);
        }
        CookieModule.setCookiePolicyHandler(null);
        DefaultAuthHandler.setAuthorizationPrompter(null);
        try {
            Statistics statistics = scriptContext.getStatistics();
            statistics.registerDataLogExpression("HTTP response code", "httpplugin.responseStatus");
            statistics.registerDataLogExpression("HTTP response length", "httpplugin.responseLength");
            statistics.registerDataLogExpression("HTTP response errors", "httpplugin.responseErrors");
            statistics.registerDataLogExpression("Time to resolve host", "httpplugin.dnsTime");
            statistics.registerDataLogExpression("Time to establish connection", "httpplugin.connectTime");
            statistics.registerDataLogExpression("Time to first byte", "httpplugin.firstByteTime");
            statistics.registerSummaryExpression("Mean response length", "(/ httpplugin.responseLength (+ (count timedTests) untimedTests))");
            statistics.registerSummaryExpression("Response bytes per second", "(* 1000 (/ httpplugin.responseLength period))");
            statistics.registerSummaryExpression("Response errors", "httpplugin.responseErrors");
            statistics.registerSummaryExpression("Mean time to resolve host", "(/ httpplugin.dnsTime (+ (count timedTests) untimedTests))");
            statistics.registerSummaryExpression("Mean time to establish connection", "(/ httpplugin.connectTime (+ (count timedTests) untimedTests))");
            statistics.registerSummaryExpression("Mean time to first byte", "(/ httpplugin.firstByteTime (+ (count timedTests) untimedTests))");
        }
        catch (GrinderException e) {
            throw new PluginException("Could not register custom statistics", (Throwable)e);
        }
    }

    public PluginThreadListener createThreadListener(PluginThreadContext threadContext) throws PluginException {
        return new HTTPPluginThreadState(threadContext, this.m_sslContextFactory, this.m_slowClientSleeper, this.m_pluginProcessContext.getTimeAuthority());
    }

    static {
        try {
            PluginRegistry.getInstance().register((GrinderPlugin)s_singleton);
        }
        catch (GrinderException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

