/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.plugin.http;

import HTTPClient.HTTPConnection;
import net.grinder.util.Sleeper;

final class SlowClientBandwidthLimiterFactory
implements HTTPConnection.BandwidthLimiterFactory {
    private final Sleeper m_sleeper;
    private final int m_targetBPS;
    private final int m_bufferIncrement;

    public SlowClientBandwidthLimiterFactory(Sleeper sleeper, int targetBPS) {
        this.m_sleeper = sleeper;
        this.m_targetBPS = targetBPS;
        this.m_bufferIncrement = Math.max(100, this.m_targetBPS / 500);
    }

    public HTTPConnection.BandwidthLimiter create() {
        return new SlowClientBandwidthLimiter();
    }

    private final class SlowClientBandwidthLimiter
    implements HTTPConnection.BandwidthLimiter {
        private static final float DAMPING_FACTOR = 0.5f;
        private long m_startTime;
        private int m_sleepTime;
        private float m_damping;

        private SlowClientBandwidthLimiter() {
        }

        public int maximumBytes(int position) {
            long now = SlowClientBandwidthLimiterFactory.this.m_sleeper.getTimeInMilliseconds();
            if (position == 0) {
                this.m_startTime = now;
                this.m_sleepTime = 0;
                this.m_damping = 2.0f;
            } else {
                long expectedTime = (long)position * 8L * 1000L / (long)SlowClientBandwidthLimiterFactory.this.m_targetBPS;
                long actualTime = now - this.m_startTime;
                this.m_sleepTime = (int)((float)this.m_sleepTime + (float)(expectedTime - actualTime) * this.m_damping);
                if (this.m_sleepTime < 0) {
                    this.m_sleepTime = 0;
                }
                this.m_damping = 0.5f;
            }
            try {
                SlowClientBandwidthLimiterFactory.this.m_sleeper.sleepNormal((long)this.m_sleepTime, 0L);
            }
            catch (Sleeper.ShutdownException e) {
                // empty catch block
            }
            return SlowClientBandwidthLimiterFactory.this.m_bufferIncrement;
        }
    }
}

