/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.plugin.http.tcpproxyfilter;

import HTTPClient.Codecs;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import net.grinder.common.Closer;
import net.grinder.plugin.http.tcpproxyfilter.ConnectionHandler;
import net.grinder.plugin.http.tcpproxyfilter.HTTPRecording;
import net.grinder.plugin.http.tcpproxyfilter.RegularExpressions;
import net.grinder.plugin.http.xml.BasicAuthorizationHeaderType;
import net.grinder.plugin.http.xml.BodyType;
import net.grinder.plugin.http.xml.ConflictingTokenReferenceType;
import net.grinder.plugin.http.xml.FormBodyType;
import net.grinder.plugin.http.xml.FormFieldType;
import net.grinder.plugin.http.xml.HeaderType;
import net.grinder.plugin.http.xml.RequestType;
import net.grinder.plugin.http.xml.ResponseTokenReferenceType;
import net.grinder.plugin.http.xml.ResponseType;
import net.grinder.plugin.http.xml.TokenReferenceType;
import net.grinder.plugin.http.xml.TokenResponseLocationType;
import net.grinder.tools.tcpproxy.CommentSource;
import net.grinder.tools.tcpproxy.ConnectionDetails;
import net.grinder.util.AttributeStringParser;
import net.grinder.util.StringEscaper;
import net.grinder.util.http.URIParser;
import org.slf4j.Logger;

final class ConnectionHandlerImplementation
implements ConnectionHandler {
    private static final Set<RequestType.Method.Enum> HTTP_METHODS_WITH_BODY = new HashSet<RequestType.Method.Enum>(Arrays.asList(RequestType.Method.OPTIONS, RequestType.Method.POST, RequestType.Method.PUT));
    private final HTTPRecording m_httpRecording;
    private final Logger m_logger;
    private final RegularExpressions m_regularExpressions;
    private final URIParser m_uriParser;
    private final AttributeStringParser m_attributeStringParser;
    private final StringEscaper m_postBodyStringEscaper;
    private final CommentSource m_commentSource;
    private final ConnectionDetails m_connectionDetails;
    private final ByteBuffer m_requestBuffer = ByteBuffer.allocate(40960);
    private Request m_request;

    public ConnectionHandlerImplementation(HTTPRecording httpRecording, Logger logger, RegularExpressions regularExpressions, URIParser uriParser, AttributeStringParser attributeStringParser, StringEscaper postBodyStringEscaper, CommentSource commentSource, ConnectionDetails connectionDetails) {
        this.m_httpRecording = httpRecording;
        this.m_logger = logger;
        this.m_regularExpressions = regularExpressions;
        this.m_uriParser = uriParser;
        this.m_attributeStringParser = attributeStringParser;
        this.m_postBodyStringEscaper = postBodyStringEscaper;
        this.m_commentSource = commentSource;
        this.m_connectionDetails = connectionDetails;
    }

    @Override
    public synchronized void handleRequest(byte[] buffer, int length) {
        int bodyStart;
        Matcher matcher;
        String asciiString;
        try {
            this.m_requestBuffer.put(buffer, 0, length);
        }
        catch (BufferOverflowException e) {
            this.m_logger.error("Filled buffer without matching request line", (Throwable)e);
            this.m_requestBuffer.clear();
            return;
        }
        this.m_requestBuffer.flip();
        try {
            asciiString = new String(this.m_requestBuffer.array(), 0, this.m_requestBuffer.remaining(), "ISO8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        if (this.m_request != null && this.m_request.isComplete()) {
            this.requestFinished();
        }
        if ((matcher = this.m_regularExpressions.getRequestLinePattern().matcher(asciiString)).find()) {
            String method = matcher.group(1);
            String relativeURI = matcher.group(2);
            if (RequestType.Method.Enum.forString((String)method) != null) {
                this.requestFinished();
                this.m_request = new Request(method, relativeURI, this.m_commentSource.getComments());
            }
        }
        if (this.m_request == null) {
            this.m_requestBuffer.position(this.m_requestBuffer.limit()).limit(this.m_requestBuffer.capacity());
            return;
        }
        if (this.m_request.getBody() != null) {
            this.m_request.getBody().write(this.m_requestBuffer.array(), 0, this.m_requestBuffer.remaining());
            this.m_requestBuffer.clear();
            return;
        }
        String headers = asciiString;
        Matcher messageBodyMatcher = this.m_regularExpressions.getMessageBodyPattern().matcher(asciiString);
        if (messageBodyMatcher.find()) {
            bodyStart = messageBodyMatcher.start(1);
            headers = asciiString.substring(0, bodyStart);
        } else {
            bodyStart = -1;
        }
        Matcher headerMatcher = this.m_regularExpressions.getHeaderPattern().matcher(headers);
        while (headerMatcher.find()) {
            String name = headerMatcher.group(1);
            String value = headerMatcher.group(2);
            if (this.m_httpRecording.getParameters().isMirroredHeader(name)) {
                this.m_request.addHeader(name, value);
            }
            if ("Content-Type".equalsIgnoreCase(name)) {
                this.m_request.setContentType(value);
            }
            if (!"Content-Length".equalsIgnoreCase(name)) continue;
            this.m_request.setContentLength(Integer.parseInt(value));
        }
        Matcher authorizationMatcher = this.m_regularExpressions.getBasicAuthorizationHeaderPattern().matcher(headers);
        if (authorizationMatcher.find()) {
            this.m_request.addBasicAuthorization(authorizationMatcher.group(1));
        }
        if (bodyStart > -1) {
            int bodyLength = this.m_requestBuffer.remaining() - bodyStart;
            if (this.m_request.expectingBody()) {
                this.m_request.new Request.RequestBody().write(this.m_requestBuffer.array(), bodyStart, bodyLength);
            } else {
                if (bodyLength != 0) {
                    this.m_logger.warn("Not expecting body, found {} bytes for {}", (Object)bodyLength, (Object)this.m_request);
                }
                this.m_request.setComplete();
            }
        }
        this.m_requestBuffer.clear();
    }

    @Override
    public synchronized void handleResponse(byte[] buffer, int length) {
        Response response;
        String asciiString;
        if (this.m_request == null) {
            this.m_logger.error("UNEXPECTED - No current request");
            return;
        }
        try {
            asciiString = new String(buffer, 0, length, "ISO8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        Matcher matcher = this.m_regularExpressions.getResponseLinePattern().matcher(asciiString);
        if (matcher.find()) {
            this.m_httpRecording.markLastResponseTime();
            this.m_request.addNewResponse(Integer.parseInt(matcher.group(1)), matcher.group(2));
        }
        if ((response = this.m_request.getResponse()) == null) {
            this.m_logger.error("UNEXPECTED - No current response");
        } else if (response.getBody() != null) {
            response.getBody().write(buffer, 0, length);
        } else {
            Matcher messageBodyMatcher;
            String headers = asciiString;
            int bodyStart = -1;
            if (this.m_request.expectingResponseBody() && (messageBodyMatcher = this.m_regularExpressions.getMessageBodyPattern().matcher(asciiString)).find()) {
                bodyStart = messageBodyMatcher.start(1);
                headers = asciiString.substring(0, bodyStart);
            }
            Matcher headerMatcher = this.m_regularExpressions.getHeaderPattern().matcher(headers);
            while (headerMatcher.find()) {
                String name = headerMatcher.group(1);
                String value = headerMatcher.group(2);
                if (!"Location".equals(name)) continue;
                this.m_uriParser.parse(value, new URIParser.AbstractParseListener(){

                    @Override
                    public boolean pathParameterNameValue(String name, String value) {
                        response.addResponseTokenReference(name, value, TokenResponseLocationType.RESPONSE_LOCATION_HEADER_PATH_PARAMETER);
                        return true;
                    }

                    @Override
                    public boolean queryStringNameValue(String name, String value) {
                        response.addResponseTokenReference(name, value, TokenResponseLocationType.RESPONSE_LOCATION_HEADER_QUERY_STRING);
                        return true;
                    }
                });
            }
            if (bodyStart > -1) {
                response.new Response.ResponseBody().write(buffer, bodyStart, length - bodyStart);
            }
        }
    }

    @Override
    public synchronized void requestFinished() {
        if (this.m_request != null) {
            this.m_request.end();
            this.m_request = null;
        }
    }

    private static abstract class AbstractBody {
        private final ByteArrayOutputStream m_entityBodyByteStream = new ByteArrayOutputStream();

        private AbstractBody() {
        }

        public void write(byte[] bytes, int start, int length) {
            this.m_entityBodyByteStream.write(bytes, start, length);
        }

        public abstract void end();

        protected final int getSize() {
            return this.m_entityBodyByteStream.size();
        }

        protected final byte[] toByteArray() {
            return this.m_entityBodyByteStream.toByteArray();
        }
    }

    private final class Response {
        private final ResponseType m_responseXML;
        private ResponseBody m_body;
        private final Map<String, ResponseTokenReferenceType> m_tokensInResponseMap = new HashMap<String, ResponseTokenReferenceType>();

        public Response(ResponseType responseXML) {
            this.m_responseXML = responseXML;
        }

        public ResponseBody getBody() {
            return this.m_body;
        }

        public void end() {
            if (this.getBody() != null) {
                this.getBody().end();
            }
        }

        public void addResponseTokenReference(String name, String value, TokenResponseLocationType.Enum source) {
            ResponseTokenReferenceType existingTokenReference = this.m_tokensInResponseMap.get(name);
            if (existingTokenReference == null) {
                ResponseTokenReferenceType newTokenReference = this.m_responseXML.addNewTokenReference();
                newTokenReference.setSource(source.toString());
                ConnectionHandlerImplementation.this.m_httpRecording.setTokenReference(name, value, (TokenReferenceType)newTokenReference);
                this.m_tokensInResponseMap.put(name, newTokenReference);
            } else {
                if (ConnectionHandlerImplementation.this.m_httpRecording.getLastValueForToken(name).equals(value)) {
                    return;
                }
                ConflictingTokenReferenceType conflictingValue = existingTokenReference.addNewConflictingValue();
                conflictingValue.setValue(value);
                conflictingValue.setSource(source.toString());
            }
        }

        private class ResponseBody
        extends AbstractBody {
            public ResponseBody() {
                assert (Response.this.m_body == null);
                Response.this.m_body = this;
            }

            @Override
            public void end() {
                String iso85591String;
                try {
                    iso85591String = new String(this.toByteArray(), "ISO8859_1");
                }
                catch (UnsupportedEncodingException e) {
                    throw new AssertionError((Object)e);
                }
                Matcher uriMatcher = ConnectionHandlerImplementation.this.m_regularExpressions.getHyperlinkURIPattern().matcher(iso85591String);
                while (uriMatcher.find()) {
                    ConnectionHandlerImplementation.this.m_uriParser.parse(uriMatcher.group(1), new URIParser.AbstractParseListener(){

                        @Override
                        public boolean pathParameterNameValue(String name, String value) {
                            Response.this.addResponseTokenReference(name, value, TokenResponseLocationType.RESPONSE_BODY_URI_PATH_PARAMETER);
                            return true;
                        }

                        @Override
                        public boolean queryStringNameValue(String name, String value) {
                            Response.this.addResponseTokenReference(name, value, TokenResponseLocationType.RESPONSE_BODY_URI_QUERY_STRING);
                            return true;
                        }
                    });
                }
                Matcher hiddenParameterMatcher = ConnectionHandlerImplementation.this.m_regularExpressions.getHiddenInputPattern().matcher(iso85591String);
                while (hiddenParameterMatcher.find()) {
                    AttributeStringParser.AttributeMap map = ConnectionHandlerImplementation.this.m_attributeStringParser.parse(hiddenParameterMatcher.group());
                    String name = map.get("name");
                    String value = map.get("value");
                    if (name == null || value == null) continue;
                    Response.this.addResponseTokenReference(name, value, TokenResponseLocationType.RESPONSE_BODY_HIDDEN_INPUT);
                }
            }
        }
    }

    private final class Request {
        private final RequestType m_requestXML;
        private int m_contentLength = -1;
        private String m_contentType = null;
        private RequestBody m_body;
        private boolean m_complete;
        private Response m_response = null;

        public Request(String method, String relativeURI, String[] userComments) {
            this.m_requestXML = ConnectionHandlerImplementation.this.m_httpRecording.addRequest(ConnectionHandlerImplementation.this.m_connectionDetails, method, relativeURI);
            ConnectionHandlerImplementation.this.m_logger.debug("Request started {}", (Object)this.m_requestXML);
            for (int i = 0; i < userComments.length; ++i) {
                this.m_requestXML.addComment(userComments[i]);
            }
        }

        public void addNewResponse(int statusCode, String reasonPhrase) {
            ResponseType responseXML = this.m_requestXML.addNewResponse();
            responseXML.setStatusCode(statusCode);
            responseXML.setReasonPhrase(reasonPhrase);
            this.m_response = new Response(responseXML);
        }

        public Response getResponse() {
            return this.m_response;
        }

        public void addBasicAuthorization(String base64) {
            String decoded = Codecs.base64Decode((String)base64);
            int colon = decoded.indexOf(":");
            if (colon < 0) {
                ConnectionHandlerImplementation.this.m_logger.error("Could not decode Authorization header");
            } else {
                BasicAuthorizationHeaderType basicAuthorization = this.m_requestXML.getHeaders().addNewAuthorization().addNewBasic();
                basicAuthorization.setUserid(decoded.substring(0, colon));
                basicAuthorization.setPassword(decoded.substring(colon + 1));
            }
        }

        public RequestBody getBody() {
            return this.m_body;
        }

        public boolean expectingBody() {
            return HTTP_METHODS_WITH_BODY.contains(this.m_requestXML.getMethod());
        }

        public boolean expectingResponseBody() {
            if (this.m_requestXML.getMethod().equals(RequestType.Method.HEAD)) {
                return false;
            }
            int status = this.m_requestXML.getResponse().getStatusCode();
            return status >= 200 && status != 204 && status != 304;
        }

        public void setContentType(String contentType) {
            this.m_contentType = contentType;
        }

        public void setContentLength(int contentLength) {
            this.m_contentLength = contentLength;
        }

        public void addHeader(String name, String value) {
            HeaderType header = this.m_requestXML.getHeaders().addNewHeader();
            header.setName(name);
            header.setValue(value);
        }

        public void end() {
            if (this.getBody() != null) {
                this.getBody().end();
            }
            if (this.getResponse() != null) {
                this.getResponse().end();
            }
            ConnectionHandlerImplementation.this.m_logger.debug("Request finished {}", (Object)this.m_requestXML);
        }

        public void setComplete() {
            this.m_complete = true;
        }

        public boolean isComplete() {
            return this.m_complete;
        }

        private class RequestBody
        extends AbstractBody {
            public RequestBody() {
                assert (Request.this.m_body == null);
                Request.this.m_body = this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(byte[] bytes, int start, int length) {
                ConnectionHandlerImplementation connectionHandlerImplementation = ConnectionHandlerImplementation.this;
                synchronized (connectionHandlerImplementation) {
                    int lengthToWrite;
                    if (Request.this.m_contentLength != -1 && length > Request.this.m_contentLength - this.getSize()) {
                        ConnectionHandlerImplementation.this.m_logger.error("Expected content length exceeded, truncating");
                        lengthToWrite = Request.this.m_contentLength - this.getSize();
                    } else {
                        lengthToWrite = length;
                    }
                    super.write(bytes, start, lengthToWrite);
                    if (Request.this.m_contentLength != -1 && this.getSize() >= Request.this.m_contentLength) {
                        ConnectionHandlerImplementation.this.m_request.setComplete();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void end() {
                block18: {
                    String iso88591String;
                    byte[] bytes;
                    boolean isFormData;
                    boolean isMultipart;
                    BodyType body;
                    block19: {
                        body = Request.this.m_requestXML.addNewBody();
                        if (Request.this.m_contentType != null) {
                            body.setContentType(Request.this.m_contentType);
                            isMultipart = Request.this.m_contentType.startsWith("multipart/form-data");
                            isFormData = isMultipart || Request.this.m_contentType.startsWith("application/x-www-form-urlencoded");
                        } else {
                            isFormData = false;
                            isMultipart = false;
                        }
                        bytes = this.toByteArray();
                        if ((bytes.length <= 16384 || isFormData) && bytes.length <= 262144) break block19;
                        File file = ConnectionHandlerImplementation.this.m_httpRecording.createBodyDataFileName();
                        FileOutputStream dataStream = null;
                        try {
                            dataStream = new FileOutputStream(file);
                            dataStream.write(bytes, 0, bytes.length);
                            body.setFile(file.getPath());
                        }
                        catch (IOException e) {
                            try {
                                ConnectionHandlerImplementation.this.m_logger.error("Failed to write body data to '" + file + "'", (Throwable)e);
                            }
                            catch (Throwable throwable) {
                                Closer.close(dataStream);
                                throw throwable;
                            }
                            Closer.close((OutputStream)dataStream);
                            break block18;
                        }
                        Closer.close((OutputStream)dataStream);
                        break block18;
                    }
                    try {
                        iso88591String = new String(bytes, "ISO8859_1");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new AssertionError((Object)e);
                    }
                    if (isFormData) {
                        try {
                            NVPair[] formNameValuePairs = isMultipart ? Codecs.mpFormDataDecode((byte[])bytes, (String)Request.this.m_contentType, (String)"/tmp") : Codecs.query2nv((String)iso88591String);
                            FormBodyType formData = body.addNewForm();
                            formData.setMultipart(isMultipart);
                            for (int i = 0; i < formNameValuePairs.length; ++i) {
                                String name = formNameValuePairs[i].getName();
                                String value = formNameValuePairs[i].getValue();
                                if (ConnectionHandlerImplementation.this.m_httpRecording.tokenReferenceExists(name, TokenResponseLocationType.RESPONSE_BODY_HIDDEN_INPUT.toString())) {
                                    TokenReferenceType tokenReference = formData.addNewTokenReference();
                                    ConnectionHandlerImplementation.this.m_httpRecording.setTokenReference(name, value, tokenReference);
                                    continue;
                                }
                                FormFieldType formField = formData.addNewFormField();
                                formField.setName(name);
                                formField.setValue(value);
                            }
                        }
                        catch (ParseException e) {
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    if (body.getForm() == null) {
                        boolean looksLikeAnExtendedASCIIString = true;
                        for (int i = 0; i < bytes.length; ++i) {
                            char c = iso88591String.charAt(i);
                            if (!Character.isISOControl(c) || Character.isWhitespace(c)) continue;
                            looksLikeAnExtendedASCIIString = false;
                            break;
                        }
                        if (looksLikeAnExtendedASCIIString) {
                            body.setEscapedString(ConnectionHandlerImplementation.this.m_postBodyStringEscaper.escape(iso88591String));
                        } else {
                            body.setBinary(bytes);
                        }
                    }
                }
            }
        }
    }
}

