/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.plugin.http.tcpproxyfilter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import net.grinder.common.GrinderException;
import net.grinder.plugin.http.tcpproxyfilter.ProcessHTTPRecordingWithXSLT;
import net.grinder.plugin.http.xml.HttpRecordingDocument;
import net.grinder.util.AbstractMainClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessRecording
extends AbstractMainClass {
    private static final String USAGE = "  java " + ProcessRecording.class + " recording [stylesheet]" + "\n\n";
    private final ProcessHTTPRecordingWithXSLT m_processor;
    private final InputStream m_recordingStream;

    public static void main(String[] args) {
        Logger logger = LoggerFactory.getLogger((String)"ProcessRecording");
        try {
            ProcessRecording process = new ProcessRecording(args, new PrintWriter(System.out), logger);
            process.run();
        }
        catch (AbstractMainClass.LoggedInitialisationException e) {
            System.exit(1);
        }
        catch (Throwable e) {
            logger.error("Could not initialise", e);
            System.exit(2);
        }
        System.exit(0);
    }

    private ProcessRecording(String[] arguments, PrintWriter out, Logger logger) throws GrinderException {
        block5: {
            super(logger, USAGE);
            try {
                this.m_recordingStream = new FileInputStream(arguments[0]);
                if (arguments.length == 1) {
                    this.m_processor = new ProcessHTTPRecordingWithXSLT(out, logger);
                    break block5;
                }
                if (arguments.length == 2) {
                    this.m_processor = new ProcessHTTPRecordingWithXSLT(new ProcessHTTPRecordingWithXSLT.StyleSheetFile(new File(arguments[1])), out, this.getLogger());
                    break block5;
                }
                throw this.barfUsage();
            }
            catch (FileNotFoundException fnfe) {
                throw this.barfError(fnfe.getMessage());
            }
            catch (IndexOutOfBoundsException e) {
                throw this.barfUsage();
            }
        }
    }

    private void run() throws Exception {
        HttpRecordingDocument recording = HttpRecordingDocument.Factory.parse((InputStream)this.m_recordingStream);
        this.m_processor.process(recording);
    }
}

