/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.tools.tcpproxy;

import java.util.ArrayList;
import java.util.List;
import net.grinder.tools.tcpproxy.ConnectionDetails;
import net.grinder.tools.tcpproxy.TCPProxyFilter;

public final class CompositeFilter
implements TCPProxyFilter {
    private final List<TCPProxyFilter> m_filters = new ArrayList<TCPProxyFilter>();

    @Override
    public byte[] handle(ConnectionDetails connectionDetails, byte[] originalBuffer, int bytesRead) throws TCPProxyFilter.FilterException {
        byte[] nextBuffer = originalBuffer;
        int nextBytesRead = bytesRead;
        for (TCPProxyFilter filter : this.m_filters) {
            byte[] buffer = filter.handle(connectionDetails, nextBuffer, nextBytesRead);
            if (buffer == null) continue;
            nextBuffer = buffer;
            nextBytesRead = buffer.length;
        }
        return (byte[])(nextBuffer != originalBuffer ? nextBuffer : null);
    }

    @Override
    public void connectionOpened(ConnectionDetails connectionDetails) throws TCPProxyFilter.FilterException {
        for (TCPProxyFilter filter : this.m_filters) {
            filter.connectionOpened(connectionDetails);
        }
    }

    @Override
    public void connectionClosed(ConnectionDetails connectionDetails) throws TCPProxyFilter.FilterException {
        for (TCPProxyFilter filter : this.m_filters) {
            filter.connectionClosed(connectionDetails);
        }
    }

    public void add(TCPProxyFilter filter) {
        this.m_filters.add(filter);
    }

    TCPProxyFilter[] getFilters() {
        return this.m_filters.toArray(new TCPProxyFilter[this.m_filters.size()]);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (TCPProxyFilter filter : this.m_filters) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(filter.getClass().getSimpleName());
        }
        return result.toString();
    }
}

