/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.tools.tcpproxy;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.grinder.tools.tcpproxy.AbstractFilterDecorator;
import net.grinder.tools.tcpproxy.ConnectionDetails;
import net.grinder.tools.tcpproxy.EndPoint;
import net.grinder.tools.tcpproxy.TCPProxyFilter;

class HTTPMethodAbsoluteURIFilterDecorator
extends AbstractFilterDecorator {
    private static final Pattern s_httpMethodLine = Pattern.compile("^([A-Z]+[ \\t]+)(.*)", 32);
    private final String m_absoluteURIPrefix;

    public HTTPMethodAbsoluteURIFilterDecorator(TCPProxyFilter delegate, EndPoint remoteEndPoint) {
        super(delegate);
        this.m_absoluteURIPrefix = "http://" + remoteEndPoint;
    }

    @Override
    public byte[] handle(ConnectionDetails connectionDetails, byte[] buffer, int bytesRead) throws TCPProxyFilter.FilterException {
        byte[] delegateResult = super.handle(connectionDetails, buffer, bytesRead);
        try {
            String original = delegateResult != null ? new String(delegateResult, "ISO8859_1") : new String(buffer, 0, bytesRead, "ISO8859_1");
            Matcher matcher = s_httpMethodLine.matcher(original);
            if (matcher.find()) {
                String result = matcher.group(1) + this.m_absoluteURIPrefix + matcher.group(2);
                return result.getBytes("ISO8859_1");
            }
            if (delegateResult != null) {
                return delegateResult;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new TCPProxyFilter.FilterException("ISO8859_1 encoding unsupported", e);
        }
        return null;
    }
}

