/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.tools.tcpproxy;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.grinder.tools.tcpproxy.AbstractFilterDecorator;
import net.grinder.tools.tcpproxy.ConnectionDetails;
import net.grinder.tools.tcpproxy.TCPProxyFilter;

class HTTPMethodRelativeURIFilterDecorator
extends AbstractFilterDecorator {
    private static final Pattern s_httpMethodLine = Pattern.compile("^([A-Z]+)[ \\t]+http://[^/:]+:?\\d*(/.*)", 32);

    public HTTPMethodRelativeURIFilterDecorator(TCPProxyFilter delegate) {
        super(delegate);
    }

    @Override
    public byte[] handle(ConnectionDetails connectionDetails, byte[] buffer, int bytesRead) throws TCPProxyFilter.FilterException {
        try {
            String original = new String(buffer, 0, bytesRead, "ISO8859_1");
            Matcher matcher = s_httpMethodLine.matcher(original);
            if (matcher.find()) {
                String result = matcher.group(1) + " " + matcher.group(2);
                byte[] resultBytes = result.getBytes("ISO8859_1");
                byte[] delegateResult = super.handle(connectionDetails, resultBytes, resultBytes.length);
                return delegateResult != null ? delegateResult : resultBytes;
            }
            return super.handle(connectionDetails, buffer, bytesRead);
        }
        catch (UnsupportedEncodingException e) {
            throw new TCPProxyFilter.FilterException("ISO8859_1 encoding unsupported", e);
        }
    }
}

