/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.tools.tcpproxy;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.tools.tcpproxy.AbstractTCPProxyEngine;
import net.grinder.tools.tcpproxy.ConnectionDetails;
import net.grinder.tools.tcpproxy.EndPoint;
import net.grinder.tools.tcpproxy.TCPProxyFilter;
import net.grinder.tools.tcpproxy.TCPProxySocketFactory;
import net.grinder.tools.tcpproxy.TCPProxySocketFactoryImplementation;
import org.slf4j.Logger;

public final class PortForwarderTCPProxyEngine
extends AbstractTCPProxyEngine {
    private final ConnectionDetails m_connectionDetails;

    public PortForwarderTCPProxyEngine(TCPProxyFilter requestFilter, TCPProxyFilter responseFilter, PrintWriter output, Logger logger, ConnectionDetails connectionDetails, boolean useColour, int timeout) throws IOException {
        this((TCPProxySocketFactory)new TCPProxySocketFactoryImplementation(), requestFilter, responseFilter, output, logger, connectionDetails, useColour, timeout);
    }

    public PortForwarderTCPProxyEngine(TCPProxySocketFactory socketFactory, TCPProxyFilter requestFilter, TCPProxyFilter responseFilter, PrintWriter output, Logger logger, ConnectionDetails connectionDetails, boolean useColour, int timeout) throws IOException {
        super(socketFactory, requestFilter, responseFilter, output, logger, connectionDetails.getLocalEndPoint(), useColour, timeout);
        this.m_connectionDetails = connectionDetails;
    }

    @Override
    public void run() {
        while (true) {
            Socket localSocket;
            try {
                localSocket = this.accept();
            }
            catch (IOException e) {
                UncheckedInterruptedException.ioException((IOException)e);
                this.logIOException(e);
                return;
            }
            EndPoint sourceEndPoint = EndPoint.clientEndPoint(localSocket);
            EndPoint targetEndPoint = this.m_connectionDetails.getRemoteEndPoint();
            try {
                Socket remoteSocket = this.getSocketFactory().createClientSocket(targetEndPoint);
                this.launchThreadPair(localSocket, remoteSocket, sourceEndPoint, targetEndPoint, this.m_connectionDetails.isSecure());
            }
            catch (IOException e) {
                UncheckedInterruptedException.ioException((IOException)e);
                this.logIOException(e);
                try {
                    localSocket.close();
                }
                catch (IOException closeException) {
                    throw new AssertionError((Object)closeException);
                }
            }
        }
    }
}

