/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.tools.tcpproxy;

import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextField;
import net.grinder.tools.tcpproxy.TCPProxyEngine;
import net.grinder.tools.tcpproxy.UpdatableCommentSource;

public final class TCPProxyConsole
extends JFrame {
    private final UpdatableCommentSource m_commentSource;

    public TCPProxyConsole(final TCPProxyEngine proxyEngine, UpdatableCommentSource commentSource) {
        super("TCPProxy Console");
        this.m_commentSource = commentSource;
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                proxyEngine.stop();
            }
        });
        Container content = this.getContentPane();
        content.setBackground(Color.white);
        content.setLayout(new FlowLayout());
        final JTextField commentTextField = new JTextField("Insert a comment and press enter", 25);
        content.add(commentTextField);
        JButton commentButton = new JButton("Insert comment");
        content.add(commentButton);
        ActionListener addCommentActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TCPProxyConsole.this.m_commentSource.addComment(commentTextField.getText());
                commentTextField.setText(null);
            }
        };
        commentButton.addActionListener(addCommentActionListener);
        commentTextField.addActionListener(addCommentActionListener);
        JButton stopButton = new JButton("Stop");
        stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                proxyEngine.stop();
            }
        });
        stopButton.setHorizontalTextPosition(2);
        content.add(stopButton);
        this.pack();
        this.setVisible(true);
    }
}

