/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util.http;

import HTTPClient.ParseException;
import HTTPClient.URI;
import java.util.BitSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.grinder.util.http.URIParser;

public final class URIParserImplementation
implements URIParser {
    private final Pattern m_uriPattern = Pattern.compile("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?");
    private final Pattern m_pathNameValuePattern = Pattern.compile("([^;/?&=#]+)=([^;&/?#]*)");
    private final Pattern m_queryStringNameValuePattern = Pattern.compile("([^;&=#]+)=([^;&#]*)");

    @Override
    public void parse(String uri, URIParser.ParseListener listener) {
        Matcher matcher = this.m_uriPattern.matcher(uri);
        matcher.matches();
        String scheme = matcher.group(1);
        String authority = matcher.group(2);
        String path = matcher.group(3);
        String queryString = matcher.group(4);
        String fragment = matcher.group(5);
        if (scheme != null && !listener.scheme(scheme)) {
            return;
        }
        if (authority != null && !listener.authority(URIParserImplementation.unescape(authority))) {
            return;
        }
        Matcher pathNameValueMatcher = this.m_pathNameValuePattern.matcher(path);
        int lastText = 0;
        while (pathNameValueMatcher.find()) {
            int start = pathNameValueMatcher.start();
            if (!listener.path(URIParserImplementation.unescapePath(path.substring(lastText, start)))) {
                return;
            }
            if (!listener.pathParameterNameValue(URIParserImplementation.unescapePath(pathNameValueMatcher.group(1)), URIParserImplementation.unescapePath(pathNameValueMatcher.group(2)))) {
                return;
            }
            lastText = pathNameValueMatcher.end();
        }
        if (path.length() != lastText && !listener.path(URIParserImplementation.unescapePath(path.substring(lastText)))) {
            return;
        }
        if (queryString != null) {
            Matcher queryNameValueMatcher = this.m_queryStringNameValuePattern.matcher(queryString);
            lastText = 0;
            while (queryNameValueMatcher.find()) {
                int start = queryNameValueMatcher.start();
                if (start != lastText && !listener.queryString(URIParserImplementation.unescapeQueryString(queryString.substring(lastText, start)))) {
                    return;
                }
                if (!listener.queryStringNameValue(URIParserImplementation.unescapeQueryString(queryNameValueMatcher.group(1)), URIParserImplementation.unescapeQueryString(queryNameValueMatcher.group(2)))) {
                    return;
                }
                lastText = queryNameValueMatcher.end();
            }
            if (queryString.length() != lastText && !listener.queryString(URIParserImplementation.unescapeQueryString(queryString.substring(lastText)))) {
                return;
            }
        }
        if (fragment != null) {
            listener.fragment(URIParserImplementation.unescape(fragment));
        }
    }

    private static String unescape(String text) {
        try {
            return URI.unescape((String)text, null);
        }
        catch (ParseException pe) {
            return text;
        }
    }

    private static String unescapePath(String text) {
        try {
            return URI.unescape((String)text, (BitSet)URI.resvdPathChar);
        }
        catch (ParseException pe) {
            return text;
        }
    }

    private static String unescapeQueryString(String text) {
        try {
            return URI.unescape((String)text, (BitSet)URI.resvdQueryChar);
        }
        catch (ParseException pe) {
            return text;
        }
    }
}

