/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.MultiValueProperty;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.KBManagement.DBKB;
import jade.domain.KBManagement.KBIterator;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.StringACLCodec;
import jade.proto.SubscriptionResponder;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.Collection;
import jade.util.leap.List;
import jade.util.leap.Properties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.rmi.server.UID;
import java.security.MessageDigest;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64;

public class DFDBKB
extends DBKB {
    private static final int MAX_PRELOAD_CNT = 1000;
    private static final int MAX_REGISTER_WITHOUT_CLEAN = 100;
    private static final int MAX_PROP_LENGTH = 255;
    private static final String MULTI_VALUE_PROPERTY_SEPARATOR = "#";
    private static final String SUBSCRIPTION = "subscription";
    private static final String SERVICEPROTOCOL = "serviceprotocol";
    private static final String SERVICEONTOLOGY = "serviceontology";
    private static final String SERVICELANGUAGE = "servicelanguage";
    private static final String SERVICEPROPERTY = "serviceproperty";
    private static final String SERVICE = "service";
    private static final String LANGUAGE = "language";
    private static final String ONTOLOGY = "ontology";
    private static final String PROTOCOL = "protocol";
    private static final String AGENTUSERDEFSLOT = "agentuserdefslot";
    private static final String AGENTRESOLVER = "agentresolver";
    private static final String AGENTADDRESS = "agentaddress";
    private static final String DFAGENTDESCR = "dfagentdescr";
    private int regsCnt = 0;
    private boolean tablesReady = false;
    protected String DEFAULT_LONGVARCHAR_TYPE = "LONGVARCHAR";
    private String localIPAddress;
    private StringACLCodec codec = new StringACLCodec();

    public DFDBKB(int maxResultLimit, String drv, String url, String user, String passwd, boolean cleanTables) throws SQLException {
        super(drv, url, user, passwd, maxResultLimit, cleanTables);
    }

    public void setup() throws SQLException {
        Connection conn;
        DBKB.ConnectionWrapper wrapper;
        block5: {
            this.logger = Logger.getMyLogger(this.getClass().getName());
            try {
                this.localIPAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                this.localIPAddress = "localhost";
            }
            wrapper = this.getConnectionWrapper();
            conn = wrapper.getConnection();
            try {
                conn.setAutoCommit(false);
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Logger.WARNING)) break block5;
                this.logger.log(Logger.WARNING, "Disabling auto-commit failed.");
            }
        }
        if (this.cleanTables) {
            this.dropDFTables();
        }
        this.createDFTables();
        this.tablesReady = true;
        PreparedStatements ps = new PreparedStatements(conn);
        wrapper.setInfo(ps);
        this.clean();
    }

    protected void initConnectionWrapper(DBKB.ConnectionWrapper wrapper) throws SQLException {
        Connection conn;
        block3: {
            conn = wrapper.getConnection();
            try {
                conn.setAutoCommit(false);
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Logger.WARNING)) break block3;
                this.logger.log(Logger.WARNING, "Disabling auto-commit failed.");
            }
        }
        if (this.tablesReady) {
            PreparedStatements ps = new PreparedStatements(conn);
            wrapper.setInfo(ps);
        }
    }

    private PreparedStatements getPreparedStatements() throws SQLException {
        DBKB.ConnectionWrapper wrapper = this.getConnectionWrapper();
        return (PreparedStatements)wrapper.getInfo();
    }

    protected String getLongVarCharType() {
        String bestMatch = this.DEFAULT_LONGVARCHAR_TYPE;
        try {
            DatabaseMetaData md = this.getConnectionWrapper().getConnection().getMetaData();
            ResultSet typeInfo = md.getTypeInfo();
            long maxPrecision = -1L;
            while (typeInfo.next()) {
                long jdbcType = Long.parseLong(typeInfo.getString("DATA_TYPE"));
                long precision = Long.parseLong(typeInfo.getString("PRECISION"));
                if (jdbcType != -1L || precision <= maxPrecision) continue;
                maxPrecision = precision;
                bestMatch = typeInfo.getString("TYPE_NAME");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bestMatch;
    }

    protected String getGUID() {
        UID uid = new UID();
        return this.localIPAddress + ":" + uid;
    }

    protected void dropTable(Statement stmt, String tableName) {
        block2: {
            try {
                stmt.execute("DROP TABLE " + tableName + " CASCADE CONSTRAINTS");
                this.getConnectionWrapper().getConnection().commit();
            }
            catch (SQLException e) {
                if (!this.tableExists(tableName)) break block2;
                this.logger.log(Logger.WARNING, "Cannot clean table " + tableName, e);
            }
        }
    }

    protected void dropDFTables() throws SQLException {
        this.logger.log(Logger.INFO, "Cleaning DF tables...");
        Statement stmt = this.getConnectionWrapper().getConnection().createStatement();
        this.dropTable(stmt, SUBSCRIPTION);
        this.dropTable(stmt, SERVICEPROTOCOL);
        this.dropTable(stmt, SERVICEONTOLOGY);
        this.dropTable(stmt, SERVICELANGUAGE);
        this.dropTable(stmt, SERVICEPROPERTY);
        this.dropTable(stmt, SERVICE);
        this.dropTable(stmt, LANGUAGE);
        this.dropTable(stmt, ONTOLOGY);
        this.dropTable(stmt, PROTOCOL);
        this.dropTable(stmt, AGENTUSERDEFSLOT);
        this.dropTable(stmt, AGENTRESOLVER);
        this.dropTable(stmt, AGENTADDRESS);
        this.dropTable(stmt, DFAGENTDESCR);
        stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tableExists(String name) {
        Statement stmt = null;
        try {
            stmt = this.getConnectionWrapper().getConnection().createStatement();
            stmt.execute("SELECT COUNT(*) FROM " + name);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException see) {
                    see.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTable(String name, String[] entries) {
        if (!this.tableExists(name)) {
            Statement stmt = null;
            try {
                Connection conn = this.getConnectionWrapper().getConnection();
                stmt = conn.createStatement();
                String sql = "CREATE TABLE " + name + " (";
                for (int i = 0; i < entries.length; ++i) {
                    sql = sql + entries[i];
                    sql = i < entries.length - 1 ? sql + ", " : sql + ")";
                }
                stmt.executeUpdate(sql);
                conn.commit();
            }
            catch (SQLException e) {
                if (this.logger.isLoggable(Logger.SEVERE)) {
                    this.logger.log(Logger.SEVERE, "Error creating table '" + name + "'", e);
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException see) {
                        see.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createIndices() {
        Statement stmt = null;
        try {
            Connection conn = this.getConnectionWrapper().getConnection();
            stmt = conn.createStatement();
            stmt.execute("CREATE INDEX dfagentDescrIdx ON dfagentdescr( aid )");
            stmt.execute("CREATE INDEX leaseIdx ON dfagentdescr( lease )");
            stmt.execute("CREATE INDEX agentAddressIdx ON agentaddress( aid )");
            stmt.execute("CREATE INDEX agentResolverIdx ON agentresolver( aid )");
            stmt.execute("CREATE INDEX agentUserdefslotIdx ON agentuserdefslot( aid )");
            stmt.execute("CREATE INDEX serviceLanguageIdx ON servicelanguage( serviceid )");
            stmt.execute("CREATE INDEX serviceProtocolIdx ON serviceprotocol( serviceid )");
            stmt.execute("CREATE INDEX serviceOntologyIdx ON serviceontology( serviceid )");
            stmt.execute("CREATE INDEX servicePropertyIdx ON serviceproperty( serviceid )");
            stmt.execute("CREATE INDEX ontologyIdx ON ontology( descrid )");
            stmt.execute("CREATE INDEX protocolIdx ON ontology( descrid )");
            stmt.execute("CREATE INDEX languageIdx ON ontology( descrid )");
            conn.commit();
        }
        catch (SQLException e) {
            if (this.logger.isLoggable(Logger.FINE)) {
                this.logger.log(Logger.FINE, "Indices for DF tables couldn't be created", e);
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException see) {
                    see.printStackTrace();
                }
            }
        }
    }

    protected void createDFTables() {
        String LONGVARCHAR_TYPE = this.getLongVarCharType();
        this.createTable(DFAGENTDESCR, new String[]{"id VARCHAR(255)", "aid VARCHAR(255)", "lease VARCHAR(20)", "PRIMARY KEY( id )"});
        this.createTable(AGENTADDRESS, new String[]{"id VARCHAR(255)", "aid VARCHAR(255)", "address VARCHAR(255)", "PRIMARY KEY( id )"});
        this.createTable(AGENTRESOLVER, new String[]{"id VARCHAR(255)", "aid VARCHAR(255)", "resolveraid VARCHAR(255)", "PRIMARY KEY( id )"});
        this.createTable(AGENTUSERDEFSLOT, new String[]{"id VARCHAR(255)", "aid\tVARCHAR(255)", "slotkey\tVARCHAR(255)", "slotval\t" + LONGVARCHAR_TYPE, "PRIMARY KEY( id )"});
        this.createTable(ONTOLOGY, new String[]{"descrid VARCHAR(255)", "ontology VARCHAR(64)", "PRIMARY KEY( descrid, ontology )", "FOREIGN KEY( descrid ) REFERENCES dfagentdescr( id )"});
        this.createTable(PROTOCOL, new String[]{"descrid VARCHAR(255)", "protocol VARCHAR(64)", "PRIMARY KEY( descrid, protocol )", "FOREIGN KEY( descrid ) REFERENCES dfagentdescr( id )"});
        this.createTable(LANGUAGE, new String[]{"descrid VARCHAR(255)", "language VARCHAR(32)", "PRIMARY KEY( descrid, language )", "FOREIGN KEY( descrid ) REFERENCES dfagentdescr( id )"});
        this.createTable(SERVICE, new String[]{"id VARCHAR(255)", "descrid VARCHAR(255)", "sname VARCHAR(255)", "stype VARCHAR(64)", "sownership VARCHAR(64)", "PRIMARY KEY( id )", "FOREIGN KEY( descrid ) REFERENCES dfagentdescr( id )"});
        this.createTable(SERVICEPROTOCOL, new String[]{"serviceid VARCHAR(255)", "protocol VARCHAR(64)", "PRIMARY KEY( serviceid, protocol )", "FOREIGN KEY( serviceid ) REFERENCES service( id )"});
        this.createTable(SERVICEONTOLOGY, new String[]{"serviceid VARCHAR(255)", "ontology VARCHAR(64)", "PRIMARY KEY( serviceid, ontology )", "FOREIGN KEY( serviceid ) REFERENCES service( id )"});
        this.createTable(SERVICELANGUAGE, new String[]{"serviceid VARCHAR(255)", "language VARCHAR(32)", "PRIMARY KEY( serviceid, language )", "FOREIGN KEY( serviceid ) REFERENCES service( id )"});
        this.createTable(SERVICEPROPERTY, new String[]{"serviceid VARCHAR(255)", "propkey VARCHAR(255)", "propval_obj " + LONGVARCHAR_TYPE, "propval_str VARCHAR(255)", "propvalhash VARCHAR(100)", "PRIMARY KEY( serviceid, propkey )", "FOREIGN KEY( serviceid ) REFERENCES service( id )"});
        this.createTable(SUBSCRIPTION, new String[]{"id\t VARCHAR(255)", "aclm " + LONGVARCHAR_TYPE, "PRIMARY KEY( id )"});
        this.createIndices();
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Tables correctly created");
        }
    }

    private String getBatchUpdateErroMsg(BatchUpdateException e) {
        StringBuffer msg = new StringBuffer("SQLException: " + e.getMessage() + "\n");
        msg.append("SQLState:  " + e.getSQLState() + "\n");
        msg.append("Message:  " + e.getMessage() + "\n");
        msg.append("Vendor:  " + e.getErrorCode() + "\n");
        msg.append("Update counts: ");
        int[] updateCounts = e.getUpdateCounts();
        for (int i = 0; i < updateCounts.length; ++i) {
            msg.append(updateCounts[i] + "   ");
        }
        return msg.toString();
    }

    private void saveResolverAID(AID aid, AID resolverAid) throws SQLException {
        this.saveAID(resolverAid);
        PreparedStatements pss = this.getPreparedStatements();
        pss.stm_insAgentResolverAID.setString(1, this.getGUID());
        pss.stm_insAgentResolverAID.setString(2, aid.getName());
        pss.stm_insAgentResolverAID.setString(3, resolverAid.getName());
        pss.stm_insAgentResolverAID.addBatch();
    }

    private void saveAID(AID aid) throws SQLException {
        Properties props;
        String name = aid.getName();
        PreparedStatements pss = this.getPreparedStatements();
        jade.util.leap.Iterator iter = aid.getAllAddresses();
        if (iter.hasNext()) {
            pss.stm_insAgentAddress.clearBatch();
            while (iter.hasNext()) {
                pss.stm_insAgentAddress.setString(1, this.getGUID());
                pss.stm_insAgentAddress.setString(2, name);
                pss.stm_insAgentAddress.setString(3, (String)iter.next());
                pss.stm_insAgentAddress.addBatch();
            }
            pss.stm_insAgentAddress.executeBatch();
        }
        if ((props = aid.getAllUserDefinedSlot()).size() > 0) {
            pss.stm_insAgentUserDefSlot.clearBatch();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                pss.stm_insAgentUserDefSlot.setString(1, this.getGUID());
                pss.stm_insAgentUserDefSlot.setString(2, name);
                pss.stm_insAgentUserDefSlot.setString(3, (String)entry.getKey());
                pss.stm_insAgentUserDefSlot.setString(4, (String)entry.getValue());
                pss.stm_insAgentUserDefSlot.addBatch();
            }
            pss.stm_insAgentUserDefSlot.executeBatch();
        }
        if ((iter = aid.getAllResolvers()).hasNext()) {
            pss.stm_insAgentResolverAID.clearBatch();
            while (iter.hasNext()) {
                AID resolverAID = (AID)iter.next();
                this.saveResolverAID(aid, resolverAID);
            }
            pss.stm_insAgentResolverAID.executeBatch();
        }
    }

    private Collection getResolverAIDs(String aid) throws SQLException {
        ArrayList res = new ArrayList();
        PreparedStatements pss = this.getPreparedStatements();
        pss.stm_selAgentResolverAIDs.setString(1, aid);
        ResultSet rs = pss.stm_selAgentResolverAIDs.executeQuery();
        while (rs.next()) {
            res.add(rs.getString(1));
        }
        return res;
    }

    private void saveServices(String descrId, jade.util.leap.Iterator iter) throws SQLException {
        if (iter.hasNext()) {
            PreparedStatements pss = this.getPreparedStatements();
            pss.stm_insService.clearBatch();
            pss.stm_insServiceOntology.clearBatch();
            pss.stm_insServiceOntology.clearBatch();
            pss.stm_insServiceLanguage.clearBatch();
            pss.stm_insServiceProperty.clearBatch();
            boolean executeProtocolsBatch = false;
            boolean executeOntologiesBatch = false;
            boolean executeLanguagesBatch = false;
            boolean executePropertiesBatch = false;
            while (iter.hasNext()) {
                ServiceDescription service = (ServiceDescription)iter.next();
                String serviceId = this.getGUID();
                pss.stm_insService.clearParameters();
                pss.stm_insService.setString(1, serviceId);
                pss.stm_insService.setString(2, descrId);
                pss.stm_insService.setString(3, service.getName());
                pss.stm_insService.setString(4, service.getType());
                pss.stm_insService.setString(5, service.getOwnership());
                pss.stm_insService.addBatch();
                jade.util.leap.Iterator iterS = service.getAllProtocols();
                while (iterS.hasNext()) {
                    pss.stm_insServiceProtocol.setString(1, serviceId);
                    pss.stm_insServiceProtocol.setString(2, (String)iterS.next());
                    pss.stm_insServiceProtocol.addBatch();
                    executeProtocolsBatch = true;
                }
                iterS = service.getAllOntologies();
                while (iterS.hasNext()) {
                    pss.stm_insServiceOntology.setString(1, serviceId);
                    pss.stm_insServiceOntology.setString(2, (String)iterS.next());
                    pss.stm_insServiceOntology.addBatch();
                    executeOntologiesBatch = true;
                }
                iterS = service.getAllLanguages();
                while (iterS.hasNext()) {
                    pss.stm_insServiceLanguage.setString(1, serviceId);
                    pss.stm_insServiceLanguage.setString(2, (String)iterS.next());
                    pss.stm_insServiceLanguage.addBatch();
                    executeLanguagesBatch = true;
                }
                iterS = service.getAllProperties();
                while (iterS.hasNext()) {
                    Object propObj = iterS.next();
                    if (propObj instanceof MultiValueProperty) {
                        MultiValueProperty mvProp = (MultiValueProperty)propObj;
                        int index = 1;
                        jade.util.leap.Iterator iterP = mvProp.getValues().iterator();
                        while (iterP.hasNext()) {
                            block16: {
                                String propName = mvProp.getName() + MULTI_VALUE_PROPERTY_SEPARATOR + index;
                                Object propValue = iterP.next();
                                Property prop = new Property(propName, propValue);
                                try {
                                    this.saveProperty(pss, serviceId, prop);
                                    executePropertiesBatch = true;
                                }
                                catch (Exception e) {
                                    if (!this.logger.isLoggable(Logger.SEVERE)) break block16;
                                    this.logger.log(Logger.SEVERE, "Cannot serialize multi value property '" + prop.getName() + "' for service '" + service.getName() + "'", e);
                                }
                            }
                            ++index;
                        }
                        continue;
                    }
                    Property prop = (Property)propObj;
                    try {
                        this.saveProperty(pss, serviceId, prop);
                        executePropertiesBatch = true;
                    }
                    catch (Exception e) {
                        if (!this.logger.isLoggable(Logger.SEVERE)) continue;
                        this.logger.log(Logger.SEVERE, "Cannot serialize property '" + prop.getName() + "' for service '" + service.getName() + "'", e);
                    }
                }
            }
            pss.stm_insService.executeBatch();
            if (executeProtocolsBatch) {
                pss.stm_insServiceProtocol.executeBatch();
            }
            if (executeOntologiesBatch) {
                pss.stm_insServiceOntology.executeBatch();
            }
            if (executeLanguagesBatch) {
                pss.stm_insServiceLanguage.executeBatch();
            }
            if (executePropertiesBatch) {
                pss.stm_insServiceProperty.executeBatch();
            }
        }
    }

    private void saveProperty(PreparedStatements pss, String serviceId, Property prop) throws Exception {
        pss.stm_insServiceProperty.setString(1, serviceId);
        pss.stm_insServiceProperty.setString(2, prop.getName());
        Object value = prop.getValue();
        if (DFDBKB.needSerialization(value)) {
            String valueStr = this.serializeObj(value);
            pss.stm_insServiceProperty.setString(3, valueStr);
            pss.stm_insServiceProperty.setString(4, null);
            String hashStr = this.getHashValue(value);
            pss.stm_insServiceProperty.setString(5, hashStr);
        } else {
            pss.stm_insServiceProperty.setString(3, null);
            pss.stm_insServiceProperty.setString(4, (String)value);
            pss.stm_insServiceProperty.setString(5, null);
        }
        pss.stm_insServiceProperty.addBatch();
    }

    private static final boolean needSerialization(Object value) {
        return !(value instanceof String) || ((String)value).length() > 255;
    }

    protected Object insertSingle(Object name, Object fact) throws SQLException {
        DFAgentDescription dfd = (DFAgentDescription)fact;
        AID agentAID = dfd.getName();
        String agentName = agentAID.getName();
        DFAgentDescription dfdToReturn = null;
        String batchErrMsg = "";
        Connection conn = this.getConnectionWrapper().getConnection();
        PreparedStatements pss = this.getPreparedStatements();
        try {
            dfdToReturn = (DFAgentDescription)this.removeSingle(dfd.getName());
            Date leaseTime = dfd.getLeaseTime();
            long lt = leaseTime != null ? leaseTime.getTime() : -1L;
            String descrId = this.getGUID();
            pss.stm_insAgentDescr.setString(1, descrId);
            pss.stm_insAgentDescr.setString(2, agentName);
            pss.stm_insAgentDescr.setString(3, String.valueOf(lt));
            pss.stm_insAgentDescr.executeUpdate();
            this.saveAID(agentAID);
            jade.util.leap.Iterator iter = dfd.getAllLanguages();
            if (iter.hasNext()) {
                pss.stm_insLanguage.clearBatch();
                while (iter.hasNext()) {
                    pss.stm_insLanguage.setString(1, descrId);
                    pss.stm_insLanguage.setString(2, (String)iter.next());
                    pss.stm_insLanguage.addBatch();
                }
                pss.stm_insLanguage.executeBatch();
            }
            if ((iter = dfd.getAllOntologies()).hasNext()) {
                pss.stm_insOntology.clearBatch();
                while (iter.hasNext()) {
                    pss.stm_insOntology.setString(1, descrId);
                    pss.stm_insOntology.setString(2, (String)iter.next());
                    pss.stm_insOntology.addBatch();
                }
                pss.stm_insOntology.executeBatch();
            }
            if ((iter = dfd.getAllProtocols()).hasNext()) {
                pss.stm_insProtocol.clearBatch();
                while (iter.hasNext()) {
                    pss.stm_insProtocol.setString(1, descrId);
                    pss.stm_insProtocol.setString(2, (String)iter.next());
                    pss.stm_insProtocol.addBatch();
                }
                pss.stm_insProtocol.executeBatch();
            }
            this.saveServices(descrId, dfd.getAllServices());
            ++this.regsCnt;
            if (this.regsCnt > 100) {
                this.regsCnt = 0;
                this.clean();
            }
            conn.commit();
        }
        catch (SQLException sqle) {
            try {
                conn.rollback();
            }
            catch (SQLException se) {
                this.logger.log(Logger.SEVERE, "Rollback for incomplete insertion of DFD for agent " + dfd.getName() + " failed.", se);
            }
            throw sqle;
        }
        return dfdToReturn;
    }

    protected Object removeSingle(Object name) throws SQLException {
        AID agentAID = (AID)name;
        String n = agentAID.getName();
        DFAgentDescription dfd = this.getDFD(n);
        if (dfd != null) {
            this.remove(n);
        }
        return dfd;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List searchSingle(Object template, int maxResult) throws SQLException {
        ArrayList matchingAIDs = new ArrayList();
        String select = null;
        ResultSet rs = null;
        Statement s = null;
        try {
            select = this.createSelect((DFAgentDescription)template);
            s = this.getConnectionWrapper().getConnection().createStatement();
            if (maxResult >= 0) {
                s.setMaxRows(maxResult);
                s.setFetchSize(maxResult);
            }
            rs = s.executeQuery(select);
            while (rs.next()) {
                String aidS = rs.getString("aid");
                matchingAIDs.add(aidS);
            }
            this.closeResultSet(rs);
            this.closeStatement(s);
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
                catch (Exception e) {
                    this.logger.log(Logger.SEVERE, "Couldn't create the SQL SELECT statement.", e);
                    throw new SQLException("Couldn't create the SQL SELECT statement. " + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(s);
                throw throwable;
            }
        }
        ArrayList dfds = new ArrayList(matchingAIDs.size());
        jade.util.leap.Iterator it = matchingAIDs.iterator();
        if (matchingAIDs.size() < 10) {
            while (it.hasNext()) {
                dfds.add(this.getDFD((String)it.next()));
            }
            return dfds;
        } else {
            PreparedStatements pss = this.getPreparedStatements();
            Map allLanguages = this.preloadIdValueTable(pss.stm_selCountAllLanguages, pss.stm_selAllLanguages);
            Map allOntologies = this.preloadIdValueTable(pss.stm_selCountAllOntologies, pss.stm_selAllOntologies);
            Map allProtocols = this.preloadIdValueTable(pss.stm_selCountAllProtocols, pss.stm_selAllProtocols);
            while (it.hasNext()) {
                dfds.add(this.getDFD((String)it.next(), allLanguages, allOntologies, allProtocols));
            }
        }
        return dfds;
    }

    private Map preloadIdValueTable(PreparedStatement cntStm, PreparedStatement stm) throws SQLException {
        HashMap<String, ArrayList> m = null;
        ResultSet rs = cntStm.executeQuery();
        rs.next();
        long recordCount = rs.getLong(1);
        this.closeResultSet(rs);
        if (recordCount < 1000L) {
            rs = stm.executeQuery();
            m = new HashMap<String, ArrayList>();
            String currentId = null;
            ArrayList l = null;
            while (rs.next()) {
                String id = rs.getString(1);
                if (!id.equals(currentId)) {
                    l = new ArrayList();
                    m.put(id, l);
                    currentId = id;
                }
                l.add(rs.getString(2));
            }
            this.closeResultSet(rs);
        }
        return m;
    }

    protected KBIterator iteratorSingle(Object template) throws SQLException {
        String select = null;
        ResultSet rs = null;
        Statement s = null;
        try {
            select = this.createSelect((DFAgentDescription)template);
            s = this.getConnectionWrapper().getConnection().createStatement();
            rs = s.executeQuery(select);
            return new DFDBKBIterator(s, rs);
        }
        catch (SQLException se) {
            this.logger.log(Logger.SEVERE, "Error accessing DB: " + select, se);
            this.closeResultSet(rs);
            this.closeStatement(s);
            throw se;
        }
        catch (Exception e) {
            this.logger.log(Logger.SEVERE, "Error creating SQL SELECT statement.", e);
            throw new SQLException("Error creating SQL SELECT statement. " + e.getMessage());
        }
    }

    private AID getAID(String aidN) throws SQLException {
        ResultSet rs = null;
        AID id = new AID(aidN, true);
        PreparedStatements pss = this.getPreparedStatements();
        pss.stm_selAgentAddresses.setString(1, aidN);
        rs = pss.stm_selAgentAddresses.executeQuery();
        while (rs.next()) {
            id.addAddresses(rs.getString(1));
        }
        Collection resolvers = this.getResolverAIDs(aidN);
        jade.util.leap.Iterator iter = resolvers.iterator();
        while (iter.hasNext()) {
            id.addResolvers(this.getAID((String)iter.next()));
        }
        pss.stm_selAgentUserDefSlot.setString(1, aidN);
        rs = pss.stm_selAgentUserDefSlot.executeQuery();
        while (rs.next()) {
            String key = rs.getString("slotkey");
            String value = rs.getString("slotval");
            id.addUserDefinedSlot(key, value);
        }
        return id;
    }

    private DFAgentDescription getDFD(String aidN) throws SQLException {
        return this.getDFD(aidN, null, null, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DFAgentDescription getDFD(String aidN, Map allLanguages, Map allOntologies, Map allProtocols) throws SQLException {
        PreparedStatements pss;
        DFAgentDescription dfd = null;
        AID id = null;
        ResultSet rs = null;
        ResultSet rsS = null;
        String descrId = null;
        try {
            pss = this.getPreparedStatements();
            pss.stm_selLease.setString(1, aidN);
            rs = pss.stm_selLease.executeQuery();
            if (!rs.next()) {
                DFAgentDescription sLease = null;
                this.closeResultSet(rs);
                this.closeResultSet(rsS);
                return sLease;
            }
            dfd = new DFAgentDescription();
            id = this.getAID(aidN);
            dfd.setName(id);
            String sLease = rs.getString("lease");
            descrId = rs.getString("id");
            long lease = Long.parseLong(sLease);
            if (lease != -1L) {
                dfd.setLeaseTime(new Date(lease));
            }
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
                catch (Exception e) {
                    this.logger.log(Logger.SEVERE, "Unexpected error retrieving DFD for agent " + aidN, e);
                    throw new SQLException("Unexpected error retrieving DFD for agent " + aidN + ". " + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeResultSet(rsS);
                throw throwable;
            }
        }
        {
            this.closeResultSet(rs);
            this.loadProtocols(descrId, dfd, allProtocols);
            this.loadLanguages(descrId, dfd, allLanguages);
            this.loadOntologies(descrId, dfd, allOntologies);
            pss.stm_selServices.setString(1, descrId);
            rs = pss.stm_selServices.executeQuery();
            while (true) {
                if (!rs.next()) {
                    this.closeResultSet(rs);
                    this.closeResultSet(rsS);
                    return dfd;
                }
                ServiceDescription sd = new ServiceDescription();
                String serviceId = rs.getString("id");
                sd.setName(rs.getString("sname"));
                sd.setType(rs.getString("stype"));
                sd.setOwnership(rs.getString("sownership"));
                pss.stm_selServiceProtocols.setString(1, serviceId);
                rsS = pss.stm_selServiceProtocols.executeQuery();
                while (rsS.next()) {
                    sd.addProtocols(rsS.getString(PROTOCOL));
                }
                this.closeResultSet(rsS);
                pss.stm_selServiceLanguages.setString(1, serviceId);
                rsS = pss.stm_selServiceLanguages.executeQuery();
                while (rsS.next()) {
                    sd.addOntologies(rsS.getString(ONTOLOGY));
                }
                this.closeResultSet(rsS);
                pss.stm_selServiceOntologies.setString(1, serviceId);
                rsS = pss.stm_selServiceOntologies.executeQuery();
                while (rsS.next()) {
                    sd.addLanguages(rsS.getString(LANGUAGE));
                }
                this.closeResultSet(rsS);
                HashMap<String, MultiValueProperty> multiValues = new HashMap<String, MultiValueProperty>();
                pss.stm_selServiceProperties.setString(1, serviceId);
                rsS = pss.stm_selServiceProperties.executeQuery();
                while (rsS.next()) {
                    String propKey = rsS.getString("propkey");
                    String objStrVal = rsS.getString("propval_obj");
                    String strStrVal = rsS.getString("propval_str");
                    String value = objStrVal == null ? strStrVal : this.deserializeObj(objStrVal);
                    int pos = propKey.indexOf(MULTI_VALUE_PROPERTY_SEPARATOR);
                    if (pos == -1) {
                        Property prop = new Property();
                        prop.setName(propKey);
                        prop.setValue(value);
                        sd.addProperties(prop);
                        continue;
                    }
                    MultiValueProperty mvp = (MultiValueProperty)multiValues.get(propKey = propKey.substring(0, pos));
                    if (mvp == null) {
                        mvp = new MultiValueProperty(propKey, new ArrayList());
                        multiValues.put(propKey, mvp);
                    }
                    mvp.getValues().add(value);
                }
                if (!multiValues.isEmpty()) {
                    Iterator it = multiValues.values().iterator();
                    while (it.hasNext()) {
                        sd.addProperties((MultiValueProperty)it.next());
                    }
                }
                dfd.addServices(sd);
            }
        }
    }

    private final void loadOntologies(String descrId, DFAgentDescription dfd, Map allOntologies) throws SQLException {
        if (allOntologies != null) {
            List ontos = (List)allOntologies.get(descrId);
            if (ontos != null) {
                jade.util.leap.Iterator it = ontos.iterator();
                while (it.hasNext()) {
                    dfd.addOntologies((String)it.next());
                }
            }
        } else {
            PreparedStatements pss = this.getPreparedStatements();
            pss.stm_selOntologies.setString(1, descrId);
            ResultSet rs = pss.stm_selOntologies.executeQuery();
            while (rs.next()) {
                dfd.addOntologies(rs.getString(ONTOLOGY));
            }
            this.closeResultSet(rs);
        }
    }

    private final void loadLanguages(String descrId, DFAgentDescription dfd, Map allLanguages) throws SQLException {
        if (allLanguages != null) {
            List langs = (List)allLanguages.get(descrId);
            if (langs != null) {
                jade.util.leap.Iterator it = langs.iterator();
                while (it.hasNext()) {
                    dfd.addLanguages((String)it.next());
                }
            }
        } else {
            PreparedStatements pss = this.getPreparedStatements();
            pss.stm_selLanguages.setString(1, descrId);
            ResultSet rs = pss.stm_selLanguages.executeQuery();
            while (rs.next()) {
                dfd.addLanguages(rs.getString(LANGUAGE));
            }
            this.closeResultSet(rs);
        }
    }

    private final void loadProtocols(String descrId, DFAgentDescription dfd, Map allProtocols) throws SQLException {
        if (allProtocols != null) {
            List protos = (List)allProtocols.get(descrId);
            if (protos != null) {
                jade.util.leap.Iterator it = protos.iterator();
                while (it.hasNext()) {
                    dfd.addProtocols((String)it.next());
                }
            }
        } else {
            PreparedStatements pss = this.getPreparedStatements();
            pss.stm_selProtocols.setString(1, descrId);
            ResultSet rs = pss.stm_selProtocols.executeQuery();
            while (rs.next()) {
                dfd.addProtocols(rs.getString(PROTOCOL));
            }
            this.closeResultSet(rs);
        }
    }

    private void removeAID(String aid) throws SQLException {
        PreparedStatements pss = this.getPreparedStatements();
        pss.stm_selNrOfDescrForAID.setString(1, aid);
        ResultSet rs = pss.stm_selNrOfDescrForAID.executeQuery();
        int found = 0;
        if (rs.next()) {
            found = Integer.parseInt(rs.getString(1));
        }
        if (found == 0) {
            pss.stm_delAgentUserDefSlot.setString(1, aid);
            pss.stm_delAgentUserDefSlot.execute();
            Collection resolverAIDs = this.getResolverAIDs(aid);
            jade.util.leap.Iterator iter = resolverAIDs.iterator();
            while (iter.hasNext()) {
                this.removeAID((String)iter.next());
            }
            pss.stm_delAgentResolver.setString(1, aid);
            pss.stm_delAgentResolver.execute();
            pss.stm_delAgentAddress.setString(1, aid);
            pss.stm_delAgentAddress.execute();
        }
    }

    private void removeServices(String descrId) throws SQLException {
        ResultSet rs = null;
        PreparedStatements pss = this.getPreparedStatements();
        pss.stm_selServiceId.setString(1, descrId);
        rs = pss.stm_selServiceId.executeQuery();
        boolean executeBatch = false;
        while (rs.next()) {
            String serviceId = rs.getString("id");
            pss.stm_delServiceLanguage.setString(1, serviceId);
            pss.stm_delServiceLanguage.addBatch();
            pss.stm_delServiceOntology.setString(1, serviceId);
            pss.stm_delServiceOntology.addBatch();
            pss.stm_delServiceProtocol.setString(1, serviceId);
            pss.stm_delServiceProtocol.addBatch();
            pss.stm_delServiceProperty.setString(1, serviceId);
            pss.stm_delServiceProperty.addBatch();
            pss.stm_delService.setString(1, descrId);
            pss.stm_delService.addBatch();
            executeBatch = true;
        }
        rs.close();
        if (executeBatch) {
            pss.stm_delServiceLanguage.executeBatch();
            pss.stm_delServiceOntology.executeBatch();
            pss.stm_delServiceProtocol.executeBatch();
            pss.stm_delServiceProperty.executeBatch();
            pss.stm_delService.executeBatch();
        }
    }

    private void remove(String aid) throws SQLException {
        ResultSet rs = null;
        Connection conn = this.getConnectionWrapper().getConnection();
        try {
            PreparedStatements pss = this.getPreparedStatements();
            pss.stm_selDescrId.setString(1, aid);
            rs = pss.stm_selDescrId.executeQuery();
            if (rs.next()) {
                String descrId = rs.getString("id");
                this.closeResultSet(rs);
                pss.stm_delOntology.setString(1, descrId);
                pss.stm_delOntology.execute();
                pss.stm_delProtocol.setString(1, descrId);
                pss.stm_delProtocol.execute();
                pss.stm_delLanguage.setString(1, descrId);
                pss.stm_delLanguage.execute();
                this.removeServices(descrId);
                pss.stm_delAgentDescr.setString(1, descrId);
                pss.stm_delAgentDescr.execute();
                this.removeAID(aid);
                conn.commit();
            } else if (this.logger.isLoggable(Logger.FINE)) {
                this.logger.log(Logger.FINE, "No DF description found to remove for agent '" + aid + "'");
            }
            this.closeResultSet(rs);
        }
        catch (SQLException sqle) {
            try {
                try {
                    conn.rollback();
                }
                catch (SQLException se) {
                    this.logger.log(Logger.SEVERE, "Rollback for incomplete remotion of DFD for agent " + aid + " failed.", se);
                }
                throw sqle;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
    }

    private String createSelect(DFAgentDescription dfdTemplate) throws Exception {
        String tmp;
        StringBuffer select = new StringBuffer("SELECT dfagentdescr.aid FROM dfagentdescr");
        ArrayList lAs = new ArrayList();
        ArrayList lWhere = new ArrayList();
        AID agentAID = dfdTemplate.getName();
        if (agentAID != null) {
            lWhere.add(" dfagentdescr.aid = '" + agentAID.getName() + "'");
        }
        Date lease = dfdTemplate.getLeaseTime();
        long currTime = System.currentTimeMillis();
        lWhere.add(" (dfagentdescr.lease = '-1' OR dfagentdescr.lease > '" + currTime + "')");
        jade.util.leap.Iterator iter = dfdTemplate.getAllLanguages();
        int i = 0;
        while (iter.hasNext()) {
            tmp = LANGUAGE + i;
            lAs.add(", language " + tmp);
            lWhere.add(tmp + ".language='" + (String)iter.next() + "'");
            lWhere.add(tmp + ".descrid=dfagentdescr.id");
            ++i;
        }
        iter = dfdTemplate.getAllOntologies();
        i = 0;
        while (iter.hasNext()) {
            tmp = ONTOLOGY + i;
            lAs.add(", ontology " + tmp);
            lWhere.add(tmp + ".ontology='" + (String)iter.next() + "'");
            lWhere.add(tmp + ".descrid=dfagentdescr.id");
            ++i;
        }
        iter = dfdTemplate.getAllProtocols();
        i = 0;
        while (iter.hasNext()) {
            tmp = PROTOCOL + i;
            lAs.add(", protocol " + tmp);
            lWhere.add(tmp + ".protocol='" + (String)iter.next() + "'");
            lWhere.add(tmp + ".descrid=dfagentdescr.id");
            ++i;
        }
        iter = dfdTemplate.getAllServices();
        i = 0;
        while (iter.hasNext()) {
            String tmp1;
            ServiceDescription service = (ServiceDescription)iter.next();
            String serviceName = service.getName();
            String serviceType = service.getType();
            String serviceOwner = service.getOwnership();
            String tmp2 = SERVICE + i;
            lAs.add(", service " + tmp2);
            if (serviceName != null) {
                lWhere.add(tmp2 + ".sname='" + serviceName + "'");
            }
            if (serviceType != null) {
                lWhere.add(tmp2 + ".stype='" + serviceType + "'");
            }
            if (serviceOwner != null) {
                lWhere.add(tmp2 + ".sownership='" + serviceOwner + "'");
            }
            lWhere.add(tmp2 + ".descrid=dfagentdescr.id");
            ++i;
            jade.util.leap.Iterator iterS = service.getAllLanguages();
            int j = 0;
            while (iterS.hasNext()) {
                tmp1 = SERVICELANGUAGE + j;
                lAs.add(", servicelanguage " + tmp1);
                lWhere.add(tmp1 + ".language='" + (String)iterS.next() + "'");
                lWhere.add(tmp1 + ".serviceid=" + tmp2 + ".id");
                ++j;
            }
            iterS = service.getAllOntologies();
            j = 0;
            while (iterS.hasNext()) {
                tmp1 = SERVICEONTOLOGY + j;
                lAs.add(", serviceontology " + tmp1);
                lWhere.add(tmp1 + ".ontology='" + (String)iterS.next() + "'");
                lWhere.add(tmp1 + ".serviceid=" + tmp2 + ".id");
                ++j;
            }
            iterS = service.getAllProtocols();
            j = 0;
            while (iterS.hasNext()) {
                tmp1 = SERVICEPROTOCOL + j;
                lAs.add(", serviceprotocol " + tmp1);
                lWhere.add(tmp1 + ".protocol='" + (String)iterS.next() + "'");
                lWhere.add(tmp1 + ".serviceid=" + tmp2 + ".id");
                ++j;
            }
            iterS = service.getAllProperties();
            j = 0;
            while (iterS.hasNext()) {
                Object value;
                tmp1 = SERVICEPROPERTY + j;
                lAs.add(", serviceproperty " + tmp1);
                Property prop = (Property)iterS.next();
                if (prop.getName() != null) {
                    if (this.isMultiValueProperty(prop.getName())) {
                        lWhere.add(tmp1 + ".propkey LIKE'" + prop.getName() + "%'");
                    } else {
                        lWhere.add(tmp1 + ".propkey='" + prop.getName() + "'");
                    }
                }
                if ((value = prop.getValue()) != null) {
                    if (DFDBKB.needSerialization(value)) {
                        String hashStr = this.getHashValue(prop.getValue());
                        lWhere.add(tmp1 + ".propvalhash='" + hashStr + "'");
                    } else {
                        lWhere.add(tmp1 + ".propval_str='" + value + "'");
                    }
                }
                lWhere.add(tmp1 + ".serviceid=" + tmp2 + ".id");
                ++j;
            }
        }
        iter = lAs.iterator();
        while (iter.hasNext()) {
            select.append((String)iter.next());
        }
        if (lWhere.size() > 0) {
            select.append(" WHERE ");
        }
        iter = lWhere.iterator();
        i = 0;
        while (iter.hasNext()) {
            if (i > 0) {
                select.append(" and ");
            }
            select.append((String)iter.next());
            ++i;
        }
        return select.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isMultiValueProperty(String propKey) throws SQLException {
        int found = 0;
        ResultSet rs = null;
        try {
            PreparedStatements pss = this.getPreparedStatements();
            pss.stm_selNrOfPropForKey.setString(1, propKey + MULTI_VALUE_PROPERTY_SEPARATOR + "1");
            rs = pss.stm_selNrOfPropForKey.executeQuery();
            if (rs.next()) {
                found = Integer.parseInt(rs.getString(1));
            }
            this.closeResultSet(rs);
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
                catch (Exception e) {
                    this.logger.log(Logger.SEVERE, "Couldn't create the SQL SELECT statement.", e);
                    throw new SQLException("Couldn't create the SQL SELECT statement. " + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
        if (found <= 0) return false;
        return true;
    }

    private void clean() {
        this.cleanExpiredRegistrations();
        this.cleanExpiredSubscriptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanExpiredRegistrations() {
        ResultSet rs = null;
        long currTime = System.currentTimeMillis();
        try {
            PreparedStatements pss = this.getPreparedStatements();
            pss.stm_selExpiredDescr.setString(1, String.valueOf(currTime));
            rs = pss.stm_selExpiredDescr.executeQuery();
            while (rs.next()) {
                this.remove(rs.getString("aid"));
            }
            this.closeResultSet(rs);
        }
        catch (SQLException se) {
            if (this.logger.isLoggable(Logger.WARNING)) {
                this.logger.log(Logger.WARNING, "Error cleaning expired DF registrations", se);
            }
        }
        finally {
            this.closeResultSet(rs);
        }
    }

    private void cleanExpiredSubscriptions() {
    }

    protected void subscribeSingle(Object dfd, SubscriptionResponder.Subscription s) throws SQLException, NotUnderstoodException {
        ACLMessage aclM = s.getMessage();
        String msgStr = aclM.toString();
        String convID = aclM.getConversationId();
        this.registerSubscription(convID, msgStr);
    }

    private void registerSubscription(String convID, String aclM) throws SQLException {
        Connection conn = this.getConnectionWrapper().getConnection();
        try {
            PreparedStatements pss = this.getPreparedStatements();
            String base64Str = new String(Base64.encodeBase64((byte[])aclM.getBytes("US-ASCII")), "US-ASCII");
            pss.stm_insSubscription.setString(1, convID);
            pss.stm_insSubscription.setString(2, base64Str);
            pss.stm_insSubscription.execute();
            conn.commit();
        }
        catch (SQLException sqle) {
            try {
                conn.rollback();
            }
            catch (SQLException se) {
                this.logger.log(Logger.SEVERE, "Rollback for incomplete subscription failed.", se);
            }
            throw sqle;
        }
        catch (Exception e) {
            this.logger.log(Logger.SEVERE, "Error encoding subscription message in Base64.", e);
            throw new SQLException("Error encoding subscription message in Base64. " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getSubscriptions() {
        Vector<SubscriptionResponder.Subscription> subscriptions = new Vector<SubscriptionResponder.Subscription>();
        StringACLCodec codec = new StringACLCodec();
        ResultSet rs = null;
        try {
            rs = this.getPreparedStatements().stm_selSubscriptions.executeQuery();
            while (rs.next()) {
                String base64Str = rs.getString("aclm");
                String aclmStr = new String(Base64.decodeBase64((byte[])base64Str.getBytes("US-ASCII")), "US-ASCII");
                ACLMessage aclm = codec.decode(aclmStr.getBytes(), "US-ASCII");
                subscriptions.add(this.sr.createSubscription(aclm));
            }
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Logger.SEVERE)) {
                this.logger.log(Logger.SEVERE, "Error retrieving subscriptions from the database", e);
            }
        }
        finally {
            this.closeResultSet(rs);
        }
        return subscriptions.elements();
    }

    protected void unsubscribeSingle(SubscriptionResponder.Subscription sub) throws SQLException {
        ACLMessage aclM = sub.getMessage();
        String convID = aclM.getConversationId();
        boolean deleted = this.deregisterSubscription(convID);
        if (!deleted && this.logger.isLoggable(Logger.WARNING)) {
            this.logger.log(Logger.WARNING, "No subscription to delete.");
        }
    }

    private boolean deregisterSubscription(String convID) throws SQLException {
        Connection conn = this.getConnectionWrapper().getConnection();
        try {
            PreparedStatements pss = this.getPreparedStatements();
            pss.stm_delSubscription.setString(1, convID);
            int rowCount = pss.stm_delSubscription.executeUpdate();
            conn.commit();
            return rowCount != 0;
        }
        catch (SQLException sqle) {
            try {
                conn.rollback();
            }
            catch (SQLException se) {
                this.logger.log(Logger.SEVERE, "Rollback for incomplete un-subscription failed.", se);
            }
            throw sqle;
        }
    }

    private void closeResultSet(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
                rs = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void closeStatement(Statement s) {
        block3: {
            try {
                if (s != null) {
                    s.close();
                    s = null;
                }
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Logger.WARNING)) break block3;
                this.logger.log(Logger.WARNING, "Closing SQL statement failed.");
            }
        }
    }

    private String serializeObj(Object obj) throws IOException {
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.close();
        byte[] data = baos.toByteArray();
        return new String(Base64.encodeBase64((byte[])data), "US-ASCII");
    }

    private Object deserializeObj(String str) throws IOException, ClassNotFoundException {
        if (str == null) {
            return null;
        }
        byte[] data = Base64.decodeBase64((byte[])str.getBytes("US-ASCII"));
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        ObjectInputStream ois = new ObjectInputStream(bais);
        return ois.readObject();
    }

    protected String getHashValue(Object obj) throws Exception {
        String HASH_ALGORITHM = "MD5";
        if (obj == null) {
            return "null";
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.close();
            byte[] data = baos.toByteArray();
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(data);
            return new String(Base64.encodeBase64((byte[])digest), "US-ASCII");
        }
        catch (Exception e) {
            throw new Exception("Couldn't create MD5 hash for given object.", e);
        }
    }

    protected String prepDBStr(String s) {
        if (s == null) {
            return "";
        }
        String result = this.replace(s, "'", "''");
        result = this.replace(result, "\"", "\"\"");
        return result;
    }

    protected String replace(String str, String pattern, String replaceWith) {
        int s = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            if (replaceWith != null) {
                result.append(replaceWith);
            }
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }

    private class DFDBKBIterator
    implements KBIterator {
        private Statement s = null;
        private ResultSet rs = null;
        private boolean hasMoreElements = false;

        public DFDBKBIterator(Statement s, ResultSet rs) throws SQLException {
            this.s = s;
            this.rs = rs;
            if (rs != null) {
                this.hasMoreElements = rs.next();
            }
        }

        public boolean hasNext() {
            return this.hasMoreElements;
        }

        public Object next() {
            if (this.hasMoreElements) {
                try {
                    String name = this.rs.getString("aid");
                    DFAgentDescription dfd = DFDBKB.this.getDFD(name);
                    this.hasMoreElements = this.rs.next();
                    return dfd;
                }
                catch (SQLException sqle) {
                    this.hasMoreElements = false;
                    throw new NoSuchElementException("DB Error. " + sqle.getMessage());
                }
            }
            throw new NoSuchElementException("");
        }

        public void remove() {
        }

        public void close() {
            DFDBKB.this.closeResultSet(this.rs);
            DFDBKB.this.closeStatement(this.s);
        }
    }

    private class PreparedStatements {
        private PreparedStatement stm_selNrOfPropForKey;
        private PreparedStatement stm_selNrOfDescrForAID;
        private PreparedStatement stm_selAgentAddresses;
        private PreparedStatement stm_selAgentResolverAIDs;
        private PreparedStatement stm_selAgentUserDefSlot;
        private PreparedStatement stm_selLease;
        private PreparedStatement stm_selProtocols;
        private PreparedStatement stm_selLanguages;
        private PreparedStatement stm_selOntologies;
        private PreparedStatement stm_selServices;
        private PreparedStatement stm_selServiceProtocols;
        private PreparedStatement stm_selServiceLanguages;
        private PreparedStatement stm_selServiceOntologies;
        private PreparedStatement stm_selServiceProperties;
        private PreparedStatement stm_selExpiredDescr;
        private PreparedStatement stm_selSubscriptions;
        private PreparedStatement stm_selAllProtocols;
        private PreparedStatement stm_selCountAllProtocols;
        private PreparedStatement stm_selAllLanguages;
        private PreparedStatement stm_selCountAllLanguages;
        private PreparedStatement stm_selAllOntologies;
        private PreparedStatement stm_selCountAllOntologies;
        private PreparedStatement stm_insAgentDescr;
        private PreparedStatement stm_insAgentAddress;
        private PreparedStatement stm_insAgentUserDefSlot;
        private PreparedStatement stm_insAgentResolverAID;
        private PreparedStatement stm_insLanguage;
        private PreparedStatement stm_insOntology;
        private PreparedStatement stm_insProtocol;
        private PreparedStatement stm_insService;
        private PreparedStatement stm_insServiceProtocol;
        private PreparedStatement stm_insServiceOntology;
        private PreparedStatement stm_insServiceLanguage;
        private PreparedStatement stm_insServiceProperty;
        private PreparedStatement stm_insSubscription;
        private PreparedStatement stm_delAgentDescr;
        private PreparedStatement stm_delAgentUserDefSlot;
        private PreparedStatement stm_delAgentResolver;
        private PreparedStatement stm_delAgentAddress;
        private PreparedStatement stm_selDescrId;
        private PreparedStatement stm_selServiceId;
        private PreparedStatement stm_delService;
        private PreparedStatement stm_delLanguage;
        private PreparedStatement stm_delProtocol;
        private PreparedStatement stm_delOntology;
        private PreparedStatement stm_delServiceLanguage;
        private PreparedStatement stm_delServiceOntology;
        private PreparedStatement stm_delServiceProtocol;
        private PreparedStatement stm_delServiceProperty;
        private PreparedStatement stm_delSubscription;

        private PreparedStatements(Connection conn) throws SQLException {
            this.stm_selNrOfPropForKey = conn.prepareStatement("SELECT COUNT(*) FROM SERVICEPROPERTY  where PROPKEY = ?");
            this.stm_selNrOfDescrForAID = conn.prepareStatement("SELECT COUNT(*) FROM dfagentdescr WHERE aid = ?");
            this.stm_selAgentAddresses = conn.prepareStatement("SELECT address FROM agentaddress WHERE aid = ?");
            this.stm_selAgentResolverAIDs = conn.prepareStatement("SELECT resolveraid FROM agentresolver WHERE aid = ?");
            this.stm_selAgentUserDefSlot = conn.prepareStatement("SELECT slotkey, slotval FROM agentuserdefslot WHERE aid = ?");
            this.stm_selLease = conn.prepareStatement("SELECT id, lease FROM dfagentdescr WHERE aid = ?");
            this.stm_selProtocols = conn.prepareStatement("SELECT protocol FROM protocol WHERE descrid = ?");
            this.stm_selLanguages = conn.prepareStatement("SELECT language FROM language WHERE descrid = ?");
            this.stm_selOntologies = conn.prepareStatement("SELECT ontology FROM ontology WHERE descrid = ?");
            this.stm_selServices = conn.prepareStatement("SELECT id, sname, stype, sownership FROM service WHERE descrid = ?");
            this.stm_selServiceProtocols = conn.prepareStatement("SELECT protocol FROM serviceprotocol WHERE serviceid = ?");
            this.stm_selServiceLanguages = conn.prepareStatement("SELECT ontology FROM serviceontology WHERE serviceid = ?");
            this.stm_selServiceOntologies = conn.prepareStatement("SELECT language FROM servicelanguage WHERE serviceid = ?");
            this.stm_selServiceProperties = conn.prepareStatement("SELECT propkey, propval_str, propval_obj FROM serviceproperty WHERE serviceid = ?");
            this.stm_selDescrId = conn.prepareStatement("SELECT id FROM dfagentdescr WHERE aid = ?");
            this.stm_selServiceId = conn.prepareStatement("SELECT id FROM service WHERE descrid = ?");
            this.stm_selExpiredDescr = conn.prepareStatement("SELECT aid FROM dfagentdescr WHERE lease < ? AND lease <> '-1'");
            this.stm_selSubscriptions = conn.prepareStatement("SELECT * FROM subscription");
            this.stm_selAllProtocols = conn.prepareStatement("SELECT descrid, protocol FROM protocol ORDER BY descrid");
            this.stm_selCountAllProtocols = conn.prepareStatement("SELECT COUNT(*) FROM protocol");
            this.stm_selAllLanguages = conn.prepareStatement("SELECT descrid, language FROM language ORDER BY descrid");
            this.stm_selCountAllLanguages = conn.prepareStatement("SELECT COUNT(*) FROM language");
            this.stm_selAllOntologies = conn.prepareStatement("SELECT descrid, ontology FROM ontology ORDER BY descrid");
            this.stm_selCountAllOntologies = conn.prepareStatement("SELECT COUNT(*) FROM ontology");
            this.stm_insAgentDescr = conn.prepareStatement("INSERT INTO dfagentdescr VALUES (?, ?, ?)");
            this.stm_insAgentAddress = conn.prepareStatement("INSERT INTO agentaddress VALUES (?, ?, ?)");
            this.stm_insAgentUserDefSlot = conn.prepareStatement("INSERT INTO agentuserdefslot VALUES (?, ?, ?, ?)");
            this.stm_insAgentResolverAID = conn.prepareStatement("INSERT INTO agentresolver VALUES (?, ?, ?)");
            this.stm_insLanguage = conn.prepareStatement("INSERT INTO language VALUES (?, ?)");
            this.stm_insOntology = conn.prepareStatement("INSERT INTO ontology VALUES (?, ?)");
            this.stm_insProtocol = conn.prepareStatement("INSERT INTO protocol VALUES (?, ?)");
            this.stm_insService = conn.prepareStatement("INSERT INTO service VALUES (?, ?, ?, ?, ?)");
            this.stm_insServiceProtocol = conn.prepareStatement("INSERT INTO serviceprotocol VALUES (?, ?)");
            this.stm_insServiceOntology = conn.prepareStatement("INSERT INTO serviceontology VALUES (?, ?)");
            this.stm_insServiceLanguage = conn.prepareStatement("INSERT INTO servicelanguage VALUES (?, ?)");
            this.stm_insServiceProperty = conn.prepareStatement("INSERT INTO serviceproperty VALUES (?, ?, ?, ?, ?)");
            this.stm_insSubscription = conn.prepareStatement("INSERT INTO subscription VALUES (?, ?)");
            this.stm_delAgentDescr = conn.prepareStatement("DELETE FROM dfagentdescr WHERE id = ?");
            this.stm_delAgentUserDefSlot = conn.prepareStatement("DELETE FROM agentuserdefslot WHERE aid = ?");
            this.stm_delAgentResolver = conn.prepareStatement("DELETE FROM agentresolver WHERE aid = ?");
            this.stm_delAgentAddress = conn.prepareStatement("DELETE FROM agentaddress WHERE aid = ?");
            this.stm_delLanguage = conn.prepareStatement("DELETE FROM language WHERE descrid = ?");
            this.stm_delProtocol = conn.prepareStatement("DELETE FROM protocol WHERE descrid = ?");
            this.stm_delOntology = conn.prepareStatement("DELETE FROM ontology WHERE descrid = ?");
            this.stm_delService = conn.prepareStatement("DELETE FROM service WHERE descrid = ?");
            this.stm_delServiceLanguage = conn.prepareStatement("DELETE FROM servicelanguage WHERE serviceid = ?");
            this.stm_delServiceOntology = conn.prepareStatement("DELETE FROM serviceontology WHERE serviceid = ?");
            this.stm_delServiceProtocol = conn.prepareStatement("DELETE FROM serviceprotocol WHERE serviceid = ?");
            this.stm_delServiceProperty = conn.prepareStatement("DELETE FROM serviceproperty WHERE serviceid = ?");
            this.stm_delSubscription = conn.prepareStatement("DELETE FROM subscription WHERE id = ?");
        }
    }
}

