/*
 * Decompiled with CFR 0.152.
 */
package jade.lang.acl;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.lang.acl.ISO8601;
import jade.lang.acl.StringACLCodec;
import jade.lang.acl.UnreadableException;
import jade.util.leap.ArrayList;
import jade.util.leap.EmptyIterator;
import jade.util.leap.Iterator;
import jade.util.leap.Properties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;

public class ACLMessage
implements Cloneable,
jade.util.leap.Serializable {
    private static final long serialVersionUID = 3945353187608998130L;
    public static final int ACCEPT_PROPOSAL = 0;
    public static final int AGREE = 1;
    public static final int CANCEL = 2;
    public static final int CFP = 3;
    public static final int CONFIRM = 4;
    public static final int DISCONFIRM = 5;
    public static final int FAILURE = 6;
    public static final int INFORM = 7;
    public static final int INFORM_IF = 8;
    public static final int INFORM_REF = 9;
    public static final int NOT_UNDERSTOOD = 10;
    public static final int PROPOSE = 11;
    public static final int QUERY_IF = 12;
    public static final int QUERY_REF = 13;
    public static final int REFUSE = 14;
    public static final int REJECT_PROPOSAL = 15;
    public static final int REQUEST = 16;
    public static final int REQUEST_WHEN = 17;
    public static final int REQUEST_WHENEVER = 18;
    public static final int SUBSCRIBE = 19;
    public static final int PROXY = 20;
    public static final int PROPAGATE = 21;
    public static final int UNKNOWN = -1;
    private int performative;
    private static final String[] performatives = new String[22];
    public static final String IGNORE_FAILURE = "JADE-ignore-failure";
    public static final String DONT_NOTIFY_FAILURE = "JADE-dont-notify-failure";
    public static final String TRACE = "JADE-trace";
    public static final String NO_CLONE = "JADE-no-clone";
    public static final String SYNCH_DELIVERY = "JADE-synch-delivery";
    public static final String REAL_SENDER = "JADE-real-sender";
    public static final String SF_TIMEOUT = "JADE-SF-timeout";
    public static final String AMS_FAILURE_AGENT_NOT_FOUND = "Agent not found";
    public static final String AMS_FAILURE_AGENT_UNREACHABLE = "Agent unreachable";
    public static final String AMS_FAILURE_SERVICE_ERROR = "Service error";
    public static final String AMS_FAILURE_UNAUTHORIZED = "Not authorized";
    public static final String AMS_FAILURE_FOREIGN_AGENT_UNREACHABLE = "Foreign agent unreachable";
    public static final String AMS_FAILURE_FOREIGN_AGENT_NO_ADDRESS = "Foreign agent with no address";
    public static final String AMS_FAILURE_UNEXPECTED_ERROR = "Unexpected error";
    private AID source = null;
    private static final int RECEIVERS_EXPECTED_SIZE = 1;
    private static final int REPLYTO_EXPECTED_SIZE = 1;
    private ArrayList dests = new ArrayList(1);
    private ArrayList reply_to = null;
    private StringBuffer content = null;
    private byte[] byteSequenceContent = null;
    private String reply_with = null;
    private String in_reply_to = null;
    private String encoding = null;
    private String language = null;
    private String ontology = null;
    private long reply_byInMillisec = 0L;
    private String protocol = null;
    private String conversation_id = null;
    private Properties userDefProps = null;
    private long postTimeStamp = -1L;
    private Envelope messageEnvelope;
    private Long persistentID;

    public static String[] getAllPerformativeNames() {
        return performatives;
    }

    public ACLMessage() {
        this.performative = 10;
    }

    public ACLMessage(int perf) {
        this.performative = perf;
    }

    public void setSender(AID s) {
        this.source = s;
    }

    public void addReceiver(AID r) {
        if (r != null) {
            this.dests.add(r);
        }
    }

    public boolean removeReceiver(AID r) {
        if (r != null) {
            return this.dests.remove(r);
        }
        return false;
    }

    public void clearAllReceiver() {
        this.dests.clear();
    }

    public void addReplyTo(AID dest) {
        if (dest != null) {
            this.reply_to = this.reply_to == null ? new ArrayList(1) : this.reply_to;
            this.reply_to.add(dest);
        }
    }

    public boolean removeReplyTo(AID dest) {
        if (dest != null && this.reply_to != null) {
            return this.reply_to.remove(dest);
        }
        return false;
    }

    public void clearAllReplyTo() {
        if (this.reply_to != null) {
            this.reply_to.clear();
        }
    }

    public void setPerformative(int perf) {
        this.performative = perf;
    }

    public void setContent(String content) {
        this.byteSequenceContent = null;
        this.content = content != null ? new StringBuffer(content) : null;
    }

    public void setByteSequenceContent(byte[] byteSequenceContent) {
        this.content = null;
        this.byteSequenceContent = byteSequenceContent;
    }

    public void setContentObject(Serializable s) throws IOException {
        ByteArrayOutputStream c = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(c);
        oos.writeObject(s);
        oos.flush();
        this.setByteSequenceContent(c.toByteArray());
    }

    public Serializable getContentObject() throws UnreadableException {
        try {
            byte[] data = this.getByteSequenceContent();
            if (data == null) {
                return null;
            }
            ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(data));
            Serializable s = (Serializable)oin.readObject();
            return s;
        }
        catch (Error e) {
            throw new UnreadableException(e.getMessage());
        }
        catch (IOException e1) {
            throw new UnreadableException(e1.getMessage());
        }
        catch (ClassNotFoundException e2) {
            throw new UnreadableException(e2.getMessage());
        }
    }

    public void setReplyWith(String reply) {
        this.reply_with = reply;
    }

    public void setInReplyTo(String reply) {
        this.in_reply_to = reply;
    }

    public void setEncoding(String str) {
        this.encoding = str;
    }

    public void setLanguage(String str) {
        this.language = str;
    }

    public void setOntology(String str) {
        this.ontology = str;
    }

    public void setReplyByDate(Date date) {
        this.reply_byInMillisec = date == null ? 0L : date.getTime();
    }

    public void setProtocol(String str) {
        this.protocol = str;
    }

    public void setConversationId(String str) {
        this.conversation_id = str;
    }

    public Iterator getAllReceiver() {
        return this.dests.iterator();
    }

    public Iterator getAllReplyTo() {
        if (this.reply_to == null) {
            return EmptyIterator.getInstance();
        }
        return this.reply_to.iterator();
    }

    public AID getSender() {
        return this.source;
    }

    public static String getPerformative(int perf) {
        try {
            return performatives[perf];
        }
        catch (Exception e) {
            return performatives[10];
        }
    }

    public static int getInteger(String perf) {
        String tmp = perf.toUpperCase();
        for (int i = 0; i < performatives.length; ++i) {
            if (!performatives[i].equals(tmp)) continue;
            return i;
        }
        return -1;
    }

    public int getPerformative() {
        return this.performative;
    }

    public boolean hasByteSequenceContent() {
        return this.byteSequenceContent != null;
    }

    public String getContent() {
        if (this.content != null) {
            return new String(this.content);
        }
        if (this.byteSequenceContent != null) {
            return new String(this.byteSequenceContent);
        }
        return null;
    }

    public byte[] getByteSequenceContent() {
        if (this.content != null) {
            return this.content.toString().getBytes();
        }
        if (this.byteSequenceContent != null) {
            return this.byteSequenceContent;
        }
        return null;
    }

    public String getReplyWith() {
        return this.reply_with;
    }

    public String getInReplyTo() {
        return this.in_reply_to;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getOntology() {
        return this.ontology;
    }

    public String getReplyBy() {
        if (this.reply_byInMillisec != 0L) {
            return ISO8601.toString(new Date(this.reply_byInMillisec));
        }
        return null;
    }

    public Date getReplyByDate() {
        if (this.reply_byInMillisec != 0L) {
            return new Date(this.reply_byInMillisec);
        }
        return null;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getConversationId() {
        return this.conversation_id;
    }

    public void addUserDefinedParameter(String key, String value) {
        this.userDefProps = this.userDefProps == null ? new Properties() : this.userDefProps;
        this.userDefProps.setProperty(key, value);
    }

    public String getUserDefinedParameter(String key) {
        if (this.userDefProps == null) {
            return null;
        }
        return this.userDefProps.getProperty(key);
    }

    public Properties getAllUserDefinedParameters() {
        this.userDefProps = this.userDefProps == null ? new Properties() : this.userDefProps;
        return this.userDefProps;
    }

    public void setAllUserDefinedParameters(Properties userDefProps) {
        this.userDefProps = userDefProps;
    }

    public boolean removeUserDefinedParameter(String key) {
        return this.clearUserDefinedParameter(key) != null;
    }

    public Object clearUserDefinedParameter(String key) {
        if (this.userDefProps == null) {
            return null;
        }
        return this.userDefProps.remove(key);
    }

    public void setPostTimeStamp() {
        this.postTimeStamp = System.currentTimeMillis();
    }

    public long getPostTimeStamp() {
        return this.postTimeStamp;
    }

    public void setEnvelope(Envelope e) {
        this.messageEnvelope = e;
    }

    public void setDefaultEnvelope() {
        this.messageEnvelope = new Envelope();
        this.messageEnvelope.setFrom(this.source);
        Iterator it = this.dests.iterator();
        while (it.hasNext()) {
            this.messageEnvelope.addTo((AID)it.next());
        }
        this.messageEnvelope.setAclRepresentation("fipa.acl.rep.string.std");
        this.messageEnvelope.setDate(new Date());
    }

    public Envelope getEnvelope() {
        return this.messageEnvelope;
    }

    public String toString() {
        return StringACLCodec.toString(this);
    }

    public synchronized Object clone() {
        ACLMessage result;
        try {
            AID id;
            Iterator it;
            result = (ACLMessage)super.clone();
            result.persistentID = null;
            if (this.source != null) {
                result.source = (AID)this.source.clone();
            }
            if (this.dests != null) {
                result.dests = new ArrayList(this.dests.size());
                it = this.dests.iterator();
                while (it.hasNext()) {
                    id = (AID)it.next();
                    result.dests.add(id.clone());
                }
            }
            if (this.reply_to != null) {
                result.reply_to = new ArrayList(this.reply_to.size());
                it = this.reply_to.iterator();
                while (it.hasNext()) {
                    id = (AID)it.next();
                    result.reply_to.add(id.clone());
                }
            }
            if (this.userDefProps != null) {
                result.userDefProps = (Properties)this.userDefProps.clone();
            }
            if (this.messageEnvelope != null) {
                result.messageEnvelope = (Envelope)this.messageEnvelope.clone();
            }
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError();
        }
        return result;
    }

    public void reset() {
        this.source = null;
        this.dests.clear();
        if (this.reply_to != null) {
            this.reply_to.clear();
        }
        this.performative = 10;
        this.content = null;
        this.byteSequenceContent = null;
        this.reply_with = null;
        this.in_reply_to = null;
        this.encoding = null;
        this.language = null;
        this.ontology = null;
        this.reply_byInMillisec = 0L;
        this.protocol = null;
        this.conversation_id = null;
        if (this.userDefProps != null) {
            this.userDefProps.clear();
        }
    }

    public ACLMessage createReply() {
        ACLMessage m = new ACLMessage(this.getPerformative());
        Iterator it = this.getAllReplyTo();
        while (it.hasNext()) {
            m.addReceiver((AID)it.next());
        }
        if (this.reply_to == null || this.reply_to.isEmpty()) {
            m.addReceiver(this.getSender());
        }
        m.setLanguage(this.getLanguage());
        m.setOntology(this.getOntology());
        m.setProtocol(this.getProtocol());
        m.setInReplyTo(this.getReplyWith());
        if (this.source != null) {
            m.setReplyWith(this.source.getName() + System.currentTimeMillis());
        } else {
            m.setReplyWith("X" + System.currentTimeMillis());
        }
        m.setConversationId(this.getConversationId());
        String trace = this.getUserDefinedParameter(TRACE);
        if (trace != null) {
            m.addUserDefinedParameter(TRACE, trace);
        }
        if (this.messageEnvelope != null) {
            m.setDefaultEnvelope();
            String aclCodec = this.messageEnvelope.getAclRepresentation();
            if (aclCodec != null) {
                m.getEnvelope().setAclRepresentation(aclCodec);
            }
        } else {
            m.setEnvelope(null);
        }
        return m;
    }

    public Iterator getAllIntendedReceiver() {
        Iterator it = null;
        Envelope env = this.getEnvelope();
        if (env != null && !(it = env.getAllIntendedReceiver()).hasNext()) {
            it = env.getAllTo();
        }
        if (it == null || !it.hasNext()) {
            it = this.getAllReceiver();
        }
        return it;
    }

    private Long getPersistentID() {
        return this.persistentID;
    }

    private void setPersistentID(Long l) {
        this.persistentID = l;
    }

    private void setReceivers(ArrayList al) {
        this.dests = al;
    }

    private ArrayList getReceivers() {
        return this.dests;
    }

    private void setReplyTo(ArrayList al) {
        this.reply_to = al;
    }

    private ArrayList getReplyTo() {
        return this.reply_to;
    }

    private void setUserDefinedProperties(jade.util.leap.Serializable p) {
        this.userDefProps = (Properties)p;
    }

    private jade.util.leap.Serializable getUserDefinedProperties() {
        return this.userDefProps;
    }

    static {
        ACLMessage.performatives[0] = "ACCEPT-PROPOSAL";
        ACLMessage.performatives[1] = "AGREE";
        ACLMessage.performatives[2] = "CANCEL";
        ACLMessage.performatives[3] = "CFP";
        ACLMessage.performatives[4] = "CONFIRM";
        ACLMessage.performatives[5] = "DISCONFIRM";
        ACLMessage.performatives[6] = "FAILURE";
        ACLMessage.performatives[7] = "INFORM";
        ACLMessage.performatives[8] = "INFORM-IF";
        ACLMessage.performatives[9] = "INFORM-REF";
        ACLMessage.performatives[10] = "NOT-UNDERSTOOD";
        ACLMessage.performatives[11] = "PROPOSE";
        ACLMessage.performatives[12] = "QUERY-IF";
        ACLMessage.performatives[13] = "QUERY-REF";
        ACLMessage.performatives[14] = "REFUSE";
        ACLMessage.performatives[15] = "REJECT-PROPOSAL";
        ACLMessage.performatives[16] = "REQUEST";
        ACLMessage.performatives[17] = "REQUEST-WHEN";
        ACLMessage.performatives[18] = "REQUEST-WHENEVER";
        ACLMessage.performatives[19] = "SUBSCRIBE";
        ACLMessage.performatives[20] = "PROXY";
        ACLMessage.performatives[21] = "PROPAGATE";
    }
}

