/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.introspector;

import jade.content.AgentAction;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Done;
import jade.core.AID;
import jade.core.Agent;
import jade.core.ContainerID;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.SenderBehaviour;
import jade.core.behaviours.SequentialBehaviour;
import jade.domain.FIPAService;
import jade.domain.JADEAgentManagement.DebugOff;
import jade.domain.JADEAgentManagement.DebugOn;
import jade.domain.introspection.AMSSubscriber;
import jade.domain.introspection.AddedBehaviour;
import jade.domain.introspection.AddedContainer;
import jade.domain.introspection.BornAgent;
import jade.domain.introspection.ChangedAgentState;
import jade.domain.introspection.ChangedBehaviourState;
import jade.domain.introspection.DeadAgent;
import jade.domain.introspection.EventRecord;
import jade.domain.introspection.MovedAgent;
import jade.domain.introspection.Occurred;
import jade.domain.introspection.PostedMessage;
import jade.domain.introspection.ReceivedMessage;
import jade.domain.introspection.RemovedBehaviour;
import jade.domain.introspection.RemovedContainer;
import jade.domain.introspection.ResetEvents;
import jade.domain.introspection.SentMessage;
import jade.domain.introspection.StartNotify;
import jade.gui.AgentTreeModel;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.SimpleAchieveREInitiator;
import jade.proto.SimpleAchieveREResponder;
import jade.tools.ToolAgent;
import jade.tools.introspector.Sensor;
import jade.tools.introspector.SensorManager;
import jade.tools.introspector.gui.IntrospectorGUI;
import jade.tools.introspector.gui.MainWindow;
import jade.util.Event;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class Introspector
extends ToolAgent {
    private Set allAgents = null;
    private Hashtable preload = null;
    public static final int STEP_EVENT = 1;
    public static final int BREAK_EVENT = 2;
    public static final int SLOW_EVENT = 3;
    public static final int GO_EVENT = 4;
    public static final int KILL_EVENT = 5;
    public static final int SUSPEND_EVENT = 6;
    private IntrospectorGUI myGUI;
    private Sensor guiSensor = new Sensor();
    private String myContainerName;
    private Map windowMap = Collections.synchronizedMap(new TreeMap());
    private Set stepByStepAgents = new HashSet();
    private Set slowAgents = new HashSet();
    private Map pendingReplies = new HashMap();
    private Map notifiers = new HashMap();
    private SequentialBehaviour AMSSubscribe = new SequentialBehaviour();

    public void toolSetup() {
        ACLMessage msg = this.getRequest();
        msg.setOntology("JADE-Agent-Management");
        this.AMSSubscribe.addSubBehaviour(new SenderBehaviour(this, this.getSubscribe()));
        this.AMSSubscribe.addSubBehaviour(new IntrospectorAMSListenerBehaviour());
        this.addBehaviour(this.AMSSubscribe);
        this.addBehaviour(new IntrospectionListenerBehaviour());
        this.addBehaviour(new ControlListenerBehaviour(this));
        this.addBehaviour(new RequestListenerBehaviour());
        this.addBehaviour(new SensorManager(this, this.guiSensor){

            public void onEvent(Event ev) {
                AID id = ((MainWindow)ev.getSource()).getDebugged();
                switch (ev.getType()) {
                    case 1: {
                        Introspector.this.proceed(id);
                        break;
                    }
                    case 2: {
                        Introspector.this.stepByStepAgents.add(id);
                        Introspector.this.slowAgents.remove(id);
                        break;
                    }
                    case 3: {
                        Introspector.this.stepByStepAgents.remove(id);
                        Introspector.this.slowAgents.add(id);
                        Introspector.this.proceed(id);
                        break;
                    }
                    case 4: {
                        Introspector.this.stepByStepAgents.remove(id);
                        Introspector.this.slowAgents.remove(id);
                        Introspector.this.proceed(id);
                    }
                }
            }
        });
        this.allAgents = new HashSet();
        this.preload = new Hashtable();
        Object[] arguments = this.getArguments();
        if (arguments != null) {
            for (int i = 0; i < arguments.length; ++i) {
                this.parsePreloadDescription((String)arguments[i]);
            }
        }
        this.myGUI = new IntrospectorGUI(this);
        this.myGUI.setVisible(true);
    }

    public boolean addAgent(AID name) {
        if (!this.windowMap.containsKey(name)) {
            MainWindow m = new MainWindow(this.guiSensor, name);
            this.myGUI.addWindow(m);
            this.windowMap.put(name, m);
            this.requestDebugOn(name);
            return true;
        }
        return false;
    }

    private void requestDebugOn(AID name) {
        try {
            ACLMessage msg = this.getRequest();
            msg.setOntology("JADE-Agent-Management");
            DebugOn dbgOn = new DebugOn();
            dbgOn.setDebugger(this.getAID());
            dbgOn.addDebuggedAgents(name);
            Action a = new Action();
            a.setActor(this.getAMS());
            a.setAction(dbgOn);
            this.getContentManager().fillContent(msg, a);
            this.addBehaviour(new AMSRequester("DebugOn", msg));
        }
        catch (Exception fe) {
            fe.printStackTrace();
        }
    }

    public void removeAgent(AID name) {
        if (this.windowMap.containsKey(name)) {
            try {
                MainWindow m = (MainWindow)this.windowMap.get(name);
                this.myGUI.closeInternal(m);
                this.windowMap.remove(name);
                this.stepByStepAgents.remove(name);
                this.slowAgents.remove(name);
                this.proceed(name);
                ACLMessage msg = this.getRequest();
                msg.setOntology("JADE-Agent-Management");
                DebugOff dbgOff = new DebugOff();
                dbgOff.setDebugger(this.getAID());
                dbgOff.addDebuggedAgents(name);
                Action a = new Action();
                a.setActor(this.getAMS());
                a.setAction(dbgOff);
                this.getContentManager().fillContent(msg, a);
                this.addBehaviour(new AMSRequester("DebugOff", msg));
            }
            catch (Exception fe) {
                fe.printStackTrace();
            }
        }
    }

    public void toolTakeDown() {
        block4: {
            if (!this.windowMap.isEmpty()) {
                ACLMessage msg = this.getRequest();
                msg.setOntology("JADE-Agent-Management");
                DebugOff dbgOff = new DebugOff();
                dbgOff.setDebugger(this.getAID());
                for (AID id : this.windowMap.keySet()) {
                    dbgOff.addDebuggedAgents(id);
                }
                Action a = new Action();
                a.setActor(this.getAMS());
                a.setAction(dbgOff);
                try {
                    this.getContentManager().fillContent(msg, a);
                    FIPAService.doFipaRequestClient(this, msg);
                }
                catch (Exception fe) {
                    if (!this.logger.isLoggable(Logger.WARNING)) break block4;
                    this.logger.log(Logger.WARNING, fe.getMessage());
                }
            }
        }
        this.send(this.getCancel());
        this.myGUI.disposeAsync();
    }

    public AgentTreeModel getModel() {
        return this.myGUI.getModel();
    }

    private void proceed(AID id) {
        String pendingReplyWith = (String)this.pendingReplies.remove(id);
        AID tn = (AID)this.notifiers.get(id);
        if (pendingReplyWith != null && tn != null) {
            ACLMessage msg = new ACLMessage(7);
            msg.addReceiver(tn);
            msg.setInReplyTo(pendingReplyWith);
            this.send(msg);
        }
    }

    public void doDelete() {
        AID amsId = this.getAMS();
        if (this.windowMap.containsKey(amsId)) {
            try {
                MainWindow m = (MainWindow)this.windowMap.get(amsId);
                this.myGUI.closeInternal(m);
                this.windowMap.remove(amsId);
                this.stepByStepAgents.remove(amsId);
                this.slowAgents.remove(amsId);
                this.proceed(amsId);
                ACLMessage msg = this.getRequest();
                msg.setOntology("JADE-Agent-Management");
                DebugOff dbgOff = new DebugOff();
                dbgOff.setDebugger(this.getAID());
                dbgOff.addDebuggedAgents(amsId);
                Action a = new Action();
                a.setActor(this.getAMS());
                a.setAction(dbgOff);
                this.getContentManager().fillContent(msg, a);
                this.addBehaviour(new AMSRequester("DebugOff", msg){

                    public int onEnd() {
                        this.myAgent.doDelete();
                        return 0;
                    }
                });
            }
            catch (Exception fe) {
                fe.printStackTrace();
            }
        } else {
            super.doDelete();
        }
    }

    protected String preloadContains(String agentName) {
        Enumeration enumeration = this.preload.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!this.isMatch(key, agentName)) continue;
            return key;
        }
        return null;
    }

    protected boolean isMatch(String aMatchExpression, String aString) {
        int expressionLength = aMatchExpression.length();
        for (int i = 0; i < expressionLength; ++i) {
            char expChar = aMatchExpression.charAt(i);
            if (expChar == '*') {
                return true;
            }
            if (i == aString.length()) {
                return false;
            }
            if (expChar == '?' || expChar == aString.charAt(i)) continue;
            return false;
        }
        return expressionLength == aString.length();
    }

    private void parsePreloadDescription(String aDescription) {
        int atPos;
        StringTokenizer st = new StringTokenizer(aDescription);
        String name = st.nextToken();
        if (!name.endsWith("*") && (atPos = name.lastIndexOf(64)) == -1) {
            name = name + "@" + this.getHap();
        }
        int performativeCount = ACLMessage.getAllPerformativeNames().length;
        boolean[] filter = new boolean[performativeCount];
        boolean initVal = !st.hasMoreTokens();
        for (int i = 0; i < performativeCount; ++i) {
            filter[i] = initVal;
        }
        while (st.hasMoreTokens()) {
            int perfIndex = ACLMessage.getInteger(st.nextToken());
            if (perfIndex == -1) continue;
            filter[perfIndex] = true;
        }
        this.preload.put(name, filter);
    }

    private class RequestListenerBehaviour
    extends SimpleAchieveREResponder {
        private Action requestAction;
        private AgentAction aa;

        RequestListenerBehaviour() {
            super(Introspector.this, MessageTemplate.and(MessageTemplate.MatchPerformative(16), MessageTemplate.MatchOntology("JADE-Agent-Management")));
        }

        protected ACLMessage prepareResponse(ACLMessage request) {
            ACLMessage response = request.createReply();
            try {
                this.requestAction = (Action)Introspector.this.getContentManager().extractContent(request);
                this.aa = (AgentAction)this.requestAction.getAction();
                if (this.aa instanceof DebugOn || this.aa instanceof DebugOff) {
                    if (Introspector.this.getAID().equals(this.requestAction.getActor())) {
                        response.setPerformative(1);
                        response.setContent(request.getContent());
                    } else {
                        response.setPerformative(14);
                        response.setContent("((unrecognised-parameter-value actor " + this.requestAction.getActor() + "))");
                    }
                } else {
                    response.setPerformative(14);
                    response.setContent("((unsupported-act " + this.aa.getClass().getName() + "))");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                response.setPerformative(10);
            }
            return response;
        }

        protected ACLMessage prepareResultNotification(ACLMessage request, ACLMessage response) {
            int i;
            ArrayList agentsToDebug;
            if (this.aa instanceof DebugOn) {
                DebugOn requestDebugOn = (DebugOn)this.aa;
                agentsToDebug = requestDebugOn.getCloneOfDebuggedAgents();
                for (i = 0; i < agentsToDebug.size(); ++i) {
                    AID aid = (AID)agentsToDebug.get(i);
                    if (Introspector.this.allAgents.contains(aid)) {
                        Introspector.this.addAgent(aid);
                        continue;
                    }
                    int performativeCount = ACLMessage.getAllPerformativeNames().length;
                    boolean[] filter = new boolean[performativeCount];
                    for (int j = 0; j < performativeCount; ++j) {
                        filter[j] = true;
                    }
                    Introspector.this.preload.put(aid.getName(), filter);
                }
            } else {
                DebugOff requestDebugOff = (DebugOff)this.aa;
                agentsToDebug = requestDebugOff.getCloneOfDebuggedAgents();
                for (i = 0; i < agentsToDebug.size(); ++i) {
                    AID aid = (AID)agentsToDebug.get(i);
                    Introspector.this.removeAgent(aid);
                }
            }
            ACLMessage result = request.createReply();
            result.setPerformative(7);
            Done d = new Done(this.requestAction);
            try {
                this.myAgent.getContentManager().fillContent(result, d);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
    }

    private class ControlListenerBehaviour
    extends CyclicBehaviour {
        private MessageTemplate template;

        ControlListenerBehaviour(Agent a) {
            super(a);
            this.template = MessageTemplate.and(MessageTemplate.MatchOntology("JADE-Introspection"), MessageTemplate.MatchConversationId(Introspector.this.getName() + "-control"));
        }

        public void action() {
            ACLMessage message = Introspector.this.receive(this.template);
            if (message != null) {
                try {
                    Done d = (Done)Introspector.this.getContentManager().extractContent(message);
                    Action a = (Action)d.getAction();
                    AID tn = a.getActor();
                    StartNotify sn = (StartNotify)a.getAction();
                    AID observed = sn.getObserved();
                    Introspector.this.notifiers.put(observed, tn);
                }
                catch (Exception fe) {
                    fe.printStackTrace();
                }
            } else {
                this.block();
            }
        }
    }

    private class IntrospectionListenerBehaviour
    extends CyclicBehaviour {
        private MessageTemplate template;
        private Map handlers = new TreeMap(String.CASE_INSENSITIVE_ORDER);

        IntrospectionListenerBehaviour() {
            this.template = MessageTemplate.and(MessageTemplate.MatchOntology("JADE-Introspection"), MessageTemplate.MatchConversationId(Introspector.this.getName() + "-event"));
            this.handlers.put("changed-agent-state", new ToolAgent.EventHandler(){

                public void handle(jade.domain.introspection.Event ev) {
                }
            });
            this.handlers.put("added-behaviour", new ToolAgent.EventHandler(){

                public void handle(jade.domain.introspection.Event ev) {
                    AddedBehaviour ab = (AddedBehaviour)ev;
                    AID agent = ab.getAgent();
                    MainWindow wnd = (MainWindow)Introspector.this.windowMap.get(agent);
                    if (wnd != null) {
                        Introspector.this.myGUI.behaviourAdded(wnd, ab);
                    }
                }
            });
            this.handlers.put("removed-behaviour", new ToolAgent.EventHandler(){

                public void handle(jade.domain.introspection.Event ev) {
                    RemovedBehaviour rb = (RemovedBehaviour)ev;
                    AID agent = rb.getAgent();
                    MainWindow wnd = (MainWindow)Introspector.this.windowMap.get(agent);
                    if (wnd != null) {
                        Introspector.this.myGUI.behaviourRemoved(wnd, rb);
                    }
                }
            });
            this.handlers.put("changed-behaviour-state", new ToolAgent.EventHandler(){

                public void handle(jade.domain.introspection.Event ev) {
                    ChangedBehaviourState cs = (ChangedBehaviourState)ev;
                    AID agent = cs.getAgent();
                    MainWindow wnd = (MainWindow)Introspector.this.windowMap.get(agent);
                    if (wnd != null) {
                        Introspector.this.myGUI.behaviourChangeState(wnd, cs);
                    }
                    if (Introspector.this.stepByStepAgents.contains(agent)) {
                        return;
                    }
                    if (Introspector.this.slowAgents.contains(agent)) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                    Introspector.this.proceed(agent);
                }
            });
            this.handlers.put("sent-message", new ToolAgent.EventHandler(){

                public void handle(jade.domain.introspection.Event ev) {
                    SentMessage sm = (SentMessage)ev;
                    AID sender = sm.getSender();
                    MainWindow wnd = (MainWindow)Introspector.this.windowMap.get(sender);
                    if (wnd != null) {
                        Introspector.this.myGUI.messageSent(wnd, sm);
                    }
                }
            });
            this.handlers.put("received-message", new ToolAgent.EventHandler(){

                public void handle(jade.domain.introspection.Event ev) {
                    ReceivedMessage rm = (ReceivedMessage)ev;
                    AID receiver = rm.getReceiver();
                    MainWindow wnd = (MainWindow)Introspector.this.windowMap.get(receiver);
                    if (wnd != null) {
                        Introspector.this.myGUI.messageReceived(wnd, rm);
                    }
                }
            });
            this.handlers.put("posted-message", new ToolAgent.EventHandler(){

                public void handle(jade.domain.introspection.Event ev) {
                    PostedMessage pm = (PostedMessage)ev;
                    AID receiver = pm.getReceiver();
                    MainWindow wnd = (MainWindow)Introspector.this.windowMap.get(receiver);
                    if (wnd != null) {
                        Introspector.this.myGUI.messagePosted(wnd, pm);
                    }
                }
            });
            this.handlers.put("changed-agent-state", new ToolAgent.EventHandler(){

                public void handle(jade.domain.introspection.Event ev) {
                    ChangedAgentState cas = (ChangedAgentState)ev;
                    AID agent = cas.getAgent();
                    MainWindow wnd = (MainWindow)Introspector.this.windowMap.get(agent);
                    if (wnd != null) {
                        Introspector.this.myGUI.changedAgentState(wnd, cas);
                    }
                }
            });
        }

        public void action() {
            ACLMessage message = Introspector.this.receive(this.template);
            if (message != null) {
                AID name = message.getSender();
                try {
                    String eventName;
                    ToolAgent.EventHandler h;
                    Occurred o = (Occurred)Introspector.this.getContentManager().extractContent(message);
                    EventRecord er = o.getWhat();
                    jade.domain.introspection.Event ev = er.getWhat();
                    if (Introspector.this.logger.isLoggable(Logger.FINEST)) {
                        Introspector.this.logger.log(Logger.FINEST, "Received event " + ev);
                    }
                    if (message.getReplyWith() != null) {
                        ChangedBehaviourState cs = (ChangedBehaviourState)ev;
                        Introspector.this.pendingReplies.put(cs.getAgent(), message.getReplyWith());
                    }
                    if ((h = (ToolAgent.EventHandler)this.handlers.get(eventName = ev.getName())) != null) {
                        h.handle(ev);
                    }
                }
                catch (Exception fe) {
                    fe.printStackTrace();
                }
            } else {
                this.block();
            }
        }
    }

    class IntrospectorAMSListenerBehaviour
    extends ToolAgent.AMSListenerBehaviour {
        IntrospectorAMSListenerBehaviour() {
        }

        protected void installHandlers(Map handlersTable) {
            handlersTable.put("meta_reset-events", new AMSSubscriber.EventHandler(){

                public void handle(jade.domain.introspection.Event ev) {
                    ResetEvents re = (ResetEvents)ev;
                    Introspector.this.myGUI.resetTree();
                }
            });
            handlersTable.put("added-container", new AMSSubscriber.EventHandler(){

                public void handle(jade.domain.introspection.Event ev) {
                    AddedContainer ac = (AddedContainer)ev;
                    ContainerID cid = ac.getContainer();
                    String name = cid.getName();
                    String address = cid.getAddress();
                    try {
                        InetAddress addr = InetAddress.getByName(address);
                        Introspector.this.myGUI.addContainer(name, addr);
                    }
                    catch (UnknownHostException uhe) {
                        Introspector.this.myGUI.addContainer(name, null);
                    }
                }
            });
            handlersTable.put("removed-container", new AMSSubscriber.EventHandler(){

                public void handle(jade.domain.introspection.Event ev) {
                    RemovedContainer rc = (RemovedContainer)ev;
                    ContainerID cid = rc.getContainer();
                    String name = cid.getName();
                    Introspector.this.myGUI.removeContainer(name);
                }
            });
            handlersTable.put("born-agent", new AMSSubscriber.EventHandler(){

                public void handle(jade.domain.introspection.Event ev) {
                    BornAgent ba = (BornAgent)ev;
                    ContainerID cid = ba.getWhere();
                    if (cid != null) {
                        String container = cid.getName();
                        AID agent = ba.getAgent();
                        Introspector.this.allAgents.add(agent);
                        Introspector.this.myGUI.addAgent(container, agent);
                        if (Introspector.this.preloadContains(agent.getName()) != null) {
                            Introspector.this.addAgent(agent);
                        }
                        if (agent.equals(Introspector.this.getAID())) {
                            Introspector.this.myContainerName = container;
                        }
                    }
                }
            });
            handlersTable.put("dead-agent", new AMSSubscriber.EventHandler(){

                public void handle(jade.domain.introspection.Event ev) {
                    DeadAgent da = (DeadAgent)ev;
                    ContainerID cid = da.getWhere();
                    if (cid != null) {
                        String container = cid.getName();
                        AID agent = da.getAgent();
                        Introspector.this.allAgents.remove(agent);
                        MainWindow m = (MainWindow)Introspector.this.windowMap.get(agent);
                        if (m != null) {
                            Introspector.this.myGUI.closeInternal(m);
                            Introspector.this.windowMap.remove(agent);
                        }
                        Introspector.this.myGUI.removeAgent(container, agent);
                    }
                }
            });
            handlersTable.put("moved-agent", new AMSSubscriber.EventHandler(){

                public void handle(jade.domain.introspection.Event ev) {
                    MovedAgent ma = (MovedAgent)ev;
                    AID agent = ma.getAgent();
                    ContainerID from = ma.getFrom();
                    Introspector.this.myGUI.removeAgent(from.getName(), agent);
                    ContainerID to = ma.getTo();
                    Introspector.this.myGUI.addAgent(to.getName(), agent);
                    if (Introspector.this.windowMap.containsKey(agent)) {
                        MainWindow m = (MainWindow)Introspector.this.windowMap.get(agent);
                        Introspector.this.requestDebugOn(agent);
                    }
                }
            });
        }
    }

    private class AMSRequester
    extends SimpleAchieveREInitiator {
        private String actionName;

        public AMSRequester(String an, ACLMessage request) {
            super(Introspector.this, request);
            this.actionName = an;
        }

        protected void handleNotUnderstood(ACLMessage reply) {
            Introspector.this.myGUI.showError("NOT-UNDERSTOOD received during " + this.actionName);
        }

        protected void handleRefuse(ACLMessage reply) {
            Introspector.this.myGUI.showError("REFUSE received during " + this.actionName);
        }

        protected void handleAgree(ACLMessage reply) {
            if (Introspector.this.logger.isLoggable(Logger.FINEST)) {
                Introspector.this.logger.log(Logger.FINEST, "AGREE received");
            }
        }

        protected void handleFailure(ACLMessage reply) {
            Introspector.this.myGUI.showError("FAILURE received during " + this.actionName);
        }

        protected void handleInform(ACLMessage reply) {
            if (Introspector.this.logger.isLoggable(Logger.FINEST)) {
                Introspector.this.logger.log(Logger.FINEST, "INFORM received");
            }
        }
    }
}

