/*
 * Decompiled with CFR 0.152.
 */
package jade.util;

import java.util.Properties;

public class Toolkit {
    private static final String DELIM_START = "{";
    private static final String DELIM_STOP = "}";

    public static String substituteParameters(String expression, Properties parameters) {
        return Toolkit.substituteParameters(expression, parameters, DELIM_START, DELIM_STOP);
    }

    public static String substituteParameters(String expression, Properties parameters, String startDelim, String stopDelim) {
        if (expression == null || parameters == null || parameters.isEmpty()) {
            return expression;
        }
        StringBuffer sbuf = new StringBuffer();
        int position = 0;
        while (true) {
            int paramStart;
            if ((paramStart = expression.indexOf(startDelim, position)) == -1) {
                if (position == 0) {
                    return expression;
                }
                sbuf.append(expression.substring(position, expression.length()));
                return sbuf.toString();
            }
            sbuf.append(expression.substring(position, paramStart));
            int paramEnd = expression.indexOf(stopDelim, paramStart);
            if (paramEnd == -1) {
                throw new IllegalArgumentException('\"' + expression + "\" has no closing brace. Opening brace at position " + paramStart + '.');
            }
            String key = expression.substring(paramStart + startDelim.length(), paramEnd);
            String replacement = parameters.getProperty(key, null);
            if (replacement != null) {
                String recursiveReplacement = Toolkit.substituteParameters(replacement, parameters, startDelim, stopDelim);
                sbuf.append(recursiveReplacement);
            }
            position = paramEnd + stopDelim.length();
        }
    }
}

