/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.barbecue;

import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.Serializable;
import net.sf.jasperreports.barbecue.BarbecueComponent;
import net.sf.jasperreports.barbecue.BarbecueStyleResolver;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.component.BaseComponentContext;
import net.sf.jasperreports.engine.component.ComponentContext;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class StandardBarbecueComponent
implements BarbecueComponent,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_CODE_EXPRESSION = "codeExpression";
    public static final String PROPERTY_APPLICATION_IDENTIFIER_EXPRESSION = "applicationIdentifierExpression";
    public static final String PROPERTY_DRAW_TEXT = "drawText";
    public static final String PROPERTY_CHECKSUM_REQUIRED = "checksumRequired";
    public static final String PROPERTY_BAR_WIDTH = "barWidth";
    public static final String PROPERTY_BAR_HEIGTH = "barHeight";
    public static final String PROPERTY_EVALUATION_TIME = "evaluationTime";
    public static final String PROPERTY_EVALUATION_GROUP = "evaluationGroup";
    public static final String PROPERTY_ROTATION = "rotation";
    private String type;
    private JRExpression codeExpression;
    private JRExpression applicationIdentifierExpression;
    private boolean drawText;
    private boolean checksumRequired;
    private Integer barWidth;
    private Integer barHeight;
    private RotationEnum rotation;
    private EvaluationTimeEnum evaluationTime;
    private String evaluationGroup;
    private ComponentContext context;
    private transient JRPropertyChangeSupport eventSupport;

    public StandardBarbecueComponent() {
    }

    public StandardBarbecueComponent(BarbecueComponent barcode, JRBaseObjectFactory objectFactory) {
        this.type = barcode.getType();
        this.codeExpression = objectFactory.getExpression(barcode.getCodeExpression());
        this.applicationIdentifierExpression = objectFactory.getExpression(barcode.getApplicationIdentifierExpression());
        this.drawText = barcode.isDrawText();
        this.checksumRequired = barcode.isChecksumRequired();
        this.barWidth = barcode.getBarWidth();
        this.barHeight = barcode.getBarHeight();
        this.evaluationTime = barcode.getEvaluationTime();
        this.evaluationGroup = barcode.getEvaluationGroup();
        this.rotation = barcode.getOwnRotation();
        this.context = new BaseComponentContext(barcode.getContext(), objectFactory);
    }

    public void setContext(ComponentContext context) {
        this.context = context;
    }

    public ComponentContext getContext() {
        return this.context;
    }

    @Override
    public JRExpression getCodeExpression() {
        return this.codeExpression;
    }

    public void setCodeExpression(JRExpression codeExpression) {
        JRExpression old = this.codeExpression;
        this.codeExpression = codeExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_CODE_EXPRESSION, (Object)old, (Object)this.codeExpression);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        String old = this.type;
        this.type = type;
        this.getEventSupport().firePropertyChange(PROPERTY_TYPE, (Object)old, (Object)this.type);
    }

    @Override
    public JRExpression getApplicationIdentifierExpression() {
        return this.applicationIdentifierExpression;
    }

    public void setApplicationIdentifierExpression(JRExpression applicationIdentifierExpression) {
        JRExpression old = this.applicationIdentifierExpression;
        this.applicationIdentifierExpression = applicationIdentifierExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_APPLICATION_IDENTIFIER_EXPRESSION, (Object)old, (Object)this.applicationIdentifierExpression);
    }

    @Override
    public Integer getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidth(Integer barWidth) {
        Integer old = this.barWidth;
        this.barWidth = barWidth;
        this.getEventSupport().firePropertyChange(PROPERTY_BAR_WIDTH, (Object)old, (Object)this.barWidth);
    }

    @Override
    public Integer getBarHeight() {
        return this.barHeight;
    }

    public void setBarHeight(Integer barHeight) {
        Integer old = this.barHeight;
        this.barHeight = barHeight;
        this.getEventSupport().firePropertyChange(PROPERTY_BAR_HEIGTH, (Object)old, (Object)this.barHeight);
    }

    @Override
    public RotationEnum getRotation() {
        return BarbecueStyleResolver.getRotation(this.getContext().getComponentElement());
    }

    @Override
    public RotationEnum getOwnRotation() {
        return this.rotation;
    }

    @JsonSetter
    public void setRotation(RotationEnum rotation) {
        RotationEnum old = this.rotation;
        this.rotation = rotation;
        this.getEventSupport().firePropertyChange(PROPERTY_ROTATION, (Object)old, (Object)this.rotation);
    }

    @Override
    public boolean isChecksumRequired() {
        return this.checksumRequired;
    }

    public void setChecksumRequired(boolean checksumRequired) {
        boolean old = this.checksumRequired;
        this.checksumRequired = checksumRequired;
        this.getEventSupport().firePropertyChange(PROPERTY_CHECKSUM_REQUIRED, old, this.checksumRequired);
    }

    @Override
    public boolean isDrawText() {
        return this.drawText;
    }

    public void setDrawText(boolean drawText) {
        boolean old = this.drawText;
        this.drawText = drawText;
        this.getEventSupport().firePropertyChange(PROPERTY_DRAW_TEXT, old, this.drawText);
    }

    public EvaluationTimeEnum getEvaluationTime() {
        return this.evaluationTime;
    }

    public void setEvaluationTime(EvaluationTimeEnum evaluationTime) {
        EvaluationTimeEnum old = this.evaluationTime;
        this.evaluationTime = evaluationTime;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_TIME, (Object)old, (Object)this.evaluationTime);
    }

    public String getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public void setEvaluationGroup(String evaluationGroup) {
        String old = this.evaluationGroup;
        this.evaluationGroup = evaluationGroup;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_GROUP, (Object)old, (Object)this.evaluationGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        StandardBarbecueComponent standardBarbecueComponent = this;
        synchronized (standardBarbecueComponent) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport((Object)this);
            }
        }
        return this.eventSupport;
    }

    public Object clone() {
        StandardBarbecueComponent clone = null;
        try {
            clone = (StandardBarbecueComponent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        clone.codeExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.codeExpression);
        clone.applicationIdentifierExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.applicationIdentifierExpression);
        clone.eventSupport = null;
        return clone;
    }
}

