/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customizers.marker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import net.sf.jasperreports.charts.JRAbstractChartCustomizer;
import net.sf.jasperreports.customizers.type.LayerEnum;
import net.sf.jasperreports.customizers.type.RectangleAnchorEnum;
import net.sf.jasperreports.customizers.type.StrokeStyleEnum;
import net.sf.jasperreports.customizers.type.TextAnchorEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.ui.Layer;
import org.jfree.chart.ui.RectangleInsets;

public abstract class AbstractMarkerCustomizer
extends JRAbstractChartCustomizer {
    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_LABEL_ANCHOR = "labelAnchor";
    public static final String PROPERTY_LABEL_OFFSET_TOP = "labelOffsetTop";
    public static final String PROPERTY_LABEL_OFFSET_LEFT = "labelOffsetLeft";
    public static final String PROPERTY_LABEL_OFFSET_BOTTOM = "labelOffsetBottom";
    public static final String PROPERTY_LABEL_OFFSET_RIGHT = "labelOffsetRight";
    public static final String PROPERTY_LABEL_TEXT_ANCHOR = "labelTextAnchor";
    public static final String PROPERTY_COLOR = "color";
    public static final String PROPERTY_ALPHA = "alpha";
    public static final String PROPERTY_STROKE_WIDTH = "strokeWidth";
    public static final String PROPERTY_STROKE_STYLE = "strokeStyle";
    public static final String PROPERTY_LAYER = "layer";

    protected void configureMarker(Marker marker) {
        Float alpha;
        Color color;
        TextAnchorEnum labelTextAnchor;
        RectangleAnchorEnum labelAnchor;
        String label = this.getProperty(PROPERTY_LABEL);
        if (label != null && label.length() > 0) {
            marker.setLabel(label);
        }
        if ((labelAnchor = RectangleAnchorEnum.getByName(this.getProperty(PROPERTY_LABEL_ANCHOR))) != null) {
            marker.setLabelAnchor(labelAnchor.getRectangleAnchor());
        }
        Double offsetTop = this.getDoubleProperty(PROPERTY_LABEL_OFFSET_TOP);
        Double offsetLeft = this.getDoubleProperty(PROPERTY_LABEL_OFFSET_LEFT);
        Double offsetBottom = this.getDoubleProperty(PROPERTY_LABEL_OFFSET_BOTTOM);
        Double offsetRight = this.getDoubleProperty(PROPERTY_LABEL_OFFSET_RIGHT);
        if (offsetTop != null || offsetLeft != null || offsetBottom != null || offsetRight != null) {
            RectangleInsets currentOffset = marker.getLabelOffset();
            marker.setLabelOffset(new RectangleInsets(offsetTop == null ? currentOffset.getTop() : offsetTop.doubleValue(), offsetLeft == null ? currentOffset.getLeft() : offsetLeft.doubleValue(), offsetBottom == null ? currentOffset.getBottom() : offsetBottom.doubleValue(), offsetRight == null ? currentOffset.getRight() : offsetRight.doubleValue()));
        }
        if ((labelTextAnchor = TextAnchorEnum.getByName(this.getProperty(PROPERTY_LABEL_TEXT_ANCHOR))) != null) {
            marker.setLabelTextAnchor(labelTextAnchor.getTextAnchor());
        }
        if ((color = JRColorUtil.getColor((String)this.getProperty(PROPERTY_COLOR), null)) != null) {
            marker.setPaint((Paint)color);
        }
        if ((alpha = this.getFloatProperty(PROPERTY_ALPHA)) != null) {
            marker.setAlpha(alpha.floatValue());
        }
    }

    protected void configureStroke(Marker marker) {
        Float strokeWidth = this.getFloatProperty(PROPERTY_STROKE_WIDTH);
        if (strokeWidth == null) {
            strokeWidth = Float.valueOf(1.0f);
        }
        BasicStroke basicStroke = this.getStroke(strokeWidth);
        marker.setStroke((Stroke)basicStroke);
    }

    protected BasicStroke getStroke(Float strokeWidth) {
        BasicStroke basicStroke = new BasicStroke(strokeWidth.floatValue());
        StrokeStyleEnum strokeStyle = StrokeStyleEnum.getByName(this.getProperty(PROPERTY_STROKE_STYLE));
        if (strokeStyle != null) {
            switch (strokeStyle) {
                case SOLID: {
                    break;
                }
                case DOTTED: {
                    basicStroke = new BasicStroke(basicStroke.getLineWidth(), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), new float[]{1.0f, 1.0f}, basicStroke.getDashPhase());
                    break;
                }
                case DASHED: {
                    basicStroke = new BasicStroke(basicStroke.getLineWidth(), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), new float[]{10.0f, 10.0f}, basicStroke.getDashPhase());
                }
            }
        }
        return basicStroke;
    }

    protected abstract void addMarker(Plot var1, Marker var2);

    protected Layer getLayer() {
        LayerEnum layer = LayerEnum.getByName(this.getProperty(PROPERTY_LAYER));
        return layer == null ? LayerEnum.BACKGROUND.getLayer() : layer.getLayer();
    }
}

