/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chartthemes.spring;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.sf.jasperreports.chartthemes.spring.ChartThemesUtilities;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialLayerChangeEvent;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialPointer;
import org.jfree.chart.plot.dial.DialScale;
import org.jfree.io.SerialUtilities;

public class ScaledDialPointer
extends DialPointer.Pointer {
    private static final long serialVersionUID = 10200L;
    private Paint fillPaint;
    private int scale;

    public ScaledDialPointer() {
        this(0, 0.03, Color.BLACK, Color.BLACK, 1);
    }

    public ScaledDialPointer(int scale) {
        this(0, 0.03, Color.BLACK, Color.BLACK, scale);
    }

    public ScaledDialPointer(int scale, Paint fillPaint, Paint outlinePaint) {
        this(0, 0.03, fillPaint, outlinePaint, scale);
    }

    public ScaledDialPointer(int scale, double widthRadius) {
        this(0, widthRadius, Color.BLACK, Color.BLACK, scale);
    }

    public ScaledDialPointer(int datasetIndex, double widthRadius, Paint fillPaint, Paint outlinePaint, int scale) {
        super(datasetIndex);
        this.setWidthRadius(widthRadius);
        this.fillPaint = fillPaint;
        this.setOutlinePaint(outlinePaint);
        this.scale = scale;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.fillPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent((DialLayer)this));
    }

    public void draw(Graphics2D g2, DialPlot plot, Rectangle2D frame, Rectangle2D view) {
        g2.setStroke(new BasicStroke(1.0f));
        Rectangle2D lengthRect = DialPlot.rectangleByRadius((Rectangle2D)frame, (double)this.getRadius(), (double)this.getRadius());
        Rectangle2D widthRect = DialPlot.rectangleByRadius((Rectangle2D)frame, (double)this.getWidthRadius(), (double)this.getWidthRadius());
        double value = ChartThemesUtilities.getScaledValue(plot.getValue(this.getDatasetIndex()), this.scale);
        DialScale scale = plot.getScaleForDataset(this.getDatasetIndex());
        double angle = scale.valueToAngle(value);
        Arc2D.Double arc1 = new Arc2D.Double(lengthRect, angle, 0.0, 0);
        Point2D pt1 = arc1.getEndPoint();
        Arc2D.Double arc2 = new Arc2D.Double(widthRect, angle - 90.0, 180.0, 0);
        Point2D pt2 = arc2.getStartPoint();
        Point2D pt3 = arc2.getEndPoint();
        Arc2D.Double arc3 = new Arc2D.Double(widthRect, angle - 180.0, 0.0, 0);
        Point2D pt4 = arc3.getStartPoint();
        GeneralPath gp = new GeneralPath();
        gp.moveTo((float)pt1.getX(), (float)pt1.getY());
        gp.lineTo((float)pt2.getX(), (float)pt2.getY());
        gp.lineTo((float)pt4.getX(), (float)pt4.getY());
        gp.lineTo((float)pt3.getX(), (float)pt3.getY());
        gp.closePath();
        g2.setPaint(this.fillPaint);
        g2.fill(gp);
        g2.setPaint(this.getOutlinePaint());
        Line2D.Double line = new Line2D.Double(frame.getCenterX(), frame.getCenterY(), pt1.getX(), pt1.getY());
        line.setLine(pt2, pt3);
        g2.draw(line);
        line.setLine(pt3, pt1);
        g2.draw(line);
        line.setLine(pt2, pt1);
        g2.draw(line);
        line.setLine(pt2, pt4);
        g2.draw(line);
        line.setLine(pt3, pt4);
        g2.draw(line);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ScaledDialPointer)) {
            return false;
        }
        ScaledDialPointer that = (ScaledDialPointer)((Object)obj);
        if (!this.fillPaint.equals(that.fillPaint)) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = HashUtilities.hashCode((int)result, (Paint)this.fillPaint);
        return result;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.fillPaint, (ObjectOutputStream)stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.fillPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
    }
}

