/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chartthemes.simple;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.jasperreports.chartthemes.simple.ChartThemeSettings;
import net.sf.jasperreports.chartthemes.simple.SimpleChartTheme;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.VersionComparator;
import net.sf.jasperreports.jackson.util.JacksonUtil;

public class XmlChartTheme
extends SimpleChartTheme {
    private String file;

    public XmlChartTheme() {
    }

    public XmlChartTheme(String file) {
        this.file = file;
    }

    public void setFile(String file) {
        this.file = file;
        this.chartThemeSettings = null;
    }

    @Override
    public ChartThemeSettings getChartThemeSettings() {
        if (this.chartThemeSettings == null) {
            this.chartThemeSettings = XmlChartTheme.loadSettings(this.file);
        }
        return this.chartThemeSettings;
    }

    public static ChartThemeSettings loadSettings(String file) {
        InputStream is = null;
        try {
            is = JRLoader.getLocationInputStream((String)file);
            ChartThemeSettings chartThemeSettings = XmlChartTheme.loadSettings(is);
            return chartThemeSettings;
        }
        catch (JRException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static ChartThemeSettings loadSettings(InputStream is) {
        return (ChartThemeSettings)JacksonUtil.getInstance((JasperReportsContext)DefaultJasperReportsContext.getInstance()).loadXml(is, ChartThemeSettings.class);
    }

    public static void saveSettings(ChartThemeSettings settings, Writer writer) {
        XmlChartTheme.saveSettings((JasperReportsContext)DefaultJasperReportsContext.getInstance(), settings, writer);
    }

    public static void saveSettings(JasperReportsContext jasperReportsContext, ChartThemeSettings settings, Writer writer) {
        VersionComparator versionComparator = new VersionComparator();
        String targetVersion = JRPropertiesUtil.getInstance((JasperReportsContext)jasperReportsContext).getProperty("net.sf.jasperreports.report.version");
        if (versionComparator.compare(targetVersion, "6.19.0") >= 0) {
            String xml = JacksonUtil.getInstance((JasperReportsContext)DefaultJasperReportsContext.getInstance()).getXmlString((Object)settings);
            try {
                writer.write(xml);
            }
            catch (IOException e) {
                throw new JRRuntimeException((Throwable)e);
            }
        }
        try {
            Class<?> clazz = XmlChartTheme.class.getClassLoader().loadClass("net.sf.jasperreports.chartthemes.simple.XmlChartThemeCastorWriter");
            Method method = clazz.getMethod("saveSettings", ChartThemeSettings.class, Writer.class);
            method.invoke(null, settings, writer);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new JRRuntimeException((Throwable)e);
        }
    }

    public static void saveSettings(ChartThemeSettings settings, File file) {
        XmlChartTheme.saveSettings((JasperReportsContext)DefaultJasperReportsContext.getInstance(), settings, file);
    }

    public static void saveSettings(JasperReportsContext jasperReportsContext, ChartThemeSettings settings, File file) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            XmlChartTheme.saveSettings(jasperReportsContext, settings, writer);
        }
        catch (IOException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String saveSettings(ChartThemeSettings settings) {
        return XmlChartTheme.saveSettings((JasperReportsContext)DefaultJasperReportsContext.getInstance(), settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveSettings(JasperReportsContext jasperReportsContext, ChartThemeSettings settings) {
        StringWriter writer = new StringWriter();
        try {
            XmlChartTheme.saveSettings(jasperReportsContext, settings, writer);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        return writer.toString();
    }
}

