/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chartthemes.simple.handlers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import net.sf.jasperreports.engine.JRFont;

public class JRFontSerializer
extends StdSerializer<JRFont> {
    private static final long serialVersionUID = 1L;

    public JRFontSerializer() {
        this(null);
    }

    public JRFontSerializer(Class<JRFont> vc) {
        super(vc);
    }

    public void serialize(JRFont value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        Boolean strikeThrough;
        Boolean underline;
        Boolean italic;
        Boolean bold;
        Float fontSize;
        if (jgen instanceof ToXmlGenerator) {
            ((ToXmlGenerator)jgen).setNextIsAttribute(true);
        }
        jgen.writeStartObject();
        String fontName = value.getOwnFontName();
        if (fontName != null) {
            jgen.writeStringField("font-name", fontName);
        }
        if ((fontSize = value.getOwnFontSize()) != null) {
            jgen.writeNumberField("font-size", fontSize.floatValue());
        }
        if ((bold = value.isOwnBold()) != null) {
            jgen.writeBooleanField("bold", bold.booleanValue());
        }
        if ((italic = value.isOwnItalic()) != null) {
            jgen.writeBooleanField("italic", italic.booleanValue());
        }
        if ((underline = value.isOwnUnderline()) != null) {
            jgen.writeBooleanField("underline", underline.booleanValue());
        }
        if ((strikeThrough = value.isOwnStrikeThrough()) != null) {
            jgen.writeBooleanField("strike-through", strikeThrough.booleanValue());
        }
        jgen.writeEndObject();
    }
}

