/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts;

import java.util.List;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRChart;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRGanttDataset;
import net.sf.jasperreports.charts.JRGanttSeries;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPieSeries;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.charts.type.ChartTypeEnum;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.engine.JRAnchor;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRHyperlink;

public class ChartsExpressionCollector {
    private final JRExpressionCollector parent;

    public ChartsExpressionCollector(JRExpressionCollector parent) {
        this.parent = parent;
    }

    public void collect(JRChart chart) {
        this.parent.collectElement((JRElement)chart);
        this.parent.collectAnchor((JRAnchor)chart);
        this.parent.collectHyperlink((JRHyperlink)chart);
        this.parent.addExpression(chart.getTitleExpression());
        this.parent.addExpression(chart.getSubtitleExpression());
        if (chart.getChartType() != ChartTypeEnum.MULTI_AXIS) {
            chart.getDataset().collectExpressions(this);
        }
        chart.getPlot().collectExpressions(this);
    }

    public void collect(JRPieDataset pieDataset) {
        this.parent.collect((JRElementDataset)pieDataset);
        JRExpressionCollector datasetCollector = this.parent.getCollector((JRElementDataset)pieDataset);
        ChartsExpressionCollector datasetChartsCollector = new ChartsExpressionCollector(datasetCollector);
        JRPieSeries[] pieSeries = pieDataset.getSeries();
        if (pieSeries != null && pieSeries.length > 0) {
            for (int j = 0; j < pieSeries.length; ++j) {
                datasetChartsCollector.collect(pieSeries[j]);
            }
        }
        datasetCollector.addExpression(pieDataset.getOtherKeyExpression());
        datasetCollector.addExpression(pieDataset.getOtherLabelExpression());
        datasetCollector.collectHyperlink(pieDataset.getOtherSectionHyperlink());
    }

    public void collect(JRCategoryDataset categoryDataset) {
        this.parent.collect((JRElementDataset)categoryDataset);
        JRCategorySeries[] categorySeries = categoryDataset.getSeries();
        if (categorySeries != null && categorySeries.length > 0) {
            JRExpressionCollector datasetCollector = this.parent.getCollector((JRElementDataset)categoryDataset);
            ChartsExpressionCollector datasetChartsCollector = new ChartsExpressionCollector(datasetCollector);
            for (int j = 0; j < categorySeries.length; ++j) {
                datasetChartsCollector.collect(categorySeries[j]);
            }
        }
    }

    public void collect(JRXyDataset xyDataset) {
        this.parent.collect((JRElementDataset)xyDataset);
        JRXySeries[] xySeries = xyDataset.getSeries();
        if (xySeries != null && xySeries.length > 0) {
            JRExpressionCollector datasetCollector = this.parent.getCollector((JRElementDataset)xyDataset);
            ChartsExpressionCollector datasetChartsCollector = new ChartsExpressionCollector(datasetCollector);
            for (int j = 0; j < xySeries.length; ++j) {
                datasetChartsCollector.collect(xySeries[j]);
            }
        }
    }

    public void collect(JRTimeSeriesDataset timeSeriesDataset) {
        this.parent.collect((JRElementDataset)timeSeriesDataset);
        JRTimeSeries[] timeSeries = timeSeriesDataset.getSeries();
        if (timeSeries != null && timeSeries.length > 0) {
            JRExpressionCollector datasetCollector = this.parent.getCollector((JRElementDataset)timeSeriesDataset);
            ChartsExpressionCollector datasetChartsCollector = new ChartsExpressionCollector(datasetCollector);
            for (int i = 0; i < timeSeries.length; ++i) {
                datasetChartsCollector.collect(timeSeries[i]);
            }
        }
    }

    public void collect(JRTimePeriodDataset timePeriodDataset) {
        this.parent.collect((JRElementDataset)timePeriodDataset);
        JRTimePeriodSeries[] timePeriodSeries = timePeriodDataset.getSeries();
        if (timePeriodSeries != null && timePeriodSeries.length > 0) {
            JRExpressionCollector datasetCollector = this.parent.getCollector((JRElementDataset)timePeriodDataset);
            ChartsExpressionCollector datasetChartsCollector = new ChartsExpressionCollector(datasetCollector);
            for (int i = 0; i < timePeriodSeries.length; ++i) {
                datasetChartsCollector.collect(timePeriodSeries[i]);
            }
        }
    }

    public void collect(JRGanttDataset ganttDataset) {
        this.parent.collect((JRElementDataset)ganttDataset);
        JRGanttSeries[] ganttSeries = ganttDataset.getSeries();
        if (ganttSeries != null && ganttSeries.length > 0) {
            JRExpressionCollector datasetCollector = this.parent.getCollector((JRElementDataset)ganttDataset);
            ChartsExpressionCollector datasetChartsCollector = new ChartsExpressionCollector(datasetCollector);
            for (int j = 0; j < ganttSeries.length; ++j) {
                datasetChartsCollector.collect(ganttSeries[j]);
            }
        }
    }

    public void collect(JRValueDataset valueDataset) {
        this.parent.collect((JRElementDataset)valueDataset);
        JRExpressionCollector datasetCollector = this.parent.getCollector((JRElementDataset)valueDataset);
        datasetCollector.addExpression(valueDataset.getValueExpression());
    }

    private void collect(JRXySeries xySeries) {
        this.parent.addExpression(xySeries.getSeriesExpression());
        this.parent.addExpression(xySeries.getXValueExpression());
        this.parent.addExpression(xySeries.getYValueExpression());
        this.parent.addExpression(xySeries.getLabelExpression());
        this.parent.collectHyperlink(xySeries.getItemHyperlink());
    }

    private void collect(JRPieSeries pieSeries) {
        this.parent.addExpression(pieSeries.getKeyExpression());
        this.parent.addExpression(pieSeries.getValueExpression());
        this.parent.addExpression(pieSeries.getLabelExpression());
        this.parent.collectHyperlink(pieSeries.getSectionHyperlink());
    }

    private void collect(JRCategorySeries categorySeries) {
        this.parent.addExpression(categorySeries.getSeriesExpression());
        this.parent.addExpression(categorySeries.getCategoryExpression());
        this.parent.addExpression(categorySeries.getValueExpression());
        this.parent.addExpression(categorySeries.getLabelExpression());
        this.parent.collectHyperlink(categorySeries.getItemHyperlink());
    }

    private void collect(JRGanttSeries ganttSeries) {
        this.parent.addExpression(ganttSeries.getSeriesExpression());
        this.parent.addExpression(ganttSeries.getTaskExpression());
        this.parent.addExpression(ganttSeries.getSubtaskExpression());
        this.parent.addExpression(ganttSeries.getStartDateExpression());
        this.parent.addExpression(ganttSeries.getEndDateExpression());
        this.parent.addExpression(ganttSeries.getPercentExpression());
        this.parent.addExpression(ganttSeries.getLabelExpression());
        this.parent.collectHyperlink(ganttSeries.getItemHyperlink());
    }

    public void collect(JRBarPlot barPlot) {
        this.parent.addExpression(barPlot.getCategoryAxisLabelExpression());
        this.parent.addExpression(barPlot.getValueAxisLabelExpression());
        this.parent.addExpression(barPlot.getDomainAxisMinValueExpression());
        this.parent.addExpression(barPlot.getDomainAxisMaxValueExpression());
        this.parent.addExpression(barPlot.getRangeAxisMinValueExpression());
        this.parent.addExpression(barPlot.getRangeAxisMaxValueExpression());
    }

    public void collect(JRBar3DPlot barPlot) {
        this.parent.addExpression(barPlot.getCategoryAxisLabelExpression());
        this.parent.addExpression(barPlot.getValueAxisLabelExpression());
        this.parent.addExpression(barPlot.getRangeAxisMinValueExpression());
        this.parent.addExpression(barPlot.getRangeAxisMaxValueExpression());
    }

    public void collect(JRLinePlot linePlot) {
        this.parent.addExpression(linePlot.getCategoryAxisLabelExpression());
        this.parent.addExpression(linePlot.getValueAxisLabelExpression());
        this.parent.addExpression(linePlot.getDomainAxisMinValueExpression());
        this.parent.addExpression(linePlot.getDomainAxisMaxValueExpression());
        this.parent.addExpression(linePlot.getRangeAxisMinValueExpression());
        this.parent.addExpression(linePlot.getRangeAxisMaxValueExpression());
    }

    public void collect(JRTimeSeriesPlot timeSeriesPlot) {
        this.parent.addExpression(timeSeriesPlot.getTimeAxisLabelExpression());
        this.parent.addExpression(timeSeriesPlot.getValueAxisLabelExpression());
        this.parent.addExpression(timeSeriesPlot.getDomainAxisMinValueExpression());
        this.parent.addExpression(timeSeriesPlot.getDomainAxisMaxValueExpression());
        this.parent.addExpression(timeSeriesPlot.getRangeAxisMinValueExpression());
        this.parent.addExpression(timeSeriesPlot.getRangeAxisMaxValueExpression());
    }

    public void collect(JRScatterPlot scatterPlot) {
        this.parent.addExpression(scatterPlot.getXAxisLabelExpression());
        this.parent.addExpression(scatterPlot.getYAxisLabelExpression());
        this.parent.addExpression(scatterPlot.getDomainAxisMinValueExpression());
        this.parent.addExpression(scatterPlot.getDomainAxisMaxValueExpression());
        this.parent.addExpression(scatterPlot.getRangeAxisMinValueExpression());
        this.parent.addExpression(scatterPlot.getRangeAxisMaxValueExpression());
    }

    public void collect(JRAreaPlot areaPlot) {
        this.parent.addExpression(areaPlot.getCategoryAxisLabelExpression());
        this.parent.addExpression(areaPlot.getValueAxisLabelExpression());
        this.parent.addExpression(areaPlot.getDomainAxisMinValueExpression());
        this.parent.addExpression(areaPlot.getDomainAxisMaxValueExpression());
        this.parent.addExpression(areaPlot.getRangeAxisMinValueExpression());
        this.parent.addExpression(areaPlot.getRangeAxisMaxValueExpression());
    }

    private void collect(JRTimeSeries timeSeries) {
        this.parent.addExpression(timeSeries.getSeriesExpression());
        this.parent.addExpression(timeSeries.getTimePeriodExpression());
        this.parent.addExpression(timeSeries.getValueExpression());
        this.parent.addExpression(timeSeries.getLabelExpression());
        this.parent.collectHyperlink(timeSeries.getItemHyperlink());
    }

    private void collect(JRTimePeriodSeries timePeriodSeries) {
        this.parent.addExpression(timePeriodSeries.getSeriesExpression());
        this.parent.addExpression(timePeriodSeries.getStartDateExpression());
        this.parent.addExpression(timePeriodSeries.getEndDateExpression());
        this.parent.addExpression(timePeriodSeries.getValueExpression());
        this.parent.addExpression(timePeriodSeries.getLabelExpression());
        this.parent.collectHyperlink(timePeriodSeries.getItemHyperlink());
    }

    public void collect(JRXyzDataset xyzDataset) {
        this.parent.collect((JRElementDataset)xyzDataset);
        JRXyzSeries[] xyzSeries = xyzDataset.getSeries();
        if (xyzSeries != null && xyzSeries.length > 0) {
            JRExpressionCollector datasetCollector = this.parent.getCollector((JRElementDataset)xyzDataset);
            ChartsExpressionCollector datasetChartsCollector = new ChartsExpressionCollector(datasetCollector);
            for (int j = 0; j < xyzSeries.length; ++j) {
                datasetChartsCollector.collect(xyzSeries[j]);
            }
        }
    }

    private void collect(JRXyzSeries xyzSeries) {
        this.parent.addExpression(xyzSeries.getSeriesExpression());
        this.parent.addExpression(xyzSeries.getXValueExpression());
        this.parent.addExpression(xyzSeries.getYValueExpression());
        this.parent.addExpression(xyzSeries.getZValueExpression());
        this.parent.collectHyperlink(xyzSeries.getItemHyperlink());
    }

    public void collect(JRBubblePlot bubblePlot) {
        this.parent.addExpression(bubblePlot.getXAxisLabelExpression());
        this.parent.addExpression(bubblePlot.getYAxisLabelExpression());
        this.parent.addExpression(bubblePlot.getDomainAxisMinValueExpression());
        this.parent.addExpression(bubblePlot.getDomainAxisMaxValueExpression());
        this.parent.addExpression(bubblePlot.getRangeAxisMinValueExpression());
        this.parent.addExpression(bubblePlot.getRangeAxisMaxValueExpression());
    }

    public void collect(JRHighLowPlot highLowPlot) {
        this.parent.addExpression(highLowPlot.getTimeAxisLabelExpression());
        this.parent.addExpression(highLowPlot.getValueAxisLabelExpression());
        this.parent.addExpression(highLowPlot.getDomainAxisMinValueExpression());
        this.parent.addExpression(highLowPlot.getDomainAxisMaxValueExpression());
        this.parent.addExpression(highLowPlot.getRangeAxisMinValueExpression());
        this.parent.addExpression(highLowPlot.getRangeAxisMaxValueExpression());
    }

    public void collect(JRDataRange dataRange) {
        if (dataRange != null) {
            this.parent.addExpression(dataRange.getLowExpression());
            this.parent.addExpression(dataRange.getHighExpression());
        }
    }

    public void collect(JRMeterPlot meterPlot) {
        List<JRMeterInterval> intervals = meterPlot.getIntervals();
        if (intervals != null) {
            for (JRMeterInterval interval : intervals) {
                this.collect(interval.getDataRange());
            }
        }
        this.collect(meterPlot.getDataRange());
    }

    public void collect(JRThermometerPlot thermometerPlot) {
        this.collect(thermometerPlot.getDataRange());
        this.collect(thermometerPlot.getLowRange());
        this.collect(thermometerPlot.getMediumRange());
        this.collect(thermometerPlot.getHighRange());
    }

    public void collect(JRHighLowDataset highLowDataset) {
        this.parent.collect((JRElementDataset)highLowDataset);
        JRExpressionCollector datasetCollector = this.parent.getCollector((JRElementDataset)highLowDataset);
        datasetCollector.addExpression(highLowDataset.getSeriesExpression());
        datasetCollector.addExpression(highLowDataset.getDateExpression());
        datasetCollector.addExpression(highLowDataset.getHighExpression());
        datasetCollector.addExpression(highLowDataset.getLowExpression());
        datasetCollector.addExpression(highLowDataset.getOpenExpression());
        datasetCollector.addExpression(highLowDataset.getCloseExpression());
        datasetCollector.addExpression(highLowDataset.getVolumeExpression());
        datasetCollector.collectHyperlink(highLowDataset.getItemHyperlink());
    }

    public void collect(JRCandlestickPlot candlestickPlot) {
        this.parent.addExpression(candlestickPlot.getTimeAxisLabelExpression());
        this.parent.addExpression(candlestickPlot.getValueAxisLabelExpression());
        this.parent.addExpression(candlestickPlot.getDomainAxisMinValueExpression());
        this.parent.addExpression(candlestickPlot.getDomainAxisMaxValueExpression());
        this.parent.addExpression(candlestickPlot.getRangeAxisMinValueExpression());
        this.parent.addExpression(candlestickPlot.getRangeAxisMaxValueExpression());
    }
}

