/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import net.sf.jasperreports.charts.ChartsExpressionCollector;
import net.sf.jasperreports.charts.JRChartDataset;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.base.ChartsBaseObjectFactory;
import net.sf.jasperreports.charts.base.JRBaseChartDataset;
import net.sf.jasperreports.charts.design.ChartsVerifier;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseXyDataset
extends JRBaseChartDataset
implements JRXyDataset {
    private static final long serialVersionUID = 10200L;
    protected JRXySeries[] xySeries;

    public JRBaseXyDataset(JRChartDataset dataset) {
        super(dataset);
    }

    public JRBaseXyDataset(JRXyDataset dataset, ChartsBaseObjectFactory factory) {
        super(dataset, factory);
        JRXySeries[] srcXySeries = dataset.getSeries();
        if (srcXySeries != null && srcXySeries.length > 0) {
            this.xySeries = new JRXySeries[srcXySeries.length];
            for (int i = 0; i < this.xySeries.length; ++i) {
                this.xySeries[i] = factory.getXySeries(srcXySeries[i]);
            }
        }
    }

    @Override
    public JRXySeries[] getSeries() {
        return this.xySeries;
    }

    @Override
    public byte getDatasetType() {
        return 3;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect((JRElementDataset)this);
    }

    @Override
    public void collectExpressions(ChartsExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void validate(ChartsVerifier verifier) {
        verifier.verify(this);
    }

    public Object clone() {
        JRBaseXyDataset clone = (JRBaseXyDataset)super.clone();
        clone.xySeries = (JRXySeries[])JRCloneUtils.cloneArray((JRCloneable[])this.xySeries);
        return clone;
    }
}

