/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.design;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.charts.ChartsExpressionCollector;
import net.sf.jasperreports.charts.JRChartDataset;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.design.ChartsVerifier;
import net.sf.jasperreports.charts.design.JRDesignChartDataset;
import net.sf.jasperreports.charts.type.TimePeriodEnum;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRDesignTimeSeriesDataset
extends JRDesignChartDataset
implements JRTimeSeriesDataset {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_TIME_PERIOD = "timePeriod";
    public static final String PROPERTY_TIME_SERIES = "timeSeries";
    private List<JRTimeSeries> timeSeriesList = new ArrayList<JRTimeSeries>();
    private TimePeriodEnum timePeriod;

    @JsonCreator
    private JRDesignTimeSeriesDataset() {
        this(null);
    }

    public JRDesignTimeSeriesDataset(JRChartDataset dataset) {
        super(dataset);
    }

    @Override
    public JRTimeSeries[] getSeries() {
        JRTimeSeries[] timeSeriesArray = new JRTimeSeries[this.timeSeriesList.size()];
        this.timeSeriesList.toArray(timeSeriesArray);
        return timeSeriesArray;
    }

    @JsonIgnore
    public List<JRTimeSeries> getSeriesList() {
        return this.timeSeriesList;
    }

    @JsonSetter
    private void setSeries(List<JRTimeSeries> series) {
        if (series != null) {
            for (JRTimeSeries s : series) {
                this.addTimeSeries(s);
            }
        }
    }

    public void addTimeSeries(JRTimeSeries timeSeries) {
        this.timeSeriesList.add(timeSeries);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_TIME_SERIES, (Object)timeSeries, this.timeSeriesList.size() - 1);
    }

    public void addTimeSeries(int index, JRTimeSeries timeSeries) {
        this.timeSeriesList.add(index, timeSeries);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_TIME_SERIES, (Object)timeSeries, index);
    }

    public JRTimeSeries removeTimeSeries(JRTimeSeries timeSeries) {
        int idx;
        if (timeSeries != null && (idx = this.timeSeriesList.indexOf(timeSeries)) >= 0) {
            this.timeSeriesList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_TIME_SERIES, (Object)timeSeries, idx);
        }
        return timeSeries;
    }

    @Override
    public TimePeriodEnum getTimePeriod() {
        return this.timePeriod;
    }

    @Override
    public void setTimePeriod(TimePeriodEnum timePeriod) {
        TimePeriodEnum old = this.timePeriod;
        this.timePeriod = timePeriod;
        this.getEventSupport().firePropertyChange(PROPERTY_TIME_PERIOD, (Object)old, (Object)this.timePeriod);
    }

    @Override
    public byte getDatasetType() {
        return 6;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect((JRElementDataset)this);
    }

    @Override
    public void collectExpressions(ChartsExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void validate(ChartsVerifier verifier) {
        verifier.verify(this);
    }

    public Object clone() {
        JRDesignTimeSeriesDataset clone = (JRDesignTimeSeriesDataset)super.clone();
        clone.timeSeriesList = JRCloneUtils.cloneList(this.timeSeriesList);
        return clone;
    }
}

