/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import net.sf.jasperreports.charts.ChartsExpressionCollector;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRChartDataset;
import net.sf.jasperreports.charts.base.ChartsBaseObjectFactory;
import net.sf.jasperreports.charts.base.JRBaseChartDataset;
import net.sf.jasperreports.charts.design.ChartsVerifier;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseCategoryDataset
extends JRBaseChartDataset
implements JRCategoryDataset {
    private static final long serialVersionUID = 10200L;
    protected JRCategorySeries[] categorySeries;

    public JRBaseCategoryDataset(JRChartDataset dataset) {
        super(dataset);
    }

    public JRBaseCategoryDataset(JRCategoryDataset dataset, ChartsBaseObjectFactory factory) {
        super(dataset, factory);
        JRCategorySeries[] srcCategorySeries = dataset.getSeries();
        if (srcCategorySeries != null && srcCategorySeries.length > 0) {
            this.categorySeries = new JRCategorySeries[srcCategorySeries.length];
            for (int i = 0; i < this.categorySeries.length; ++i) {
                this.categorySeries[i] = factory.getCategorySeries(srcCategorySeries[i]);
            }
        }
    }

    @Override
    public JRCategorySeries[] getSeries() {
        return this.categorySeries;
    }

    @Override
    public byte getDatasetType() {
        return 2;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect((JRElementDataset)this);
    }

    @Override
    public void collectExpressions(ChartsExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void validate(ChartsVerifier verifier) {
        verifier.verify(this);
    }

    public Object clone() {
        JRBaseCategoryDataset clone = (JRBaseCategoryDataset)super.clone();
        clone.categorySeries = (JRCategorySeries[])JRCloneUtils.cloneArray((JRCloneable[])this.categorySeries);
        return clone;
    }
}

