/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import net.sf.jasperreports.charts.ChartCopyObjectFactory;
import net.sf.jasperreports.charts.ChartsExpressionCollector;
import net.sf.jasperreports.charts.JRChart;
import net.sf.jasperreports.charts.JRChartPlot;
import net.sf.jasperreports.charts.JRItemLabel;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.base.ChartCopyBaseObjectFactory;
import net.sf.jasperreports.charts.base.ChartsBaseObjectFactory;
import net.sf.jasperreports.charts.base.JRBaseChartPlot;
import net.sf.jasperreports.charts.base.JRBaseItemLabel;

public class JRBasePiePlot
extends JRBaseChartPlot
implements JRPiePlot {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_CIRCULAR = "isCircular";
    public static final String PROPERTY_LABEL_FORMAT = "labelFormat";
    public static final String PROPERTY_LEGEND_LABEL_FORMAT = "legendLabelFormat";
    public static final String PROPERTY_ITEM_LABEL = "itemLabel";
    public static final String PROPERTY_SHOW_LABELS = "isShowLabels";
    protected Boolean circular;
    protected String labelFormat;
    protected String legendLabelFormat;
    protected JRItemLabel itemLabel;
    protected Boolean showLabels;

    public JRBasePiePlot(JRChartPlot chartPlot, JRChart chart) {
        this(chartPlot, chart, ChartCopyBaseObjectFactory.instance());
    }

    protected JRBasePiePlot(JRChartPlot chartPlot, JRChart chart, ChartCopyObjectFactory copyObjectFactory) {
        super(chartPlot, chart);
        JRPiePlot piePlot = chartPlot instanceof JRPiePlot ? (JRPiePlot)chartPlot : null;
        this.itemLabel = piePlot == null ? copyObjectFactory.copyItemLabel(null, chart) : copyObjectFactory.copyItemLabel(piePlot.getItemLabel(), chart);
    }

    public JRBasePiePlot(JRPiePlot piePlot, ChartsBaseObjectFactory factory) {
        super((JRChartPlot)piePlot, factory);
        this.circular = piePlot.getCircular();
        this.labelFormat = piePlot.getLabelFormat();
        this.legendLabelFormat = piePlot.getLegendLabelFormat();
        this.itemLabel = new JRBaseItemLabel(piePlot.getItemLabel(), factory);
        this.showLabels = piePlot.getShowLabels();
    }

    @Override
    public void collectExpressions(ChartsExpressionCollector collector) {
    }

    @Override
    public Boolean getCircular() {
        return this.circular;
    }

    public void setCircular(Boolean isCircular) {
        Boolean old = this.circular;
        this.circular = isCircular;
        this.getEventSupport().firePropertyChange(PROPERTY_CIRCULAR, (Object)old, (Object)this.circular);
    }

    @Override
    public String getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(String labelFormat) {
        String old = this.labelFormat;
        this.labelFormat = labelFormat;
        this.getEventSupport().firePropertyChange(PROPERTY_LABEL_FORMAT, (Object)old, (Object)this.labelFormat);
    }

    @Override
    public String getLegendLabelFormat() {
        return this.legendLabelFormat;
    }

    @Override
    public JRItemLabel getItemLabel() {
        return this.itemLabel;
    }

    public void setLegendLabelFormat(String legendLabelFormat) {
        String old = this.legendLabelFormat;
        this.legendLabelFormat = legendLabelFormat;
        this.getEventSupport().firePropertyChange(PROPERTY_LEGEND_LABEL_FORMAT, (Object)old, (Object)this.legendLabelFormat);
    }

    public void setItemLabel(JRItemLabel itemLabel) {
        JRItemLabel old = this.itemLabel;
        this.itemLabel = itemLabel;
        this.getEventSupport().firePropertyChange(PROPERTY_ITEM_LABEL, (Object)old, (Object)this.itemLabel);
    }

    @Override
    public Boolean getShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(Boolean showLabels) {
        Boolean old = this.showLabels;
        this.showLabels = showLabels;
        this.getEventSupport().firePropertyChange(PROPERTY_SHOW_LABELS, (Object)old, (Object)this.showLabels);
    }

    @Override
    public Object clone(JRChart parentChart) {
        JRBasePiePlot clone = (JRBasePiePlot)super.clone(parentChart);
        clone.itemLabel = this.itemLabel == null ? null : this.itemLabel.clone(parentChart);
        return clone;
    }
}

