/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import net.sf.jasperreports.charts.ChartsExpressionCollector;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.base.ChartsBaseObjectFactory;
import net.sf.jasperreports.charts.base.JRBaseChartDataset;
import net.sf.jasperreports.charts.design.ChartsVerifier;
import net.sf.jasperreports.charts.type.TimePeriodEnum;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseTimeSeriesDataset
extends JRBaseChartDataset
implements JRTimeSeriesDataset,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_TIME_PERIOD = "timePeriod";
    private JRTimeSeries[] timeSeries;
    private TimePeriodEnum timePeriod;
    private transient JRPropertyChangeSupport eventSupport;

    protected JRBaseTimeSeriesDataset(JRTimeSeriesDataset dataset) {
        super(dataset);
    }

    public JRBaseTimeSeriesDataset(JRTimeSeriesDataset dataset, ChartsBaseObjectFactory factory) {
        super(dataset, factory);
        this.timePeriod = dataset.getTimePeriod();
        JRTimeSeries[] srcTimeSeries = dataset.getSeries();
        if (srcTimeSeries != null && srcTimeSeries.length > 0) {
            this.timeSeries = new JRTimeSeries[srcTimeSeries.length];
            for (int i = 0; i < this.timeSeries.length; ++i) {
                this.timeSeries[i] = factory.getTimeSeries(srcTimeSeries[i]);
            }
        }
    }

    @Override
    public JRTimeSeries[] getSeries() {
        return this.timeSeries;
    }

    @Override
    public TimePeriodEnum getTimePeriod() {
        return this.timePeriod;
    }

    @Override
    public void setTimePeriod(TimePeriodEnum timePeriod) {
        TimePeriodEnum old = this.timePeriod;
        this.timePeriod = timePeriod;
        this.getEventSupport().firePropertyChange(PROPERTY_TIME_PERIOD, (Object)old, (Object)this.timePeriod);
    }

    @Override
    public byte getDatasetType() {
        return 6;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect((JRElementDataset)this);
    }

    @Override
    public void collectExpressions(ChartsExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void validate(ChartsVerifier verifier) {
        verifier.verify(this);
    }

    public Object clone() {
        JRBaseTimeSeriesDataset clone = (JRBaseTimeSeriesDataset)super.clone();
        clone.timeSeries = (JRTimeSeries[])JRCloneUtils.cloneArray((JRCloneable[])this.timeSeries);
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseTimeSeriesDataset jRBaseTimeSeriesDataset = this;
        synchronized (jRBaseTimeSeriesDataset) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport((Object)this);
            }
        }
        return this.eventSupport;
    }
}

