/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.design;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonMerge;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.charts.ChartVisitorFactory;
import net.sf.jasperreports.charts.ChartsExpressionCollector;
import net.sf.jasperreports.charts.JRChart;
import net.sf.jasperreports.charts.JRChartDataset;
import net.sf.jasperreports.charts.JRChartPlot;
import net.sf.jasperreports.charts.design.JRDesignAreaPlot;
import net.sf.jasperreports.charts.design.JRDesignBar3DPlot;
import net.sf.jasperreports.charts.design.JRDesignBarPlot;
import net.sf.jasperreports.charts.design.JRDesignBubblePlot;
import net.sf.jasperreports.charts.design.JRDesignCandlestickPlot;
import net.sf.jasperreports.charts.design.JRDesignCategoryDataset;
import net.sf.jasperreports.charts.design.JRDesignGanttDataset;
import net.sf.jasperreports.charts.design.JRDesignHighLowDataset;
import net.sf.jasperreports.charts.design.JRDesignHighLowPlot;
import net.sf.jasperreports.charts.design.JRDesignLinePlot;
import net.sf.jasperreports.charts.design.JRDesignMeterPlot;
import net.sf.jasperreports.charts.design.JRDesignMultiAxisPlot;
import net.sf.jasperreports.charts.design.JRDesignPie3DPlot;
import net.sf.jasperreports.charts.design.JRDesignPieDataset;
import net.sf.jasperreports.charts.design.JRDesignPiePlot;
import net.sf.jasperreports.charts.design.JRDesignScatterPlot;
import net.sf.jasperreports.charts.design.JRDesignThermometerPlot;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesDataset;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesPlot;
import net.sf.jasperreports.charts.design.JRDesignValueDataset;
import net.sf.jasperreports.charts.design.JRDesignXyDataset;
import net.sf.jasperreports.charts.design.JRDesignXyzDataset;
import net.sf.jasperreports.charts.type.ChartTypeEnum;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRCommonElement;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import net.sf.jasperreports.jackson.util.ReportDeserializer;

public class JRDesignChart
extends JRDesignElement
implements JRChart {
    public static final String EXCEPTION_MESSAGE_KEY_UNSUPPORTED_CHART_TYPE = "charts.chart.type.unsupported";
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_ANCHOR_NAME_EXPRESSION = "anchorNameExpression";
    public static final String PROPERTY_BOOKMARK_LEVEL = "bookmarkLevel";
    public static final String PROPERTY_BOOKMARK_LEVEL_EXPRESSION = "bookmarkLevelExpression";
    public static final String PROPERTY_EVALUATION_GROUP = "evaluationGroup";
    public static final String PROPERTY_EVALUATION_TIME = "evaluationTime";
    public static final String PROPERTY_CHART_TYPE = "chartType";
    public static final String PROPERTY_CUSTOMIZER_CLASS = "customizerClass";
    public static final String PROPERTY_DATASET = "dataset";
    public static final String PROPERTY_LEGEND_FONT = "legendFont";
    public static final String PROPERTY_SUBTITLE_EXPRESSION = "subtitleExpression";
    public static final String PROPERTY_SUBTITLE_FONT = "subtitleFont";
    public static final String PROPERTY_TITLE_EXPRESSION = "titleExpression";
    public static final String PROPERTY_TITLE_FONT = "titleFont";
    protected ChartTypeEnum chartType;
    protected Boolean showLegend;
    protected EvaluationTimeEnum evaluationTime;
    protected String linkType;
    protected String linkTarget;
    protected Color titleColor;
    protected Color subtitleColor;
    protected Color legendColor;
    protected Color legendBackgroundColor;
    protected String renderType;
    protected String theme;
    protected JRFont titleFont;
    protected JRFont subtitleFont;
    protected JRFont legendFont;
    protected EdgeEnum legendPosition;
    protected EdgeEnum titlePosition;
    protected String customizerClass;
    protected String evaluationGroup;
    protected JRExpression titleExpression;
    protected JRExpression subtitleExpression;
    protected JRExpression anchorNameExpression;
    protected JRExpression bookmarkLevelExpression;
    protected JRExpression hyperlinkReferenceExpression;
    protected JRExpression hyperlinkWhenExpression;
    protected JRExpression hyperlinkAnchorExpression;
    protected JRExpression hyperlinkPageExpression;
    private JRExpression hyperlinkTooltipExpression;
    private List<JRHyperlinkParameter> hyperlinkParameters;
    protected JRChartDataset dataset;
    @JsonMerge
    protected JRChartPlot plot;
    protected JRLineBox lineBox;
    protected int bookmarkLevel = 0;

    @JsonCreator
    private JRDesignChart(@JsonProperty(value="chartType") ChartTypeEnum chartType) {
        this(ReportDeserializer.getDefaultStyleProvider(), chartType);
    }

    public JRDesignChart(JRDefaultStyleProvider defaultStyleProvider, ChartTypeEnum chartType) {
        super(defaultStyleProvider);
        this.setChartType(chartType);
        this.hyperlinkParameters = new ArrayList<JRHyperlinkParameter>();
        this.lineBox = new JRBaseLineBox((JRBoxContainer)this);
    }

    @Override
    public Boolean getShowLegend() {
        return this.showLegend;
    }

    @Override
    public void setShowLegend(Boolean isShowLegend) {
        Boolean old = this.showLegend;
        this.showLegend = isShowLegend;
        this.getEventSupport().firePropertyChange("isShowLegend", (Object)old, (Object)this.showLegend);
    }

    @Override
    public String getRenderType() {
        return this.renderType;
    }

    @Override
    public void setRenderType(String renderType) {
        String old = this.renderType;
        this.renderType = renderType;
        this.getEventSupport().firePropertyChange("renderType", (Object)old, (Object)this.renderType);
    }

    @Override
    public String getTheme() {
        return this.theme;
    }

    @Override
    public void setTheme(String theme) {
        String old = this.theme;
        this.theme = theme;
        this.getEventSupport().firePropertyChange("theme", (Object)old, (Object)this.theme);
    }

    public EvaluationTimeEnum getEvaluationTime() {
        return this.evaluationTime;
    }

    public void setEvaluationTime(EvaluationTimeEnum evaluationTime) {
        EvaluationTimeEnum old = this.evaluationTime;
        this.evaluationTime = evaluationTime;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_TIME, (Object)old, (Object)this.evaluationTime);
    }

    public String getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public void setEvaluationGroup(String group) {
        String old = this.evaluationGroup;
        this.evaluationGroup = group;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_GROUP, (Object)old, (Object)this.evaluationGroup);
    }

    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @JsonSetter(value="box")
    private void setLineBox(JRLineBox lineBox) {
        this.lineBox = lineBox == null ? null : lineBox.clone((JRBoxContainer)this);
    }

    @Override
    public JRFont getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(JRFont font) {
        JRFont old = this.titleFont;
        this.titleFont = font;
        this.getEventSupport().firePropertyChange(PROPERTY_TITLE_FONT, (Object)old, (Object)this.titleFont);
    }

    @Override
    public EdgeEnum getTitlePosition() {
        return this.titlePosition;
    }

    @Override
    public void setTitlePosition(EdgeEnum titlePosition) {
        EdgeEnum old = this.titlePosition;
        this.titlePosition = titlePosition;
        this.getEventSupport().firePropertyChange("titlePosition", (Object)old, (Object)this.titlePosition);
    }

    @Override
    public Color getTitleColor() {
        return this.getChartsStyleResolver().getTitleColor(this);
    }

    @Override
    public Color getOwnTitleColor() {
        return this.titleColor;
    }

    @Override
    public void setTitleColor(Color titleColor) {
        Color old = this.titleColor;
        this.titleColor = titleColor;
        this.getEventSupport().firePropertyChange("titleColor", (Object)old, (Object)this.titleColor);
    }

    @Override
    public JRFont getSubtitleFont() {
        return this.subtitleFont;
    }

    public void setSubtitleFont(JRFont font) {
        JRFont old = this.subtitleFont;
        this.subtitleFont = font;
        this.getEventSupport().firePropertyChange(PROPERTY_SUBTITLE_FONT, (Object)old, (Object)this.subtitleFont);
    }

    @Override
    public Color getSubtitleColor() {
        return this.getChartsStyleResolver().getSubtitleColor(this);
    }

    @Override
    public Color getOwnSubtitleColor() {
        return this.subtitleColor;
    }

    @Override
    public void setSubtitleColor(Color subtitleColor) {
        Color old = this.subtitleColor;
        this.subtitleColor = subtitleColor;
        this.getEventSupport().firePropertyChange("subtitleColor", (Object)old, (Object)this.subtitleColor);
    }

    @Override
    public Color getOwnLegendColor() {
        return this.legendColor;
    }

    @Override
    public Color getLegendColor() {
        return this.getChartsStyleResolver().getLegendColor(this);
    }

    @Override
    public void setLegendColor(Color legendColor) {
        Color old = this.legendColor;
        this.legendColor = legendColor;
        this.getEventSupport().firePropertyChange("legendColor", (Object)old, (Object)this.legendColor);
    }

    @Override
    public Color getOwnLegendBackgroundColor() {
        return this.legendBackgroundColor;
    }

    @Override
    public Color getLegendBackgroundColor() {
        return this.getChartsStyleResolver().getLegendBackgroundColor(this);
    }

    @Override
    public void setLegendBackgroundColor(Color legendBackgroundColor) {
        Color old = this.legendBackgroundColor;
        this.legendBackgroundColor = legendBackgroundColor;
        this.getEventSupport().firePropertyChange("legendBackgroundColor", (Object)old, (Object)this.legendBackgroundColor);
    }

    @Override
    public JRFont getLegendFont() {
        return this.legendFont;
    }

    public void setLegendFont(JRFont legendFont) {
        JRFont old = this.legendFont;
        this.legendFont = legendFont;
        this.getEventSupport().firePropertyChange(PROPERTY_LEGEND_FONT, (Object)old, (Object)this.legendFont);
    }

    @Override
    public EdgeEnum getLegendPosition() {
        return this.legendPosition;
    }

    @Override
    public void setLegendPosition(EdgeEnum legendPosition) {
        EdgeEnum old = this.legendPosition;
        this.legendPosition = legendPosition;
        this.getEventSupport().firePropertyChange("legendPosition", (Object)old, (Object)this.legendPosition);
    }

    public HyperlinkTypeEnum getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType((JRHyperlink)this);
    }

    public void setHyperlinkType(HyperlinkTypeEnum hyperlinkType) {
        this.setLinkType(JRHyperlinkHelper.getLinkType((HyperlinkTypeEnum)hyperlinkType));
    }

    public HyperlinkTargetEnum getHyperlinkTarget() {
        return JRHyperlinkHelper.getHyperlinkTarget((JRHyperlink)this);
    }

    public void setHyperlinkTarget(HyperlinkTargetEnum hyperlinkTarget) {
        this.setLinkTarget(JRHyperlinkHelper.getLinkTarget((HyperlinkTargetEnum)hyperlinkTarget));
    }

    @Override
    public JRExpression getTitleExpression() {
        return this.titleExpression;
    }

    public void setTitleExpression(JRExpression expression) {
        JRExpression old = this.titleExpression;
        this.titleExpression = expression;
        this.getEventSupport().firePropertyChange(PROPERTY_TITLE_EXPRESSION, (Object)old, (Object)this.titleExpression);
    }

    @Override
    public JRExpression getSubtitleExpression() {
        return this.subtitleExpression;
    }

    public void setSubtitleExpression(JRExpression expression) {
        JRExpression old = this.subtitleExpression;
        this.subtitleExpression = expression;
        this.getEventSupport().firePropertyChange(PROPERTY_SUBTITLE_EXPRESSION, (Object)old, (Object)this.subtitleExpression);
    }

    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    public void setAnchorNameExpression(JRExpression anchorNameExpression) {
        JRExpression old = this.anchorNameExpression;
        this.anchorNameExpression = anchorNameExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_ANCHOR_NAME_EXPRESSION, (Object)old, (Object)this.anchorNameExpression);
    }

    public JRExpression getBookmarkLevelExpression() {
        return this.bookmarkLevelExpression;
    }

    public void setBookmarkLevelExpression(JRExpression bookmarkLevelExpression) {
        JRExpression old = this.bookmarkLevelExpression;
        this.bookmarkLevelExpression = bookmarkLevelExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_BOOKMARK_LEVEL_EXPRESSION, (Object)old, (Object)this.bookmarkLevelExpression);
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public void setHyperlinkReferenceExpression(JRExpression hyperlinkReferenceExpression) {
        JRExpression old = this.hyperlinkReferenceExpression;
        this.hyperlinkReferenceExpression = hyperlinkReferenceExpression;
        this.getEventSupport().firePropertyChange("hyperlinkReferenceExpression", (Object)old, (Object)this.hyperlinkReferenceExpression);
    }

    public JRExpression getHyperlinkWhenExpression() {
        return this.hyperlinkWhenExpression;
    }

    public void setHyperlinkWhenExpression(JRExpression hyperlinkWhenExpression) {
        JRExpression old = this.hyperlinkWhenExpression;
        this.hyperlinkWhenExpression = hyperlinkWhenExpression;
        this.getEventSupport().firePropertyChange("hyperlinkWhenExpression", (Object)old, (Object)this.hyperlinkWhenExpression);
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public void setHyperlinkAnchorExpression(JRExpression hyperlinkAnchorExpression) {
        JRExpression old = this.hyperlinkAnchorExpression;
        this.hyperlinkAnchorExpression = hyperlinkAnchorExpression;
        this.getEventSupport().firePropertyChange("hyperlinkAnchorExpression", (Object)old, (Object)this.hyperlinkAnchorExpression);
    }

    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    public void setHyperlinkPageExpression(JRExpression hyperlinkPageExpression) {
        JRExpression old = this.hyperlinkPageExpression;
        this.hyperlinkPageExpression = hyperlinkPageExpression;
        this.getEventSupport().firePropertyChange("hyperlinkPageExpression", (Object)old, (Object)this.hyperlinkPageExpression);
    }

    @Override
    public JRChartDataset getDataset() {
        return this.chartType == ChartTypeEnum.MULTI_AXIS ? null : this.dataset;
    }

    @Override
    public JRChartPlot getPlot() {
        return this.plot;
    }

    @Override
    public ChartTypeEnum getChartType() {
        return this.chartType;
    }

    public void setChartType(ChartTypeEnum chartType) {
        ChartTypeEnum old = this.chartType;
        this.chartType = chartType;
        switch (chartType) {
            case AREA: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignAreaPlot(this.plot, this);
                break;
            }
            case BAR: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBarPlot(this.plot, this);
                break;
            }
            case BAR3D: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                JRDesignBar3DPlot depPlot = new JRDesignBar3DPlot(this.plot, this);
                this.plot = depPlot;
                break;
            }
            case BUBBLE: {
                this.dataset = new JRDesignXyzDataset(this.dataset);
                this.plot = new JRDesignBubblePlot(this.plot, this);
                break;
            }
            case CANDLESTICK: {
                this.dataset = new JRDesignHighLowDataset(this.dataset);
                this.plot = new JRDesignCandlestickPlot(this.plot, this);
                break;
            }
            case HIGHLOW: {
                this.dataset = new JRDesignHighLowDataset(this.dataset);
                this.plot = new JRDesignHighLowPlot(this.plot, this);
                break;
            }
            case LINE: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignLinePlot(this.plot, this);
                break;
            }
            case METER: {
                this.dataset = new JRDesignValueDataset(this.dataset);
                this.plot = new JRDesignMeterPlot(this.plot, this);
                break;
            }
            case MULTI_AXIS: {
                this.dataset = null;
                this.plot = new JRDesignMultiAxisPlot(this.plot, this);
                break;
            }
            case PIE: {
                this.dataset = new JRDesignPieDataset(this.dataset);
                this.plot = new JRDesignPiePlot(this.plot, this);
                break;
            }
            case PIE3D: {
                this.dataset = new JRDesignPieDataset(this.dataset);
                JRDesignPie3DPlot depPlot = new JRDesignPie3DPlot(this.plot, this);
                this.plot = depPlot;
                break;
            }
            case SCATTER: {
                this.dataset = new JRDesignXyDataset(this.dataset);
                this.plot = new JRDesignScatterPlot(this.plot, this);
                break;
            }
            case STACKEDBAR: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBarPlot(this.plot, this);
                break;
            }
            case STACKEDBAR3D: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                JRDesignBar3DPlot depPlot = new JRDesignBar3DPlot(this.plot, this);
                this.plot = depPlot;
                break;
            }
            case THERMOMETER: {
                this.dataset = new JRDesignValueDataset(this.dataset);
                this.plot = new JRDesignThermometerPlot(this.plot, this);
                break;
            }
            case TIMESERIES: {
                this.dataset = new JRDesignTimeSeriesDataset(this.dataset);
                this.plot = new JRDesignTimeSeriesPlot(this.plot, this);
                break;
            }
            case XYAREA: {
                this.dataset = new JRDesignXyDataset(this.dataset);
                this.plot = new JRDesignAreaPlot(this.plot, this);
                break;
            }
            case XYBAR: {
                this.plot = new JRDesignBarPlot(this.plot, this);
                break;
            }
            case XYLINE: {
                this.dataset = new JRDesignXyDataset(this.dataset);
                this.plot = new JRDesignLinePlot(this.plot, this);
                break;
            }
            case STACKEDAREA: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignAreaPlot(this.plot, this);
                break;
            }
            case GANTT: {
                this.dataset = new JRDesignGanttDataset(this.dataset);
                this.plot = new JRDesignBarPlot(this.plot, this);
                break;
            }
            default: {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNSUPPORTED_CHART_TYPE, (Object[])null);
            }
        }
        this.getEventSupport().firePropertyChange(PROPERTY_CHART_TYPE, (Object)old, (Object)this.chartType);
    }

    public void setDataset(JRChartDataset ds) {
        if (this.chartType != ChartTypeEnum.MULTI_AXIS) {
            JRChartDataset old = this.dataset;
            this.dataset = ds;
            this.getEventSupport().firePropertyChange(PROPERTY_DATASET, (Object)old, (Object)this.dataset);
        }
    }

    public void collectExpressions(JRExpressionCollector collector) {
        new ChartsExpressionCollector(collector).collect(this);
    }

    public void visit(JRVisitor visitor) {
        ChartVisitorFactory.getInstance().getChartVisitor(visitor).visitChart(this);
    }

    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public void setBookmarkLevel(int bookmarkLevel) {
        int old = this.bookmarkLevel;
        this.bookmarkLevel = bookmarkLevel;
        this.getEventSupport().firePropertyChange(PROPERTY_BOOKMARK_LEVEL, old, this.bookmarkLevel);
    }

    @Override
    public String getCustomizerClass() {
        return this.customizerClass;
    }

    public void setCustomizerClass(String customizerClass) {
        String old = this.customizerClass;
        this.customizerClass = customizerClass;
        this.getEventSupport().firePropertyChange(PROPERTY_CUSTOMIZER_CLASS, (Object)old, (Object)this.customizerClass);
    }

    public ModeEnum getMode() {
        return this.getStyleResolver().getMode((JRCommonElement)this, ModeEnum.TRANSPARENT);
    }

    public String getLinkType() {
        return this.linkType;
    }

    public void setLinkType(String type) {
        String old = this.linkType;
        this.linkType = type;
        this.getEventSupport().firePropertyChange("hyperlinkType", (Object)old, (Object)this.linkType);
    }

    public String getLinkTarget() {
        return this.linkTarget;
    }

    public void setLinkTarget(String target) {
        String old = this.linkTarget;
        this.linkTarget = target;
        this.getEventSupport().firePropertyChange("linkTarget", (Object)old, (Object)this.linkTarget);
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        JRHyperlinkParameter[] parameters;
        if (this.hyperlinkParameters.isEmpty()) {
            parameters = null;
        } else {
            parameters = new JRHyperlinkParameter[this.hyperlinkParameters.size()];
            this.hyperlinkParameters.toArray(parameters);
        }
        return parameters;
    }

    @JsonSetter
    private void setHyperlinkParameters(List<JRHyperlinkParameter> parameters) {
        if (parameters != null) {
            for (JRHyperlinkParameter parameter : parameters) {
                this.addHyperlinkParameter(parameter);
            }
        }
    }

    @JsonIgnore
    public List<JRHyperlinkParameter> getHyperlinkParametersList() {
        return this.hyperlinkParameters;
    }

    public void addHyperlinkParameter(JRHyperlinkParameter parameter) {
        this.hyperlinkParameters.add(parameter);
        this.getEventSupport().fireCollectionElementAddedEvent("hyperlinkParameters", (Object)parameter, this.hyperlinkParameters.size() - 1);
    }

    public void removeHyperlinkParameter(JRHyperlinkParameter parameter) {
        int idx = this.hyperlinkParameters.indexOf(parameter);
        if (idx >= 0) {
            this.hyperlinkParameters.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent("hyperlinkParameters", (Object)parameter, idx);
        }
    }

    public void removeHyperlinkParameter(String parameterName) {
        ListIterator<JRHyperlinkParameter> it = this.hyperlinkParameters.listIterator();
        while (it.hasNext()) {
            JRHyperlinkParameter parameter = it.next();
            if (parameter.getName() == null || !parameter.getName().equals(parameterName)) continue;
            it.remove();
            this.getEventSupport().fireCollectionElementRemovedEvent("hyperlinkParameters", (Object)parameter, it.nextIndex());
        }
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    public void setHyperlinkTooltipExpression(JRExpression hyperlinkTooltipExpression) {
        JRExpression old = this.hyperlinkTooltipExpression;
        this.hyperlinkTooltipExpression = hyperlinkTooltipExpression;
        this.getEventSupport().firePropertyChange("hyperlinkTooltipExpression", (Object)old, (Object)this.hyperlinkTooltipExpression);
    }

    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    public Object clone() {
        JRDesignChart clone = (JRDesignChart)super.clone();
        clone.lineBox = this.lineBox.clone((JRBoxContainer)clone);
        clone.hyperlinkParameters = JRCloneUtils.cloneList(this.hyperlinkParameters);
        clone.titleExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.titleExpression);
        clone.subtitleExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.subtitleExpression);
        clone.anchorNameExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.anchorNameExpression);
        clone.bookmarkLevelExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.bookmarkLevelExpression);
        clone.hyperlinkReferenceExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.hyperlinkReferenceExpression);
        clone.hyperlinkWhenExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.hyperlinkWhenExpression);
        clone.hyperlinkAnchorExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.hyperlinkAnchorExpression);
        clone.hyperlinkPageExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.hyperlinkPageExpression);
        clone.hyperlinkTooltipExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.hyperlinkTooltipExpression);
        clone.dataset = (JRChartDataset)JRCloneUtils.nullSafeClone((JRCloneable)this.dataset);
        clone.plot = this.plot == null ? null : (JRChartPlot)this.plot.clone(clone);
        return clone;
    }
}

