/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.charts.ChartsExpressionCollector;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.design.ChartsVerifier;
import net.sf.jasperreports.charts.fill.ChartsFillObjectFactory;
import net.sf.jasperreports.charts.fill.JRFillChartDataset;
import net.sf.jasperreports.charts.fill.JRFillTimeSeries;
import net.sf.jasperreports.charts.type.TimePeriodEnum;
import net.sf.jasperreports.charts.util.ChartUtil;
import net.sf.jasperreports.charts.util.TimeSeriesLabelGenerator;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class JRFillTimeSeriesDataset
extends JRFillChartDataset
implements JRTimeSeriesDataset {
    public static final String EXCEPTION_MESSAGE_KEY_SERIES_NULL_NAME = "charts.time.series.dataset.series.null.name";
    protected JRFillTimeSeries[] timeSeries;
    private List<Comparable<?>> seriesNames;
    private Map<Comparable<?>, TimeSeries> seriesMap;
    private Map<Comparable<?>, Map<RegularTimePeriod, String>> labelsMap;
    private Map<Comparable<?>, Map<RegularTimePeriod, JRPrintHyperlink>> itemHyperlinks;

    public JRFillTimeSeriesDataset(JRTimeSeriesDataset timeSeriesDataset, ChartsFillObjectFactory factory) {
        super(timeSeriesDataset, factory.getParent());
        JRTimeSeries[] srcTimeSeries = timeSeriesDataset.getSeries();
        if (srcTimeSeries != null && srcTimeSeries.length > 0) {
            this.timeSeries = new JRFillTimeSeries[srcTimeSeries.length];
            for (int i = 0; i < this.timeSeries.length; ++i) {
                this.timeSeries[i] = (JRFillTimeSeries)factory.getTimeSeries(srcTimeSeries[i]);
            }
        }
    }

    @Override
    public JRTimeSeries[] getSeries() {
        return this.timeSeries;
    }

    protected void customInitialize() {
        this.seriesNames = null;
        this.seriesMap = null;
        this.labelsMap = null;
        this.itemHyperlinks = null;
    }

    protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
        if (this.timeSeries != null && this.timeSeries.length > 0) {
            for (int i = 0; i < this.timeSeries.length; ++i) {
                this.timeSeries[i].evaluate(calculator);
            }
        }
    }

    protected void customIncrement() {
        if (this.timeSeries != null && this.timeSeries.length > 0) {
            if (this.seriesNames == null) {
                this.seriesNames = new ArrayList();
                this.seriesMap = new HashMap();
                this.labelsMap = new HashMap();
                this.itemHyperlinks = new HashMap();
            }
            for (int i = 0; i < this.timeSeries.length; ++i) {
                JRFillTimeSeries crtTimeSeries = this.timeSeries[i];
                Comparable<?> seriesName = crtTimeSeries.getSeries();
                if (seriesName == null) {
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_SERIES_NULL_NAME, (Object[])null);
                }
                TimeSeries series = this.seriesMap.get(seriesName);
                if (series == null) {
                    series = new TimeSeries((Comparable)((Object)seriesName.toString()));
                    this.seriesNames.add(seriesName);
                    this.seriesMap.put(seriesName, series);
                }
                RegularTimePeriod tp = RegularTimePeriod.createInstance(ChartUtil.getTimePeriod(this.getTimePeriod()), (Date)crtTimeSeries.getTimePeriod(), (TimeZone)this.getTimeZone(), (Locale)this.getLocale());
                series.addOrUpdate(tp, crtTimeSeries.getValue());
                if (crtTimeSeries.getLabelExpression() != null) {
                    Map<RegularTimePeriod, String> seriesLabels = this.labelsMap.get(seriesName);
                    if (seriesLabels == null) {
                        seriesLabels = new HashMap<RegularTimePeriod, String>();
                        this.labelsMap.put(seriesName, seriesLabels);
                    }
                    seriesLabels.put(tp, crtTimeSeries.getLabel());
                }
                if (!crtTimeSeries.hasItemHyperlink()) continue;
                Map<RegularTimePeriod, JRPrintHyperlink> seriesLinks = this.itemHyperlinks.get(seriesName);
                if (seriesLinks == null) {
                    seriesLinks = new HashMap<RegularTimePeriod, JRPrintHyperlink>();
                    this.itemHyperlinks.put(seriesName, seriesLinks);
                }
                seriesLinks.put(tp, crtTimeSeries.getPrintItemHyperlink());
            }
        }
    }

    @Override
    public Dataset getCustomDataset() {
        TimeSeriesCollection dataset = new TimeSeriesCollection(this.getTimeZone());
        if (this.seriesNames != null) {
            for (int i = 0; i < this.seriesNames.size(); ++i) {
                Comparable<?> seriesName = this.seriesNames.get(i);
                dataset.addSeries(this.seriesMap.get(seriesName));
            }
        }
        return dataset;
    }

    @Override
    public TimePeriodEnum getTimePeriod() {
        return ((JRTimeSeriesDataset)this.parent).getTimePeriod();
    }

    @Override
    public void setTimePeriod(TimePeriodEnum timePeriod) {
    }

    @Override
    public byte getDatasetType() {
        return 6;
    }

    @Override
    public Object getLabelGenerator() {
        return new TimeSeriesLabelGenerator(this.labelsMap, this.getLocale());
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect((JRElementDataset)this);
    }

    @Override
    public void collectExpressions(ChartsExpressionCollector collector) {
        collector.collect(this);
    }

    public Map<Comparable<?>, Map<RegularTimePeriod, JRPrintHyperlink>> getItemHyperlinks() {
        return this.itemHyperlinks;
    }

    public boolean hasItemHyperlinks() {
        boolean foundLinks = false;
        if (this.timeSeries != null && this.timeSeries.length > 0) {
            for (int i = 0; i < this.timeSeries.length && !foundLinks; ++i) {
                foundLinks = this.timeSeries[i].hasItemHyperlink();
            }
        }
        return foundLinks;
    }

    @Override
    public void validate(ChartsVerifier verifier) {
        verifier.verify(this);
    }
}

