/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chrome;

import com.github.kklisura.cdt.launch.ChromeArguments;
import com.github.kklisura.cdt.launch.support.annotations.ChromeArgument;
import java.lang.reflect.Field;
import java.util.Map;
import net.sf.jasperreports.chrome.LaunchConfiguration;
import net.sf.jasperreports.engine.JRRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChromeArgumentsBuilder {
    private static final Log log = LogFactory.getLog(ChromeArgumentsBuilder.class);
    private static final ChromeArgumentsBuilder INSTANCE = new ChromeArgumentsBuilder();

    public static ChromeArgumentsBuilder instance() {
        return INSTANCE;
    }

    public ChromeArguments toArguments(LaunchConfiguration configuration) {
        ChromeArguments.Builder builder = ChromeArguments.defaults((boolean)configuration.isHeadless());
        ChromeArguments arguments = builder.build();
        Map<String, String> configArguments = configuration.getArguments();
        if (configArguments != null && !configArguments.isEmpty()) {
            for (Map.Entry<String, String> entry : configArguments.entrySet()) {
                String arg = entry.getKey();
                String value = entry.getValue();
                if (value == null || value.isEmpty()) continue;
                this.setArgument(arguments, arg, value);
            }
        }
        return arguments;
    }

    protected void setArgument(ChromeArguments arguments, String name, String value) {
        Field[] chromeArgumentsFields;
        boolean setField = false;
        for (Field field : chromeArgumentsFields = ChromeArguments.class.getDeclaredFields()) {
            Object fieldValue;
            ChromeArgument fieldAnnotation = field.getAnnotation(ChromeArgument.class);
            if (fieldAnnotation == null || !fieldAnnotation.value().equals(name)) continue;
            Class<?> type = field.getType();
            if (type.equals(String.class)) {
                fieldValue = value;
            } else if (type.equals(Boolean.class)) {
                fieldValue = Boolean.valueOf(value);
            } else if (type.equals(Integer.class)) {
                fieldValue = Integer.valueOf(value);
            } else {
                log.warn((Object)("Chrome arguments field type " + type + " not supported"));
                break;
            }
            field.setAccessible(true);
            try {
                field.set(arguments, fieldValue);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new JRRuntimeException((Throwable)e);
            }
            setField = true;
            break;
        }
        if (!setField) {
            arguments.getAdditionalArguments().put(name, value);
        }
    }
}

