/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chrome;

import java.nio.file.Path;
import java.util.Map;
import net.sf.jasperreports.engine.util.ObjectUtils;

public class LaunchConfiguration {
    private final Path executablePath;
    private final boolean headless;
    private Map<String, String> arguments;
    private long idleTimeout;
    private long liveTimeout;

    public LaunchConfiguration(Path executablePath, boolean headless, Map<String, String> arguments, long idleTimeout, long liveTimeout) {
        this.executablePath = executablePath;
        this.headless = headless;
        this.arguments = arguments;
        this.idleTimeout = idleTimeout;
        this.liveTimeout = liveTimeout;
    }

    public int hashCode() {
        int result = 31 + (this.headless ? 1231 : 1237);
        result = 31 * result + (this.executablePath == null ? 0 : this.executablePath.hashCode());
        result = 31 * result + (this.arguments == null ? 0 : this.arguments.hashCode());
        result = 31 * result + Long.hashCode(this.idleTimeout);
        result = 31 * result + Long.hashCode(this.liveTimeout);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LaunchConfiguration other = (LaunchConfiguration)obj;
        return this.headless == other.headless && ObjectUtils.equals((Object)this.executablePath, (Object)other.executablePath) && ObjectUtils.equals(this.arguments, other.arguments) && this.idleTimeout == other.idleTimeout && this.liveTimeout == other.liveTimeout;
    }

    public Path getExecutablePath() {
        return this.executablePath;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public long getLiveTimeout() {
        return this.liveTimeout;
    }

    public String toString() {
        return "executable: " + this.executablePath + ", headless: " + this.headless + ", arguments: " + this.arguments + ", idle timeout: " + this.idleTimeout + ", live timeout: " + this.liveTimeout;
    }
}

