/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customvisualization.export;

import net.sf.jasperreports.customvisualization.export.CVElementImageDataProvider;
import net.sf.jasperreports.customvisualization.export.CVElementPhantomJSImageDataProvider;
import net.sf.jasperreports.customvisualization.export.ChromeCVElementImageDataProvider;
import net.sf.jasperreports.customvisualization.export.JRPhantomCVElementImageDataProvider;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CVElementDefaultImageDataProvider
implements CVElementImageDataProvider {
    private static final Log log = LogFactory.getLog(CVElementDefaultImageDataProvider.class);
    private static final CVElementDefaultImageDataProvider INSTANCE = new CVElementDefaultImageDataProvider();
    private CVElementImageDataProvider cvElementPhantomJSImageProvider = new CVElementPhantomJSImageDataProvider();
    private JRPhantomCVElementImageDataProvider jrPhantomCVElementImageDataProvider = new JRPhantomCVElementImageDataProvider();
    private ChromeCVElementImageDataProvider chromeCVElementImageDataProvider = new ChromeCVElementImageDataProvider();

    public static CVElementDefaultImageDataProvider getInstance() {
        return INSTANCE;
    }

    @Override
    public byte[] getImageData(JasperReportsContext jasperReportsContext, JRGenericPrintElement element) throws Exception {
        if (this.chromeCVElementImageDataProvider.isEnabled(jasperReportsContext)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"using JR chrome");
            }
            return this.chromeCVElementImageDataProvider.getImageData(jasperReportsContext, element);
        }
        if (this.jrPhantomCVElementImageDataProvider.isEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using JR PhantomJS to produce custom visualization image data!");
            }
            return this.jrPhantomCVElementImageDataProvider.getImageData(jasperReportsContext, element);
        }
        String phantomjsExecutablePath = jasperReportsContext.getProperty("com.jaspersoft.jasperreports.components.customvisualization.phantomjs.executable.path");
        if (phantomjsExecutablePath != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using CVC PhantomJS to produce custom visualization image data!");
            }
            return this.cvElementPhantomJSImageProvider.getImageData(jasperReportsContext, element);
        }
        throw new JRRuntimeException("Chrome and/or PhantomJS not properly configured for server side rendering");
    }
}

