/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customvisualization.export;

import net.sf.jasperreports.customvisualization.export.CVElementImageProvider;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.oasis.GenericElementOdtHandler;
import net.sf.jasperreports.engine.export.oasis.JROdtExporter;
import net.sf.jasperreports.engine.export.oasis.JROdtExporterContext;
import net.sf.jasperreports.repo.RepositoryContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CVElementOdtHandler
implements GenericElementOdtHandler {
    private static final CVElementOdtHandler INSTANCE = new CVElementOdtHandler();
    private static final Log log = LogFactory.getLog(CVElementOdtHandler.class);

    public static CVElementOdtHandler getInstance() {
        return INSTANCE;
    }

    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }

    public void exportElement(JROdtExporterContext exporterContext, JRGenericPrintElement element, JRExporterGridCell gridCell) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exporting to ODT " + element));
        }
        try {
            RepositoryContext repositoryContext = exporterContext.getRepository().getRepositoryContext();
            JRPrintImage chartImage = CVElementImageProvider.getInstance().getImage(repositoryContext, element);
            JROdtExporter exporter = (JROdtExporter)exporterContext.getExporterRef();
            exporter.exportImage(exporterContext.getTableBuilder(), chartImage, gridCell);
        }
        catch (Exception e) {
            throw new JRRuntimeException((Throwable)e);
        }
    }
}

