/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customvisualization.export;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.customvisualization.CVUtils;
import net.sf.jasperreports.customvisualization.export.CVElementImageDataProvider;
import net.sf.jasperreports.customvisualization.export.CVElementJsonHandler;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.web.util.VelocityUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CVElementAbstractImageDataProvider
implements CVElementImageDataProvider {
    private static final Log log = LogFactory.getLog(CVElementAbstractImageDataProvider.class);
    private static final String COMPONENT_PAGE_TEMPLATE = "net/sf/jasperreports/customvisualization/templates/component.page.vm";

    public String getHtmlPage(JasperReportsContext jrContext, JRGenericPrintElement element, List<String> scripts, String cssUri) {
        Map originalConfiguration = (Map)element.getParameterValue("configuration");
        if (originalConfiguration == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Configuration object in the element " + element + " is NULL!"));
            }
            throw new JRRuntimeException("Configuration object in the element " + element + " is NULL!");
        }
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.putAll(originalConfiguration);
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map<String, Object> jsonConfiguration = CVElementJsonHandler.createConfigurationForJSON(configuration, null);
            jsonConfiguration.put("animation", false);
            String instanceData = mapper.writeValueAsString(jsonConfiguration);
            configuration.put("instanceData", instanceData);
        }
        catch (Exception ex) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Error dumping the JSON for the configuration...: " + ex.getMessage()), (Throwable)ex);
            }
            throw new JRRuntimeException("Error dumping the JSON for the configuration...: " + ex.getMessage());
        }
        configuration.put("element", element);
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("elementId", CVUtils.getElementId(element));
        velocityContext.put("scripts", scripts);
        velocityContext.put("configuration", configuration);
        velocityContext.put("module", element.getParameterValue("module"));
        velocityContext.put("cssUri", cssUri);
        return VelocityUtil.processTemplate((String)COMPONENT_PAGE_TEMPLATE, velocityContext);
    }
}

