/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customvisualization.export;

import net.sf.jasperreports.customvisualization.export.CVElementImageProvider;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.ooxml.GenericElementPptxHandler;
import net.sf.jasperreports.engine.export.ooxml.JRPptxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRPptxExporterContext;
import net.sf.jasperreports.repo.RepositoryContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CVElementPptxHandler
implements GenericElementPptxHandler {
    private static final CVElementPptxHandler INSTANCE = new CVElementPptxHandler();
    private static final Log log = LogFactory.getLog(CVElementPptxHandler.class);

    public static CVElementPptxHandler getInstance() {
        return INSTANCE;
    }

    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }

    public void exportElement(JRPptxExporterContext exporterContext, JRGenericPrintElement element) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exporting to PPTX " + element));
        }
        try {
            RepositoryContext repositoryContext = exporterContext.getRepository().getRepositoryContext();
            JRPrintImage chartImage = CVElementImageProvider.getInstance().getImage(repositoryContext, element);
            JRPptxExporter exporter = (JRPptxExporter)exporterContext.getExporterRef();
            exporter.exportImage(chartImage);
        }
        catch (Exception e) {
            throw new JRRuntimeException((Throwable)e);
        }
    }
}

