/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.dataadapters.http;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.data.http.HttpLocationParameter;
import net.sf.jasperreports.dataadapters.DataFileConnection;
import net.sf.jasperreports.dataadapters.DataFileService;
import net.sf.jasperreports.dataadapters.http.HttpDataConnection;
import net.sf.jasperreports.dataadapters.http.HttpDataLocation;
import net.sf.jasperreports.dataadapters.http.RequestMethod;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.util.SecretsUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;

public class HttpDataService
implements DataFileService {
    private static final Log log = LogFactory.getLog(HttpDataService.class);
    public static final String HTTP_DATA_SERVICE_NAME = "net.sf.jasperreports.data.file.service:HTTP";
    public static final String EXCEPTION_MESSAGE_KEY_NO_HTTP_URL_SET = "data.http.no.http.url.set";
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_REQUEST_METHOD = "data.http.unknown.request.method";
    public static final String PARAMETER_URL = "HTTP_DATA_URL";
    public static final String PARAMETER_USERNAME = "HTTP_DATA_USERNAME";
    public static final String PARAMETER_PASSWORD = "HTTP_DATA_PASSWORD";
    public static final String PARAMETER_PREFIX_URL_PARAMETER = "HTTP_DATA_URL_PARAMETER_";
    public static final String PARAMETER_PREFIX_POST_PARAMETER = "HTTP_DATA_POST_PARAMETER_";
    public static final String PROPERTY_METHOD = "net.sf.jasperreports.http.data.method";
    public static final String PROPERTY_URL = "net.sf.jasperreports.http.data.url";
    public static final String PROPERTY_USERNAME = "net.sf.jasperreports.http.data.username";
    public static final String PROPERTY_PASSWORD = "net.sf.jasperreports.http.data.password";
    public static final String PROPERTY_URL_PARAMETER = "net.sf.jasperreports.http.data.url.parameter";
    public static final String PROPERTY_BODY = "net.sf.jasperreports.http.data.body";
    public static final String PROPERTY_POST_PARAMETER = "net.sf.jasperreports.http.data.post.parameter";
    public static final String PROPERTY_HEADER = "net.sf.jasperreports.http.data.header";
    private final ParameterContributorContext context;
    private final HttpDataLocation dataLocation;

    public HttpDataService(ParameterContributorContext context, HttpDataLocation dataLocation) {
        this.context = context;
        this.dataLocation = dataLocation;
    }

    public DataFileConnection getDataFileConnection(Map<String, Object> parameters) throws JRException {
        CloseableHttpClient httpClient = this.createHttpClient(parameters);
        HttpRequestBase request = this.createRequest(parameters);
        return new HttpDataConnection(httpClient, request);
    }

    protected CloseableHttpClient createHttpClient(Map<String, Object> parameters) {
        HttpClientBuilder clientBuilder = HttpClients.custom();
        BasicHttpClientConnectionManager connManager = new BasicHttpClientConnectionManager();
        clientBuilder.setConnectionManager((HttpClientConnectionManager)connManager);
        RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("ignoreCookies").build();
        clientBuilder.setDefaultRequestConfig(requestConfig);
        this.setAuthentication(parameters, clientBuilder);
        CloseableHttpClient client = clientBuilder.build();
        return client;
    }

    protected void setAuthentication(Map<String, Object> parameters, HttpClientBuilder clientBuilder) {
        String username = this.getUsername(parameters);
        if (username != null) {
            String password = this.getPassword(parameters);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(username, password));
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
    }

    protected String getUsername(Map<String, Object> parameters) {
        String username = this.getPropertyOrParameterValue(PROPERTY_USERNAME, PARAMETER_USERNAME, parameters);
        if (username == null) {
            username = this.dataLocation.getUsername();
        }
        return username;
    }

    protected String getPassword(Map<String, Object> parameters) {
        String password = this.getPropertyOrParameterValue(PROPERTY_PASSWORD, PARAMETER_PASSWORD, parameters);
        if (password == null) {
            password = this.dataLocation.getPassword();
        }
        if (password != null) {
            SecretsUtil secrets = SecretsUtil.getInstance((JasperReportsContext)this.context.getJasperReportsContext());
            password = secrets.getSecret("net.sf.jasperreports.data.adapter", password);
        }
        return password;
    }

    protected HttpRequestBase createRequest(Map<String, Object> parameters) {
        HttpPost request;
        URI requestURI = this.getRequestURI(parameters);
        RequestMethod method = this.getMethod(parameters);
        String body = this.getBody(parameters);
        List<NameValuePair> postParameters = this.collectPostParameters(parameters);
        if (method == null) {
            method = body == null && postParameters.isEmpty() ? RequestMethod.GET : RequestMethod.POST;
        }
        switch (method) {
            case GET: {
                if (body != null) {
                    log.warn((Object)("Ignoring request body for GET request to " + this.dataLocation.getUrl()));
                }
                if (!postParameters.isEmpty()) {
                    log.warn((Object)("Ignoring POST parameters for GET request to " + this.dataLocation.getUrl()));
                }
                request = this.createGetRequest(requestURI);
                break;
            }
            case POST: {
                if (body == null) {
                    request = this.createPostRequest(requestURI, postParameters);
                    break;
                }
                if (!postParameters.isEmpty()) {
                    log.warn((Object)("Ignoring POST parameters for POST request having request body to " + this.dataLocation.getUrl()));
                }
                request = this.createPostRequest(requestURI, body);
                break;
            }
            case PUT: {
                if (body == null) {
                    request = this.createPutRequest(requestURI, postParameters);
                    break;
                }
                if (!postParameters.isEmpty()) {
                    log.warn((Object)("Ignoring POST parameters for PUT request having request body to " + this.dataLocation.getUrl()));
                }
                request = this.createPutRequest(requestURI, body);
                break;
            }
            default: {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNKNOWN_REQUEST_METHOD, new Object[]{method});
            }
        }
        List<NameValuePair> headers = this.collectHeaders(parameters);
        if (headers != null) {
            for (NameValuePair header : headers) {
                request.addHeader(header.getName(), header.getValue());
            }
        }
        return request;
    }

    protected HttpGet createGetRequest(URI requestURI) {
        HttpGet httpGet = new HttpGet(requestURI);
        return httpGet;
    }

    protected HttpPost createPostRequest(URI requestURI, String body) {
        HttpPost httpPost = new HttpPost(requestURI);
        HttpEntity entity = this.createRequestEntity(body);
        httpPost.setEntity(entity);
        return httpPost;
    }

    protected HttpPost createPostRequest(URI requestURI, List<NameValuePair> postParameters) {
        HttpPost httpPost = new HttpPost(requestURI);
        HttpEntity entity = this.createRequestEntity(postParameters);
        httpPost.setEntity(entity);
        return httpPost;
    }

    protected HttpPut createPutRequest(URI requestURI, String body) {
        HttpPut httpPost = new HttpPut(requestURI);
        HttpEntity entity = this.createRequestEntity(body);
        httpPost.setEntity(entity);
        return httpPost;
    }

    protected HttpPut createPutRequest(URI requestURI, List<NameValuePair> postParameters) {
        HttpPut httpPost = new HttpPut(requestURI);
        HttpEntity entity = this.createRequestEntity(postParameters);
        httpPost.setEntity(entity);
        return httpPost;
    }

    protected HttpEntity createRequestEntity(String body) {
        return new StringEntity(body, "UTF-8");
    }

    protected HttpEntity createRequestEntity(List<NameValuePair> postParameters) {
        UrlEncodedFormEntity formEntity;
        try {
            formEntity = new UrlEncodedFormEntity(postParameters, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        return formEntity;
    }

    protected List<NameValuePair> collectUrlParameters(Map<String, Object> reportParameters) {
        return this.collectParameters(this.dataLocation.getUrlParameters(), reportParameters, PROPERTY_URL_PARAMETER, PARAMETER_PREFIX_URL_PARAMETER);
    }

    protected List<NameValuePair> collectPostParameters(Map<String, Object> reportParameters) {
        return this.collectParameters(this.dataLocation.getPostParameters(), reportParameters, PROPERTY_POST_PARAMETER, PARAMETER_PREFIX_POST_PARAMETER);
    }

    protected List<NameValuePair> collectHeaders(Map<String, Object> reportParameters) {
        return this.collectParameters(this.dataLocation.getHeaders(), reportParameters, PROPERTY_HEADER, null);
    }

    protected List<NameValuePair> collectParameters(List<HttpLocationParameter> dataAdapterParameters, Map<String, Object> parameterValues, String propertyName, String parameterPrefix) {
        String mappedParamName;
        String requestParamName;
        ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
        HashMap<String, String> requestParamMappings = new HashMap<String, String>();
        if (this.context.getDataset() != null && this.context.getDataset().getParameters() != null) {
            for (JRParameter parameter : this.context.getDataset().getParameters()) {
                if (!parameter.hasProperties() || !parameter.getPropertiesMap().containsProperty(propertyName)) continue;
                requestParamName = parameter.getPropertiesMap().getProperty(propertyName);
                if (requestParamName == null) {
                    requestParamName = parameter.getName();
                }
                requestParamMappings.put(requestParamName, parameter.getName());
            }
        }
        if (dataAdapterParameters != null && !dataAdapterParameters.isEmpty()) {
            for (HttpLocationParameter httpLocationParameter : dataAdapterParameters) {
                String dataAdapterParamName = httpLocationParameter.getName();
                String paramValue = httpLocationParameter.getValue();
                if (paramValue == null) continue;
                String prefixConventionParamName = parameterPrefix == null ? null : parameterPrefix + dataAdapterParamName;
                mappedParamName = (String)requestParamMappings.get(dataAdapterParamName);
                if (prefixConventionParamName != null && parameterValues.containsKey(prefixConventionParamName) || requestParamMappings.containsKey(dataAdapterParamName) && parameterValues.containsKey(mappedParamName)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("data adapter parameter " + dataAdapterParamName + " overridden by the report"));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("adding parameter " + dataAdapterParamName + " with value " + paramValue));
                }
                postParameters.add((NameValuePair)new BasicNameValuePair(dataAdapterParamName, paramValue));
            }
        }
        if (parameterPrefix != null) {
            for (Map.Entry entry : parameterValues.entrySet()) {
                String paramName = (String)entry.getKey();
                Object value = entry.getValue();
                if (!paramName.startsWith(parameterPrefix)) continue;
                requestParamName = paramName.substring(parameterPrefix.length(), paramName.length());
                mappedParamName = (String)requestParamMappings.get(requestParamName);
                if (!(value == null || requestParamMappings.containsKey(requestParamName) && parameterValues.containsKey(mappedParamName))) {
                    String paramValue = this.toHttpParameterValue(value);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("adding parameter " + requestParamName + " with value " + paramValue));
                    }
                    postParameters.add((NameValuePair)new BasicNameValuePair(requestParamName, paramValue));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("prefix convention parameter " + requestParamName + " overridden by the property mapped parameter"));
            }
        }
        if (this.context.getDataset() != null && this.context.getDataset().getParameters() != null) {
            for (JRParameter parameter : this.context.getDataset().getParameters()) {
                String paramName;
                if (!parameter.hasProperties() || !parameter.getPropertiesMap().containsProperty(propertyName)) continue;
                requestParamName = parameter.getPropertiesMap().getProperty(propertyName);
                if (requestParamName == null) {
                    requestParamName = parameter.getName();
                }
                if (!parameterValues.containsKey(paramName = parameter.getName())) continue;
                Object value = parameterValues.get(paramName);
                String paramValue = this.toHttpParameterValue(value);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("adding parameter " + requestParamName + " with value " + paramValue));
                }
                postParameters.add((NameValuePair)new BasicNameValuePair(requestParamName, paramValue));
            }
        }
        return postParameters;
    }

    protected URI getRequestURI(Map<String, Object> parameters) {
        String url = this.getURL(parameters);
        if (url == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NO_HTTP_URL_SET, (Object[])null);
        }
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            List<NameValuePair> urlParameters = this.collectUrlParameters(parameters);
            if (!urlParameters.isEmpty()) {
                uriBuilder.addParameters(urlParameters);
            }
            URI uri = uriBuilder.build();
            if (log.isDebugEnabled()) {
                log.debug((Object)("request URI " + uri));
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new JRRuntimeException((Throwable)e);
        }
    }

    protected String getURL(Map<String, Object> parameters) {
        String url = this.getPropertyOrParameterValue(PROPERTY_URL, PARAMETER_URL, parameters);
        if (url == null) {
            url = this.dataLocation.getUrl();
        }
        return url;
    }

    protected RequestMethod getMethod(Map<String, Object> parameters) {
        String method = this.getPropertyOrParameterValue(PROPERTY_METHOD, null, parameters);
        return method != null ? RequestMethod.valueOf(method.toUpperCase()) : this.dataLocation.getMethod();
    }

    protected String getBody(Map<String, Object> parameters) {
        String body = this.getPropertyOrParameterValue(PROPERTY_BODY, null, parameters);
        if (body == null) {
            body = this.dataLocation.getBody();
        }
        return body;
    }

    protected String getPropertyOrParameterValue(String propName, String paramName, Map<String, Object> parameterValues) {
        JRParameter[] parameters;
        String value = null;
        JRDataset dataset = this.context.getDataset();
        if (dataset != null && dataset.hasProperties()) {
            value = JRPropertiesUtil.getOwnProperty((JRPropertiesHolder)dataset, (String)propName);
        }
        if (paramName != null && parameterValues.containsKey(paramName)) {
            value = (String)parameterValues.get(paramName);
        }
        if (dataset != null && (parameters = dataset.getParameters()) != null) {
            for (JRParameter parameter : parameters) {
                if (!parameter.hasProperties() || !parameter.getPropertiesMap().containsProperty(propName) || !parameterValues.containsKey(parameter.getName())) continue;
                value = (String)parameterValues.get(parameter.getName());
            }
        }
        return value;
    }

    protected String toHttpParameterValue(Object value) {
        return String.valueOf(value);
    }
}

