/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.poi.data;

import java.io.InputStream;
import java.util.Map;
import net.sf.jasperreports.data.excel.ExcelDataAdapter;
import net.sf.jasperreports.data.excel.ExcelFormatEnum;
import net.sf.jasperreports.data.xls.AbstractXlsDataAdapterService;
import net.sf.jasperreports.data.xls.XlsDataAdapter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.data.AbstractXlsDataSource;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.Pair;
import net.sf.jasperreports.poi.query.ExcelQueryExecuter;

public class ExcelDataAdapterService
extends AbstractXlsDataAdapterService {
    public ExcelDataAdapterService(ParameterContributorContext paramContribContext, ExcelDataAdapter excelDataAdapter) {
        super(paramContribContext, (XlsDataAdapter)excelDataAdapter);
    }

    public ExcelDataAdapter getExcelDataAdapter() {
        return (ExcelDataAdapter)this.getDataAdapter();
    }

    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        super.contributeParameters(parameters);
        ExcelDataAdapter xlsDataAdapter = this.getExcelDataAdapter();
        if (xlsDataAdapter != null) {
            ExcelFormatEnum format = xlsDataAdapter.getFormat();
            if (xlsDataAdapter.isQueryExecuterMode() && format != null) {
                parameters.put("net.sf.jasperreports.xls.format", format);
            }
        }
    }

    protected AbstractXlsDataSource getXlsDataSource() throws JRException {
        AbstractXlsDataSource dataSource = null;
        ExcelDataAdapter excelDataAdapter = this.getExcelDataAdapter();
        Object inputStream = this.dataStream;
        ExcelFormatEnum format = excelDataAdapter.getFormat();
        if (format == null || format == ExcelFormatEnum.AUTODETECT) {
            Pair<InputStream, ExcelFormatEnum> sniffResult = ExcelQueryExecuter.sniffExcelFormat((InputStream)inputStream);
            inputStream = (InputStream)sniffResult.first();
            format = (ExcelFormatEnum)sniffResult.second();
        }
        switch (format) {
            case XLS: {
                dataSource = ExcelQueryExecuter.createDataSource("net.sf.jasperreports.poi.data.ExcelDataSource", new Class[]{InputStream.class, Boolean.TYPE, ExcelFormatEnum.class}, new Object[]{inputStream, false, format});
                break;
            }
            case XLSX: {
                String dataSourceFactoryClassName = JRPropertiesUtil.getInstance((JasperReportsContext)this.getJasperReportsContext()).getProperty("net.sf.jasperreports.xlsx.data.source.factory", new JRPropertiesHolder[]{this.getParameterContributorContext().getDataset()});
                if (dataSourceFactoryClassName == null) {
                    try {
                        JRClassLoader.loadClassForName((String)"net.sf.jasperreports.fastexcel.FastExcelDataSource");
                        dataSource = ExcelQueryExecuter.createDataSource("net.sf.jasperreports.fastexcel.FastExcelDataSource", new Class[]{InputStream.class, Boolean.TYPE}, new Object[]{inputStream, false});
                    }
                    catch (ClassNotFoundException e) {
                        dataSource = ExcelQueryExecuter.createDataSource("net.sf.jasperreports.poi.data.ExcelDataSource", new Class[]{InputStream.class, Boolean.TYPE, ExcelFormatEnum.class}, new Object[]{inputStream, false, format});
                    }
                    break;
                }
                dataSource = ExcelQueryExecuter.createDataSource(dataSourceFactoryClassName, (InputStream)inputStream, false);
                break;
            }
        }
        return dataSource;
    }
}

