/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.poi.query;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.query.AbstractXlsQueryExecuter;
import net.sf.jasperreports.engine.query.QueryExecutionContext;
import net.sf.jasperreports.engine.query.SimpleQueryExecutionContext;
import net.sf.jasperreports.poi.data.XlsDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Workbook;

public class XlsQueryExecuter
extends AbstractXlsQueryExecuter {
    private static final Log log = LogFactory.getLog(XlsQueryExecuter.class);

    protected XlsQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        this((QueryExecutionContext)SimpleQueryExecutionContext.of((JasperReportsContext)jasperReportsContext), dataset, parametersMap);
    }

    protected XlsQueryExecuter(QueryExecutionContext context, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(context, dataset, parametersMap);
    }

    public JRDataSource createDatasource() throws JRException {
        XlsDataSource datasource = null;
        try {
            Workbook workbook = (Workbook)this.getParameterValue("XLS_WORKBOOK");
            if (workbook != null) {
                datasource = new XlsDataSource(workbook);
            } else {
                InputStream xlsInputStream = (InputStream)this.getParameterValue("XLS_INPUT_STREAM");
                if (xlsInputStream != null) {
                    datasource = new XlsDataSource(xlsInputStream);
                } else {
                    File xlsFile = (File)this.getParameterValue("XLS_FILE");
                    if (xlsFile != null) {
                        datasource = new XlsDataSource(xlsFile);
                    } else {
                        String xlsSource = this.getStringParameterOrProperty("net.sf.jasperreports.xls.source");
                        if (xlsSource != null) {
                            datasource = new XlsDataSource(this.getRepositoryContext(), xlsSource);
                        } else if (log.isWarnEnabled()) {
                            log.warn((Object)"No XLS source was provided.");
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new JRException((Throwable)e);
        }
        if (datasource != null) {
            this.initDatasource(datasource);
        }
        return datasource;
    }
}

