/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.poi.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRImageAlignment;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.export.Cut;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ExcelAbstractExporter;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.export.XlsRowLevelInfo;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.export.data.TextValueHandler;
import net.sf.jasperreports.engine.export.type.ImageAnchorTypeEnum;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.engine.util.ExifOrientationEnum;
import net.sf.jasperreports.engine.util.ImageUtil;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextUtil;
import net.sf.jasperreports.export.XlsExporterConfiguration;
import net.sf.jasperreports.export.XlsReportConfiguration;
import net.sf.jasperreports.poi.export.GenericElementXlsHandler;
import net.sf.jasperreports.poi.export.JRXlsExporterContext;
import net.sf.jasperreports.poi.export.JRXlsExporterNature;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Graphics2DRenderable;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.RenderersCache;
import net.sf.jasperreports.renderers.ResourceRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFName;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.usermodel.HeaderFooter;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.PageMargin;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;

public class JRXlsExporter
extends JRXlsAbstractExporter<XlsReportConfiguration, XlsExporterConfiguration, JRXlsExporterContext> {
    private static final Log log = LogFactory.getLog(JRXlsExporter.class);
    public static final String XLS_EXPORTER_KEY = "net.sf.jasperreports.xls";
    public static short MAX_COLOR_INDEX = (short)56;
    public static short MIN_COLOR_INDEX = (short)10;
    private static short A2_PAPERSIZE = (short)66;
    private static Map<HSSFColor, short[]> hssfColorsRgbs;
    protected Map<StyleInfo, HSSFCellStyle> loadedCellStyles = new HashMap<StyleInfo, HSSFCellStyle>();
    protected Map<String, List<Hyperlink>> anchorLinks = new HashMap<String, List<Hyperlink>>();
    protected Map<Integer, List<Hyperlink>> pageLinks = new HashMap<Integer, List<Hyperlink>>();
    protected Map<String, HSSFName> anchorNames = new HashMap<String, HSSFName>();
    protected Map<HSSFSheet, List<Integer>> autofitColumns = new HashMap<HSSFSheet, List<Integer>>();
    protected HSSFWorkbook workbook;
    protected HSSFSheet sheet;
    protected HSSFRow row;
    protected HSSFCell cell;
    protected HSSFCellStyle emptyCellStyle;
    protected CreationHelper createHelper;
    private HSSFPalette palette = null;
    private Map<Color, HSSFColor> hssfColorsCache = new HashMap<Color, HSSFColor>();
    protected short whiteIndex = HSSFColor.HSSFColorPredefined.WHITE.getIndex();
    protected short blackIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
    protected short customColorIndex = MIN_COLOR_INDEX;
    protected FillPatternType backgroundMode = FillPatternType.SOLID_FOREGROUND;
    protected HSSFDataFormat dataFormat;
    protected HSSFPatriarch patriarch;
    protected Map<HSSFCell, String> formulaCellsMap;

    public JRXlsExporter() {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance());
    }

    public JRXlsExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
        this.maxColumnIndex = 255;
    }

    protected Class<XlsExporterConfiguration> getConfigurationInterface() {
        return XlsExporterConfiguration.class;
    }

    protected Class<XlsReportConfiguration> getItemConfigurationInterface() {
        return XlsReportConfiguration.class;
    }

    protected void initExport() {
        super.initExport();
        this.sheet = null;
    }

    protected void initReport() {
        super.initReport();
        XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
        if (!configuration.isWhitePageBackground().booleanValue()) {
            this.backgroundMode = FillPatternType.NO_FILL;
        }
        this.nature = new JRXlsExporterNature(this.jasperReportsContext, this.filter, configuration.isIgnoreGraphics(), configuration.isIgnorePageMargins());
    }

    protected void openWorkbook(OutputStream os) {
        String keywords;
        String author;
        String subject;
        String application;
        String lcWorkbookTemplate;
        XlsExporterConfiguration configuration = (XlsExporterConfiguration)this.getCurrentConfiguration();
        String string = lcWorkbookTemplate = this.workbookTemplate == null ? configuration.getWorkbookTemplate() : this.workbookTemplate;
        if (lcWorkbookTemplate == null) {
            this.workbook = new HSSFWorkbook();
        } else {
            InputStream templateIs = null;
            try {
                templateIs = this.getRepository().getInputStreamFromLocation(lcWorkbookTemplate);
                if (templateIs == null) {
                    throw new JRRuntimeException("export.xls.common.template.not.found", new Object[]{lcWorkbookTemplate});
                }
                this.workbook = new HSSFWorkbook(new POIFSFileSystem(templateIs));
                boolean keepSheets = this.keepTemplateSheets == null ? configuration.isKeepWorkbookTemplateSheets() : this.keepTemplateSheets;
                if (keepSheets) {
                    this.sheetIndex += this.workbook.getNumberOfSheets();
                } else {
                    for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
                        this.workbook.removeSheetAt(i);
                    }
                }
            }
            catch (IOException | JRException e) {
                throw new JRRuntimeException(e);
            }
            finally {
                if (templateIs != null) {
                    try {
                        templateIs.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.emptyCellStyle = this.workbook.createCellStyle();
        this.emptyCellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
        this.emptyCellStyle.setFillPattern(this.backgroundMode);
        this.dataFormat = this.workbook.createDataFormat();
        this.createHelper = this.workbook.getCreationHelper();
        this.firstPageNotSet = true;
        this.palette = this.workbook.getCustomPalette();
        this.customColorIndex = MIN_COLOR_INDEX;
        this.autofitColumns = new HashMap<HSSFSheet, List<Integer>>();
        this.formulaCellsMap = new HashMap<HSSFCell, String>();
        SummaryInformation summaryInformation = this.workbook.getSummaryInformation();
        if (summaryInformation == null) {
            this.workbook.createInformationProperties();
            summaryInformation = this.workbook.getSummaryInformation();
        }
        if ((application = configuration.getMetadataApplication()) == null) {
            String depApplication;
            application = depApplication = "JasperReports Library version " + Package.getPackage("net.sf.jasperreports.engine").getImplementationVersion();
        }
        summaryInformation.setApplicationName(application);
        String title = configuration.getMetadataTitle();
        if (title != null) {
            summaryInformation.setTitle(title);
        }
        if ((subject = configuration.getMetadataSubject()) != null) {
            summaryInformation.setSubject(subject);
        }
        if ((author = configuration.getMetadataAuthor()) != null) {
            summaryInformation.setAuthor(author);
        }
        if ((keywords = configuration.getMetadataKeywords()) != null) {
            summaryInformation.setKeywords(keywords);
        }
    }

    protected void createSheet(CutsInfo xCuts, JRXlsAbstractExporter.SheetInfo sheetInfo) {
        String sheetFooterRight;
        String sheetFooterCenter;
        String sheetFooterLeft;
        String sheetHeaderRight;
        String sheetHeaderCenter;
        XlsReportConfiguration configuration;
        String password;
        this.sheet = this.workbook.createSheet(sheetInfo.sheetName);
        this.patriarch = this.sheet.createDrawingPatriarch();
        HSSFPrintSetup printSetup = this.sheet.getPrintSetup();
        printSetup.setLandscape(this.pageFormat.getOrientation() == OrientationEnum.LANDSCAPE);
        short paperSize = this.getSuitablePaperSize(sheetInfo.printSettings);
        if (paperSize != -1) {
            printSetup.setPaperSize(paperSize);
        }
        if ((password = (configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration()).getPassword()) != null) {
            this.sheet.protectSheet(password);
        }
        JRXlsAbstractExporter.SheetInfo.SheetPrintSettings printSettings = sheetInfo.printSettings;
        this.sheet.setMargin(PageMargin.LEFT, LengthUtil.inch((double)printSettings.getLeftMargin().intValue()));
        this.sheet.setMargin(PageMargin.RIGHT, LengthUtil.inch((double)printSettings.getRightMargin().intValue()));
        this.sheet.setMargin(PageMargin.TOP, LengthUtil.inch((double)printSettings.getTopMargin().intValue()));
        this.sheet.setMargin(PageMargin.BOTTOM, LengthUtil.inch((double)printSettings.getBottomMargin().intValue()));
        String sheetHeaderLeft = printSettings.getHeaderLeft();
        if (sheetHeaderLeft != null) {
            this.sheet.getHeader().setLeft(sheetHeaderLeft);
        }
        if ((sheetHeaderCenter = printSettings.getHeaderCenter()) != null) {
            this.sheet.getHeader().setCenter(sheetHeaderCenter);
        }
        if ((sheetHeaderRight = printSettings.getHeaderRight()) != null) {
            this.sheet.getHeader().setRight(sheetHeaderRight);
        }
        if ((sheetFooterLeft = printSettings.getFooterLeft()) != null) {
            this.sheet.getFooter().setLeft(sheetFooterLeft);
        }
        if ((sheetFooterCenter = printSettings.getFooterCenter()) != null) {
            this.sheet.getFooter().setCenter(sheetFooterCenter);
        }
        if ((sheetFooterRight = printSettings.getFooterRight()) != null) {
            this.sheet.getFooter().setRight(sheetFooterRight);
        }
        printSetup.setHeaderMargin(LengthUtil.inch((double)printSettings.getHeaderMargin().intValue()));
        printSetup.setFooterMargin(LengthUtil.inch((double)printSettings.getFooterMargin().intValue()));
        RunDirectionEnum sheetDirection = configuration.getSheetDirection();
        if (sheetDirection != null) {
            printSetup.setLeftToRight(sheetDirection == RunDirectionEnum.LTR);
            this.sheet.setRightToLeft(sheetDirection == RunDirectionEnum.RTL);
        }
        if (sheetInfo.sheetFirstPageNumber != null && sheetInfo.sheetFirstPageNumber > 0) {
            printSetup.setPageStart((short)sheetInfo.sheetFirstPageNumber.intValue());
            printSetup.setUsePage(true);
            this.firstPageNotSet = false;
        } else {
            Integer documentFirstPageNumber = configuration.getFirstPageNumber();
            if (documentFirstPageNumber != null && documentFirstPageNumber > 0 && this.firstPageNotSet) {
                printSetup.setPageStart((short)documentFirstPageNumber.intValue());
                printSetup.setUsePage(true);
                this.firstPageNotSet = false;
            }
        }
        if (!(this.firstPageNotSet || this.sheet.getFooter().getCenter() != null && this.sheet.getFooter().getCenter().length() != 0)) {
            this.sheet.getFooter().setCenter("Page " + HeaderFooter.page());
        }
        boolean showGridlines = true;
        if (sheetInfo.sheetShowGridlines == null) {
            Boolean documentShowGridlines = configuration.isShowGridLines();
            if (documentShowGridlines != null) {
                showGridlines = documentShowGridlines;
            }
        } else {
            showGridlines = sheetInfo.sheetShowGridlines;
        }
        this.sheet.setDisplayGridlines(showGridlines);
        this.backgroundMode = Boolean.TRUE.equals(sheetInfo.whitePageBackground) ? FillPatternType.SOLID_FOREGROUND : FillPatternType.NO_FILL;
        this.onePagePerSheetMap.put(this.sheetIndex, this.onePagePerSheet);
        this.sheetsBeforeCurrentReportMap.put(this.sheetIndex, this.sheetsBeforeCurrentReport);
    }

    protected void closeSheet() {
        if (this.sheet == null) {
            return;
        }
        HSSFPrintSetup printSetup = this.sheet.getPrintSetup();
        if (this.isValidScale(this.sheetInfo.sheetPageScale)) {
            printSetup.setScale((short)this.sheetInfo.sheetPageScale.intValue());
        } else {
            Integer fitHeight;
            XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
            Integer fitWidth = configuration.getFitWidth();
            if (fitWidth != null) {
                printSetup.setFitWidth(fitWidth.shortValue());
                this.sheet.setAutobreaks(true);
            }
            Integer n = (fitHeight = configuration.getFitHeight()) == null ? (Boolean.TRUE == configuration.isAutoFitPageHeight() ? Integer.valueOf(this.pageIndex - this.sheetInfo.sheetFirstPageIndex) : null) : (fitHeight = fitHeight);
            if (fitHeight != null) {
                printSetup.setFitHeight(fitHeight.shortValue());
                this.sheet.setAutobreaks(true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void closeWorkbook(OutputStream os) throws JRException {
        try {
            void var3_12;
            for (Map.Entry<String, HSSFName> entry : this.anchorNames.entrySet()) {
                String anchorName = entry.getKey();
                HSSFName anchor = entry.getValue();
                List<Hyperlink> linkList = this.anchorLinks.get(anchorName);
                anchor.setRefersToFormula("'" + this.workbook.getSheetName(anchor.getSheetIndex()) + "'!" + anchor.getRefersToFormula());
                if (linkList == null || linkList.isEmpty()) continue;
                for (Hyperlink link : linkList) {
                    link.setAddress(anchor.getRefersToFormula());
                }
            }
            if (!this.definedNamesMap.isEmpty()) {
                for (Map.Entry<String, Object> entry : this.definedNamesMap.entrySet()) {
                    HSSFName name = this.workbook.createName();
                    ExcelAbstractExporter.NameScope nameScope = (ExcelAbstractExporter.NameScope)entry.getKey();
                    name.setNameName(nameScope.getName());
                    name.setRefersToFormula((String)entry.getValue());
                    int scopeIndex = this.workbook.getSheetIndex(nameScope.getScope());
                    if (nameScope.getScope() == null || "workbook".equalsIgnoreCase(nameScope.getScope()) || scopeIndex < 0) continue;
                    name.setSheetIndex(scopeIndex);
                }
            }
            if (this.formulaCellsMap != null && !this.formulaCellsMap.isEmpty()) {
                for (Map.Entry<String, Object> entry : this.formulaCellsMap.entrySet()) {
                    try {
                        ((HSSFCell)entry.getKey()).setCellFormula((String)entry.getValue());
                    }
                    catch (Exception e) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)e.getMessage());
                        }
                        throw new JRException((Throwable)e);
                    }
                }
            }
            int index = 0;
            for (Map.Entry<Integer, List<Hyperlink>> entry : this.pageLinks.entrySet()) {
                Integer linkPage = entry.getKey();
                List<Hyperlink> linkList = entry.getValue();
                if (linkList == null || linkList.isEmpty()) continue;
                for (Hyperlink link : linkList) {
                    index = this.onePagePerSheetMap.get(linkPage - 1) != null ? (((Boolean)this.onePagePerSheetMap.get(linkPage - 1)).booleanValue() ? Math.max(0, linkPage - 1) : Math.max(0, (Integer)this.sheetsBeforeCurrentReportMap.get(linkPage))) : 0;
                    link.setAddress("'" + this.workbook.getSheetName(index) + "'!$A$1");
                }
            }
            boolean bl = false;
            while (var3_12 < this.workbook.getNumberOfSheets()) {
                HSSFSheet currentSheet = this.workbook.getSheetAt((int)var3_12);
                currentSheet.setForceFormulaRecalculation(true);
                List<Integer> autofitList = this.autofitColumns.get(currentSheet);
                if (autofitList != null) {
                    for (Integer j : autofitList) {
                        currentSheet.autoSizeColumn(j.intValue(), false);
                    }
                }
                ++var3_12;
            }
            String string = ((XlsExporterConfiguration)this.getCurrentConfiguration()).getEncryptionPassword();
            if (string == null || string.trim().length() == 0) {
                Biff8EncryptionKey.setCurrentUserPassword(null);
            } else {
                Biff8EncryptionKey.setCurrentUserPassword((String)string);
            }
            this.workbook.write(os);
            Biff8EncryptionKey.setCurrentUserPassword(null);
        }
        catch (IOException e) {
            throw new JRException("export.xls.common.report.generation.error", new Object[]{this.jasperPrint.getName()}, (Throwable)e);
        }
    }

    protected void setColumnWidth(int col, int width, boolean autoFit) {
        if (autoFit) {
            ArrayList<Integer> autofitList = this.autofitColumns.get(this.sheet) != null ? this.autofitColumns.get(this.sheet) : new ArrayList<Integer>();
            autofitList.add(col);
            this.autofitColumns.put(this.sheet, autofitList);
        } else {
            this.sheet.setColumnWidth(col, Math.min(43 * width, 65280));
        }
    }

    protected void setRowHeight(int rowIndex, int lastRowHeight, Cut yCut, XlsRowLevelInfo levelInfo) {
        boolean isAutoFit;
        this.row = this.sheet.getRow(rowIndex);
        if (this.row == null) {
            this.row = this.sheet.createRow(rowIndex);
        }
        if (!(isAutoFit = (yCut.hasProperty("net.sf.jasperreports.export.xls.auto.fit.row") ? (Boolean)yCut.getProperty("net.sf.jasperreports.export.xls.auto.fit.row") : ((XlsReportConfiguration)this.getCurrentItemConfiguration()).isAutoFitRow()).booleanValue())) {
            this.row.setHeightInPoints((float)lastRowHeight);
        }
    }

    protected void addRowBreak(int rowIndex) {
        if (rowIndex >= 0 && rowIndex <= SpreadsheetVersion.EXCEL97.getLastRowIndex()) {
            this.sheet.setRowBreak(rowIndex);
        }
    }

    protected void addBlankCell(JRExporterGridCell gridCell, int colIndex, int rowIndex) {
        this.cell = this.row.createCell(colIndex);
        FillPatternType mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (!Boolean.TRUE.equals(this.sheetInfo.ignoreCellBackground) && gridCell.getCellBackcolor() != null) {
            mode = FillPatternType.SOLID_FOREGROUND;
            backcolor = this.getWorkbookColor(gridCell.getCellBackcolor()).getIndex();
        }
        short forecolor = this.blackIndex;
        if (gridCell.getForecolor() != null) {
            forecolor = this.getWorkbookColor(gridCell.getForecolor()).getIndex();
        }
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, HorizontalAlignment.LEFT, VerticalAlignment.TOP, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor, null, this.getLocale()), gridCell, true, true, false, false);
        this.cell.setCellStyle(cellStyle);
    }

    protected void addOccupiedCell(OccupiedGridCell occupiedGridCell, int colIndex, int rowIndex) {
    }

    protected void exportLine(JRPrintLine line, JRExporterGridCell gridCell, int colIndex, int rowIndex) {
        short forecolor = this.getWorkbookColor(line.getLinePen().getLineColor()).getIndex();
        int side = 0;
        float ratio = line.getWidth() / line.getHeight();
        side = ratio > 1.0f ? (line.getDirection() != LineDirectionEnum.BOTTOM_UP ? 0 : 2) : (line.getDirection() != LineDirectionEnum.BOTTOM_UP ? 1 : 3);
        BoxStyle boxStyle = new BoxStyle(side, line.getLinePen());
        FillPatternType mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (!Boolean.TRUE.equals(this.sheetInfo.ignoreCellBackground) && gridCell.getCellBackcolor() != null) {
            mode = FillPatternType.SOLID_FOREGROUND;
            backcolor = this.getWorkbookColor(gridCell.getCellBackcolor()).getIndex();
        }
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, HorizontalAlignment.LEFT, VerticalAlignment.TOP, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor, null, this.getLocale()), boxStyle, false, this.isCellLocked((JRPrintElement)line), this.isCellHidden((JRPrintElement)line), this.isShrinkToFit((JRPrintElement)line));
        this.createMergeRegion(gridCell, colIndex, rowIndex, cellStyle);
        this.cell = this.row.createCell(colIndex);
        this.cell.setCellStyle(cellStyle);
    }

    protected void exportRectangle(JRPrintGraphicElement element, JRExporterGridCell gridCell, int colIndex, int rowIndex) {
        short forecolor = this.getWorkbookColor(element.getLinePen().getLineColor()).getIndex();
        FillPatternType mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (!Boolean.TRUE.equals(this.sheetInfo.ignoreCellBackground) && gridCell.getCellBackcolor() != null) {
            mode = FillPatternType.SOLID_FOREGROUND;
            backcolor = this.getWorkbookColor(gridCell.getCellBackcolor()).getIndex();
        }
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, HorizontalAlignment.LEFT, VerticalAlignment.TOP, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor, null, this.getLocale()), gridCell, this.isWrapText((JRPrintElement)element), this.isCellLocked((JRPrintElement)element), this.isCellHidden((JRPrintElement)element), this.isShrinkToFit((JRPrintElement)element));
        this.createMergeRegion(gridCell, colIndex, rowIndex, cellStyle);
        this.cell = this.row.createCell(colIndex);
        this.cell.setCellStyle(cellStyle);
    }

    public void exportText(JRPrintText textElement, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        JRStyledText styledText = this.getStyledText(textElement);
        if (styledText == null) {
            return;
        }
        short forecolor = this.getWorkbookColor(textElement.getForecolor()).getIndex();
        ExcelAbstractExporter.TextAlignHolder textAlignHolder = JRXlsExporter.getTextAlignHolder((JRPrintText)textElement);
        HorizontalAlignment horizontalAlignment = this.getHorizontalAlignment(textAlignHolder);
        VerticalAlignment verticalAlignment = this.getVerticalAlignment(textAlignHolder);
        short rotation = this.getRotation(textAlignHolder);
        FillPatternType mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (!Boolean.TRUE.equals(this.sheetInfo.ignoreCellBackground) && gridCell.getCellBackcolor() != null) {
            mode = FillPatternType.SOLID_FOREGROUND;
            backcolor = this.getWorkbookColor(gridCell.getCellBackcolor()).getIndex();
        }
        StyleInfo baseStyle = this.isIgnoreTextFormatting((JRPrintElement)textElement) ? new StyleInfo(mode, this.whiteIndex, horizontalAlignment, verticalAlignment, 0, null, (JRExporterGridCell)null, this.isWrapText((JRPrintElement)textElement) || Boolean.TRUE.equals(((JRXlsExporterNature)this.nature).getColumnAutoFit((JRPrintElement)textElement)), this.isCellLocked((JRPrintElement)textElement), this.isCellHidden((JRPrintElement)textElement), this.isShrinkToFit((JRPrintElement)textElement)) : new StyleInfo(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, this.getLoadedFont((JRFont)textElement, forecolor, null, this.getTextLocale(textElement)), gridCell, this.isWrapText((JRPrintElement)textElement) || Boolean.TRUE.equals(((JRXlsExporterNature)this.nature).getColumnAutoFit((JRPrintElement)textElement)), this.isCellLocked((JRPrintElement)textElement), this.isCellHidden((JRPrintElement)textElement), this.isShrinkToFit((JRPrintElement)textElement));
        this.createTextCell(textElement, gridCell, colIndex, rowIndex, styledText, baseStyle, forecolor);
    }

    protected void createTextCell(final JRPrintText textElement, final JRExporterGridCell gridCell, final int colIndex, final int rowIndex, final JRStyledText styledText, final StyleInfo baseStyle, final short forecolor) throws JRException {
        String anchorName;
        String convertedPattern;
        TextValue value;
        String textStr;
        block13: {
            String formula = this.getFormula(textElement);
            textStr = styledText.getText();
            value = null;
            String pattern = null;
            if (formula != null || this.detectCellType) {
                value = this.getTextValue(textElement, textStr);
                if (value instanceof NumberTextValue) {
                    pattern = ((NumberTextValue)value).getPattern();
                } else if (value instanceof DateTextValue) {
                    pattern = ((DateTextValue)value).getPattern();
                }
            }
            if ((convertedPattern = this.getConvertedPattern(textElement, pattern)) != null) {
                baseStyle.setDataFormat(this.dataFormat.getFormat(convertedPattern));
            }
            if (formula != null) {
                try {
                    HSSFCellStyle cellStyle = this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    this.formulaCellsMap.put(this.cell, formula);
                    this.endCreateCell(cellStyle);
                    return;
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block13;
                    log.warn((Object)e.getMessage());
                }
            }
        }
        if (this.detectCellType) {
            value.handle(new TextValueHandler(){

                public void handle(StringTextValue textValue) {
                    HSSFCellStyle cellStyle = JRXlsExporter.this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    if (textValue.getText() == null || textValue.getText().length() == 0) {
                        JRXlsExporter.this.cell.setCellType(CellType.BLANK);
                    } else if ("none".equals(textElement.getMarkup()) || JRXlsExporter.this.isIgnoreTextFormatting((JRPrintElement)textElement)) {
                        JRXlsExporter.this.setStringCellValue(textValue.getText());
                    } else {
                        JRXlsExporter.this.setRichTextStringCellValue(styledText, forecolor, (JRFont)textElement, JRXlsExporter.this.getTextLocale(textElement));
                    }
                    JRXlsExporter.this.endCreateCell(cellStyle);
                }

                public void handle(NumberTextValue textValue) {
                    HSSFCellStyle cellStyle = JRXlsExporter.this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    if (textValue.getValue() == null) {
                        JRXlsExporter.this.cell.setCellType(CellType.BLANK);
                    } else {
                        double doubleValue = textValue.getValue().doubleValue();
                        if ("[h]:mm:ss".equals(convertedPattern)) {
                            doubleValue /= 86400.0;
                        }
                        JRXlsExporter.this.cell.setCellValue(doubleValue);
                    }
                    JRXlsExporter.this.endCreateCell(cellStyle);
                }

                public void handle(DateTextValue textValue) {
                    HSSFCellStyle cellStyle = JRXlsExporter.this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    Date date = textValue.getValue();
                    if (date == null) {
                        JRXlsExporter.this.cell.setCellType(CellType.BLANK);
                    } else {
                        date = JRXlsExporter.this.translateDateValue(textElement, date);
                        JRXlsExporter.this.cell.setCellValue(date);
                    }
                    JRXlsExporter.this.endCreateCell(cellStyle);
                }

                public void handle(BooleanTextValue textValue) {
                    HSSFCellStyle cellStyle = JRXlsExporter.this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    if (textValue.getValue() == null) {
                        JRXlsExporter.this.cell.setCellType(CellType.BLANK);
                    } else {
                        JRXlsExporter.this.cell.setCellValue(textValue.getValue().booleanValue());
                    }
                    JRXlsExporter.this.endCreateCell(cellStyle);
                }
            });
        } else {
            HSSFCellStyle cellStyle = this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
            if ("none".equals(textElement.getMarkup()) || this.isIgnoreTextFormatting((JRPrintElement)textElement)) {
                this.setStringCellValue(textStr);
            } else {
                this.setRichTextStringCellValue(styledText, forecolor, (JRFont)textElement, this.getTextLocale(textElement));
            }
            this.endCreateCell(cellStyle);
        }
        if (!this.ignoreAnchors && (anchorName = textElement.getAnchorName()) != null) {
            HSSFName aName = this.workbook.createName();
            aName.setNameName(this.toExcelName(anchorName));
            aName.setSheetIndex(this.workbook.getSheetIndex((Sheet)this.sheet));
            CellReference cRef = new CellReference(rowIndex, colIndex, true, true);
            aName.setRefersToFormula(cRef.formatAsString());
            this.anchorNames.put(anchorName, aName);
        }
        this.setHyperlinkCell((JRPrintHyperlink)textElement);
    }

    protected HSSFCellStyle initCreateCell(JRExporterGridCell gridCell, int colIndex, int rowIndex, StyleInfo baseStyle) {
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(baseStyle);
        this.createMergeRegion(gridCell, colIndex, rowIndex, cellStyle);
        this.cell = this.row.createCell(colIndex);
        return cellStyle;
    }

    protected void endCreateCell(HSSFCellStyle cellStyle) {
        this.cell.setCellStyle(cellStyle);
    }

    protected final void setStringCellValue(String textStr) {
        this.cell.setCellValue((RichTextString)new HSSFRichTextString(textStr));
    }

    protected final void setRichTextStringCellValue(JRStyledText styledText, short forecolor, JRFont defaultFont, Locale locale) {
        if (styledText != null) {
            this.cell.setCellValue((RichTextString)this.getRichTextString(styledText, forecolor, defaultFont, locale));
        }
    }

    protected HSSFRichTextString getRichTextString(JRStyledText styledText, short forecolor, JRFont defaultFont, Locale locale) {
        styledText = JRStyledTextUtil.getBulletedStyledText((JRStyledText)styledText);
        String text = styledText.getText();
        HSSFRichTextString richTextStr = new HSSFRichTextString(text);
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            Map<AttributedCharacterIterator.Attribute, Object> attributes = iterator.getAttributes();
            JRFont runFont = attributes.isEmpty() ? defaultFont : new JRBaseFont(attributes);
            short runForecolor = attributes.get(TextAttribute.FOREGROUND) != null ? this.getWorkbookColor((Color)attributes.get(TextAttribute.FOREGROUND)).getIndex() : forecolor;
            HSSFFont font = this.getLoadedFont(runFont, runForecolor, attributes, locale);
            richTextStr.applyFont(iterator.getIndex(), runLimit, (Font)font);
            iterator.setIndex(runLimit);
        }
        return richTextStr;
    }

    protected void createMergeRegion(JRExporterGridCell gridCell, int colIndex, int rowIndex, HSSFCellStyle cellStyle) {
        int rowSpan;
        int n = rowSpan = this.collapseRowSpan ? 1 : gridCell.getRowSpan();
        if (gridCell.getColSpan() > 1 || rowSpan > 1) {
            this.sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex + rowSpan - 1, colIndex, colIndex + gridCell.getColSpan() - 1));
            for (int i = 0; i < rowSpan; ++i) {
                HSSFRow spanRow = this.sheet.getRow(rowIndex + i);
                if (spanRow == null) {
                    spanRow = this.sheet.createRow(rowIndex + i);
                }
                for (int j = 0; j < gridCell.getColSpan(); ++j) {
                    HSSFCell spanCell = spanRow.getCell(colIndex + j);
                    if (spanCell == null) {
                        spanCell = spanRow.createCell(colIndex + j);
                    }
                    spanCell.setCellStyle(cellStyle);
                }
            }
        }
    }

    private HorizontalAlignment getHorizontalAlignment(ExcelAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.horizontalAlignment) {
            case RIGHT: {
                return HorizontalAlignment.RIGHT;
            }
            case CENTER: {
                return HorizontalAlignment.CENTER;
            }
            case JUSTIFIED: {
                return HorizontalAlignment.JUSTIFY;
            }
        }
        return HorizontalAlignment.LEFT;
    }

    private VerticalAlignment getVerticalAlignment(ExcelAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.verticalAlignment) {
            case BOTTOM: {
                return VerticalAlignment.BOTTOM;
            }
            case MIDDLE: {
                return VerticalAlignment.CENTER;
            }
            case JUSTIFIED: {
                return VerticalAlignment.JUSTIFY;
            }
        }
        return VerticalAlignment.TOP;
    }

    private short getRotation(ExcelAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.rotation) {
            case LEFT: {
                return 90;
            }
            case RIGHT: {
                return -90;
            }
        }
        return 0;
    }

    protected HSSFColor getWorkbookColor(Color awtColor) {
        byte red = (byte)awtColor.getRed();
        byte green = (byte)awtColor.getGreen();
        byte blue = (byte)awtColor.getBlue();
        HSSFColor color = null;
        if (((XlsExporterConfiguration)this.getCurrentConfiguration()).isCreateCustomPalette().booleanValue()) {
            try {
                color = this.palette.findColor(red, green, blue) != null ? this.palette.findColor(red, green, blue) : this.palette.addColor(red, green, blue);
            }
            catch (Exception e) {
                if (this.customColorIndex < MAX_COLOR_INDEX) {
                    this.palette.setColorAtIndex(this.customColorIndex, red, green, blue);
                    short s = this.customColorIndex;
                    this.customColorIndex = (short)(s + 1);
                    color = this.palette.getColor(s);
                }
                color = this.palette.findSimilarColor(red, green, blue);
            }
        }
        return color == null ? this.getNearestColor(awtColor) : color;
    }

    protected HSSFColor getNearestColor(Color awtColor) {
        HSSFColor color = this.hssfColorsCache.get(awtColor);
        if (color == null) {
            int minDiff = Integer.MAX_VALUE;
            for (Map.Entry<HSSFColor, short[]> hssfColorEntry : hssfColorsRgbs.entrySet()) {
                HSSFColor crtColor = hssfColorEntry.getKey();
                short[] rgb = hssfColorEntry.getValue();
                int diff = Math.abs(rgb[0] - awtColor.getRed()) + Math.abs(rgb[1] - awtColor.getGreen()) + Math.abs(rgb[2] - awtColor.getBlue());
                if (diff >= minDiff) continue;
                minDiff = diff;
                color = crtColor;
            }
            this.hssfColorsCache.put(awtColor, color);
        }
        return color;
    }

    protected HSSFFont getLoadedFont(JRFont font, short forecolor, Map<AttributedCharacterIterator.Attribute, Object> attributes, Locale locale) {
        HSSFFont cellFont = null;
        String fontName = this.fontUtil.getExportFontFamily(font.getFontName(), locale, this.getExporterKey());
        short superscriptType = 0;
        if (attributes != null && attributes.get(TextAttribute.SUPERSCRIPT) != null) {
            Object value = attributes.get(TextAttribute.SUPERSCRIPT);
            if (TextAttribute.SUPERSCRIPT_SUPER.equals(value)) {
                superscriptType = 1;
            } else if (TextAttribute.SUPERSCRIPT_SUB.equals(value)) {
                superscriptType = 2;
            }
        }
        boolean isFontSizeFixEnabled = ((XlsReportConfiguration)this.getCurrentItemConfiguration()).isFontSizeFixEnabled();
        for (int i = 0; i < this.loadedFonts.size(); ++i) {
            HSSFFont cf = (HSSFFont)this.loadedFonts.get(i);
            short fontSize = (short)font.getFontSize();
            if (isFontSizeFixEnabled) {
                fontSize = (short)(fontSize - 1);
            }
            if (!cf.getFontName().equals(fontName) || cf.getColor() != forecolor || cf.getFontHeightInPoints() != fontSize || !(cf.getUnderline() == 1 ? font.isUnderline() : !font.isUnderline()) || cf.getStrikeout() != font.isStrikeThrough() || cf.getBold() != font.isBold() || cf.getItalic() != font.isItalic() || cf.getTypeOffset() != superscriptType) continue;
            cellFont = cf;
            break;
        }
        if (cellFont == null) {
            cellFont = this.workbook.createFont();
            cellFont.setFontName(fontName);
            cellFont.setColor(forecolor);
            short fontSize = (short)font.getFontSize();
            if (isFontSizeFixEnabled) {
                fontSize = (short)(fontSize - 1);
            }
            cellFont.setFontHeightInPoints(fontSize);
            if (font.isUnderline()) {
                cellFont.setUnderline((byte)1);
            }
            if (font.isStrikeThrough()) {
                cellFont.setStrikeout(true);
            }
            if (font.isBold()) {
                cellFont.setBold(true);
            }
            if (font.isItalic()) {
                cellFont.setItalic(true);
            }
            cellFont.setTypeOffset(superscriptType);
            this.loadedFonts.add(cellFont);
        }
        return cellFont;
    }

    protected HSSFCellStyle getLoadedCellStyle(StyleInfo style) {
        HSSFCellStyle cellStyle = this.loadedCellStyles.get(style);
        if (cellStyle == null) {
            boolean isIgnoreCellBorder;
            cellStyle = this.workbook.createCellStyle();
            cellStyle.setFillForegroundColor(style.backcolor);
            cellStyle.setFillPattern(style.mode);
            cellStyle.setAlignment(style.horizontalAlignment);
            cellStyle.setVerticalAlignment(style.verticalAlignment);
            cellStyle.setRotation(style.rotation);
            if (style.font != null) {
                cellStyle.setFont(style.font);
            }
            cellStyle.setWrapText(style.lcWrapText);
            cellStyle.setLocked(style.lcCellLocked);
            cellStyle.setHidden(style.lcCellHidden);
            cellStyle.setShrinkToFit(style.lcShrinkToFit);
            if (style.hasDataFormat()) {
                cellStyle.setDataFormat(style.getDataFormat());
            }
            boolean bl = isIgnoreCellBorder = Boolean.TRUE.equals(this.sheetInfo.ignoreCellBorder) || style.box == null;
            if (!isIgnoreCellBorder) {
                BoxStyle box = style.box;
                if (box.borderStyle[0] != null) {
                    cellStyle.setBorderTop(box.borderStyle[0]);
                }
                cellStyle.setTopBorderColor(box.borderColour[0]);
                if (box.borderStyle[1] != null) {
                    cellStyle.setBorderLeft(box.borderStyle[1]);
                }
                cellStyle.setLeftBorderColor(box.borderColour[1]);
                if (box.borderStyle[2] != null) {
                    cellStyle.setBorderBottom(box.borderStyle[2]);
                }
                cellStyle.setBottomBorderColor(box.borderColour[2]);
                if (box.borderStyle[3] != null) {
                    cellStyle.setBorderRight(box.borderStyle[3]);
                }
                cellStyle.setRightBorderColor(box.borderColour[3]);
            }
            this.loadedCellStyles.put(style, cellStyle);
        }
        return cellStyle;
    }

    protected HSSFCellStyle getLoadedCellStyle(FillPatternType mode, short backcolor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, short rotation, HSSFFont font, JRExporterGridCell gridCell, boolean isWrapText, boolean isCellLocked, boolean isCellHidden, boolean isShrinkToFit) {
        return this.getLoadedCellStyle(new StyleInfo(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, gridCell, isWrapText, isCellLocked, isCellHidden, isShrinkToFit));
    }

    protected HSSFCellStyle getLoadedCellStyle(FillPatternType mode, short backcolor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, short rotation, HSSFFont font, BoxStyle box, boolean isWrapText, boolean isCellLocked, boolean isCellHidden, boolean isShrinkToFit) {
        StyleInfo style = new StyleInfo(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, box, isWrapText, isCellLocked, isCellHidden, isShrinkToFit);
        return this.getLoadedCellStyle(style);
    }

    protected static BorderStyle getBorderStyle(JRPen pen) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            switch (pen.getLineStyle()) {
                case DOUBLE: {
                    return BorderStyle.DOUBLE;
                }
                case DOTTED: {
                    return BorderStyle.DOTTED;
                }
                case DASHED: {
                    if (lineWidth >= 1.0f) {
                        return BorderStyle.MEDIUM_DASHED;
                    }
                    return BorderStyle.DASHED;
                }
            }
            if (lineWidth >= 2.0f) {
                return BorderStyle.THICK;
            }
            if (lineWidth >= 1.0f) {
                return BorderStyle.MEDIUM;
            }
            if (lineWidth >= 0.5f) {
                return BorderStyle.THIN;
            }
            return BorderStyle.HAIR;
        }
        return BorderStyle.NONE;
    }

    public void exportImage(JRPrintImage element, JRExporterGridCell gridCell, int colIndex, int rowIndex, int emptyCols, int yCutsRow, JRGridLayout layout) throws JRException {
        block9: {
            int topPadding = Math.max(element.getLineBox().getTopPadding(), this.getImageBorderCorrection((JRPen)element.getLineBox().getTopPen()));
            int leftPadding = Math.max(element.getLineBox().getLeftPadding(), this.getImageBorderCorrection((JRPen)element.getLineBox().getLeftPen()));
            int bottomPadding = Math.max(element.getLineBox().getBottomPadding(), this.getImageBorderCorrection((JRPen)element.getLineBox().getBottomPen()));
            int rightPadding = Math.max(element.getLineBox().getRightPadding(), this.getImageBorderCorrection((JRPen)element.getLineBox().getRightPen()));
            int tmpAvailableImageWidth = element.getWidth() - leftPadding - rightPadding;
            int availableImageWidth = tmpAvailableImageWidth < 0 ? 0 : tmpAvailableImageWidth;
            int tmpAvailableImageHeight = element.getHeight() - topPadding - bottomPadding;
            int availableImageHeight = tmpAvailableImageHeight < 0 ? 0 : tmpAvailableImageHeight;
            InternalImageProcessor imageProcessor = new InternalImageProcessor(element, availableImageWidth, availableImageHeight);
            try {
                InternalImageProcessorResult imageProcessorResult;
                block10: {
                    Renderable renderer = element.getRenderer();
                    if (renderer == null || availableImageWidth <= 0 || availableImageHeight <= 0) break block9;
                    imageProcessorResult = null;
                    try {
                        imageProcessorResult = imageProcessor.process(renderer);
                    }
                    catch (Exception e) {
                        Renderable onErrorRenderer = this.getRendererUtil().handleImageError(e, element.getOnErrorType());
                        if (onErrorRenderer == null) break block10;
                        imageProcessorResult = imageProcessor.process(onErrorRenderer);
                    }
                }
                if (imageProcessorResult != null) {
                    FillPatternType mode = this.backgroundMode;
                    short backcolor = this.whiteIndex;
                    if (!Boolean.TRUE.equals(this.sheetInfo.ignoreCellBackground) && gridCell.getCellBackcolor() != null) {
                        mode = FillPatternType.SOLID_FOREGROUND;
                        backcolor = this.getWorkbookColor(gridCell.getCellBackcolor()).getIndex();
                    }
                    short forecolor = this.getWorkbookColor(element.getLineBox().getPen().getLineColor()).getIndex();
                    if (element.getMode() == ModeEnum.OPAQUE) {
                        backcolor = this.getWorkbookColor(element.getBackcolor()).getIndex();
                    }
                    HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, HorizontalAlignment.LEFT, VerticalAlignment.TOP, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor, null, this.getLocale()), gridCell, this.isWrapText((JRPrintElement)element), this.isCellLocked((JRPrintElement)element), this.isCellHidden((JRPrintElement)element), this.isShrinkToFit((JRPrintElement)element));
                    this.createMergeRegion(gridCell, colIndex, rowIndex, cellStyle);
                    this.cell = this.row.createCell(colIndex);
                    this.cell.setCellStyle(cellStyle);
                    double topPos = this.getRowRelativePosition(layout, yCutsRow, topPadding + imageProcessorResult.topOffset);
                    double leftPos = this.getColumnRelativePosition(layout, colIndex, leftPadding + imageProcessorResult.leftOffset);
                    double bottomPos = this.getRowRelativePosition(layout, yCutsRow, element.getHeight() - bottomPadding - imageProcessorResult.bottomOffset);
                    double rightPos = this.getColumnRelativePosition(layout, colIndex, element.getWidth() - rightPadding - imageProcessorResult.rightOffset);
                    HSSFClientAnchor anchor = new HSSFClientAnchor((int)((leftPos - (double)((int)leftPos)) * 1023.0), (int)((topPos - (double)((int)topPos)) * 255.0), (int)((rightPos - (double)((int)rightPos)) * 1023.0), (int)((bottomPos - (double)((int)bottomPos)) * 255.0), (short)(colIndex + (int)leftPos), rowIndex + (int)topPos, (short)(colIndex + (int)rightPos), rowIndex + (int)bottomPos);
                    ImageAnchorTypeEnum imageAnchorType = ImageAnchorTypeEnum.getByName((String)JRPropertiesUtil.getOwnProperty((JRPropertiesHolder)element, (String)"net.sf.jasperreports.export.xls.image.anchor.type"));
                    if (imageAnchorType == null && (imageAnchorType = this.defaultImageAnchorType) == null) {
                        imageAnchorType = ImageAnchorTypeEnum.MOVE_NO_SIZE;
                    }
                    anchor.setAnchorType(JRXlsExporter.getAnchorType(imageAnchorType));
                    int imgIndex = this.workbook.addPicture(imageProcessorResult.imageData, 6);
                    this.patriarch.createPicture(anchor, imgIndex).setRotationDegree(imageProcessorResult.angle);
                }
            }
            catch (Exception ex) {
                throw new JRException("export.xls.common.cannot.add.cell", null, (Throwable)ex);
            }
            catch (Error err) {
                throw new JRException("export.xls.common.cannot.add.cell", null, (Throwable)err);
            }
        }
    }

    protected double getColumnRelativePosition(JRGridLayout layout, int col, int offset) {
        int colWidth;
        double colRelPos = 0.0;
        int colIndex = 0;
        for (int cumulativeColWidth = 0; cumulativeColWidth < offset; cumulativeColWidth += colWidth) {
            colWidth = layout.getColumnWidth(col + colIndex);
            if (cumulativeColWidth + colWidth < offset) {
                ++colIndex;
                continue;
            }
            colRelPos += (double)colIndex + (double)(offset - cumulativeColWidth) / (double)colWidth;
        }
        return colRelPos;
    }

    protected double getRowRelativePosition(JRGridLayout layout, int row, int offset) {
        int rowHeight;
        double rowRelPos = 0.0;
        int rowIndex = 0;
        for (int cumulativeRowHeight = 0; cumulativeRowHeight < offset; cumulativeRowHeight += rowHeight) {
            int n = rowHeight = this.collapseRowSpan ? layout.getMaxRowHeight(row + rowIndex) : layout.getRowHeight(row + rowIndex);
            if (cumulativeRowHeight + rowHeight < offset) {
                ++rowIndex;
                continue;
            }
            rowRelPos += (double)rowIndex + (double)(offset - cumulativeRowHeight) / (double)rowHeight;
        }
        return rowRelPos;
    }

    protected void exportFrame(JRPrintFrame frame, JRExporterGridCell gridCell, int x, int y) {
        FillPatternType mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (frame.getMode() == ModeEnum.OPAQUE) {
            mode = FillPatternType.SOLID_FOREGROUND;
            backcolor = this.getWorkbookColor(frame.getBackcolor()).getIndex();
        }
        short forecolor = this.getWorkbookColor(frame.getForecolor()).getIndex();
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, HorizontalAlignment.LEFT, VerticalAlignment.TOP, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor, null, this.getLocale()), gridCell, this.isWrapText((JRPrintElement)frame), this.isCellLocked((JRPrintElement)frame), this.isCellHidden((JRPrintElement)frame), this.isShrinkToFit((JRPrintElement)frame));
        this.createMergeRegion(gridCell, x, y, cellStyle);
        this.cell = this.row.createCell(x);
        this.cell.setCellStyle(cellStyle);
    }

    protected void exportGenericElement(JRGenericPrintElement element, JRExporterGridCell gridCell, int colIndex, int rowIndex, int emptyCols, int yCutsRow, JRGridLayout layout) throws JRException {
        GenericElementXlsHandler handler = (GenericElementXlsHandler)GenericElementHandlerEnviroment.getInstance((JasperReportsContext)this.getJasperReportsContext()).getElementHandler(element.getGenericType(), XLS_EXPORTER_KEY);
        if (handler != null) {
            handler.exportElement((JRXlsExporterContext)this.exporterContext, element, gridCell, colIndex, rowIndex, emptyCols, yCutsRow, layout);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No XLS generic element handler for " + element.getGenericType()));
        }
    }

    private final short getSuitablePaperSize(JRXlsAbstractExporter.SheetInfo.SheetPrintSettings printSettings) {
        if (printSettings == null) {
            return -1;
        }
        long width = 0L;
        long height = 0L;
        int ps = -1;
        if (printSettings.getPageWidth() != 0 && printSettings.getPageHeight() != 0) {
            double dWidth = (double)printSettings.getPageWidth().intValue() / 72.0;
            double dHeight = (double)printSettings.getPageHeight().intValue() / 72.0;
            height = Math.round(dHeight * 25.4);
            width = Math.round(dWidth * 25.4);
            for (int i = 2; i < 6; ++i) {
                int w = this.calculateWidthForDinAN(i);
                int h = this.calculateHeightForDinAN(i);
                if (((long)w != width || (long)h != height) && ((long)h != width || (long)w != height)) continue;
                if (i == 2) {
                    ps = A2_PAPERSIZE;
                }
                if (i == 3) {
                    ps = 8;
                    break;
                }
                if (i == 4) {
                    ps = 9;
                    break;
                }
                if (i != 5) break;
                ps = 11;
                break;
            }
            if (ps == -1 && (width == 110L && height == 220L || width == 220L && height == 110L)) {
                ps = 27;
            }
            if (ps == -1) {
                if (width == 216L && height == 279L || width == 279L && height == 216L) {
                    ps = 1;
                }
                if (width == 216L && height == 356L || width == 356L && height == 216L) {
                    ps = 5;
                } else if (width == 190L && height == 254L || width == 254L && height == 190L) {
                    ps = 7;
                }
            }
        }
        return (short)ps;
    }

    protected void setHyperlinkCell(JRPrintHyperlink hyperlink) {
        block17: {
            Hyperlink link;
            block19: {
                JRHyperlinkProducer customHandler;
                block18: {
                    link = null;
                    Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink((String)"net.sf.jasperreports.export.xls.ignore.hyperlink", (JRPrintHyperlink)hyperlink);
                    if (ignoreHyperlink == null) {
                        ignoreHyperlink = this.defaultIgnoreHyperlink;
                    }
                    if (ignoreHyperlink.booleanValue()) break block17;
                    customHandler = this.getHyperlinkProducer(hyperlink);
                    if (customHandler != null) break block18;
                    switch (hyperlink.getHyperlinkType()) {
                        case REFERENCE: {
                            String href = hyperlink.getHyperlinkReference();
                            if (href != null) {
                                link = this.createHelper.createHyperlink(HyperlinkType.URL);
                                link.setAddress(href);
                                break;
                            }
                            break block19;
                        }
                        case LOCAL_ANCHOR: {
                            String href;
                            if (!this.ignoreAnchors && (href = hyperlink.getHyperlinkAnchor()) != null) {
                                link = this.createHelper.createHyperlink(HyperlinkType.DOCUMENT);
                                if (this.anchorLinks.containsKey(href)) {
                                    this.anchorLinks.get(href).add(link);
                                    break;
                                }
                                ArrayList<Hyperlink> hrefList = new ArrayList<Hyperlink>();
                                hrefList.add(link);
                                this.anchorLinks.put(href, hrefList);
                                break;
                            }
                            break block19;
                        }
                        case LOCAL_PAGE: {
                            Integer hrefPage = this.onePagePerSheet ? hyperlink.getHyperlinkPage() : 0;
                            if (hrefPage != null) {
                                link = this.createHelper.createHyperlink(HyperlinkType.DOCUMENT);
                                if (this.pageLinks.containsKey(this.sheetsBeforeCurrentReport + hrefPage)) {
                                    this.pageLinks.get(this.sheetsBeforeCurrentReport + hrefPage).add(link);
                                    break;
                                }
                                ArrayList<Hyperlink> hrefList = new ArrayList<Hyperlink>();
                                hrefList.add(link);
                                this.pageLinks.put(this.sheetsBeforeCurrentReport + hrefPage, hrefList);
                                break;
                            }
                            break block19;
                        }
                        case REMOTE_ANCHOR: {
                            String href = hyperlink.getHyperlinkReference();
                            if (href != null && hyperlink.getHyperlinkAnchor() != null) {
                                href = href + "#" + hyperlink.getHyperlinkAnchor();
                                link = this.createHelper.createHyperlink(HyperlinkType.FILE);
                                link.setAddress(href);
                                break;
                            }
                            break block19;
                        }
                        case REMOTE_PAGE: {
                            String href = hyperlink.getHyperlinkReference();
                            if (href != null && hyperlink.getHyperlinkPage() != null) {
                                href = href + "#JR_PAGE_ANCHOR_0_" + hyperlink.getHyperlinkPage().toString();
                                link = this.createHelper.createHyperlink(HyperlinkType.FILE);
                                link.setAddress(href);
                                break;
                            }
                            break block19;
                        }
                    }
                    break block19;
                }
                String href = customHandler.getHyperlink(hyperlink);
                if (href != null) {
                    link = this.createHelper.createHyperlink(HyperlinkType.URL);
                    link.setAddress(href);
                }
            }
            if (link != null) {
                this.cell.setHyperlink(link);
            }
        }
    }

    protected Integer getMaxRowsPerSheet() {
        Integer maxRowsPerSheet = super.getMaxRowsPerSheet();
        return maxRowsPerSheet == null || maxRowsPerSheet == 0 || maxRowsPerSheet > 65536 ? 65536 : maxRowsPerSheet;
    }

    public String getExporterKey() {
        return XLS_EXPORTER_KEY;
    }

    public String getExporterPropertiesPrefix() {
        return "net.sf.jasperreports.export.xls.";
    }

    protected void setFreezePane(int rowIndex, int colIndex) {
        if (rowIndex > 0 || colIndex > 0) {
            this.sheet.createFreezePane(Math.max(0, colIndex), Math.max(0, rowIndex));
        }
    }

    protected void setSheetName(String sheetName) {
        this.workbook.setSheetName(this.workbook.getSheetIndex((Sheet)this.sheet), sheetName);
    }

    protected void setAutoFilter(String autoFilterRange) {
        this.sheet.setAutoFilter(CellRangeAddress.valueOf((String)autoFilterRange));
    }

    protected void setRowLevels(XlsRowLevelInfo levelInfo, String level) {
        SortedMap levelMap = levelInfo.getLevelMap();
        if (levelMap != null && levelMap.size() > 0) {
            for (Map.Entry entry : levelMap.entrySet()) {
                String l = (String)entry.getKey();
                if (level != null && l.compareTo(level) < 0) continue;
                Integer startIndex = (Integer)entry.getValue();
                if (levelInfo.getEndIndex() < startIndex) continue;
                this.sheet.groupRow(startIndex.intValue(), levelInfo.getEndIndex().intValue());
            }
            this.sheet.setRowSumsBelow(false);
        }
    }

    public static ClientAnchor.AnchorType getAnchorType(ImageAnchorTypeEnum anchorType) {
        switch (anchorType) {
            case MOVE_SIZE: {
                return ClientAnchor.AnchorType.MOVE_AND_RESIZE;
            }
            case NO_MOVE_NO_SIZE: {
                return ClientAnchor.AnchorType.DONT_MOVE_AND_RESIZE;
            }
        }
        return ClientAnchor.AnchorType.MOVE_DONT_RESIZE;
    }

    static {
        Map hssfColors = HSSFColor.getTripletHash();
        hssfColorsRgbs = new LinkedHashMap<HSSFColor, short[]>();
        for (HSSFColor color : hssfColors.values()) {
            hssfColorsRgbs.put(color, color.getTriplet());
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRXlsExporterContext {
        protected ExporterContext() {
            super((JRAbstractExporter)JRXlsExporter.this);
        }
    }

    class BoxStyle {
        protected static final int TOP = 0;
        protected static final int LEFT = 1;
        protected static final int BOTTOM = 2;
        protected static final int RIGHT = 3;
        protected BorderStyle[] borderStyle = new BorderStyle[]{BorderStyle.NONE, BorderStyle.NONE, BorderStyle.NONE, BorderStyle.NONE};
        protected short[] borderColour = new short[4];
        private int hash;

        public BoxStyle(int side, JRPen pen) {
            this.borderStyle[side] = JRXlsExporter.getBorderStyle(pen);
            this.borderColour[side] = JRXlsExporter.this.getWorkbookColor(pen.getLineColor()).getIndex();
            this.hash = this.computeHash();
        }

        public BoxStyle(JRExporterGridCell gridCell) {
            if (gridCell != null) {
                JRPrintElement element;
                JRLineBox lineBox = gridCell.getBox();
                if (lineBox != null) {
                    this.setBox(lineBox);
                }
                if ((element = gridCell.getElement()) instanceof JRCommonGraphicElement) {
                    this.setPen(((JRCommonGraphicElement)element).getLinePen());
                }
                this.hash = this.computeHash();
            }
        }

        public void setBox(JRLineBox box) {
            this.borderStyle[0] = JRXlsExporter.getBorderStyle((JRPen)box.getTopPen());
            this.borderColour[0] = JRXlsExporter.this.getWorkbookColor(box.getTopPen().getLineColor()).getIndex();
            this.borderStyle[2] = JRXlsExporter.getBorderStyle((JRPen)box.getBottomPen());
            this.borderColour[2] = JRXlsExporter.this.getWorkbookColor(box.getBottomPen().getLineColor()).getIndex();
            this.borderStyle[1] = JRXlsExporter.getBorderStyle((JRPen)box.getLeftPen());
            this.borderColour[1] = JRXlsExporter.this.getWorkbookColor(box.getLeftPen().getLineColor()).getIndex();
            this.borderStyle[3] = JRXlsExporter.getBorderStyle((JRPen)box.getRightPen());
            this.borderColour[3] = JRXlsExporter.this.getWorkbookColor(box.getRightPen().getLineColor()).getIndex();
            this.hash = this.computeHash();
        }

        public void setPen(JRPen pen) {
            if (this.borderStyle[0] == BorderStyle.NONE && this.borderStyle[1] == BorderStyle.NONE && this.borderStyle[2] == BorderStyle.NONE && this.borderStyle[3] == BorderStyle.NONE) {
                BorderStyle style = JRXlsExporter.getBorderStyle(pen);
                short colour = JRXlsExporter.this.getWorkbookColor(pen.getLineColor()).getIndex();
                this.borderStyle[0] = style;
                this.borderStyle[2] = style;
                this.borderStyle[1] = style;
                this.borderStyle[3] = style;
                this.borderColour[0] = colour;
                this.borderColour[2] = colour;
                this.borderColour[1] = colour;
                this.borderColour[3] = colour;
            }
            this.hash = this.computeHash();
        }

        private int computeHash() {
            int hashCode = this.borderStyle[0] == null ? 0 : this.borderStyle[0].hashCode();
            hashCode = 31 * hashCode + this.borderColour[0];
            hashCode = 31 * hashCode + (this.borderStyle[2] == null ? 0 : this.borderStyle[2].hashCode());
            hashCode = 31 * hashCode + this.borderColour[2];
            hashCode = 31 * hashCode + (this.borderStyle[1] == null ? 0 : this.borderStyle[1].hashCode());
            hashCode = 31 * hashCode + this.borderColour[1];
            hashCode = 31 * hashCode + (this.borderStyle[3] == null ? 0 : this.borderStyle[3].hashCode());
            hashCode = 31 * hashCode + this.borderColour[3];
            return hashCode;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            BoxStyle b = (BoxStyle)o;
            return b.borderStyle[0] == this.borderStyle[0] && b.borderColour[0] == this.borderColour[0] && b.borderStyle[2] == this.borderStyle[2] && b.borderColour[2] == this.borderColour[2] && b.borderStyle[1] == this.borderStyle[1] && b.borderColour[1] == this.borderColour[1] && b.borderStyle[3] == this.borderStyle[3] && b.borderColour[3] == this.borderColour[3];
        }

        public String toString() {
            return "(" + this.borderStyle[0] + "/" + this.borderColour[0] + "," + this.borderStyle[2] + "/" + this.borderColour[2] + "," + this.borderStyle[1] + "/" + this.borderColour[1] + "," + this.borderStyle[3] + "/" + this.borderColour[3] + ")";
        }
    }

    protected class StyleInfo {
        protected final FillPatternType mode;
        protected final short backcolor;
        protected final HorizontalAlignment horizontalAlignment;
        protected final VerticalAlignment verticalAlignment;
        protected final short rotation;
        protected final HSSFFont font;
        protected final BoxStyle box;
        protected final boolean lcWrapText;
        protected final boolean lcCellLocked;
        protected final boolean lcCellHidden;
        protected final boolean lcShrinkToFit;
        private short lcDataFormat = (short)-1;
        private int hashCode;

        public StyleInfo(FillPatternType mode, short backcolor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, short rotation, HSSFFont font, JRExporterGridCell gridCell, boolean wrapText, boolean cellLocked, boolean cellHidden, boolean shrinkToFit) {
            this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, gridCell == null ? null : this$0.new BoxStyle(gridCell), wrapText, cellLocked, cellHidden, shrinkToFit);
        }

        public StyleInfo(FillPatternType mode, short backcolor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, short rotation, HSSFFont font, BoxStyle box, boolean wrapText, boolean cellLocked, boolean cellHidden, boolean shrinkToFit) {
            this.mode = mode;
            this.backcolor = backcolor;
            this.horizontalAlignment = horizontalAlignment;
            this.verticalAlignment = verticalAlignment;
            this.rotation = rotation;
            this.font = font;
            this.box = box;
            this.lcWrapText = shrinkToFit ? false : wrapText;
            this.lcCellLocked = cellLocked;
            this.lcCellHidden = cellHidden;
            this.lcShrinkToFit = shrinkToFit;
            this.hashCode = this.computeHash();
        }

        protected int computeHash() {
            int hash = this.mode.hashCode();
            hash = 31 * hash + this.backcolor;
            hash = 31 * hash + this.horizontalAlignment.hashCode();
            hash = 31 * hash + this.verticalAlignment.hashCode();
            hash = 31 * hash + this.rotation;
            hash = 31 * hash + (this.font == null ? 0 : this.font.getIndexAsInt());
            hash = 31 * hash + (this.box == null ? 0 : this.box.hashCode());
            hash = 31 * hash + this.lcDataFormat;
            hash = 31 * hash + (this.lcWrapText ? 0 : 1);
            hash = 31 * hash + (this.lcCellLocked ? 0 : 1);
            hash = 31 * hash + (this.lcCellHidden ? 0 : 1);
            hash = 31 * hash + (this.lcShrinkToFit ? 0 : 1);
            return hash;
        }

        public void setDataFormat(short dataFormat) {
            this.lcDataFormat = dataFormat;
            this.hashCode = this.computeHash();
        }

        public boolean hasDataFormat() {
            return this.lcDataFormat != -1;
        }

        public short getDataFormat() {
            return this.lcDataFormat;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            StyleInfo s = (StyleInfo)o;
            return s.mode == this.mode && s.backcolor == this.backcolor && s.horizontalAlignment == this.horizontalAlignment && s.verticalAlignment == this.verticalAlignment && s.rotation == this.rotation && (s.font == null ? this.font == null : this.font != null && s.font.getIndexAsInt() == this.font.getIndexAsInt()) && (s.box == null ? this.box == null : this.box != null && s.box.equals(this.box)) && s.rotation == this.rotation && s.lcWrapText == this.lcWrapText && s.lcCellLocked == this.lcCellLocked && s.lcCellHidden == this.lcCellHidden && s.lcShrinkToFit == this.lcShrinkToFit;
        }

        public String toString() {
            return "(" + this.mode + "," + this.backcolor + "," + this.horizontalAlignment + "," + this.verticalAlignment + "," + this.rotation + "," + this.font + "," + this.box + "," + this.lcDataFormat + "," + this.lcWrapText + "," + this.lcCellLocked + "," + this.lcCellHidden + "," + this.lcShrinkToFit + ")";
        }
    }

    private class InternalImageProcessor {
        private final JRPrintImage imageElement;
        private final RenderersCache imageRenderersCache;
        private final int availableImageWidth;
        private final int availableImageHeight;

        protected InternalImageProcessor(JRPrintImage imageElement, int availableImageWidth, int availableImageHeight) {
            this.imageElement = imageElement;
            this.imageRenderersCache = imageElement.isUsingCache() ? JRXlsExporter.this.renderersCache : new RenderersCache(JRXlsExporter.this.getJasperReportsContext());
            this.availableImageWidth = availableImageWidth;
            this.availableImageHeight = availableImageHeight;
        }

        private InternalImageProcessorResult process(Renderable renderer) throws JRException {
            InternalImageProcessorResult imageProcessorResult = null;
            if (renderer instanceof ResourceRenderer) {
                renderer = this.imageRenderersCache.getLoadedRenderer((ResourceRenderer)renderer);
            }
            switch (this.imageElement.getScaleImage()) {
                case CLIP: {
                    imageProcessorResult = this.processImageClip(this.imageRenderersCache.getGraphics2DRenderable(renderer));
                    break;
                }
                case FILL_FRAME: {
                    Dimension dimension = null;
                    dimension = this.imageElement.getRotation() == RotationEnum.LEFT || this.imageElement.getRotation() == RotationEnum.RIGHT ? new Dimension(this.availableImageHeight, this.availableImageWidth) : new Dimension(this.availableImageWidth, this.availableImageHeight);
                    imageProcessorResult = this.processImageFillFrame(JRXlsExporter.this.getRendererUtil().getImageDataRenderable(this.imageRenderersCache, renderer, dimension, ModeEnum.OPAQUE == this.imageElement.getMode() ? this.imageElement.getBackcolor() : null));
                    break;
                }
                default: {
                    Dimension dimension = null;
                    dimension = this.imageElement.getRotation() == RotationEnum.LEFT || this.imageElement.getRotation() == RotationEnum.RIGHT ? new Dimension(this.availableImageHeight, this.availableImageWidth) : new Dimension(this.availableImageWidth, this.availableImageHeight);
                    imageProcessorResult = this.processImageRetainShape(JRXlsExporter.this.getRendererUtil().getImageDataRenderable(this.imageRenderersCache, renderer, dimension, ModeEnum.OPAQUE == this.imageElement.getMode() ? this.imageElement.getBackcolor() : null));
                    break;
                }
            }
            return imageProcessorResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InternalImageProcessorResult processImageClip(Graphics2DRenderable renderer) throws JRException {
            Dimension2D dimension;
            int normalWidth = this.availableImageWidth;
            int normalHeight = this.availableImageHeight;
            DimensionRenderable dimensionRenderer = this.imageRenderersCache.getDimensionRenderable((Renderable)renderer);
            Dimension2D dimension2D = dimension = dimensionRenderer == null ? null : dimensionRenderer.getDimension(JRXlsExporter.this.jasperReportsContext);
            if (dimension != null) {
                normalWidth = (int)dimension.getWidth();
                normalHeight = (int)dimension.getHeight();
            }
            int minWidth = 0;
            int minHeight = 0;
            int topOffset = 0;
            int leftOffset = 0;
            int bottomOffset = 0;
            int rightOffset = 0;
            int translateX = 0;
            int translateY = 0;
            short angle = 0;
            switch (this.imageElement.getRotation()) {
                case LEFT: {
                    if (dimension == null) {
                        normalWidth = this.availableImageHeight;
                        normalHeight = this.availableImageWidth;
                    }
                    minWidth = Math.min(normalWidth, this.availableImageHeight);
                    minHeight = Math.min(normalHeight, this.availableImageWidth);
                    topOffset = (int)((1.0f - ImageUtil.getXAlignFactor((JRImageAlignment)this.imageElement)) * (float)(this.availableImageHeight - normalWidth));
                    leftOffset = (int)(ImageUtil.getYAlignFactor((JRImageAlignment)this.imageElement) * (float)(this.availableImageWidth - normalHeight));
                    bottomOffset = (int)(ImageUtil.getXAlignFactor((JRImageAlignment)this.imageElement) * (float)(this.availableImageHeight - normalWidth));
                    rightOffset = (int)((1.0f - ImageUtil.getYAlignFactor((JRImageAlignment)this.imageElement)) * (float)(this.availableImageWidth - normalHeight));
                    translateX = bottomOffset;
                    translateY = leftOffset;
                    angle = -90;
                    break;
                }
                case RIGHT: {
                    if (dimension == null) {
                        normalWidth = this.availableImageHeight;
                        normalHeight = this.availableImageWidth;
                    }
                    minWidth = Math.min(normalWidth, this.availableImageHeight);
                    minHeight = Math.min(normalHeight, this.availableImageWidth);
                    topOffset = (int)(ImageUtil.getXAlignFactor((JRImageAlignment)this.imageElement) * (float)(this.availableImageHeight - normalWidth));
                    leftOffset = (int)((1.0f - ImageUtil.getYAlignFactor((JRImageAlignment)this.imageElement)) * (float)(this.availableImageWidth - normalHeight));
                    bottomOffset = (int)((1.0f - ImageUtil.getXAlignFactor((JRImageAlignment)this.imageElement)) * (float)(this.availableImageHeight - normalWidth));
                    rightOffset = (int)(ImageUtil.getYAlignFactor((JRImageAlignment)this.imageElement) * (float)(this.availableImageWidth - normalHeight));
                    translateX = topOffset;
                    translateY = rightOffset;
                    angle = 90;
                    break;
                }
                case UPSIDE_DOWN: {
                    minWidth = Math.min(normalWidth, this.availableImageWidth);
                    minHeight = Math.min(normalHeight, this.availableImageHeight);
                    topOffset = (int)((1.0f - ImageUtil.getYAlignFactor((JRImageAlignment)this.imageElement)) * (float)(this.availableImageHeight - normalHeight));
                    leftOffset = (int)((1.0f - ImageUtil.getXAlignFactor((JRImageAlignment)this.imageElement)) * (float)(this.availableImageWidth - normalWidth));
                    bottomOffset = (int)(ImageUtil.getYAlignFactor((JRImageAlignment)this.imageElement) * (float)(this.availableImageHeight - normalHeight));
                    translateX = rightOffset = (int)(ImageUtil.getXAlignFactor((JRImageAlignment)this.imageElement) * (float)(this.availableImageWidth - normalWidth));
                    translateY = bottomOffset;
                    angle = 180;
                    break;
                }
                default: {
                    minWidth = Math.min(normalWidth, this.availableImageWidth);
                    minHeight = Math.min(normalHeight, this.availableImageHeight);
                    topOffset = (int)(ImageUtil.getYAlignFactor((JRImageAlignment)this.imageElement) * (float)(this.availableImageHeight - normalHeight));
                    leftOffset = (int)(ImageUtil.getXAlignFactor((JRImageAlignment)this.imageElement) * (float)(this.availableImageWidth - normalWidth));
                    bottomOffset = (int)((1.0f - ImageUtil.getYAlignFactor((JRImageAlignment)this.imageElement)) * (float)(this.availableImageHeight - normalHeight));
                    rightOffset = (int)((1.0f - ImageUtil.getXAlignFactor((JRImageAlignment)this.imageElement)) * (float)(this.availableImageWidth - normalWidth));
                    translateX = leftOffset;
                    translateY = topOffset;
                    angle = 0;
                }
            }
            int dpi = JRXlsExporter.this.getPropertiesUtil().getIntegerProperty("net.sf.jasperreports.image.dpi", 72);
            double scale = (double)dpi / 72.0;
            BufferedImage bi = new BufferedImage((int)(scale * (double)minWidth), (int)(scale * (double)minHeight), 2);
            Graphics2D grx = bi.createGraphics();
            try {
                grx.scale(scale, scale);
                grx.clip(new Rectangle(0, 0, minWidth, minHeight));
                renderer.render(JRXlsExporter.this.jasperReportsContext, grx, (Rectangle2D)new Rectangle(translateX > 0 ? 0 : translateX, translateY > 0 ? 0 : translateY, normalWidth, normalHeight));
            }
            finally {
                grx.dispose();
            }
            return new InternalImageProcessorResult(JRImageLoader.getInstance((JasperReportsContext)JRXlsExporter.this.jasperReportsContext).loadBytesFromAwtImage((Image)bi, ImageTypeEnum.PNG), topOffset < 0 ? 0 : topOffset, leftOffset < 0 ? 0 : leftOffset, bottomOffset < 0 ? 0 : bottomOffset, rightOffset < 0 ? 0 : rightOffset, angle);
        }

        private InternalImageProcessorResult processImageFillFrame(DataRenderable renderer) throws JRException {
            byte[] imageData = renderer.getData(JRXlsExporter.this.jasperReportsContext);
            ExifOrientationEnum exifOrientation = ImageUtil.getExifOrientation((byte[])imageData);
            short angle = 0;
            switch (ImageUtil.getRotation((RotationEnum)this.imageElement.getRotation(), (ExifOrientationEnum)exifOrientation)) {
                case LEFT: {
                    angle = -90;
                    break;
                }
                case RIGHT: {
                    angle = 90;
                    break;
                }
                case UPSIDE_DOWN: {
                    angle = 180;
                    break;
                }
                default: {
                    angle = 0;
                }
            }
            return new InternalImageProcessorResult(imageData, 0, 0, 0, 0, angle);
        }

        private InternalImageProcessorResult processImageRetainShape(DataRenderable renderer) throws JRException {
            Dimension2D dimension;
            float normalWidth = this.availableImageWidth;
            float normalHeight = this.availableImageHeight;
            DimensionRenderable dimensionRenderer = this.imageRenderersCache.getDimensionRenderable((Renderable)renderer);
            Dimension2D dimension2D = dimension = dimensionRenderer == null ? null : dimensionRenderer.getDimension(JRXlsExporter.this.jasperReportsContext);
            if (dimension != null) {
                normalWidth = (int)dimension.getWidth();
                normalHeight = (int)dimension.getHeight();
            }
            float ratioX = 1.0f;
            float ratioY = 1.0f;
            int imageWidth = 0;
            int imageHeight = 0;
            int topOffset = 0;
            int leftOffset = 0;
            int bottomOffset = 0;
            int rightOffset = 0;
            short angle = 0;
            byte[] imageData = renderer.getData(JRXlsExporter.this.jasperReportsContext);
            ExifOrientationEnum exifOrientation = ImageUtil.getExifOrientation((byte[])imageData);
            switch (ImageUtil.getRotation((RotationEnum)this.imageElement.getRotation(), (ExifOrientationEnum)exifOrientation)) {
                case LEFT: {
                    ratioX = (float)this.availableImageWidth / normalHeight;
                    ratioY = (float)this.availableImageHeight / normalWidth;
                    ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                    imageWidth = (int)(normalHeight * ratioX);
                    imageHeight = (int)(normalWidth * ratioY);
                    topOffset = (int)((1.0f - ImageUtil.getXAlignFactor((JRImageAlignment)this.imageElement)) * (float)(this.availableImageHeight - imageHeight));
                    leftOffset = (int)(ImageUtil.getYAlignFactor((JRImageAlignment)this.imageElement) * (float)(this.availableImageWidth - imageWidth));
                    bottomOffset = (int)(ImageUtil.getXAlignFactor((JRImageAlignment)this.imageElement) * (float)(this.availableImageHeight - imageHeight));
                    rightOffset = (int)((1.0f - ImageUtil.getYAlignFactor((JRImageAlignment)this.imageElement)) * (float)(this.availableImageWidth - imageWidth));
                    angle = -90;
                    break;
                }
                case RIGHT: {
                    ratioX = (float)this.availableImageWidth / normalHeight;
                    ratioY = (float)this.availableImageHeight / normalWidth;
                    ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                    imageWidth = (int)(normalHeight * ratioX);
                    imageHeight = (int)(normalWidth * ratioY);
                    topOffset = (int)(ImageUtil.getXAlignFactor((JRImageAlignment)this.imageElement) * (float)(this.availableImageHeight - imageHeight));
                    leftOffset = (int)((1.0f - ImageUtil.getYAlignFactor((JRImageAlignment)this.imageElement)) * (float)(this.availableImageWidth - imageWidth));
                    bottomOffset = (int)((1.0f - ImageUtil.getXAlignFactor((JRImageAlignment)this.imageElement)) * (float)(this.availableImageHeight - imageHeight));
                    rightOffset = (int)(ImageUtil.getYAlignFactor((JRImageAlignment)this.imageElement) * (float)(this.availableImageWidth - imageWidth));
                    angle = 90;
                    break;
                }
                case UPSIDE_DOWN: {
                    ratioX = (float)this.availableImageWidth / normalWidth;
                    ratioY = (float)this.availableImageHeight / normalHeight;
                    ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                    imageWidth = (int)(normalWidth * ratioX);
                    imageHeight = (int)(normalHeight * ratioY);
                    topOffset = (int)((1.0f - ImageUtil.getYAlignFactor((JRImageAlignment)this.imageElement)) * (float)(this.availableImageHeight - imageHeight));
                    leftOffset = (int)((1.0f - ImageUtil.getXAlignFactor((JRImageAlignment)this.imageElement)) * (float)(this.availableImageWidth - imageWidth));
                    bottomOffset = (int)(ImageUtil.getYAlignFactor((JRImageAlignment)this.imageElement) * (float)(this.availableImageHeight - imageHeight));
                    rightOffset = (int)(ImageUtil.getXAlignFactor((JRImageAlignment)this.imageElement) * (float)(this.availableImageWidth - imageWidth));
                    angle = 180;
                    break;
                }
                default: {
                    ratioX = (float)this.availableImageWidth / normalWidth;
                    ratioY = (float)this.availableImageHeight / normalHeight;
                    ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                    imageWidth = (int)(normalWidth * ratioX);
                    imageHeight = (int)(normalHeight * ratioY);
                    topOffset = (int)(ImageUtil.getYAlignFactor((JRImageAlignment)this.imageElement) * (float)(this.availableImageHeight - imageHeight));
                    leftOffset = (int)(ImageUtil.getXAlignFactor((JRImageAlignment)this.imageElement) * (float)(this.availableImageWidth - imageWidth));
                    bottomOffset = (int)((1.0f - ImageUtil.getYAlignFactor((JRImageAlignment)this.imageElement)) * (float)(this.availableImageHeight - imageHeight));
                    rightOffset = (int)((1.0f - ImageUtil.getXAlignFactor((JRImageAlignment)this.imageElement)) * (float)(this.availableImageWidth - imageWidth));
                    angle = 0;
                }
            }
            block5 : switch (this.imageElement.getRotation()) {
                case LEFT: {
                    switch (exifOrientation) {
                        case UPSIDE_DOWN: {
                            int t = leftOffset;
                            leftOffset = rightOffset;
                            rightOffset = t;
                            t = topOffset;
                            topOffset = bottomOffset;
                            bottomOffset = t;
                            break;
                        }
                        case RIGHT: {
                            int t;
                            if (this.imageElement.getHorizontalImageAlign() == HorizontalImageAlignEnum.LEFT && this.imageElement.getVerticalImageAlign() == VerticalImageAlignEnum.BOTTOM || this.imageElement.getHorizontalImageAlign() == HorizontalImageAlignEnum.RIGHT && this.imageElement.getVerticalImageAlign() == VerticalImageAlignEnum.TOP) {
                                t = leftOffset;
                                leftOffset = rightOffset;
                                rightOffset = t;
                            }
                            if ((this.imageElement.getHorizontalImageAlign() != HorizontalImageAlignEnum.LEFT || this.imageElement.getVerticalImageAlign() != VerticalImageAlignEnum.TOP) && (this.imageElement.getHorizontalImageAlign() != HorizontalImageAlignEnum.RIGHT || this.imageElement.getVerticalImageAlign() != VerticalImageAlignEnum.BOTTOM)) break block5;
                            t = topOffset;
                            topOffset = bottomOffset;
                            bottomOffset = t;
                            break;
                        }
                        case LEFT: {
                            int t;
                            if (this.imageElement.getHorizontalImageAlign() == HorizontalImageAlignEnum.LEFT && this.imageElement.getVerticalImageAlign() == VerticalImageAlignEnum.TOP || this.imageElement.getHorizontalImageAlign() == HorizontalImageAlignEnum.RIGHT && this.imageElement.getVerticalImageAlign() == VerticalImageAlignEnum.BOTTOM) {
                                t = leftOffset;
                                leftOffset = rightOffset;
                                rightOffset = t;
                            }
                            if ((this.imageElement.getHorizontalImageAlign() != HorizontalImageAlignEnum.LEFT || this.imageElement.getVerticalImageAlign() != VerticalImageAlignEnum.BOTTOM) && (this.imageElement.getHorizontalImageAlign() != HorizontalImageAlignEnum.RIGHT || this.imageElement.getVerticalImageAlign() != VerticalImageAlignEnum.TOP)) break block5;
                            t = topOffset;
                            topOffset = bottomOffset;
                            bottomOffset = t;
                            break;
                        }
                    }
                    break;
                }
                case RIGHT: {
                    switch (exifOrientation) {
                        case UPSIDE_DOWN: {
                            int t = leftOffset;
                            leftOffset = rightOffset;
                            rightOffset = t;
                            t = topOffset;
                            topOffset = bottomOffset;
                            bottomOffset = t;
                            break;
                        }
                        case RIGHT: {
                            int t;
                            if (this.imageElement.getHorizontalImageAlign() == HorizontalImageAlignEnum.LEFT && this.imageElement.getVerticalImageAlign() == VerticalImageAlignEnum.BOTTOM || this.imageElement.getHorizontalImageAlign() == HorizontalImageAlignEnum.RIGHT && this.imageElement.getVerticalImageAlign() == VerticalImageAlignEnum.TOP) {
                                t = leftOffset;
                                leftOffset = rightOffset;
                                rightOffset = t;
                            }
                            if ((this.imageElement.getHorizontalImageAlign() != HorizontalImageAlignEnum.LEFT || this.imageElement.getVerticalImageAlign() != VerticalImageAlignEnum.TOP) && (this.imageElement.getHorizontalImageAlign() != HorizontalImageAlignEnum.RIGHT || this.imageElement.getVerticalImageAlign() != VerticalImageAlignEnum.BOTTOM)) break block5;
                            t = topOffset;
                            topOffset = bottomOffset;
                            bottomOffset = t;
                            break;
                        }
                        case LEFT: {
                            int t;
                            if (this.imageElement.getHorizontalImageAlign() == HorizontalImageAlignEnum.LEFT && this.imageElement.getVerticalImageAlign() == VerticalImageAlignEnum.TOP || this.imageElement.getHorizontalImageAlign() == HorizontalImageAlignEnum.RIGHT && this.imageElement.getVerticalImageAlign() == VerticalImageAlignEnum.BOTTOM) {
                                t = leftOffset;
                                leftOffset = rightOffset;
                                rightOffset = t;
                            }
                            if ((this.imageElement.getHorizontalImageAlign() != HorizontalImageAlignEnum.LEFT || this.imageElement.getVerticalImageAlign() != VerticalImageAlignEnum.BOTTOM) && (this.imageElement.getHorizontalImageAlign() != HorizontalImageAlignEnum.RIGHT || this.imageElement.getVerticalImageAlign() != VerticalImageAlignEnum.TOP)) break block5;
                            t = topOffset;
                            topOffset = bottomOffset;
                            bottomOffset = t;
                            break;
                        }
                    }
                    break;
                }
                case UPSIDE_DOWN: {
                    switch (exifOrientation) {
                        case UPSIDE_DOWN: {
                            int t = leftOffset;
                            leftOffset = rightOffset;
                            rightOffset = t;
                            t = topOffset;
                            topOffset = bottomOffset;
                            bottomOffset = t;
                            break;
                        }
                        case RIGHT: {
                            int t;
                            if (this.imageElement.getHorizontalImageAlign() == HorizontalImageAlignEnum.LEFT && this.imageElement.getVerticalImageAlign() == VerticalImageAlignEnum.TOP || this.imageElement.getHorizontalImageAlign() == HorizontalImageAlignEnum.RIGHT && this.imageElement.getVerticalImageAlign() == VerticalImageAlignEnum.BOTTOM) {
                                t = leftOffset;
                                leftOffset = rightOffset;
                                rightOffset = t;
                            }
                            if ((this.imageElement.getHorizontalImageAlign() != HorizontalImageAlignEnum.LEFT || this.imageElement.getVerticalImageAlign() != VerticalImageAlignEnum.BOTTOM) && (this.imageElement.getHorizontalImageAlign() != HorizontalImageAlignEnum.RIGHT || this.imageElement.getVerticalImageAlign() != VerticalImageAlignEnum.TOP)) break block5;
                            t = topOffset;
                            topOffset = bottomOffset;
                            bottomOffset = t;
                            break;
                        }
                        case LEFT: {
                            int t;
                            if (this.imageElement.getHorizontalImageAlign() == HorizontalImageAlignEnum.LEFT && this.imageElement.getVerticalImageAlign() == VerticalImageAlignEnum.BOTTOM || this.imageElement.getHorizontalImageAlign() == HorizontalImageAlignEnum.RIGHT && this.imageElement.getVerticalImageAlign() == VerticalImageAlignEnum.TOP) {
                                t = leftOffset;
                                leftOffset = rightOffset;
                                rightOffset = t;
                            }
                            if ((this.imageElement.getHorizontalImageAlign() != HorizontalImageAlignEnum.LEFT || this.imageElement.getVerticalImageAlign() != VerticalImageAlignEnum.TOP) && (this.imageElement.getHorizontalImageAlign() != HorizontalImageAlignEnum.RIGHT || this.imageElement.getVerticalImageAlign() != VerticalImageAlignEnum.BOTTOM)) break block5;
                            t = topOffset;
                            topOffset = bottomOffset;
                            bottomOffset = t;
                            break;
                        }
                    }
                    break;
                }
                default: {
                    switch (exifOrientation) {
                        case UPSIDE_DOWN: {
                            int t = leftOffset;
                            leftOffset = rightOffset;
                            rightOffset = t;
                            t = topOffset;
                            topOffset = bottomOffset;
                            bottomOffset = t;
                            break block5;
                        }
                        case RIGHT: {
                            int t;
                            if (this.imageElement.getHorizontalImageAlign() == HorizontalImageAlignEnum.LEFT && this.imageElement.getVerticalImageAlign() == VerticalImageAlignEnum.TOP || this.imageElement.getHorizontalImageAlign() == HorizontalImageAlignEnum.RIGHT && this.imageElement.getVerticalImageAlign() == VerticalImageAlignEnum.BOTTOM) {
                                t = leftOffset;
                                leftOffset = rightOffset;
                                rightOffset = t;
                            }
                            if ((this.imageElement.getHorizontalImageAlign() != HorizontalImageAlignEnum.LEFT || this.imageElement.getVerticalImageAlign() != VerticalImageAlignEnum.BOTTOM) && (this.imageElement.getHorizontalImageAlign() != HorizontalImageAlignEnum.RIGHT || this.imageElement.getVerticalImageAlign() != VerticalImageAlignEnum.TOP)) break block5;
                            t = topOffset;
                            topOffset = bottomOffset;
                            bottomOffset = t;
                            break block5;
                        }
                        case LEFT: {
                            int t;
                            if (this.imageElement.getHorizontalImageAlign() == HorizontalImageAlignEnum.LEFT && this.imageElement.getVerticalImageAlign() == VerticalImageAlignEnum.TOP || this.imageElement.getHorizontalImageAlign() == HorizontalImageAlignEnum.RIGHT && this.imageElement.getVerticalImageAlign() == VerticalImageAlignEnum.BOTTOM) {
                                t = topOffset;
                                topOffset = bottomOffset;
                                bottomOffset = t;
                            }
                            if ((this.imageElement.getHorizontalImageAlign() != HorizontalImageAlignEnum.LEFT || this.imageElement.getVerticalImageAlign() != VerticalImageAlignEnum.BOTTOM) && (this.imageElement.getHorizontalImageAlign() != HorizontalImageAlignEnum.RIGHT || this.imageElement.getVerticalImageAlign() != VerticalImageAlignEnum.TOP)) break block5;
                            t = leftOffset;
                            leftOffset = rightOffset;
                            rightOffset = t;
                            break block5;
                        }
                    }
                }
            }
            return new InternalImageProcessorResult(imageData, topOffset, leftOffset, bottomOffset, rightOffset, angle);
        }
    }

    private class InternalImageProcessorResult {
        private final byte[] imageData;
        private final int topOffset;
        private final int leftOffset;
        private final int bottomOffset;
        private final int rightOffset;
        private final short angle;

        protected InternalImageProcessorResult(byte[] imageData, int topOffset, int leftOffset, int bottomOffset, int rightOffset, short angle) {
            this.imageData = imageData;
            this.topOffset = topOffset;
            this.leftOffset = leftOffset;
            this.bottomOffset = bottomOffset;
            this.rightOffset = rightOffset;
            this.angle = angle;
        }
    }
}

