/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map;

import java.awt.Color;
import java.util.HashMap;
import net.sf.jasperreports.components.map.MapUtils;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.export.GenericElementHtmlHandler;
import net.sf.jasperreports.engine.export.JRHtmlExporterContext;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.velocity.util.VelocityUtil;
import org.apache.velocity.VelocityContext;

public class MapElementHtmlHandler
implements GenericElementHtmlHandler {
    private static final MapElementHtmlHandler INSTANCE = new MapElementHtmlHandler();
    private static final String MAP_ELEMENT_HTML_TEMPLATE = "net/sf/jasperreports/components/map/resources/templates/MapElementHtmlTemplate.vm";
    private static final String FIRST_ATTEMPT_PARAM = "exporter_first_attempt";

    public static MapElementHtmlHandler getInstance() {
        return INSTANCE;
    }

    public String getHtmlFragment(JRHtmlExporterContext context, JRGenericPrintElement element) {
        ReportContext reportContext = context.getExporterRef().getReportContext();
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put("mapCanvasId", "map_canvas_" + element.hashCode());
        contextMap.put("elementWidth", element.getWidth());
        contextMap.put("elementHeight", element.getHeight());
        if (element.getMode() == ModeEnum.OPAQUE) {
            contextMap.put("backgroundColor", JRColorUtil.getColorHexa((Color)element.getBackcolor()));
        }
        contextMap.put("gotReportContext", reportContext != null);
        if (reportContext == null) {
            contextMap.put("jasperreportsMapApiScript", VelocityUtil.processTemplate((String)"net/sf/jasperreports/components/map/resources/scripts/jasperreportsMapApi.js", (VelocityContext)null));
            MapUtils.prepareContextForVelocityTemplate(contextMap, context.getJasperReportsContext(), element);
            if (context.getValue(FIRST_ATTEMPT_PARAM) == null) {
                context.setValue(FIRST_ATTEMPT_PARAM, (Object)true);
                contextMap.put("exporterFirstAttempt", true);
            }
        }
        return VelocityUtil.processTemplate((String)MAP_ELEMENT_HTML_TEMPLATE, contextMap);
    }

    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }
}

