/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map;

import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.map.MapComponent;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.jackson.util.JacksonUtil;

public class MapUtils {
    public static final String MAP_API_SCRIPT = "net/sf/jasperreports/components/map/resources/scripts/jasperreportsMapApi.js";

    public static void prepareContextForVelocityTemplate(Map<String, Object> velocityContext, JasperReportsContext jasperReportsContext, JRGenericPrintElement element) {
        String defaultMarkerIcon;
        JacksonUtil jacksonUtil = JacksonUtil.getInstance((JasperReportsContext)jasperReportsContext);
        Float latitude = (Float)element.getParameterValue("latitude");
        latitude = latitude == null ? MapComponent.DEFAULT_LATITUDE : latitude;
        Float longitude = (Float)element.getParameterValue("longitude");
        longitude = longitude == null ? MapComponent.DEFAULT_LONGITUDE : longitude;
        Integer zoom = (Integer)element.getParameterValue("zoom");
        zoom = zoom == null ? MapComponent.DEFAULT_ZOOM : zoom;
        String mapType = (String)element.getParameterValue("mapType");
        mapType = (mapType == null ? MapComponent.DEFAULT_MAP_TYPE.getName() : mapType).toUpperCase();
        Boolean markerClustering = (Boolean)element.getParameterValue("markerClustering");
        markerClustering = markerClustering != null ? markerClustering : false;
        Boolean markerSpidering = (Boolean)element.getParameterValue("markerSpidering");
        markerSpidering = markerSpidering != null ? markerSpidering : false;
        velocityContext.put("latitude", latitude);
        velocityContext.put("longitude", longitude);
        velocityContext.put("zoom", zoom);
        velocityContext.put("mapType", mapType);
        velocityContext.put("useMarkerClustering", markerClustering);
        velocityContext.put("useMarkerSpidering", markerSpidering);
        Map legendPropertiesParam = (Map)element.getParameterValue("legendProperties");
        String legendProperties = legendPropertiesParam == null ? "{}" : jacksonUtil.getIndentedJsonString((Object)legendPropertiesParam);
        velocityContext.put("legendProperties", legendProperties);
        Map resetMapPropertiesParam = (Map)element.getParameterValue("resetMapProperties");
        String resetMapProperties = resetMapPropertiesParam == null ? "{}" : jacksonUtil.getIndentedJsonString((Object)resetMapPropertiesParam);
        velocityContext.put("resetMapProperties", resetMapProperties);
        Map markerSeries = (Map)element.getParameterValue("markers");
        String markers = markerSeries == null || markerSeries.isEmpty() ? "{}" : jacksonUtil.getIndentedJsonString((Object)markerSeries);
        velocityContext.put("markerList", markers);
        List pathList = (List)element.getParameterValue("paths");
        String paths = pathList == null || pathList.isEmpty() ? "[]" : jacksonUtil.getIndentedJsonString((Object)pathList);
        velocityContext.put("pathsList", paths);
        String reqParams = (String)element.getParameterValue("reqParams");
        if (reqParams != null) {
            velocityContext.put("reqParams", reqParams);
        }
        velocityContext.put("defaultMarkerIcon", (defaultMarkerIcon = (String)element.getParameterValue("defaultMarkerIcon")) != null ? defaultMarkerIcon : "");
    }
}

