/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map;

import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.items.StandardItem;
import net.sf.jasperreports.components.items.StandardItemData;
import net.sf.jasperreports.components.map.MapComponent;
import net.sf.jasperreports.components.map.MarkerItemData;
import net.sf.jasperreports.components.map.StandardMarkerItemData;
import net.sf.jasperreports.components.map.type.MapImageTypeEnum;
import net.sf.jasperreports.components.map.type.MapScaleEnum;
import net.sf.jasperreports.components.map.type.MapTypeEnum;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class StandardMapComponent
implements MapComponent,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_LATITUDE_EXPRESSION = "latitudeExpression";
    public static final String PROPERTY_LONGITUDE_EXPRESSION = "longitudeExpression";
    public static final String PROPERTY_ADDRESS_EXPRESSION = "addressExpression";
    public static final String PROPERTY_ZOOM_EXPRESSION = "zoomExpression";
    public static final String PROPERTY_LANGUAGE_EXPRESSION = "languageExpression";
    public static final String PROPERTY_EVALUATION_TIME = "evaluationTime";
    public static final String PROPERTY_EVALUATION_GROUP = "evaluationGroup";
    public static final String PROPERTY_MAP_TYPE = "mapType";
    public static final String PROPERTY_MAP_SCALE = "mapScale";
    public static final String PROPERTY_IMAGE_TYPE = "imageType";
    public static final String PROPERTY_ON_ERROR_TYPE = "onErrorType";
    public static final String PROPERTY_MARKER_CLUSTERING = "markerClustering";
    public static final String PROPERTY_MARKER_SPIDERING = "markerSpidering";
    public static final String PROPERTY_MARKER_DATA_LIST = "markerDataList";
    public static final String PROPERTY_PATH_STYLE_LIST = "pathStyleList";
    public static final String PROPERTY_PATH_DATA_LIST = "pathDataList";
    public static final String PROPERTY_LEGEND = "legend";
    public static final String PROPERTY_RESET_MAP = "resetMap";
    private JRExpression latitudeExpression;
    private JRExpression longitudeExpression;
    private JRExpression addressExpression;
    private JRExpression zoomExpression;
    private JRExpression languageExpression;
    private EvaluationTimeEnum evaluationTime;
    private String evaluationGroup;
    private MapTypeEnum mapType;
    private MapScaleEnum mapScale;
    private MapImageTypeEnum imageType;
    private OnErrorTypeEnum onErrorType;
    private Boolean markerClustering;
    private Boolean markerSpidering;
    private List<MarkerItemData> markerItemDataList = new ArrayList<MarkerItemData>();
    private List<ItemData> pathStyleList = new ArrayList<ItemData>();
    private List<ItemData> pathDataList = new ArrayList<ItemData>();
    private Item legend;
    private Item resetMap;
    private transient JRPropertyChangeSupport eventSupport;

    public StandardMapComponent() {
    }

    public StandardMapComponent(MapComponent map, JRBaseObjectFactory objectFactory) {
        List<ItemData> list;
        List<MarkerItemData> markerList;
        Item resetMapItem;
        this.latitudeExpression = objectFactory.getExpression(map.getLatitudeExpression());
        this.longitudeExpression = objectFactory.getExpression(map.getLongitudeExpression());
        this.addressExpression = objectFactory.getExpression(map.getAddressExpression());
        this.zoomExpression = objectFactory.getExpression(map.getZoomExpression());
        this.languageExpression = objectFactory.getExpression(map.getLanguageExpression());
        this.evaluationTime = map.getEvaluationTime();
        this.evaluationGroup = map.getEvaluationGroup();
        this.mapType = map.getMapType();
        this.mapScale = map.getMapScale();
        this.imageType = map.getImageType();
        this.markerClustering = map.getMarkerClustering();
        this.markerSpidering = map.getMarkerSpidering();
        Item legendItem = map.getLegendItem();
        if (legendItem != null) {
            this.legend = new StandardItem(StandardItemData.getCompiledProperties((List)legendItem.getProperties(), (JRBaseObjectFactory)objectFactory));
        }
        if ((resetMapItem = map.getResetMapItem()) != null) {
            this.resetMap = new StandardItem(StandardItemData.getCompiledProperties((List)resetMapItem.getProperties(), (JRBaseObjectFactory)objectFactory));
        }
        if ((markerList = map.getMarkerItemDataList()) != null && markerList.size() > 0) {
            this.markerItemDataList = new ArrayList<MarkerItemData>();
            for (MarkerItemData markerItemData : markerList) {
                this.markerItemDataList.add(new StandardMarkerItemData(markerItemData, objectFactory));
            }
        }
        this.onErrorType = map.getOnErrorType();
        List<ItemData> styleList = map.getPathStyleList();
        if (styleList != null && styleList.size() > 0) {
            this.pathStyleList = new ArrayList<ItemData>();
            for (ItemData pathStyle : styleList) {
                this.pathStyleList.add((ItemData)new StandardItemData(pathStyle, objectFactory));
            }
        }
        if ((list = map.getPathDataList()) != null && list.size() > 0) {
            this.pathDataList = new ArrayList<ItemData>();
            for (ItemData pathData : list) {
                this.pathDataList.add((ItemData)new StandardItemData(pathData, objectFactory));
            }
        }
    }

    @Override
    public JRExpression getLatitudeExpression() {
        return this.latitudeExpression;
    }

    public void setLatitudeExpression(JRExpression latitudeExpression) {
        JRExpression old = this.latitudeExpression;
        this.latitudeExpression = latitudeExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_LATITUDE_EXPRESSION, (Object)old, (Object)this.latitudeExpression);
    }

    @Override
    public JRExpression getLongitudeExpression() {
        return this.longitudeExpression;
    }

    public void setLongitudeExpression(JRExpression longitudeExpression) {
        JRExpression old = this.longitudeExpression;
        this.longitudeExpression = longitudeExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_LONGITUDE_EXPRESSION, (Object)old, (Object)this.longitudeExpression);
    }

    @Override
    public JRExpression getAddressExpression() {
        return this.addressExpression;
    }

    public void setAddressExpression(JRExpression addressExpression) {
        JRExpression old = this.addressExpression;
        this.addressExpression = addressExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_ADDRESS_EXPRESSION, (Object)old, (Object)this.addressExpression);
    }

    @Override
    public JRExpression getZoomExpression() {
        return this.zoomExpression;
    }

    public void setZoomExpression(JRExpression zoomExpression) {
        JRExpression old = this.zoomExpression;
        this.zoomExpression = zoomExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_ZOOM_EXPRESSION, (Object)old, (Object)this.zoomExpression);
    }

    @Override
    public JRExpression getLanguageExpression() {
        return this.languageExpression;
    }

    public void setLanguageExpression(JRExpression languageExpression) {
        JRExpression old = this.languageExpression;
        this.languageExpression = languageExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_LANGUAGE_EXPRESSION, (Object)old, (Object)this.languageExpression);
    }

    public EvaluationTimeEnum getEvaluationTime() {
        return this.evaluationTime;
    }

    public void setEvaluationTime(EvaluationTimeEnum evaluationTime) {
        EvaluationTimeEnum old = this.evaluationTime;
        this.evaluationTime = evaluationTime;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_TIME, (Object)old, (Object)this.evaluationTime);
    }

    public String getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public void setEvaluationGroup(String evaluationGroup) {
        String old = this.evaluationGroup;
        this.evaluationGroup = evaluationGroup;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_GROUP, (Object)old, (Object)this.evaluationGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        StandardMapComponent standardMapComponent = this;
        synchronized (standardMapComponent) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport((Object)this);
            }
        }
        return this.eventSupport;
    }

    public Object clone() {
        StandardMapComponent clone = null;
        try {
            clone = (StandardMapComponent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        clone.latitudeExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.latitudeExpression);
        clone.longitudeExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.longitudeExpression);
        clone.addressExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.addressExpression);
        clone.zoomExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.zoomExpression);
        clone.languageExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.languageExpression);
        clone.markerItemDataList = JRCloneUtils.cloneList(this.markerItemDataList);
        clone.pathStyleList = JRCloneUtils.cloneList(this.pathStyleList);
        clone.pathDataList = JRCloneUtils.cloneList(this.pathDataList);
        clone.eventSupport = null;
        return clone;
    }

    @Override
    public MapTypeEnum getMapType() {
        return this.mapType;
    }

    public void setMapType(MapTypeEnum mapType) {
        MapTypeEnum old = this.mapType;
        this.mapType = mapType;
        this.getEventSupport().firePropertyChange(PROPERTY_MAP_TYPE, (Object)old, (Object)this.mapType);
    }

    @Override
    public MapScaleEnum getMapScale() {
        return this.mapScale;
    }

    public void setMapScale(MapScaleEnum mapScale) {
        MapScaleEnum old = this.mapScale;
        this.mapScale = mapScale;
        this.getEventSupport().firePropertyChange(PROPERTY_MAP_SCALE, (Object)old, (Object)this.mapScale);
    }

    @Override
    public MapImageTypeEnum getImageType() {
        return this.imageType;
    }

    public void setImageType(MapImageTypeEnum imageType) {
        MapImageTypeEnum old = this.imageType;
        this.imageType = imageType;
        this.getEventSupport().firePropertyChange(PROPERTY_IMAGE_TYPE, (Object)old, (Object)this.imageType);
    }

    @Override
    public OnErrorTypeEnum getOnErrorType() {
        return this.onErrorType;
    }

    public void setOnErrorType(OnErrorTypeEnum onErrorType) {
        OnErrorTypeEnum old = this.onErrorType;
        this.onErrorType = onErrorType;
        this.getEventSupport().firePropertyChange(PROPERTY_ON_ERROR_TYPE, (Object)old, (Object)this.onErrorType);
    }

    @Override
    public Boolean getMarkerClustering() {
        return this.markerClustering;
    }

    public void setMarkerClustering(Boolean markerClustering) {
        Boolean old = this.markerClustering;
        this.markerClustering = markerClustering;
        this.getEventSupport().firePropertyChange(PROPERTY_MARKER_CLUSTERING, (Object)old, (Object)this.markerClustering);
    }

    @Override
    public Boolean getMarkerSpidering() {
        return this.markerSpidering;
    }

    public void setMarkerSpidering(Boolean markerSpidering) {
        Boolean old = this.markerSpidering;
        this.markerSpidering = markerSpidering;
        this.getEventSupport().firePropertyChange(PROPERTY_MARKER_SPIDERING, (Object)old, (Object)this.markerSpidering);
    }

    @Override
    public List<ItemData> getPathStyleList() {
        return this.pathStyleList;
    }

    @JsonSetter
    private void setPathStyleList(List<ItemData> pathStyleList) {
        if (pathStyleList != null) {
            for (ItemData pathStyle : pathStyleList) {
                this.addPathStyle(pathStyle);
            }
        }
    }

    public void addPathStyle(ItemData pathStyle) {
        this.pathStyleList.add(pathStyle);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PATH_STYLE_LIST, (Object)pathStyle, this.pathStyleList.size() - 1);
    }

    public void addPathStyle(int index, ItemData pathStyle) {
        if (index >= 0 && index < this.pathStyleList.size()) {
            this.pathStyleList.add(index, pathStyle);
        } else {
            this.pathStyleList.add(pathStyle);
            index = this.pathStyleList.size() - 1;
        }
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PATH_STYLE_LIST, this.pathStyleList, index);
    }

    public ItemData removePathStyle(ItemData pathStyle) {
        int idx;
        if (pathStyle != null && (idx = this.pathStyleList.indexOf(pathStyle)) >= 0) {
            this.pathStyleList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PATH_STYLE_LIST, (Object)pathStyle, idx);
        }
        return pathStyle;
    }

    @Override
    public List<ItemData> getMarkerDataList() {
        ArrayList<ItemData> markerDataList = new ArrayList<ItemData>();
        for (MarkerItemData markerItemData : this.markerItemDataList) {
            markerDataList.add(markerItemData);
        }
        return markerDataList;
    }

    @Override
    public List<MarkerItemData> getMarkerItemDataList() {
        return this.markerItemDataList;
    }

    @JsonSetter
    private void setMarkerItemDataList(List<MarkerItemData> markerItemDataList) {
        if (markerItemDataList != null) {
            for (MarkerItemData markerItemData : markerItemDataList) {
                this.addMarkerItemData(markerItemData);
            }
        }
    }

    public void addMarkerData(ItemData markerData) {
        this.addMarkerItemData((MarkerItemData)markerData);
    }

    public void addMarkerItemData(MarkerItemData markerItemData) {
        this.markerItemDataList.add(markerItemData);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_MARKER_DATA_LIST, (Object)markerItemData, this.markerItemDataList.size() - 1);
    }

    public void addMarkerData(int index, ItemData markerData) {
        this.addMarkerItemData(index, (MarkerItemData)markerData);
    }

    public void addMarkerItemData(int index, MarkerItemData markerData) {
        if (index >= 0 && index < this.markerItemDataList.size()) {
            this.markerItemDataList.add(index, markerData);
        } else {
            this.markerItemDataList.add(markerData);
            index = this.markerItemDataList.size() - 1;
        }
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_MARKER_DATA_LIST, this.markerItemDataList, index);
    }

    public ItemData removeMarkerData(ItemData markerData) {
        int idx;
        if (markerData != null && (idx = this.markerItemDataList.indexOf(markerData)) >= 0) {
            this.markerItemDataList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_MARKER_DATA_LIST, (Object)markerData, idx);
        }
        return markerData;
    }

    public MarkerItemData removeMarkerItemData(MarkerItemData markerItemData) {
        int idx;
        if (markerItemData != null && (idx = this.markerItemDataList.indexOf(markerItemData)) >= 0) {
            this.markerItemDataList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_MARKER_DATA_LIST, (Object)markerItemData, idx);
        }
        return markerItemData;
    }

    @Override
    public Item getLegendItem() {
        return this.legend;
    }

    @JsonSetter(value="legendItem")
    public void setLegend(Item legend) {
        Item old = this.legend;
        this.legend = legend;
        this.getEventSupport().firePropertyChange(PROPERTY_LEGEND, (Object)old, (Object)this.legend);
    }

    @Override
    public Item getResetMapItem() {
        return this.resetMap;
    }

    @JsonSetter(value="resetMapItem")
    public void setResetMap(Item resetMap) {
        Item old = this.resetMap;
        this.resetMap = resetMap;
        this.getEventSupport().firePropertyChange(PROPERTY_RESET_MAP, (Object)old, (Object)this.resetMap);
    }

    @Override
    public List<ItemData> getPathDataList() {
        return this.pathDataList;
    }

    @JsonSetter
    private void setPathDataList(List<ItemData> pathDataList) {
        if (pathDataList != null) {
            for (ItemData pathData : pathDataList) {
                this.addPathData(pathData);
            }
        }
    }

    public void addPathData(ItemData pathData) {
        this.pathDataList.add(pathData);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PATH_DATA_LIST, (Object)pathData, this.pathDataList.size() - 1);
    }

    public void addPathData(int index, ItemData pathData) {
        if (index >= 0 && index < this.pathDataList.size()) {
            this.pathDataList.add(index, pathData);
        } else {
            this.pathDataList.add(pathData);
            index = this.pathDataList.size() - 1;
        }
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PATH_DATA_LIST, this.pathDataList, index);
    }

    public ItemData removePathData(ItemData pathData) {
        int idx;
        if (pathData != null && (idx = this.pathDataList.indexOf(pathData)) >= 0) {
            this.pathDataList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PATH_DATA_LIST, (Object)pathData, idx);
        }
        return pathData;
    }
}

