/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map.fill;

import java.util.Map;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.map.fill.CustomMapControlOrientationEnum;
import net.sf.jasperreports.components.map.fill.FillResetMapItem;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.component.FillContextProvider;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;

public class FillLegendItem
extends FillResetMapItem {
    public static final String[] LEGEND_AVAILABLE_ITEM_PROPERTIES = new String[]{"orientation", "legendMaxWidth", "legendMaxWidth.fullscreen", "legendMaxHeight", "legendMaxHeight.fullscreen", "useMarkerIcons"};

    public FillLegendItem(FillContextProvider fillContextProvider, Item item, JRFillObjectFactory factory) {
        super(fillContextProvider, item, factory);
    }

    @Override
    public void verifyValues(Map<String, Object> result) throws JRException {
        super.verifyValues(result);
        for (String propertyName : LEGEND_AVAILABLE_ITEM_PROPERTIES) {
            if (!result.containsKey(propertyName)) continue;
            Object propertyValue = result.get(propertyName);
            if (propertyValue == null) {
                throw new JRException("components.map.null.or.empty.value.not.allowed", new Object[]{propertyName});
            }
            if (propertyName.toLowerCase().indexOf("width") == -1 && propertyName.toLowerCase().indexOf("height") == -1) continue;
            if (!(propertyValue instanceof String)) {
                throw new JRException("components.map.legend.invalid.value", new Object[]{propertyValue, propertyName, "java.lang.String"});
            }
            if (((String)propertyValue).endsWith("px")) continue;
            throw new JRException("components.map.legend.invalid.size.value", new Object[]{propertyValue, propertyName});
        }
        Object orientation = result.get("orientation");
        if (orientation != null && CustomMapControlOrientationEnum.getByName((String)orientation) == null) {
            throw new JRException("components.map.custom.control.orientation.invalid.value", new Object[]{orientation, CustomMapControlOrientationEnum.getAllNames()});
        }
    }
}

