/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.groovy;

import groovy.lang.Closure;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovy.lang.MissingMethodException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JasperReportsContextAware;
import net.sf.jasperreports.functions.FunctionSupport;
import net.sf.jasperreports.functions.FunctionsUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.MethodClosure;
import org.codehaus.groovy.runtime.metaclass.ClosureMetaMethod;

public abstract class GroovyEvaluator
extends JREvaluator
implements JasperReportsContextAware {
    private static final Log log = LogFactory.getLog(GroovyEvaluator.class);
    public static final String EXCEPTION_MESSAGE_KEY_FUNCTION_NOT_FOUND = "compilers.groovy.function.not.found";
    private static final Pattern GROOVY_EXCEPTION_PATTERN_AMBIGUOUS_NULL = Pattern.compile("Ambiguous method overloading for method.*Cannot resolve which method to invoke for \\[null\\] due to overlapping prototypes between.*", 32);
    private FunctionsUtil functionsUtil;
    private List<ClosureMetaMethod> functionMethods = new ArrayList<ClosureMetaMethod>();

    public void setJasperReportsContext(JasperReportsContext context) {
        this.functionsUtil = FunctionsUtil.getInstance((JasperReportsContext)context);
    }

    protected Object handleEvaluationException(JRExpression expression, Throwable e) throws JRExpressionEvalException {
        Matcher matcher;
        if (this.ignoreNPE && e instanceof GroovyRuntimeException && e.getMessage() != null && (matcher = GROOVY_EXCEPTION_PATTERN_AMBIGUOUS_NULL.matcher(e.getMessage())).matches()) {
            return null;
        }
        return super.handleEvaluationException(expression, e);
    }

    protected Object functionCall(String methodName, Object[] args) {
        MetaMethod metaMethod;
        Method functionMethod = this.functionsUtil.getMethod4Function(methodName);
        if (functionMethod == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_FUNCTION_NOT_FOUND, new Object[]{methodName});
        }
        assert (functionMethod.getName().equals(methodName));
        Class<?> functionClass = functionMethod.getDeclaringClass();
        MetaClass functionMetaClass = DefaultGroovyMethods.getMetaClass(functionClass);
        MethodClosure functionMethodClosure = null;
        if (FunctionSupport.class.isAssignableFrom(functionClass) && (metaMethod = functionMetaClass.getMetaMethod(methodName, args)) != null && metaMethod.isPublic()) {
            FunctionSupport functionObject = this.getFunctionSupport(functionClass);
            functionMethodClosure = new MethodClosure((Object)functionObject, methodName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("found public instance method " + metaMethod + " in class " + functionClass));
            }
        }
        if (functionMethodClosure == null && (metaMethod = functionMetaClass.getStaticMetaMethod(methodName, args)) != null && metaMethod.isPublic()) {
            functionMethodClosure = new MethodClosure(functionClass, methodName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("found public static method " + metaMethod + " in class " + functionClass));
            }
        }
        if (functionMethodClosure == null) {
            throw new MissingMethodException(methodName, functionMetaClass.getTheClass(), args);
        }
        this.addFunctionClosureMethods(functionMethodClosure, methodName);
        ExpandoMetaClass extendedMetaClass = new ExpandoMetaClass(((Object)((Object)this)).getClass(), false);
        this.registerMethods(extendedMetaClass);
        extendedMetaClass.initialize();
        DefaultGroovyMethods.setMetaClass((GroovyObject)((GroovyObject)this), (MetaClass)extendedMetaClass);
        return functionMethodClosure.call(args);
    }

    protected void addFunctionClosureMethods(MethodClosure methodClosure, String functionName) {
        List closureMethods = ClosureMetaMethod.createMethodList((String)functionName, ((Object)((Object)this)).getClass(), (Closure)methodClosure);
        for (MetaMethod metaMethod : closureMethods) {
            if (!(metaMethod instanceof ClosureMetaMethod)) {
                log.warn((Object)("Got unexpected closure method " + metaMethod + " of type " + metaMethod.getClass().getName()));
                continue;
            }
            ClosureMetaMethod closureMethod = (ClosureMetaMethod)metaMethod;
            if (!closureMethod.getDoCall().isPublic()) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("method " + closureMethod.getDoCall() + " is not public, not registering"));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("creating closure method for " + closureMethod.getDoCall()));
            }
            this.functionMethods.add(closureMethod);
        }
    }

    protected void registerMethods(ExpandoMetaClass extendedMetaClass) {
        for (ClosureMetaMethod closureMethod : this.functionMethods) {
            extendedMetaClass.registerInstanceMethod((MetaMethod)closureMethod);
        }
    }
}

