/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.groovy;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.jasperreports.compilers.DirectExpressionValueFilter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.CompiledClasses;
import net.sf.jasperreports.engine.design.JRAbstractJavaCompiler;
import net.sf.jasperreports.engine.design.JRCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRDefaultCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.groovy.GroovyClassFilterTransformer;
import net.sf.jasperreports.groovy.GroovyDirectExpressionValueFilter;
import net.sf.jasperreports.groovy.GroovySandboxEvaluator;
import net.sf.jasperreports.groovy.JRGroovyGenerator;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.tools.GroovyClass;

public class JRGroovyCompiler
extends JRAbstractJavaCompiler {
    public static final String EXCEPTION_MESSAGE_KEY_COMPILING_EXPRESSIONS_CLASS_FILE = "compilers.compiling.expressions.class.file";
    public static final String EXCEPTION_MESSAGE_KEY_TOO_FEW_CLASSES_GENERATED = "compilers.groovy.too.few.classes.generated";
    public static final String EXCEPTION_MESSAGE_KEY_TOO_MANY_CLASSES_GENERATED = "compilers.groovy.too.many.classes.generated";
    public static final String EXCEPTION_MESSAGE_KEY_REPORT_NOT_COMPILED_FOR_CLASS_FILTERING = "compilers.groovy.report.not.compiled.for.class.filtering";

    public JRGroovyCompiler(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext, false);
    }

    protected DirectExpressionValueFilter directValueFilter() {
        return GroovyDirectExpressionValueFilter.instance();
    }

    protected String compileUnits(JRCompilationUnit[] units, String classpath, File tempDirFile) throws JRException {
        CompilerConfiguration config = new CompilerConfiguration();
        config.setSourceEncoding(StandardCharsets.UTF_8.name());
        if (this.reportClassFilter.isFilteringEnabled()) {
            config.addCompilationCustomizers(new CompilationCustomizer[]{new GroovyClassFilterTransformer()});
        }
        CompilationUnit unit = new CompilationUnit(config);
        for (int i = 0; i < units.length; ++i) {
            byte[] sourceBytes = units[i].getSourceCode().getBytes(StandardCharsets.UTF_8);
            unit.addSource("calculator_" + units[i].getCompileName(), (InputStream)new ByteArrayInputStream(sourceBytes));
        }
        try {
            unit.compile(7);
        }
        catch (CompilationFailedException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_COMPILING_EXPRESSIONS_CLASS_FILE, new Object[]{e.toString()}, (Throwable)e);
        }
        List generatedClasses = unit.getClasses();
        if (generatedClasses.size() < units.length) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_TOO_FEW_CLASSES_GENERATED, (Object[])null);
        }
        Map<String, byte[]> classBytes = generatedClasses.stream().collect(Collectors.toMap(GroovyClass::getName, GroovyClass::getBytes));
        CompiledClasses compiledClasses = new CompiledClasses(classBytes);
        for (int i = 0; i < units.length; ++i) {
            units[i].setCompileData((Serializable)compiledClasses);
        }
        return null;
    }

    protected void checkLanguage(String language) throws JRException {
        if (!"groovy".equals(language) && !"java".equals(language)) {
            throw new JRException("compilers.language.not.supported", new Object[]{language, "groovy", "java"});
        }
    }

    protected JRCompilationSourceCode generateSourceCode(JRSourceCompileTask sourceTask) throws JRException {
        return new JRDefaultCompilationSourceCode(JRGroovyGenerator.generateClass(sourceTask, this.reportClassFilter), null);
    }

    protected String getSourceFileName(String unitName) {
        return unitName + ".groovy";
    }

    protected Class<?> loadClass(String className, byte[] compileData) {
        return JRClassLoader.loadClassFromBytes((String)className, (byte[])compileData);
    }

    protected Class<?> loadClass(String className, CompiledClasses classes) {
        return JRClassLoader.loadClassFromBytes(null, (String)className, (CompiledClasses)classes);
    }

    protected JREvaluator loadEvaluator(Serializable compileData, String className) throws JRException {
        JREvaluator evaluator = super.loadEvaluator(compileData, className);
        if (this.reportClassFilter.isFilteringEnabled()) {
            if (!(evaluator instanceof GroovySandboxEvaluator)) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_REPORT_NOT_COMPILED_FOR_CLASS_FILTERING);
            }
            ((GroovySandboxEvaluator)evaluator).setReportClassFilter(this.reportClassFilter);
        }
        return evaluator;
    }
}

