/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.hibernate;

import jakarta.persistence.Tuple;
import jakarta.persistence.TupleElement;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.data.JRAbstractBeanDataSource;
import net.sf.jasperreports.hibernate.JRHibernateQueryExecuter;

public abstract class JRHibernateAbstractDataSource
implements JRDataSource {
    public static final String EXCEPTION_MESSAGE_KEY_FIELD_ALIAS_TYPE_MISMATCH = "data.hibernate.field.alias.type.mismatch";
    public static final String EXCEPTION_MESSAGE_KEY_MANY_FIELDS_DETECTED = "data.hibernate.many.fields.detected";
    public static final String EXCEPTION_MESSAGE_KEY_NO_FIELD_ALIAS = "data.hibernate.no.field.alias";
    public static final String EXCEPTION_MESSAGE_KEY_NO_FIELD_READER = "data.hibernate.no.field.reader";
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_RETURN_ALIAS = "data.hibernate.unknown.return.alias";
    private final JRAbstractBeanDataSource.PropertyNameProvider propertyNameProvider;
    private Map<String, FieldReader> fieldReaders;
    protected final JRHibernateQueryExecuter queryExecuter;
    private Tuple currentReturnValue;

    protected JRHibernateAbstractDataSource(JRHibernateQueryExecuter queryExecuter, boolean useFieldDescription) {
        this.propertyNameProvider = new JRAbstractBeanDataSource.DefaultPropertyNameProvider(useFieldDescription);
        this.queryExecuter = queryExecuter;
    }

    protected Map<String, FieldReader> assignReaders(Tuple result) {
        HashMap<String, FieldReader> readers;
        block6: {
            HashMap<String, Integer> aliasesMap;
            List elements;
            JRField[] fields;
            block4: {
                block5: {
                    readers = new HashMap<String, FieldReader>();
                    fields = this.queryExecuter.getDataset().getFields();
                    elements = result.getElements();
                    aliasesMap = new HashMap<String, Integer>();
                    ListIterator iterator = elements.listIterator();
                    while (iterator.hasNext()) {
                        TupleElement tupleElement = (TupleElement)iterator.next();
                        aliasesMap.put(tupleElement.getAlias(), iterator.previousIndex());
                    }
                    if (elements.size() != 1) break block4;
                    TupleElement element = (TupleElement)elements.get(0);
                    boolean managedType = this.isManagedType(element);
                    if (!managedType) break block5;
                    for (int i = 0; i < fields.length; ++i) {
                        JRField field = fields[i];
                        readers.put(field.getName(), this.getFieldReaderSingleReturn(aliasesMap, field));
                    }
                    break block6;
                }
                if (fields.length > 1) {
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_MANY_FIELDS_DETECTED, (Object[])null);
                }
                if (fields.length != 1) break block6;
                JRField field = fields[0];
                readers.put(field.getName(), new IndexFieldReader(0));
                break block6;
            }
            for (int i = 0; i < fields.length; ++i) {
                JRField field = fields[i];
                readers.put(field.getName(), this.getFieldReader(elements, aliasesMap, field));
            }
        }
        return readers;
    }

    protected boolean isManagedType(TupleElement<?> element) {
        try {
            this.queryExecuter.getSession().getMetamodel().managedType(element.getJavaType());
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected FieldReader getFieldReaderSingleReturn(Map<String, Integer> aliasesMap, JRField field) {
        FieldReader reader;
        String fieldMapping = this.getFieldMapping(field);
        if (aliasesMap.containsKey(fieldMapping)) {
            reader = new IndexFieldReader(0);
        } else {
            int firstNestedIdx = fieldMapping.indexOf(46);
            if (firstNestedIdx >= 0 && aliasesMap.containsKey(fieldMapping.substring(0, firstNestedIdx))) {
                fieldMapping = fieldMapping.substring(firstNestedIdx + 1);
            }
            reader = new IndexPropertyFieldReader(0, fieldMapping);
        }
        return reader;
    }

    protected FieldReader getFieldReader(List<TupleElement<?>> elements, Map<String, Integer> aliasesMap, JRField field) {
        FieldReader reader;
        String fieldMapping = this.getFieldMapping(field);
        Integer fieldIdx = aliasesMap.get(fieldMapping);
        if (fieldIdx == null) {
            int firstNestedIdx = fieldMapping.indexOf(46);
            if (firstNestedIdx < 0) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNKNOWN_RETURN_ALIAS, new Object[]{fieldMapping});
            }
            String fieldAlias = fieldMapping.substring(0, firstNestedIdx);
            String fieldProperty = fieldMapping.substring(firstNestedIdx + 1);
            fieldIdx = aliasesMap.get(fieldAlias);
            if (fieldIdx == null) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NO_FIELD_ALIAS, new Object[]{fieldAlias});
            }
            if (!this.isManagedType(elements.get(fieldIdx))) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_FIELD_ALIAS_TYPE_MISMATCH, new Object[]{fieldAlias});
            }
            reader = new IndexPropertyFieldReader(fieldIdx, fieldProperty);
        } else {
            reader = new IndexFieldReader(fieldIdx);
        }
        return reader;
    }

    protected void setCurrentRowValue(Tuple currentReturnValue) {
        this.currentReturnValue = currentReturnValue;
    }

    protected FieldReader fieldReader(JRField jrField) {
        if (this.fieldReaders == null) {
            this.fieldReaders = this.assignReaders(this.currentReturnValue);
        }
        return this.fieldReaders.get(jrField.getName());
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        FieldReader reader = this.fieldReader(jrField);
        if (reader == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NO_FIELD_READER, new Object[]{jrField.getName()});
        }
        return reader.getFieldValue(this.currentReturnValue);
    }

    protected String getFieldMapping(JRField field) {
        return this.propertyNameProvider.getPropertyName(field);
    }

    protected static interface FieldReader {
        public Object getFieldValue(Tuple var1) throws JRException;
    }

    protected static class IndexFieldReader
    implements FieldReader {
        private final int idx;

        protected IndexFieldReader(int idx) {
            this.idx = idx;
        }

        @Override
        public Object getFieldValue(Tuple resultTuple) {
            return resultTuple.get(this.idx);
        }
    }

    protected static class IndexPropertyFieldReader
    implements FieldReader {
        private final int idx;
        private final String property;

        protected IndexPropertyFieldReader(int idx, String property) {
            this.idx = idx;
            this.property = property;
        }

        @Override
        public Object getFieldValue(Tuple resultTuple) throws JRException {
            Object tupleValue = resultTuple.get(this.idx);
            return JRAbstractBeanDataSource.getBeanProperty((Object)tupleValue, (String)this.property);
        }
    }
}

