/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.hibernate;

import jakarta.persistence.Tuple;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.hibernate.JRHibernateAbstractDataSource;
import net.sf.jasperreports.hibernate.JRHibernateIterateDataSource;
import net.sf.jasperreports.hibernate.JRHibernateListDataSource;
import net.sf.jasperreports.hibernate.JRHibernateScrollDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.query.BindableType;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;

public class JRHibernateQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(JRHibernateQueryExecuter.class);
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_QUERY_RUN_TYPE = "query.hibernate.unknown.query.run.type";
    public static final String EXCEPTION_MESSAGE_KEY_UNRESOLVED_TYPE_CONSTANT = "query.hibernate.unresolved.type.constant";
    public static final String CANONICAL_LANGUAGE = "HQL";
    private static final Map<Class<?>, BindableType<?>> hibernateTypeMap = new HashMap();
    private final Integer reportMaxCount;
    private Session session = (Session)this.getParameterValue("HIBERNATE_SESSION");
    private Query<Tuple> query;
    private boolean queryRunning;
    private ScrollableResults<Tuple> scrollableResults;
    private Stream<Tuple> resultsStream;
    private boolean isClearCache;

    public JRHibernateQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parameters) {
        super(jasperReportsContext, dataset, parameters);
        this.reportMaxCount = (Integer)this.getParameterValue("REPORT_MAX_COUNT");
        this.isClearCache = this.getPropertiesUtil().getBooleanProperty((JRPropertiesHolder)dataset, "net.sf.jasperreports.hql.clear.cache", false);
        if (this.session == null) {
            log.warn((Object)"The supplied org.hibernate.Session object is null.");
        }
        this.parseQuery();
    }

    protected String getCanonicalQueryLanguage() {
        return CANONICAL_LANGUAGE;
    }

    public JRDataSource createDatasource() throws JRException {
        JRDataSource datasource = null;
        String queryString = this.getQueryString();
        if (this.session != null && queryString != null && queryString.trim().length() > 0) {
            this.createQuery(queryString);
            datasource = this.createResultDatasource();
        }
        return datasource;
    }

    protected JRDataSource createResultDatasource() {
        JRHibernateAbstractDataSource resDatasource;
        String runType = this.getPropertiesUtil().getProperty((JRPropertiesHolder)this.dataset, "net.sf.jasperreports.hql.query.run.type");
        boolean useFieldDescriptions = this.getPropertiesUtil().getBooleanProperty((JRPropertiesHolder)this.dataset, "net.sf.jasperreports.hql.field.mapping.descriptions", true);
        if (runType == null || runType.equals("list")) {
            try {
                int pageSize = this.getPropertiesUtil().getIntegerProperty((JRPropertiesHolder)this.dataset, "net.sf.jasperreports.hql.query.list.page.size", 0);
                resDatasource = new JRHibernateListDataSource(this, useFieldDescriptions, pageSize);
            }
            catch (NumberFormatException e) {
                throw new JRRuntimeException("query.numeric.type.required", new Object[]{"net.sf.jasperreports.hql.query.list.page.size"}, (Throwable)e);
            }
        } else if (runType.equals("iterate")) {
            resDatasource = new JRHibernateIterateDataSource(this, useFieldDescriptions);
        } else if (runType.equals("scroll")) {
            resDatasource = new JRHibernateScrollDataSource(this, useFieldDescriptions);
        } else {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNKNOWN_QUERY_RUN_TYPE, new Object[]{"net.sf.jasperreports.hql.query.run.type", "list", "iterate", "scroll"});
        }
        return resDatasource;
    }

    protected synchronized void createQuery(String queryString) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("HQL query: " + queryString));
        }
        this.query = this.session.createQuery(queryString, Tuple.class);
        this.query.setReadOnly(true);
        int fetchSize = this.getPropertiesUtil().getIntegerProperty((JRPropertiesHolder)this.dataset, "net.sf.jasperreports.jdbc.fetch.size", 0);
        if (fetchSize != 0) {
            this.query.setFetchSize(fetchSize);
        }
        this.setParameters();
    }

    protected void setParameters() {
        List parameterNames = this.getCollectedParameterNames();
        if (!parameterNames.isEmpty()) {
            HashSet<String> namesSet = new HashSet<String>();
            for (String parameterName : parameterNames) {
                if (!namesSet.add(parameterName)) continue;
                JRValueParameter parameter = this.getValueParameter(parameterName);
                this.setParameter(parameter);
            }
        }
    }

    protected void setParameter(JRValueParameter parameter) {
        BindableType<?> type;
        String hqlParamName = this.getHqlParameterName(parameter.getName());
        Class clazz = parameter.getValueClass();
        Object parameterValue = parameter.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parameter " + hqlParamName + " of type " + clazz.getName() + ": " + parameterValue));
        }
        if ((type = hibernateTypeMap.get(clazz)) != null) {
            this.query.setParameter(hqlParamName, parameterValue, type);
        } else if (Collection.class.isAssignableFrom(clazz)) {
            this.query.setParameterList(hqlParamName, (Collection)parameterValue);
        } else {
            this.query.setParameter(hqlParamName, parameterValue);
        }
    }

    public synchronized void close() {
        this.closeScrollableResults();
        this.closeResultsStream();
        this.query = null;
    }

    public void closeScrollableResults() {
        if (this.scrollableResults != null) {
            try {
                this.scrollableResults.close();
            }
            finally {
                this.scrollableResults = null;
            }
        }
    }

    protected void closeResultsStream() {
        if (this.resultsStream != null) {
            try {
                this.resultsStream.close();
            }
            finally {
                this.resultsStream = null;
            }
        }
    }

    public synchronized boolean cancelQuery() throws JRException {
        if (this.queryRunning) {
            this.session.cancelQuery();
            return true;
        }
        return false;
    }

    protected String getParameterReplacement(String parameterName) {
        return ':' + this.getHqlParameterName(parameterName);
    }

    protected String getHqlParameterName(String parameterName) {
        return '_' + JRStringUtil.getJavaIdentifier((String)parameterName);
    }

    public JRDataset getDataset() {
        return this.dataset;
    }

    public List<Tuple> list() {
        this.setMaxCount();
        this.setQueryRunning(true);
        try {
            List list = this.query.list();
            return list;
        }
        finally {
            this.setQueryRunning(false);
        }
    }

    protected synchronized void setQueryRunning(boolean queryRunning) {
        this.queryRunning = queryRunning;
    }

    private void setMaxCount() {
        if (this.reportMaxCount != null) {
            this.query.setMaxResults(this.reportMaxCount.intValue());
        }
    }

    public List<Tuple> list(int firstIndex, int resultCount) {
        if (this.reportMaxCount != null && firstIndex + resultCount > this.reportMaxCount) {
            resultCount = this.reportMaxCount - firstIndex;
        }
        this.query.setFirstResult(firstIndex);
        this.query.setMaxResults(resultCount);
        if (this.isClearCache) {
            this.clearCache();
        }
        return this.query.list();
    }

    public Stream<Tuple> stream() {
        this.closeResultsStream();
        this.setMaxCount();
        this.setQueryRunning(true);
        try {
            this.resultsStream = this.query.stream();
            Stream<Tuple> stream = this.resultsStream;
            return stream;
        }
        finally {
            this.setQueryRunning(false);
        }
    }

    public ScrollableResults<Tuple> scroll() {
        this.setMaxCount();
        this.setQueryRunning(true);
        try {
            this.scrollableResults = this.query.scroll(ScrollMode.FORWARD_ONLY);
        }
        finally {
            this.setQueryRunning(false);
        }
        return this.scrollableResults;
    }

    protected Session getSession() {
        return this.session;
    }

    public void clearCache() {
        this.session.flush();
        this.session.clear();
    }

    static {
        hibernateTypeMap.put(Boolean.class, (BindableType<?>)StandardBasicTypes.BOOLEAN);
        hibernateTypeMap.put(Byte.class, (BindableType<?>)StandardBasicTypes.BYTE);
        hibernateTypeMap.put(Double.class, (BindableType<?>)StandardBasicTypes.DOUBLE);
        hibernateTypeMap.put(Float.class, (BindableType<?>)StandardBasicTypes.FLOAT);
        hibernateTypeMap.put(Integer.class, (BindableType<?>)StandardBasicTypes.INTEGER);
        hibernateTypeMap.put(Long.class, (BindableType<?>)StandardBasicTypes.LONG);
        hibernateTypeMap.put(Short.class, (BindableType<?>)StandardBasicTypes.SHORT);
        hibernateTypeMap.put(BigDecimal.class, (BindableType<?>)StandardBasicTypes.BIG_DECIMAL);
        hibernateTypeMap.put(BigInteger.class, (BindableType<?>)StandardBasicTypes.BIG_INTEGER);
        hibernateTypeMap.put(Character.class, (BindableType<?>)StandardBasicTypes.CHARACTER);
        hibernateTypeMap.put(String.class, (BindableType<?>)StandardBasicTypes.STRING);
        hibernateTypeMap.put(Date.class, (BindableType<?>)StandardBasicTypes.DATE);
        hibernateTypeMap.put(Timestamp.class, (BindableType<?>)StandardBasicTypes.TIMESTAMP);
        hibernateTypeMap.put(Time.class, (BindableType<?>)StandardBasicTypes.TIME);
    }
}

