/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table.fill;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sf.jasperreports.components.headertoolbar.HeaderToolbarElement;
import net.sf.jasperreports.components.iconlabel.IconLabelComponent;
import net.sf.jasperreports.components.iconlabel.IconLabelComponentUtil;
import net.sf.jasperreports.components.table.BaseCell;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.Column;
import net.sf.jasperreports.components.table.ColumnGroup;
import net.sf.jasperreports.components.table.ColumnVisitor;
import net.sf.jasperreports.components.table.Row;
import net.sf.jasperreports.components.table.TableComponent;
import net.sf.jasperreports.components.table.WhenNoDataTypeTableEnum;
import net.sf.jasperreports.components.table.fill.FillColumn;
import net.sf.jasperreports.components.table.fill.TableReportDataset;
import net.sf.jasperreports.components.table.fill.TableReportGroup;
import net.sf.jasperreports.components.table.fill.TableReportScriptlet;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.components.util.FieldFilter;
import net.sf.jasperreports.components.util.FilterTypesEnum;
import net.sf.jasperreports.engine.CompositeDatasetFilter;
import net.sf.jasperreports.engine.DatasetFilter;
import net.sf.jasperreports.engine.DatasetPropertyExpression;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseTextElement;
import net.sf.jasperreports.engine.component.FillContext;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignGenericElement;
import net.sf.jasperreports.engine.design.JRDesignGenericElementParameter;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.fill.BuiltinExpressionEvaluator;
import net.sf.jasperreports.engine.fill.BuiltinExpressionEvaluatorFactory;
import net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.type.PositionTypeEnum;
import net.sf.jasperreports.engine.type.PrintOrderEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.SectionTypeEnum;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;
import net.sf.jasperreports.engine.type.SortOrderEnum;
import net.sf.jasperreports.engine.type.SplitTypeEnum;
import net.sf.jasperreports.engine.type.StretchTypeEnum;
import net.sf.jasperreports.engine.type.WhenNoDataTypeEnum;
import net.sf.jasperreports.engine.type.WhenResourceMissingTypeEnum;
import net.sf.jasperreports.engine.util.DigestUtils;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.Pair;
import net.sf.jasperreports.engine.util.StyleResolver;
import net.sf.jasperreports.engine.util.StyleUtil;
import net.sf.jasperreports.export.type.AccessibilityTagEnum;
import net.sf.jasperreports.util.JsonLoader;

public class TableReport
implements JRReport {
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_CHILD_TYPE = "fill.table.report.unknown.child.type";
    public static final String EXCEPTION_MESSAGE_KEY_FIELD_NOT_FOUND = "fill.table.report.field.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_VARIABLE_NOT_FOUND = "fill.table.report.variable.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_UNRECOGNIZED_FILTER_EXPRESSION_TYPE = "fill.table.report.unrecognized.filter.expression.type";
    public static final String METADATA_KEY_QUALIFICATION = "table";
    public static final String PROPERTY_UP_ARROW_CHAR = "net.sf.jasperreports.components.sort.up.arrow.char";
    public static final String PROPERTY_DOWN_ARROW_CHAR = "net.sf.jasperreports.components.sort.down.arrow.char";
    public static final String PROPERTY_FILTER_CHAR = "net.sf.jasperreports.components.filter.char";
    public static final String PROPERTY_ICON_FONT = "net.sf.jasperreports.components.icon.font";
    public static final String PROPERTY_INTERACTIVE_TABLE = "net.sf.jasperreports.components.table.interactive";
    public static final String PROPERTY_FLOATING_HEADER = "net.sf.jasperreports.components.table.floating.header";
    public static final String PROPERTY_GENERATE_TABLE_PDF_TAGS = "net.sf.jasperreports.components.table.generate.pdf.tags";
    public static final String PROPERTY_ACCESSIBLE_TABLE = "net.sf.jasperreports.components.table.accessible";
    public static final String PROPERTY_COLUMN_FIELD = "net.sf.jasperreports.components.table.column.field";
    public static final String PROPERTY_COLUMN_VARIABLE = "net.sf.jasperreports.components.table.column.variable";
    public static final String PROPERTY_COLUMN_SORTABLE = "net.sf.jasperreports.components.table.column.sortable";
    public static final String PROPERTY_COLUMN_FILTERABLE = "net.sf.jasperreports.components.table.column.filterable";
    public static final String PROPERTY_TABLE_NAME = "net.sf.jasperreports.components.table.name";
    protected static final String SUMMARY_GROUP_NAME = "__SummaryGroup";
    protected static final String HTML_CLASS_CELL_PREFIX = "cel_";
    protected static final String HTML_CLASS_CELL = "jrcel";
    public static final String TABLE_HEADER_LABEL_MATCHER_EXPORT_KEY = "net.sf.jasperreports.components.table.header.label";
    public static final String TABLE_HEADER_ICON_LABEL_MATCHER_EXPORT_KEY = "net.sf.jasperreports.components.table.header.icon.label";
    private final FillContext fillContext;
    private final TableComponent table;
    private final JasperReport parentReport;
    private final TableReportDataset mainDataset;
    private final BuiltinExpressionEvaluatorFactory builtinEvaluatorFactory;
    private final JRSection detail;
    private final JRDesignBand title;
    private final JRDesignBand summary;
    private final JRDesignBand columnHeader;
    private final JRDesignBand pageFooter;
    private final JRDesignBand lastPageFooter;
    private final JRDesignBand noData;
    private final List<TableIndexProperties> tableIndexProperties = new ArrayList<TableIndexProperties>();
    private final Map<Integer, JRPropertiesMap> headerHtmlBaseProperties = new HashMap<Integer, JRPropertiesMap>();
    private final JRPropertiesUtil propertiesUtil;
    private String tableName;
    private boolean isInteractiveTable;
    private boolean hasFloatingHeader;
    private boolean isAccessibleTable;
    private Map<Column, Pair<Boolean, String>> columnInteractivityMapping;
    protected static final String TABLE_SCRIPTLET_NAME = "__Table";

    public TableReport(FillContext fillContext, TableComponent table, TableReportDataset mainDataset, List<FillColumn> fillColumns, BuiltinExpressionEvaluatorFactory builtinEvaluatorFactory) {
        String accessibleProp;
        this.fillContext = fillContext;
        this.table = table;
        this.parentReport = fillContext.getFiller().getJasperReport();
        this.mainDataset = mainDataset;
        this.builtinEvaluatorFactory = builtinEvaluatorFactory;
        this.tableName = JRPropertiesUtil.getOwnProperty(fillContext.getComponentElement(), PROPERTY_TABLE_NAME);
        this.propertiesUtil = JRPropertiesUtil.getInstance(fillContext.getFiller().getJasperReportsContext());
        this.isInteractiveTable = Boolean.valueOf(this.propertiesUtil.getProperty(PROPERTY_INTERACTIVE_TABLE, fillContext.getComponentElement(), this.parentReport));
        this.columnInteractivityMapping = new HashMap<Column, Pair<Boolean, String>>();
        int interactiveColumnCount = 0;
        for (BaseColumn column : TableUtil.getAllColumns(table)) {
            boolean interactiveColumn = this.isInteractiveTable;
            String columnName = null;
            if (column.getPropertiesMap().containsProperty(PROPERTY_INTERACTIVE_TABLE)) {
                interactiveColumn = Boolean.valueOf(column.getPropertiesMap().getProperty(PROPERTY_INTERACTIVE_TABLE));
            }
            if (interactiveColumn) {
                ++interactiveColumnCount;
            }
            if (column.getPropertiesMap().containsProperty("net.sf.jasperreports.components.name")) {
                columnName = column.getPropertiesMap().getProperty("net.sf.jasperreports.components.name");
            }
            this.columnInteractivityMapping.put((Column)column, new Pair<Boolean, String>(interactiveColumn, columnName));
        }
        if (interactiveColumnCount > 0) {
            this.isInteractiveTable = true;
            this.hasFloatingHeader = this.propertiesUtil.getBooleanProperty(PROPERTY_FLOATING_HEADER, true, fillContext.getComponentElement(), this.parentReport);
        }
        if ((accessibleProp = this.propertiesUtil.getProperty(PROPERTY_ACCESSIBLE_TABLE, fillContext.getComponentElement(), this.parentReport)) == null) {
            accessibleProp = this.propertiesUtil.getProperty(PROPERTY_GENERATE_TABLE_PDF_TAGS, fillContext.getComponentElement(), this.parentReport);
        }
        this.isAccessibleTable = Boolean.valueOf(accessibleProp);
        this.columnHeader = this.createColumnHeader(fillColumns);
        this.detail = this.wrapBand(this.createDetailBand(fillColumns), new JROrigin(BandTypeEnum.DETAIL));
        this.title = this.createTitle(fillColumns);
        this.summary = this.createSummary(fillColumns);
        this.pageFooter = this.createPageFooter(fillColumns);
        this.setGroupBands(fillColumns);
        if (this.pageFooter != null && this.summary != null) {
            this.addSummaryGroup(fillColumns);
            this.lastPageFooter = new JRDesignBand();
            this.lastPageFooter.setHeight(0);
        } else {
            this.lastPageFooter = null;
        }
        this.noData = this.createNoData(table.getNoData());
    }

    protected JRBand createDetailBand(List<FillColumn> fillColumns) {
        JRDesignBand detailBand = new JRDesignBand();
        Row detailRow = this.table.getDetail();
        detailBand.setSplitType(detailRow == null || detailRow.getSplitType() == null ? SplitTypeEnum.PREVENT : detailRow.getSplitType());
        detailBand.setPrintWhenExpression(detailRow == null ? null : detailRow.getPrintWhenExpression());
        ReportBandInfo bandInfo = new ReportBandInfo(detailBand, BandTypeEnum.DETAIL.getName());
        int xOffset = 0;
        for (FillColumn subcolumn : fillColumns) {
            DetailBandCreator subVisitor = new DetailBandCreator(bandInfo, subcolumn, xOffset, 0, 0);
            subVisitor.visit();
            xOffset = subVisitor.xOffset;
        }
        this.setAccessibilitTags(bandInfo, false);
        return detailBand;
    }

    protected TimeZone getFormatTimeZone(JRTextField textField, Class<?> valueClass) {
        String formatTimeZone = null;
        if (textField.hasProperties()) {
            formatTimeZone = textField.getPropertiesMap().getProperty("net.sf.jasperreports.pattern.timezone");
        }
        if (formatTimeZone == null || formatTimeZone.isEmpty()) {
            if (Date.class.isAssignableFrom(valueClass)) {
                formatTimeZone = this.propertiesUtil.getProperty(this.parentReport, "net.sf.jasperreports.sql.date.pattern.timezone");
            } else if (Timestamp.class.isAssignableFrom(valueClass)) {
                formatTimeZone = this.propertiesUtil.getProperty(this.parentReport, "net.sf.jasperreports.sql.timestamp.pattern.timezone");
            } else if (Time.class.isAssignableFrom(valueClass)) {
                formatTimeZone = this.propertiesUtil.getProperty(this.parentReport, "net.sf.jasperreports.sql.time.pattern.timezone");
            }
        }
        if (formatTimeZone == null || formatTimeZone.isEmpty()) {
            formatTimeZone = this.propertiesUtil.getProperty(this.parentReport, "net.sf.jasperreports.pattern.timezone");
        }
        TimeZone reportTimeZone = this.fillContext.getFillDataset().getTimeZone();
        return JRDataUtils.resolveFormatTimeZone(formatTimeZone, reportTimeZone);
    }

    protected JRDesignBand createColumnHeader(List<FillColumn> fillColumns) {
        JRDesignBand columnHeader = new JRDesignBand();
        Row columnHeaderRow = this.table.getColumnHeader();
        columnHeader.setSplitType(columnHeaderRow == null || columnHeaderRow.getSplitType() == null ? SplitTypeEnum.PREVENT : columnHeaderRow.getSplitType());
        columnHeader.setPrintWhenExpression(columnHeaderRow == null ? null : columnHeaderRow.getPrintWhenExpression());
        ReportBandInfo bandInfo = new ReportBandInfo(columnHeader, BandTypeEnum.COLUMN_HEADER.getName());
        int xOffset = 0;
        for (FillColumn subcolumn : fillColumns) {
            ColumnHeaderCreator subVisitor = new ColumnHeaderCreator(bandInfo, subcolumn, xOffset, 0, 0, this.headerHtmlBaseProperties, new AtomicBoolean());
            subVisitor.visit();
            xOffset = subVisitor.xOffset;
        }
        this.setAccessibilitTags(bandInfo, true);
        if (columnHeader.getHeight() == 0) {
            columnHeader = null;
        }
        return columnHeader;
    }

    protected JRDesignBand createPageFooter(List<FillColumn> fillColumns) {
        JRDesignBand pageFooter = new JRDesignBand();
        Row columnFooterRow = this.table.getColumnFooter();
        pageFooter.setSplitType(columnFooterRow == null || columnFooterRow.getSplitType() == null ? SplitTypeEnum.PREVENT : columnFooterRow.getSplitType());
        pageFooter.setPrintWhenExpression(columnFooterRow == null ? null : columnFooterRow.getPrintWhenExpression());
        ReportBandInfo bandInfo = new ReportBandInfo(pageFooter, BandTypeEnum.PAGE_FOOTER.getName());
        int xOffset = 0;
        for (FillColumn subcolumn : fillColumns) {
            PageFooterCreator subVisitor = new PageFooterCreator(bandInfo, subcolumn, xOffset, 0, 0);
            subVisitor.visit();
            xOffset = subVisitor.xOffset;
        }
        this.setAccessibilitTags(bandInfo, false);
        if (pageFooter.getHeight() == 0) {
            pageFooter = null;
        }
        return pageFooter;
    }

    protected JRDesignBand createNoData(BaseCell cell) {
        JRDesignBand noData = null;
        if (cell != null) {
            noData = new JRDesignBand();
            noData.setSplitType(SplitTypeEnum.PREVENT);
            noData.addElement(this.createCell(null, cell, this.fillContext.getComponentElement().getWidth(), this.fillContext.getComponentElement().getWidth(), 0, 0, null, null, false));
        }
        return noData;
    }

    protected JRDesignBand createTitle(List<FillColumn> fillColumns) {
        JRDesignBand title = new JRDesignBand();
        Row tableHeaderRow = this.table.getTableHeader();
        title.setSplitType(tableHeaderRow == null || tableHeaderRow.getSplitType() == null ? SplitTypeEnum.PREVENT : tableHeaderRow.getSplitType());
        title.setPrintWhenExpression(tableHeaderRow == null ? null : tableHeaderRow.getPrintWhenExpression());
        ReportBandInfo bandInfo = new ReportBandInfo(title, BandTypeEnum.TITLE.getName());
        int xOffset = 0;
        for (FillColumn subcolumn : fillColumns) {
            TitleCreator subVisitor = new TitleCreator(bandInfo, subcolumn, xOffset, 0, 0);
            subVisitor.visit();
            xOffset = subVisitor.xOffset;
        }
        this.setAccessibilitTags(bandInfo, false);
        if (title.getHeight() == 0) {
            title = null;
        }
        return title;
    }

    protected JRDesignBand createSummary(List<FillColumn> fillColumns) {
        JRDesignBand summary = new JRDesignBand();
        Row tableFooterRow = this.table.getTableFooter();
        summary.setSplitType(tableFooterRow == null || tableFooterRow.getSplitType() == null ? SplitTypeEnum.PREVENT : tableFooterRow.getSplitType());
        summary.setPrintWhenExpression(tableFooterRow == null ? null : tableFooterRow.getPrintWhenExpression());
        ReportBandInfo bandInfo = new ReportBandInfo(summary, BandTypeEnum.SUMMARY.getName());
        int xOffset = 0;
        for (FillColumn subcolumn : fillColumns) {
            SummaryCreator subVisitor = new SummaryCreator(bandInfo, subcolumn, xOffset, 0, 0);
            subVisitor.visit();
            xOffset = subVisitor.xOffset;
        }
        this.setAccessibilitTags(bandInfo, false);
        if (summary.getHeight() == 0) {
            summary = null;
        }
        return summary;
    }

    protected JRBand createGroupHeader(String groupName, List<FillColumn> fillColumns) {
        JRDesignBand header = new JRDesignBand();
        Row headerRow = this.table.getGroupHeader(groupName);
        header.setSplitType(headerRow == null || headerRow.getSplitType() == null ? SplitTypeEnum.PREVENT : headerRow.getSplitType());
        header.setPrintWhenExpression(headerRow == null ? null : headerRow.getPrintWhenExpression());
        ReportBandInfo bandInfo = new ReportBandInfo(header, BandTypeEnum.GROUP_HEADER + "-" + groupName);
        int xOffset = 0;
        for (FillColumn subcolumn : fillColumns) {
            GroupHeaderCreator subVisitor = new GroupHeaderCreator(groupName, bandInfo, subcolumn, xOffset, 0, 0);
            subVisitor.visit();
            xOffset = subVisitor.xOffset;
        }
        this.setAccessibilitTags(bandInfo, false);
        if (header.getHeight() == 0) {
            header = null;
        }
        return header;
    }

    protected JRBand createGroupFooter(String groupName, List<FillColumn> fillColumns) {
        JRDesignBand footer = new JRDesignBand();
        Row footerRow = this.table.getGroupFooter(groupName);
        footer.setSplitType(footerRow == null || footerRow.getSplitType() == null ? SplitTypeEnum.PREVENT : footerRow.getSplitType());
        footer.setPrintWhenExpression(footerRow == null ? null : footerRow.getPrintWhenExpression());
        ReportBandInfo bandInfo = new ReportBandInfo(footer, BandTypeEnum.GROUP_FOOTER + "-" + groupName);
        int xOffset = 0;
        for (FillColumn subcolumn : fillColumns) {
            GroupFooterCreator subVisitor = new GroupFooterCreator(groupName, bandInfo, subcolumn, xOffset, 0, 0);
            subVisitor.visit();
            xOffset = subVisitor.xOffset;
        }
        this.setAccessibilitTags(bandInfo, false);
        if (footer.getHeight() == 0) {
            footer = null;
        }
        return footer;
    }

    private void setGroupBands(List<FillColumn> fillColumns) {
        TableReportGroup[] groups = this.mainDataset.getTableGroups();
        if (groups != null) {
            for (TableReportGroup group : groups) {
                JRBand footer;
                JRBand header = this.createGroupHeader(group.getName(), fillColumns);
                if (header != null) {
                    group.setGroupHeader(header);
                }
                if ((footer = this.createGroupFooter(group.getName(), fillColumns)) == null) continue;
                group.setGroupFooter(footer);
            }
        }
    }

    private void setAccessibilitTags(ReportBandInfo bandInfo, boolean isHeader) {
        if (!this.isAccessibleTable) {
            return;
        }
        String cellTagProp = isHeader ? "net.sf.jasperreports.export.pdf.tag.th" : "net.sf.jasperreports.export.pdf.tag.td";
        List<BandRowInfo> rows = bandInfo.getRows();
        for (BandRowInfo row : rows) {
            List<CellInfo> cells = row.getCells();
            CellInfo firstCell = cells.get(0);
            firstCell.getElement().getPropertiesMap().setProperty("net.sf.jasperreports.export.pdf.tag.tr", "start");
            for (CellInfo cell : cells) {
                cell.getElement().getPropertiesMap().setProperty(cellTagProp, "full");
                if (isHeader) {
                    cell.getElement().getPropertiesMap().setProperty("net.sf.jasperreports.export.accessibility.tag", AccessibilityTagEnum.COLUMN_HEADER.getName());
                }
                if (cell.getRowSpan() > 1) {
                    cell.getElement().getPropertiesMap().setProperty("net.sf.jasperreports.export.pdf.tag.rowspan", String.valueOf(cell.getRowSpan()));
                }
                if (cell.getColSpan() <= 1) continue;
                cell.getElement().getPropertiesMap().setProperty("net.sf.jasperreports.export.pdf.tag.colspan", String.valueOf(cell.getColSpan()));
            }
            CellInfo lastCell = cells.get(cells.size() - 1);
            lastCell.getElement().getPropertiesMap().setProperty("net.sf.jasperreports.export.pdf.tag.tr", cells.size() == 1 ? "full" : "end");
        }
    }

    protected boolean isAccessibleTable() {
        return this.isAccessibleTable;
    }

    protected int computeTableWidth(List<FillColumn> fillColumns) {
        int width = 0;
        for (FillColumn column : fillColumns) {
            width += column.getWidth();
        }
        return width;
    }

    protected void addSummaryGroup(List<FillColumn> fillColumns) {
        JRDesignGroup summaryGroup = new JRDesignGroup();
        summaryGroup.setName(SUMMARY_GROUP_NAME);
        JRDesignBand groupFooter = new JRDesignBand();
        groupFooter.setSplitType(SplitTypeEnum.PREVENT);
        groupFooter.setHeight(this.pageFooter.getHeight());
        JRDesignFrame footerFrame = new JRDesignFrame();
        DigestUtils digestUtils = DigestUtils.instance();
        UUID uuid = digestUtils.deriveUUID(this.fillContext.getComponentElement().getUUID(), BandTypeEnum.GROUP_FOOTER + "-" + SUMMARY_GROUP_NAME);
        footerFrame.setUUID(uuid);
        footerFrame.setX(0);
        footerFrame.setY(0);
        footerFrame.setWidth(this.computeTableWidth(fillColumns));
        footerFrame.setHeight(this.pageFooter.getHeight());
        footerFrame.getLineBox().setPadding(0);
        footerFrame.getLineBox().getPen().setLineWidth(Float.valueOf(0.0f));
        footerFrame.setRemoveLineWhenBlank(true);
        JRDesignExpression footerPrintWhen = this.builtinEvaluatorFactory.createExpression(new SummaryGroupFooterPrintWhenEvaluator());
        footerFrame.setPrintWhenExpression(footerPrintWhen);
        List<JRChild> footerChildren = this.pageFooter.getChildren();
        for (JRChild child : footerChildren) {
            JRChild childClone = (JRChild)child.clone(footerFrame);
            if (childClone instanceof JRElement) {
                footerFrame.addElement((JRElement)childClone);
                continue;
            }
            if (childClone instanceof JRElementGroup) {
                footerFrame.addElementGroup((JRElementGroup)childClone);
                continue;
            }
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNKNOWN_CHILD_TYPE, childClone.getClass().getName());
        }
        JRElement[] footerElements = this.pageFooter.getElements();
        JRElement[] footerCloneElements = footerFrame.getElements();
        for (int i = 0; i < footerElements.length; ++i) {
            uuid = digestUtils.deriveUUID(footerElements[i].getUUID(), BandTypeEnum.GROUP_FOOTER + "-" + SUMMARY_GROUP_NAME);
            ((JRBaseElement)footerCloneElements[i]).setUUID(uuid);
        }
        groupFooter.addElement(footerFrame);
        ((JRDesignSection)summaryGroup.getGroupFooterSection()).addBand(groupFooter);
        this.mainDataset.addScriptlet(TABLE_SCRIPTLET_NAME, TableReportScriptlet.class);
        this.mainDataset.addFirstGroup(summaryGroup);
    }

    protected JRElement createCell(JRElementGroup parentGroup, BaseCell cell, int originalWidth, int width, int x, int y, Integer columnHashCode, UUID uuid, boolean forceFrame) {
        JRElement cellElement;
        if (!forceFrame && (cellElement = this.createCellElement(parentGroup, cell, originalWidth, width, x, y, columnHashCode)) != null) {
            return cellElement;
        }
        JRDesignFrame frame = new JRDesignFrame(this);
        frame.setUUID(uuid);
        frame.setElementGroup(parentGroup);
        frame.setX(x);
        frame.setY(y);
        frame.setWidth(width);
        frame.setHeight(cell.getHeight());
        frame.setPositionType(PositionTypeEnum.FLOAT);
        frame.setStretchType(StretchTypeEnum.ELEMENT_GROUP_BOTTOM);
        frame.setStyle(cell.getStyle());
        frame.setStyleNameReference(cell.getStyleNameReference());
        frame.copyBox(cell.getLineBox());
        if (columnHashCode != null && this.headerHtmlBaseProperties.get(columnHashCode) != null) {
            JRPropertiesMap propertiesMap = frame.getPropertiesMap();
            assert (propertiesMap != null && propertiesMap.getBaseProperties() == null);
            propertiesMap.setBaseProperties(this.headerHtmlBaseProperties.get(columnHashCode));
        }
        for (JRChild child : cell.getChildren()) {
            if (child instanceof JRElement) {
                JRElement element = (JRElement)child;
                element = (JRElement)element.clone(frame);
                if (width != originalWidth) {
                    this.scaleCellElement(element, originalWidth, width);
                    if (element instanceof JRElementGroup) {
                        JRElementGroup elementGroup = (JRElementGroup)((Object)element);
                        JRElement[] jRElementArray = elementGroup.getElements();
                        int n = jRElementArray.length;
                        for (int i = 0; i < n; ++i) {
                            JRElement subelement = jRElementArray[i];
                            this.scaleCellElement(subelement, originalWidth, width);
                        }
                    }
                }
                frame.addElement(element);
                continue;
            }
            if (child instanceof JRElementGroup) {
                JRElementGroup elementGroup = (JRElementGroup)child;
                elementGroup = (JRElementGroup)elementGroup.clone(frame);
                frame.addElementGroup(elementGroup);
                if (width == originalWidth) continue;
                for (JRElement element : elementGroup.getElements()) {
                    this.scaleCellElement(element, originalWidth, width);
                }
                continue;
            }
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNKNOWN_CHILD_TYPE, child.getClass().getName());
        }
        return frame;
    }

    protected JRElement createCellElement(JRElementGroup elementGroup, BaseCell cell, int originalWidth, int width, int x, int y, Integer columnHashCode) {
        ModeEnum cellMode;
        List<JRChild> children = cell.getChildren();
        if (children.size() != 1) {
            return null;
        }
        JRChild child = children.get(0);
        if (!(child instanceof JRStaticText) && !(child instanceof JRTextField)) {
            return null;
        }
        JRElement element = (JRElement)child;
        if (element.getX() != 0 || element.getY() != 0 || element.getWidth() != originalWidth || element.getHeight() != cell.getHeight().intValue()) {
            return null;
        }
        ModeEnum elementMode = StyleUtil.instance().resolveElementMode(element);
        if ((elementMode == null || elementMode == ModeEnum.TRANSPARENT) && (cellMode = StyleUtil.instance().resolveMode(cell)) != ModeEnum.TRANSPARENT) {
            return null;
        }
        if (StyleUtil.instance().hasBox(cell)) {
            return null;
        }
        JRElement cellElement = element.clone(elementGroup, y);
        cellElement.setX(x);
        cellElement.setWidth(width);
        cellElement.setStretchType(StretchTypeEnum.ELEMENT_GROUP_HEIGHT);
        if (columnHashCode != null && this.headerHtmlBaseProperties.get(columnHashCode) != null) {
            JRPropertiesMap propertiesMap = cellElement.getPropertiesMap();
            assert (propertiesMap != null && propertiesMap.getBaseProperties() == null);
            propertiesMap.setBaseProperties(this.headerHtmlBaseProperties.get(columnHashCode));
        }
        if (width != originalWidth) {
            this.scaleCellElement(element, originalWidth, width);
        }
        return cellElement;
    }

    protected void scaleCellElement(JRElement element, Integer cellWidth, int scaledCellWidth) {
        int scaledX = (int)Math.floor((float)element.getX() * (float)scaledCellWidth / (float)cellWidth.intValue());
        element.setX(scaledX);
        int scaledWidth = (int)Math.floor((float)element.getWidth() * (float)scaledCellWidth / (float)cellWidth.intValue());
        element.setWidth(scaledWidth);
    }

    protected JRSection wrapBand(JRBand band, JROrigin origin) {
        JRDesignSection section = new JRDesignSection(origin);
        section.addBand(band);
        return section;
    }

    @Override
    public JRBand getBackground() {
        return null;
    }

    @Override
    public int getBottomMargin() {
        return 0;
    }

    @Override
    public Integer getColumnCount() {
        return 1;
    }

    @Override
    public JRBand getColumnFooter() {
        return null;
    }

    @Override
    public JRBand getColumnHeader() {
        return this.columnHeader;
    }

    @Override
    public int getColumnSpacing() {
        return 0;
    }

    @Override
    public int getColumnWidth() {
        return this.fillContext.getComponentElement().getWidth();
    }

    @Override
    public JRDataset[] getDatasets() {
        return this.parentReport.getDatasets();
    }

    @Deprecated
    public JRBand getDetail() {
        return null;
    }

    @Override
    public JRSection getDetailSection() {
        return this.detail;
    }

    @Override
    public JRField[] getFields() {
        return this.mainDataset.getFields();
    }

    protected JRField getField(String name) {
        JRField found = null;
        for (JRField field : this.getFields()) {
            if (!name.equals(field.getName())) continue;
            found = field;
            break;
        }
        return found;
    }

    @Override
    public String getFormatFactoryClass() {
        return this.parentReport.getFormatFactoryClass();
    }

    @Override
    public JRGroup[] getGroups() {
        return this.mainDataset.getGroups();
    }

    @Override
    public String[] getImports() {
        return this.parentReport.getImports();
    }

    @Override
    public String getLanguage() {
        return this.parentReport.getLanguage();
    }

    @Override
    public JRBand getLastPageFooter() {
        return this.lastPageFooter;
    }

    @Override
    public int getLeftMargin() {
        return 0;
    }

    @Override
    public JRDataset getMainDataset() {
        return this.mainDataset;
    }

    @Override
    public String getName() {
        return this.tableName == null ? this.mainDataset.getName() : this.tableName;
    }

    @Override
    public JRBand getNoData() {
        return this.noData;
    }

    @Override
    public OrientationEnum getOrientation() {
        return OrientationEnum.PORTRAIT;
    }

    @Override
    public JRBand getPageFooter() {
        return this.pageFooter;
    }

    @Override
    public JRBand getPageHeader() {
        return null;
    }

    @Override
    public int getPageHeight() {
        return this.parentReport.getPageHeight();
    }

    @Override
    public int getPageWidth() {
        return this.fillContext.getComponentElement().getWidth();
    }

    @Override
    public JRParameter[] getParameters() {
        return this.mainDataset.getParameters();
    }

    @Override
    public PrintOrderEnum getPrintOrder() {
        return PrintOrderEnum.VERTICAL;
    }

    @Override
    public RunDirectionEnum getColumnDirection() {
        return RunDirectionEnum.LTR;
    }

    @Override
    public String getProperty(String name) {
        return this.mainDataset.getPropertiesMap().getProperty(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.mainDataset.getPropertiesMap().getPropertyNames();
    }

    @Override
    public JRQuery getQuery() {
        return this.mainDataset.getQuery();
    }

    @Override
    public String getResourceBundle() {
        return this.mainDataset.getResourceBundle();
    }

    @Override
    public int getRightMargin() {
        return 0;
    }

    @Override
    public String getScriptletClass() {
        return this.mainDataset.getScriptletClass();
    }

    @Override
    public JRScriptlet[] getScriptlets() {
        return this.mainDataset.getScriptlets();
    }

    @Override
    public JRSortField[] getSortFields() {
        return this.mainDataset.getSortFields();
    }

    @Override
    public JRStyle[] getStyles() {
        return this.parentReport.getStyles();
    }

    @Override
    public JRBand getSummary() {
        return this.summary;
    }

    @Override
    public JRReportTemplate[] getTemplates() {
        return null;
    }

    @Override
    public JRBand getTitle() {
        return this.title;
    }

    @Override
    public int getTopMargin() {
        return 0;
    }

    @Override
    public JRVariable[] getVariables() {
        return this.mainDataset.getVariables();
    }

    protected JRVariable getVariable(String name) {
        JRVariable found = null;
        for (JRVariable var : this.getVariables()) {
            if (!name.equals(var.getName())) continue;
            found = var;
            break;
        }
        return found;
    }

    @Override
    public WhenNoDataTypeEnum getWhenNoDataType() {
        WhenNoDataTypeTableEnum whenNoDataType = this.table.getWhenNoDataType();
        if (whenNoDataType == null) {
            whenNoDataType = WhenNoDataTypeTableEnum.getByName(this.propertiesUtil.getProperty(this.fillContext.getFillDataset(), "net.sf.jasperreports.components.table.when.no.data.type"));
        }
        switch (whenNoDataType) {
            case ALL_SECTIONS_NO_DETAIL: {
                return WhenNoDataTypeEnum.ALL_SECTIONS_NO_DETAIL;
            }
            case NO_DATA_CELL: {
                return WhenNoDataTypeEnum.NO_DATA_SECTION;
            }
        }
        return WhenNoDataTypeEnum.NO_PAGES;
    }

    @Override
    public SectionTypeEnum getSectionType() {
        return SectionTypeEnum.BAND;
    }

    @Override
    public WhenResourceMissingTypeEnum getWhenResourceMissingType() {
        return this.mainDataset.getWhenResourceMissingType();
    }

    @Override
    public boolean isFloatColumnFooter() {
        return true;
    }

    @Override
    public boolean isIgnorePagination() {
        return false;
    }

    @Override
    public boolean isSummaryNewPage() {
        return false;
    }

    @Override
    public boolean isSummaryWithPageHeaderAndFooter() {
        return false;
    }

    @Override
    public boolean isTitleNewPage() {
        return false;
    }

    @Override
    public void removeProperty(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProperty(String name, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setWhenNoDataType(WhenNoDataTypeEnum whenNoDataType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setWhenResourceMissingType(WhenResourceMissingTypeEnum whenResourceMissingType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JRStyle getDefaultStyle() {
        return this.parentReport.getDefaultStyle();
    }

    @Override
    public StyleResolver getStyleResolver() {
        return this.parentReport.getStyleResolver();
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return null;
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        return this.mainDataset.getPropertiesMap();
    }

    @Override
    public boolean hasProperties() {
        return this.mainDataset.hasProperties();
    }

    @Override
    public DatasetPropertyExpression[] getPropertyExpressions() {
        return this.mainDataset.getPropertyExpressions();
    }

    @Override
    public UUID getUUID() {
        return this.mainDataset.getUUID();
    }

    public boolean isInteractiveTable() {
        return this.isInteractiveTable;
    }

    public void setTableInstanceIndex(int instanceIndex) {
        for (TableIndexProperties properties : this.tableIndexProperties) {
            properties.setTableInstanceIndex(instanceIndex);
        }
    }

    private static void getFieldFilters(DatasetFilter existingFilter, List<FieldFilter> fieldFilters, String fieldName) {
        if (existingFilter instanceof FieldFilter) {
            if (fieldName == null || fieldName != null && ((FieldFilter)existingFilter).getField().equals(fieldName)) {
                fieldFilters.add((FieldFilter)existingFilter);
            }
        } else if (existingFilter instanceof CompositeDatasetFilter) {
            for (DatasetFilter datasetFilter : ((CompositeDatasetFilter)existingFilter).getFilters()) {
                TableReport.getFieldFilters(datasetFilter, fieldFilters, fieldName);
            }
        }
    }

    protected class ReportBandInfo {
        final JRDesignBand band;
        final String bandId;
        final List<BandRowInfo> rows = new ArrayList<BandRowInfo>();

        ReportBandInfo(JRDesignBand band, String bandId) {
            this.band = band;
            this.bandId = bandId;
        }

        protected void cellAdded(int rowLevel, CellInfo cell) {
            JRElement element = cell.getElement();
            if (this.band.getHeight() < element.getHeight() + element.getY()) {
                this.band.setHeight(element.getHeight() + element.getY());
            }
            BandRowInfo row = this.getBandRowInfo(rowLevel);
            row.addCell(cell);
        }

        JRDesignElementGroup getRowElementGroup(int rowLevel) {
            BandRowInfo row = this.getBandRowInfo(rowLevel);
            JRDesignElementGroup elementGroup = row.getElementGroup();
            if (elementGroup == null) {
                elementGroup = new JRDesignElementGroup();
                row.setElementGroup(elementGroup);
                this.band.addElementGroup(elementGroup);
            }
            return elementGroup;
        }

        BandRowInfo getBandRowInfo(int rowLevel) {
            int rowCount = this.rows.size();
            if (rowLevel >= rowCount) {
                for (int level = rowCount; level <= rowLevel; ++level) {
                    this.rows.add(new BandRowInfo());
                }
            }
            return this.rows.get(rowLevel);
        }

        List<BandRowInfo> getRows() {
            return this.rows;
        }

        String getBandId() {
            return this.bandId;
        }
    }

    protected class DetailBandCreator
    extends ReportBandCreator {
        public DetailBandCreator(ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
        }

        @Override
        protected Cell columnCell(Column column) {
            return column.getDetailCell();
        }

        @Override
        protected Cell columnGroupCell(ColumnGroup group) {
            return null;
        }

        @Override
        protected ReportBandCreator createSubVisitor(FillColumn subcolumn, int xOffset, int yOffset, int sublevel) {
            return new DetailBandCreator(this.bandInfo, subcolumn, xOffset, yOffset, sublevel);
        }

        @Override
        protected boolean isEmpty(Cell cell) {
            if (super.isEmpty(cell)) {
                return true;
            }
            List<JRChild> children = cell.getChildren();
            return cell.getHeight() == 0 && (children == null || children.isEmpty());
        }
    }

    protected class ColumnHeaderCreator
    extends ReportBandCreator {
        private Map<Integer, JRPropertiesMap> headerBaseProperties;
        private final AtomicBoolean firstColumn;

        public ColumnHeaderCreator(ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level, Map<Integer, JRPropertiesMap> headerBaseProperties, AtomicBoolean firstColumn) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
            this.headerBaseProperties = headerBaseProperties;
            this.firstColumn = firstColumn;
        }

        @Override
        protected Cell columnCell(Column column) {
            return column.getColumnHeader();
        }

        @Override
        protected JRDesignFrame createColumnCell(Column column, JRElementGroup parentGroup, Cell cell) {
            JRDesignFrame frame = (JRDesignFrame)this.createColumnCell(column, parentGroup, cell, true);
            this.addHeaderToolbarElement(column, frame, TableUtil.getCellElement(JRTextField.class, column.getDetailCell(), true));
            return frame;
        }

        protected JRExpression getColumnHeaderLabelExpression(Cell header) {
            List<JRChild> detailElements;
            List<JRChild> list = detailElements = header == null ? null : header.getChildren();
            if (detailElements == null || detailElements.size() != 1) {
                return null;
            }
            JRChild detailElement = detailElements.get(0);
            if (detailElement instanceof JRTextField) {
                return ((JRTextField)detailElement).getExpression();
            }
            if (detailElement instanceof JRStaticText) {
                return TableReport.this.builtinEvaluatorFactory.createConstantExpression(((JRStaticText)detailElement).getText());
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void addHeaderToolbarElement(Column column, JRDesignFrame frame, JRTextField sortTextField) {
            int columnIndex = TableUtil.getColumnIndex(column, TableReport.this.table);
            Pair columnData = (Pair)TableReport.this.columnInteractivityMapping.get(column);
            boolean interactiveColumn = (Boolean)columnData.first();
            if (sortTextField != null && interactiveColumn) {
                boolean isFilterable;
                Cell header = column.getColumnHeader();
                JRDesignGenericElement genericElement = new JRDesignGenericElement(header.getDefaultStyleProvider());
                genericElement.setGenericType(HeaderToolbarElement.ELEMENT_TYPE);
                genericElement.setPositionType(PositionTypeEnum.FIX_RELATIVE_TO_TOP);
                genericElement.setX(0);
                genericElement.setY(0);
                genericElement.setHeight(1);
                genericElement.setWidth(1);
                genericElement.setMode(ModeEnum.TRANSPARENT);
                String fieldOrVariableName = null;
                SortFieldTypeEnum columnType = null;
                FilterTypesEnum filterType = null;
                TimeZone formatTimeZone = null;
                String suffix = "";
                boolean hasFieldOrVariable = false;
                if (column.getPropertiesMap().containsProperty(TableReport.PROPERTY_COLUMN_FIELD)) {
                    hasFieldOrVariable = true;
                    fieldOrVariableName = column.getPropertiesMap().getProperty(TableReport.PROPERTY_COLUMN_FIELD);
                    columnType = SortFieldTypeEnum.FIELD;
                    JRField field = TableReport.this.getField(fieldOrVariableName);
                    if (field == null) throw new JRRuntimeException(TableReport.EXCEPTION_MESSAGE_KEY_FIELD_NOT_FOUND, fieldOrVariableName);
                    filterType = FilterTypesEnum.getFilterType(field.getValueClass());
                } else if (column.getPropertiesMap().containsProperty(TableReport.PROPERTY_COLUMN_VARIABLE)) {
                    hasFieldOrVariable = true;
                    fieldOrVariableName = column.getPropertiesMap().getProperty(TableReport.PROPERTY_COLUMN_VARIABLE);
                    columnType = SortFieldTypeEnum.VARIABLE;
                    JRVariable variable = TableReport.this.getVariable(fieldOrVariableName);
                    if (variable == null) throw new JRRuntimeException(TableReport.EXCEPTION_MESSAGE_KEY_VARIABLE_NOT_FOUND, fieldOrVariableName);
                    filterType = FilterTypesEnum.getFilterType(variable.getValueClass());
                } else if (TableUtil.hasSingleChunkExpression(sortTextField)) {
                    JRExpressionChunk sortExpression = sortTextField.getExpression().getChunks()[0];
                    fieldOrVariableName = sortExpression.getText();
                    switch (sortExpression.getType()) {
                        case 3: {
                            columnType = SortFieldTypeEnum.FIELD;
                            JRField field = TableReport.this.getField(fieldOrVariableName);
                            filterType = FilterTypesEnum.getFilterType(field.getValueClass());
                            formatTimeZone = TableReport.this.getFormatTimeZone(sortTextField, field.getValueClass());
                            break;
                        }
                        case 4: {
                            columnType = SortFieldTypeEnum.VARIABLE;
                            JRVariable variable = TableReport.this.getVariable(fieldOrVariableName);
                            filterType = FilterTypesEnum.getFilterType(variable.getValueClass());
                            formatTimeZone = TableReport.this.getFormatTimeZone(sortTextField, variable.getValueClass());
                            break;
                        }
                        default: {
                            throw new JRRuntimeException(TableReport.EXCEPTION_MESSAGE_KEY_UNRECOGNIZED_FILTER_EXPRESSION_TYPE, sortExpression.getType());
                        }
                    }
                }
                boolean isSortable = TableReport.this.propertiesUtil.getBooleanProperty(column.getPropertiesMap(), TableReport.PROPERTY_COLUMN_SORTABLE, true) && fieldOrVariableName != null;
                boolean bl = isFilterable = TableReport.this.propertiesUtil.getBooleanProperty(column.getPropertiesMap(), TableReport.PROPERTY_COLUMN_FILTERABLE, true) && fieldOrVariableName != null && TableUtil.isFilterable(sortTextField) && filterType != null;
                if (isSortable) {
                    genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.can.sort", Boolean.TRUE.toString());
                    JRSortField[] sortFields = TableReport.this.mainDataset.getSortFields();
                    if (sortFields != null) {
                        for (JRSortField sortField : sortFields) {
                            if (!sortField.getName().equals(fieldOrVariableName) || sortField.getType() != columnType) continue;
                            suffix = suffix + "" + (sortField.getOrder() == SortOrderEnum.ASCENDING ? TableReport.this.propertiesUtil.getProperty(TableReport.PROPERTY_UP_ARROW_CHAR) : (sortField.getOrder() == SortOrderEnum.DESCENDING ? TableReport.this.propertiesUtil.getProperty(TableReport.PROPERTY_DOWN_ARROW_CHAR) : ""));
                        }
                    }
                } else {
                    genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.can.sort", Boolean.FALSE.toString());
                }
                if (isFilterable) {
                    List<FieldFilter> existingFilters;
                    genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.can.filter", Boolean.TRUE.toString());
                    JasperReportsContext jasperReportsContext = TableReport.this.fillContext.getFiller().getJasperReportsContext();
                    String serializedFilters = TableReport.this.mainDataset.getPropertiesMap().getProperty("net.sf.jasperreports.filters");
                    if (serializedFilters != null && (existingFilters = JsonLoader.getInstance(jasperReportsContext).loadList(serializedFilters, FieldFilter.class)) != null) {
                        ArrayList fieldFilters = new ArrayList();
                        TableReport.getFieldFilters(new CompositeDatasetFilter(existingFilters), fieldFilters, fieldOrVariableName);
                        if (fieldFilters.size() > 0) {
                            suffix = suffix + "" + TableReport.this.propertiesUtil.getProperty(TableReport.PROPERTY_FILTER_CHAR);
                        }
                    }
                    if (formatTimeZone != null && !formatTimeZone.equals(TableReport.this.fillContext.getFiller().getFillContext().getMasterTimeZone())) {
                        genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.format.time.zone", JRDataUtils.getTimeZoneId(formatTimeZone));
                    }
                } else {
                    genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.can.filter", Boolean.FALSE.toString());
                }
                if (suffix.length() > 0) {
                    this.addIconLabelComponent(column, frame, suffix);
                }
                if (isSortable || isFilterable) {
                    genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.sortColumnType", columnType.getName());
                }
                if (filterType != null) {
                    genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.filter.type", filterType.getName());
                }
                if (columnType != null && hasFieldOrVariable) {
                    String property = SortFieldTypeEnum.FIELD.equals(columnType) ? "net.sf.jasperreports.export.headertoolbar.column.field" : "net.sf.jasperreports.export.headertoolbar.column.variable";
                    genericElement.getPropertiesMap().setProperty(property, fieldOrVariableName);
                }
                String columnName = fieldOrVariableName != null ? fieldOrVariableName : String.valueOf(columnIndex);
                String columnUuid = column.getUUID().toString();
                String cellId = columnName + "_" + column.hashCode();
                if (this.firstColumn.compareAndSet(false, true)) {
                    this.addColumnLabelParameters(genericElement, TableReport.this.table);
                    String tableName = TableReport.this.propertiesUtil.getProperty("net.sf.jasperreports.components.name", TableReport.this.fillContext.getComponentElement());
                    genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.table.name", tableName);
                    genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.table.floating.header", String.valueOf(TableReport.this.hasFloatingHeader));
                }
                genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.columnUUID", columnUuid);
                genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.columnIndex", Integer.toString(columnIndex));
                genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.sortColumnName", columnName);
                genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.column.name", (String)columnData.second());
                genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.tableUUID", TableReport.this.fillContext.getComponentElement().getUUID().toString());
                this.addElementParameter(genericElement, "sortColumnLabel", this.getColumnHeaderLabelExpression(header));
                frame.getPropertiesMap().setProperty("net.sf.jasperreports.export.html.class", "jrcolHeader" + (interactiveColumn ? " interactiveElement" : ""));
                frame.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.columnUUID", columnUuid);
                frame.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.tableUUID", TableReport.this.fillContext.getComponentElement().getUUID().toString());
                frame.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.columnIndex", String.valueOf(columnIndex));
                String cellIdFixedPart = JRStringUtil.getCSSClass(cellId + "_");
                TableIndexProperties cellIdProperties = new TableIndexProperties("net.sf.jasperreports.export.headertoolbar.cellID", cellIdFixedPart);
                TableReport.this.tableIndexProperties.add(cellIdProperties);
                assert (frame.getPropertiesMap().getBaseProperties() == null);
                frame.getPropertiesMap().setBaseProperties(cellIdProperties.getPropertiesMap());
                String classFixedPart = "jrcel cel_" + cellIdFixedPart;
                TableIndexProperties columnClassProperties = new TableIndexProperties("net.sf.jasperreports.export.html.class", classFixedPart);
                TableReport.this.tableIndexProperties.add(columnClassProperties);
                this.headerBaseProperties.put(column.hashCode(), columnClassProperties.getPropertiesMap());
                frame.addElement(0, genericElement);
                return;
            } else {
                if (!TableReport.this.isInteractiveTable) return;
                String columnName = String.valueOf(columnIndex);
                String cellId = columnName + "_" + column.hashCode();
                frame.getPropertiesMap().setProperty("net.sf.jasperreports.export.html.class", "jrcolHeader");
                frame.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.columnUUID", column.getUUID().toString());
                frame.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.cellID", cellId);
                frame.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.tableUUID", TableReport.this.fillContext.getComponentElement().getUUID().toString());
                frame.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.columnIndex", String.valueOf(columnIndex));
            }
        }

        protected void addIconLabelComponent(Column column, JRDesignFrame frame, String suffix) {
            JRBaseTextElement headerTextElement;
            List<JRChild> children = frame.getChildren();
            if (children.size() > 0 && (headerTextElement = (JRBaseTextElement)children.get(0)) != null) {
                JRDesignComponentElement componentElement = IconLabelComponentUtil.getInstance(TableReport.this.fillContext.getFiller().getJasperReportsContext()).createIconLabelComponentElement(headerTextElement);
                IconLabelComponent iconLabelComponent = (IconLabelComponent)componentElement.getComponent();
                JRDesignTextField labelTextField = (JRDesignTextField)iconLabelComponent.getLabelTextField();
                if (headerTextElement instanceof JRTextField) {
                    labelTextField.setExpression(((JRTextField)((Object)headerTextElement)).getExpression());
                } else if (headerTextElement instanceof JRStaticText) {
                    labelTextField.setExpression(TableReport.this.builtinEvaluatorFactory.createConstantExpression(((JRStaticText)((Object)headerTextElement)).getText()));
                }
                JRDesignTextField iconTextField = (JRDesignTextField)iconLabelComponent.getIconTextField();
                iconTextField.setExpression(TableReport.this.builtinEvaluatorFactory.createConstantExpression(suffix));
                componentElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.matcher.filter.key", TableReport.TABLE_HEADER_ICON_LABEL_MATCHER_EXPORT_KEY);
                headerTextElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.matcher.filter.key", TableReport.TABLE_HEADER_LABEL_MATCHER_EXPORT_KEY);
                frame.getChildren().add(componentElement);
            }
        }

        protected void addElementParameter(JRDesignGenericElement element, String name, Object value) {
            JRDesignGenericElementParameter param = new JRDesignGenericElementParameter();
            param.setName(name);
            JRDesignExpression valueExpression = TableReport.this.builtinEvaluatorFactory.createConstantExpression(value);
            param.setValueExpression(valueExpression);
            element.addParameter(param);
        }

        protected void addElementParameter(JRDesignGenericElement element, String name, JRExpression expression) {
            JRDesignGenericElementParameter param = new JRDesignGenericElementParameter();
            param.setName(name);
            param.setValueExpression(expression);
            element.addParameter(param);
        }

        protected void addColumnLabelParameters(JRDesignGenericElement element, TableComponent table) {
            List<BaseColumn> columns = TableUtil.getAllColumns(table);
            int ln = columns.size();
            for (int i = 0; i < ln; ++i) {
                BaseColumn column = columns.get(i);
                JRExpression columnHeaderExpression = this.getColumnHeaderLabelExpression(column.getColumnHeader());
                boolean interactiveColumn = (Boolean)((Pair)TableReport.this.columnInteractivityMapping.get(column)).first() != false && TableUtil.getCellElement(JRTextField.class, ((Column)column).getDetailCell(), true) != null;
                String paramName = "column." + i + "|" + column.getUUID().toString() + "|" + interactiveColumn;
                this.addElementParameter(element, paramName, columnHeaderExpression);
            }
        }

        @Override
        protected Cell columnGroupCell(ColumnGroup group) {
            return group.getColumnHeader();
        }

        @Override
        protected ReportBandCreator createSubVisitor(FillColumn subcolumn, int xOffset, int yOffset, int sublevel) {
            return new ColumnHeaderCreator(this.bandInfo, subcolumn, xOffset, yOffset, sublevel, TableReport.this.headerHtmlBaseProperties, this.firstColumn);
        }

        @Override
        protected JRElement createColumnGroupCell(ColumnGroup columnGroup, Cell cell, JRDesignElementGroup elementGroup) {
            JRDesignFrame frame = (JRDesignFrame)TableReport.this.createCell(elementGroup, cell, columnGroup.getWidth(), this.fillColumn.getWidth(), this.xOffset, this.yOffset, null, this.deriveUUID(), true);
            frame.getPropertiesMap().setProperty("net.sf.jasperreports.export.html.class", "jrcolGroupHeader");
            return frame;
        }
    }

    protected class PageFooterCreator
    extends ReverseReportBandCreator {
        public PageFooterCreator(ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
        }

        @Override
        protected Cell columnCell(Column column) {
            return column.getColumnFooter();
        }

        @Override
        protected Cell columnGroupCell(ColumnGroup group) {
            return group.getColumnFooter();
        }

        @Override
        protected ReportBandCreator createSubVisitor(FillColumn subcolumn, int xOffset, int yOffset, int sublevel) {
            return new PageFooterCreator(this.bandInfo, subcolumn, xOffset, yOffset, sublevel);
        }
    }

    protected class TitleCreator
    extends ReportBandCreator {
        public TitleCreator(ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
        }

        @Override
        protected Cell columnCell(Column column) {
            return column.getTableHeader();
        }

        @Override
        protected Cell columnGroupCell(ColumnGroup group) {
            return group.getTableHeader();
        }

        @Override
        protected ReportBandCreator createSubVisitor(FillColumn subcolumn, int xOffset, int yOffset, int sublevel) {
            return new TitleCreator(this.bandInfo, subcolumn, xOffset, yOffset, sublevel);
        }
    }

    protected class SummaryCreator
    extends ReverseReportBandCreator {
        public SummaryCreator(ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
        }

        @Override
        protected Cell columnCell(Column column) {
            return column.getTableFooter();
        }

        @Override
        protected Cell columnGroupCell(ColumnGroup group) {
            return group.getTableFooter();
        }

        @Override
        protected ReportBandCreator createSubVisitor(FillColumn subcolumn, int xOffset, int yOffset, int sublevel) {
            return new SummaryCreator(this.bandInfo, subcolumn, xOffset, yOffset, sublevel);
        }
    }

    protected class GroupHeaderCreator
    extends ReportBandCreator {
        private final String groupName;

        public GroupHeaderCreator(String groupName, ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
            this.groupName = groupName;
        }

        @Override
        protected Cell columnCell(Column column) {
            return column.getGroupHeader(this.groupName);
        }

        @Override
        protected Cell columnGroupCell(ColumnGroup group) {
            return group.getGroupHeader(this.groupName);
        }

        @Override
        protected ReportBandCreator createSubVisitor(FillColumn subcolumn, int xOffset, int yOffset, int sublevel) {
            return new GroupHeaderCreator(this.groupName, this.bandInfo, subcolumn, xOffset, yOffset, sublevel);
        }
    }

    protected class GroupFooterCreator
    extends ReverseReportBandCreator {
        private final String groupName;

        public GroupFooterCreator(String groupName, ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
            this.groupName = groupName;
        }

        @Override
        protected Cell columnCell(Column column) {
            return column.getGroupFooter(this.groupName);
        }

        @Override
        protected Cell columnGroupCell(ColumnGroup group) {
            return group.getGroupFooter(this.groupName);
        }

        @Override
        protected ReportBandCreator createSubVisitor(FillColumn subcolumn, int xOffset, int yOffset, int sublevel) {
            return new GroupFooterCreator(this.groupName, this.bandInfo, subcolumn, xOffset, yOffset, sublevel);
        }
    }

    protected class BandRowInfo {
        JRDesignElementGroup elementGroup;
        List<CellInfo> cells = new ArrayList<CellInfo>();

        BandRowInfo() {
        }

        protected JRDesignElementGroup getElementGroup() {
            return this.elementGroup;
        }

        protected void setElementGroup(JRDesignElementGroup elementGroup) {
            this.elementGroup = elementGroup;
        }

        protected List<CellInfo> getCells() {
            return this.cells;
        }

        protected void addCell(CellInfo cell) {
            this.cells.add(cell);
        }
    }

    protected class CellInfo {
        final JRElement element;
        final int rowSpan;
        final int colSpan;

        CellInfo(JRElement element, int rowSpan, int colSpan) {
            this.element = element;
            this.rowSpan = rowSpan;
            this.colSpan = colSpan;
        }

        protected JRElement getElement() {
            return this.element;
        }

        protected int getRowSpan() {
            return this.rowSpan;
        }

        protected int getColSpan() {
            return this.colSpan;
        }
    }

    protected class SummaryGroupFooterPrintWhenEvaluator
    implements BuiltinExpressionEvaluator {
        private JRValueParameter tableScriptletParam;
        private TableReportScriptlet tableScriptlet;

        protected SummaryGroupFooterPrintWhenEvaluator() {
        }

        @Override
        public void init(Map<String, JRFillParameter> parametersMap, Map<String, JRFillField> fieldsMap, Map<String, JRFillVariable> variablesMap, WhenResourceMissingTypeEnum resourceMissingType) throws JRException {
            this.tableScriptletParam = parametersMap.get("__Table_SCRIPTLET");
        }

        protected void ensureValue() {
            if (this.tableScriptlet == null) {
                this.tableScriptlet = (TableReportScriptlet)this.tableScriptletParam.getValue();
            }
        }

        @Override
        public Object evaluate(DatasetExpressionEvaluator evaluator) throws JRExpressionEvalException {
            this.ensureValue();
            return this.tableScriptlet.hasDetailOnPage();
        }

        @Override
        public Object evaluateEstimated(DatasetExpressionEvaluator evaluator) throws JRExpressionEvalException {
            this.ensureValue();
            return this.tableScriptlet.hasDetailOnPage();
        }

        @Override
        public Object evaluateOld(DatasetExpressionEvaluator evaluator) throws JRExpressionEvalException {
            this.ensureValue();
            return this.tableScriptlet.hasDetailOnPage();
        }
    }

    protected static class TableIndexProperties {
        private final String propertyName;
        private final String classFixedPart;
        private JRPropertiesMap propertiesMap;

        public TableIndexProperties(String propertyName, String classFixedPart) {
            this.propertyName = propertyName;
            this.classFixedPart = classFixedPart;
            this.propertiesMap = new JRPropertiesMap();
        }

        public JRPropertiesMap getPropertiesMap() {
            return this.propertiesMap;
        }

        public void setTableInstanceIndex(int instanceIndex) {
            this.propertiesMap.setProperty(this.propertyName, this.classFixedPart + instanceIndex);
        }
    }

    protected abstract class ReverseReportBandCreator
    extends ReportBandCreator {
        public ReverseReportBandCreator(ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
        }

        @Override
        public Void visitColumnGroup(ColumnGroup columnGroup) {
            Cell cell = this.columnGroupCell(columnGroup);
            int rowSpan = cell == null ? 0 : (cell.getRowSpan() == null ? 1 : cell.getRowSpan());
            int origXOffset = this.xOffset;
            int origYOffset = this.yOffset;
            int colSpan = 0;
            for (FillColumn subcolumn : this.fillColumn.getSubcolumns()) {
                ReportBandCreator subVisitor = this.createSubVisitor(subcolumn, this.xOffset, origYOffset, this.level + rowSpan);
                subVisitor.visit();
                this.xOffset = subVisitor.xOffset;
                if (subVisitor.yOffset > this.yOffset) {
                    this.yOffset = subVisitor.yOffset;
                }
                colSpan += subcolumn.getColSpan();
            }
            int n = colSpan = colSpan == 0 ? 1 : colSpan;
            if (cell != null) {
                int rowLevel = this.level + rowSpan - 1;
                JRDesignElementGroup elementGroup = this.bandInfo.getRowElementGroup(rowLevel);
                JRElement cellElement = TableReport.this.createCell(elementGroup, cell, columnGroup.getWidth(), this.fillColumn.getWidth(), origXOffset, this.yOffset, null, this.deriveUUID(), false);
                elementGroup.addElement(cellElement);
                this.bandInfo.cellAdded(this.level, new CellInfo(cellElement, rowSpan, colSpan));
                this.yOffset += cell.getHeight().intValue();
            }
            return null;
        }
    }

    protected abstract class ReportBandCreator
    implements ColumnVisitor<Void> {
        final ReportBandInfo bandInfo;
        final FillColumn fillColumn;
        int xOffset;
        int yOffset;
        int level;

        public ReportBandCreator(ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            this.bandInfo = bandInfo;
            this.fillColumn = fillColumn;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.level = level;
        }

        protected boolean isEmpty(Cell cell) {
            return cell == null;
        }

        @Override
        public Void visitColumn(Column column) {
            Cell cell = this.columnCell(column);
            if (!this.isEmpty(cell)) {
                int rowSpan = cell.getRowSpan() == null ? 1 : cell.getRowSpan();
                int rowLevel = this.level + rowSpan - 1;
                JRDesignElementGroup elementGroup = this.bandInfo.getRowElementGroup(rowLevel);
                JRElement cellElement = this.createColumnCell(column, elementGroup, cell);
                elementGroup.addElement(cellElement);
                this.bandInfo.cellAdded(this.level, new CellInfo(cellElement, rowSpan, this.fillColumn.getColSpan()));
                this.yOffset += cell.getHeight().intValue();
            }
            this.xOffset += column.getWidth().intValue();
            return null;
        }

        protected UUID deriveUUID() {
            UUID columnUUID = this.fillColumn.getTableColumn().getUUID();
            UUID derived = DigestUtils.instance().deriveUUID(columnUUID, this.bandInfo.getBandId());
            return derived;
        }

        protected abstract Cell columnCell(Column var1);

        protected JRElement createColumnCell(Column column, JRElementGroup parentGroup, Cell cell) {
            return this.createColumnCell(column, parentGroup, cell, false);
        }

        protected JRElement createColumnCell(Column column, JRElementGroup parentGroup, Cell cell, boolean forceFrame) {
            return TableReport.this.createCell(parentGroup, cell, column.getWidth(), this.fillColumn.getWidth(), this.xOffset, this.yOffset, column.hashCode(), this.deriveUUID(), forceFrame);
        }

        @Override
        public Void visitColumnGroup(ColumnGroup columnGroup) {
            Cell cell = this.columnGroupCell(columnGroup);
            int cellHeight = 0;
            int sublevel = this.level;
            if (cell != null) {
                int rowSpan = cell.getRowSpan() == null ? 1 : cell.getRowSpan();
                int rowLevel = this.level + rowSpan - 1;
                int colSpan = 0;
                for (FillColumn subcolumn : this.fillColumn.getSubcolumns()) {
                    colSpan += subcolumn.getColSpan();
                }
                colSpan = colSpan == 0 ? 1 : colSpan;
                JRDesignElementGroup elementGroup = this.bandInfo.getRowElementGroup(rowLevel);
                JRElement cellElement = this.createColumnGroupCell(columnGroup, cell, elementGroup);
                elementGroup.addElement(cellElement);
                this.bandInfo.cellAdded(this.level, new CellInfo(cellElement, rowSpan, colSpan));
                cellHeight = cell.getHeight();
                sublevel += rowSpan;
            }
            for (FillColumn subcolumn : this.fillColumn.getSubcolumns()) {
                ReportBandCreator subVisitor = this.createSubVisitor(subcolumn, this.xOffset, this.yOffset + cellHeight, sublevel);
                subVisitor.visit();
                this.xOffset = subVisitor.xOffset;
            }
            return null;
        }

        protected JRElement createColumnGroupCell(ColumnGroup columnGroup, Cell cell, JRDesignElementGroup elementGroup) {
            return TableReport.this.createCell(elementGroup, cell, columnGroup.getWidth(), this.fillColumn.getWidth(), this.xOffset, this.yOffset, null, this.deriveUUID(), false);
        }

        protected abstract Cell columnGroupCell(ColumnGroup var1);

        protected abstract ReportBandCreator createSubVisitor(FillColumn var1, int var2, int var3, int var4);

        public void visit() {
            this.fillColumn.getTableColumn().visitColumn(this);
        }
    }
}

